/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Group;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.flightcontroller.IMUSensorState;
import dji.sdk.keyvalue.value.flightcontroller.IMUState;
import dji.sdk.keyvalue.value.flightcontroller.RedundancySensorUsedStateMsg;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.ImuCalibrateDialog;
import dji.v5.ux.core.base.ProgressStatusWidget;
import dji.v5.ux.core.util.ViewUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ImuStatusWidget
extends ConstraintLayout {
    private static final String TAG = "ImuStatusWidget";
    private int[] IMU_STATE_RES = new int[]{R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_1, R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_2, R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_3, R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_4, R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_5, R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_6, R.string.uxsdk_setting_ui_redundancy_sensor_imu_stat_0};
    private static final int ONE_IMU = 1;
    private static final int TWO_IMU = 2;
    private static final int THREE_IMU = 3;
    private Group mSettingUiFlycImuLy2;
    private Group mSettingUiFlycImuLy3;
    private List<TextView> mSettingUiFlycAccTitles = new ArrayList<TextView>();
    private List<ProgressStatusWidget> mSettingUiFlycImuAccs = new ArrayList<ProgressStatusWidget>();
    private List<ProgressStatusWidget> mSettingUiFlycImuGyros = new ArrayList<ProgressStatusWidget>();
    private int mImuCount;
    private List<IMUState> mIMUStateList = new ArrayList<IMUState>();
    private boolean mAreMotorOn;
    private RedundancySensorUsedStateMsg mSensorUsedState;

    private void initView(View view) {
        this.mSettingUiFlycImuLy2 = (Group)view.findViewById(R.id.setting_ui_flyc_imu_ly2);
        this.mSettingUiFlycImuLy3 = (Group)view.findViewById(R.id.setting_ui_flyc_imu_ly3);
        this.mSettingUiFlycAccTitles.add((TextView)view.findViewById(R.id.setting_ui_flyc_acc_0_title));
        this.mSettingUiFlycAccTitles.add((TextView)view.findViewById(R.id.setting_ui_flyc_acc_1_title));
        this.mSettingUiFlycAccTitles.add((TextView)view.findViewById(R.id.setting_ui_flyc_acc_2_title));
        this.mSettingUiFlycImuAccs.add((ProgressStatusWidget)view.findViewById(R.id.setting_ui_flyc_imu_acc_1));
        this.mSettingUiFlycImuAccs.add((ProgressStatusWidget)view.findViewById(R.id.setting_ui_flyc_imu_acc_2));
        this.mSettingUiFlycImuAccs.add((ProgressStatusWidget)view.findViewById(R.id.setting_ui_flyc_imu_acc_3));
        this.mSettingUiFlycImuGyros.add((ProgressStatusWidget)view.findViewById(R.id.setting_ui_flyc_imu_gyr_1));
        this.mSettingUiFlycImuGyros.add((ProgressStatusWidget)view.findViewById(R.id.setting_ui_flyc_imu_gyr_2));
        this.mSettingUiFlycImuGyros.add((ProgressStatusWidget)view.findViewById(R.id.setting_ui_flyc_imu_gyr_3));
        this.findViewById(R.id.setting_menu_imu_calibrate).setOnClickListener(view1 -> this.startCompassCalibrating());
    }

    public ImuStatusWidget(Context context) {
        this(context, null);
    }

    public ImuStatusWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImuStatusWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        View view = ImuStatusWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_imu_status_layout, (ViewGroup)this);
        this.initView(view);
        this.mSettingUiFlycAccTitles.get(0).setSelected(true);
        this.initKeys();
    }

    private void initKeys() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIMUCount), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<Integer>(){

            public void onSuccess(Integer count) {
                LogUtils.d((String)ImuStatusWidget.TAG, (Object[])new Object[]{"listen imu count=" + count});
                ImuStatusWidget.this.mImuCount = count;
                ImuStatusWidget.this.updateViewByImuCount();
            }

            public void onFailure(@NonNull IDJIError error) {
                LogUtils.d((String)ImuStatusWidget.TAG, (Object[])new Object[]{"listen imu get error"});
            }
        });
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<Boolean>(){

            public void onSuccess(Boolean isOn) {
                ImuStatusWidget.this.mAreMotorOn = isOn;
            }

            public void onFailure(@NonNull IDJIError error) {
                LogUtils.d((String)ImuStatusWidget.TAG, (Object[])new Object[]{"get KeyAreMotorsOn error"});
            }
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIMUStatus), (Object)this, (oldValue, newValue) -> {
            this.mIMUStateList = newValue;
            this.updateSensorsStatus(this.mSettingUiFlycImuAccs, false);
            this.updateSensorsStatus(this.mSettingUiFlycImuGyros, true);
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyRedundancySensorUsedState), (Object)this, (oldValue, newValue) -> {
            this.mSensorUsedState = newValue;
            this.updateSelectedSensor(this.mSensorUsedState.getGyroIndex());
        });
    }

    protected void onDetachedFromWindow() {
        KeyManager.getInstance().cancelListen((Object)this);
        super.onDetachedFromWindow();
    }

    protected void startCompassCalibrating() {
        if (this.mAreMotorOn) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_ui_imu_tip, 0);
        } else if (((Boolean)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), (Object)false)).booleanValue()) {
            ImuCalibrateDialog dialog = new ImuCalibrateDialog(this.getContext());
            dialog.show();
        } else {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_app_check_aircraft_connection, 0);
        }
    }

    private void updateViewByImuCount() {
        if (this.mImuCount == 2) {
            this.mSettingUiFlycImuLy3.setVisibility(8);
        } else if (this.mImuCount == 1) {
            this.mSettingUiFlycImuLy2.setVisibility(8);
            this.mSettingUiFlycImuLy3.setVisibility(8);
        } else {
            this.mSettingUiFlycImuLy2.setVisibility(0);
            this.mSettingUiFlycImuLy3.setVisibility(0);
        }
    }

    private void updateSelectedSensor(int index) {
        for (int i = 0; i < 3; ++i) {
            this.mSettingUiFlycAccTitles.get(i).setSelected(index == i + 1);
        }
    }

    private void updateSensorsStatus(List<ProgressStatusWidget> viewList, boolean isGyro) {
        if (this.mIMUStateList == null) {
            return;
        }
        for (int i = 0; i < this.mImuCount && i < this.mIMUStateList.size(); ++i) {
            IMUState imuState = this.mIMUStateList.get(i);
            IMUSensorState state = isGyro ? imuState.getGyroscopeState() : imuState.getAccelerometerState();
            float value = isGyro ? imuState.getGyroscopeBias().floatValue() : imuState.getAccelerometerBias().floatValue();
            ProgressStatusWidget statusView = viewList.get(i);
            if (state == IMUSensorState.NORMAL_BIAS) {
                statusView.setProgressDrawable(this.getContext().getResources().getDrawable(R.drawable.uxsdk_setting_ui_status_pgb_green));
            } else if (state == IMUSensorState.MEDIUM_BIAS) {
                statusView.setProgressDrawable(this.getContext().getResources().getDrawable(R.drawable.uxsdk_setting_ui_status_pgb_yellow));
            } else if (state == IMUSensorState.LARGE_BIAS) {
                statusView.setProgressDrawable(this.getContext().getResources().getDrawable(R.drawable.uxsdk_setting_ui_status_pgb_red));
            }
            statusView.mProgressBar.setVisibility(0);
            statusView.mValueView.setVisibility(0);
            this.updateStatus(state, statusView, isGyro, value);
        }
    }

    private void updateStatus(IMUSensorState state, ProgressStatusWidget statusView, boolean isGyro, float value) {
        if (state == IMUSensorState.NORMAL_BIAS || state == IMUSensorState.MEDIUM_BIAS || state == IMUSensorState.LARGE_BIAS) {
            statusView.setValue(String.format(Locale.US, "%.3f", Float.valueOf(value)));
            if (isGyro) {
                statusView.setProgress((int)(value / 0.05f * 100.0f));
            } else {
                statusView.setProgress((int)(value / 0.1f * 100.0f));
            }
            statusView.mDescView.setVisibility(8);
        } else {
            statusView.mProgressBar.setProgress(0);
            if (state != null && state.ordinal() >= 0 && state.ordinal() <= IMUSensorState.IN_MOTION.ordinal()) {
                statusView.mDescView.setText(this.IMU_STATE_RES[state.ordinal()]);
                statusView.mDescView.setVisibility(0);
                statusView.mProgressBar.setVisibility(8);
                statusView.mValueView.setVisibility(8);
            } else {
                statusView.mDescView.setVisibility(8);
            }
        }
    }
}

