/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.amap.utils;

import android.graphics.Bitmap;
import android.view.View;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.PolygonOptions;
import com.amap.api.maps.model.PolylineOptions;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdateFactory;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.DJILatLngBounds;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.core.utils.DJIGpsUtils;
import java.util.ArrayList;
import java.util.List;

public class AMapUtils {
    private AMapUtils() {
    }

    public static final LatLng fromDJILatLng(DJILatLng latLng) {
        DJILatLng gcjLatLng = DJIGpsUtils.wgs2gcjInChina(latLng);
        return new LatLng(gcjLatLng.getLatitude(), gcjLatLng.getLongitude());
    }

    public static final DJILatLng fromLatLng(LatLng latLng) {
        DJILatLng ll = new DJILatLng(latLng.latitude, latLng.longitude);
        DJILatLng transformed = DJIGpsUtils.gcj2wgsInChina(ll);
        return transformed;
    }

    public static final CameraUpdate fromDJICameraUpdate(DJICameraUpdate cameraUpdate) {
        CameraUpdate u = CameraUpdateFactory.newLatLng((LatLng)new LatLng(0.0, 0.0));
        if (cameraUpdate instanceof DJICameraUpdateFactory.CameraBoundsUpdate) {
            DJICameraUpdateFactory.CameraBoundsUpdate boundsUpdate = (DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate;
            int width = boundsUpdate.getWidth();
            int height = boundsUpdate.getHeight();
            int padding = boundsUpdate.getPadding();
            int paddingLeft = boundsUpdate.getPaddingLeft();
            int paddingRight = boundsUpdate.getPaddingRight();
            int paddingBottom = boundsUpdate.getPaddingBottom();
            int paddingTop = boundsUpdate.getPaddingTop();
            LatLngBounds.Builder builder = new LatLngBounds.Builder();
            DJILatLngBounds bounds = boundsUpdate.getBounds();
            DJILatLng northeast = bounds.getNortheast();
            DJILatLng southwest = bounds.getSouthwest();
            builder.include(AMapUtils.fromDJILatLng(northeast)).include(AMapUtils.fromDJILatLng(southwest));
            u = width == 0 || height == 0 ? CameraUpdateFactory.newLatLngBoundsRect((LatLngBounds)builder.build(), (int)(padding + paddingLeft), (int)(padding + paddingRight), (int)(padding + paddingTop), (int)(padding + paddingBottom)) : CameraUpdateFactory.newLatLngBounds((LatLngBounds)builder.build(), (int)width, (int)height, (int)padding);
        } else if (cameraUpdate instanceof DJICameraUpdateFactory.CameraPositionUpdate) {
            DJICameraUpdateFactory.CameraPositionUpdate positionUpdate = (DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate;
            LatLng target = AMapUtils.fromDJILatLng(positionUpdate.getTarget());
            CameraPosition p = new CameraPosition.Builder().target(target).zoom(positionUpdate.getZoom()).tilt(positionUpdate.getTilt()).bearing(positionUpdate.getBearing()).build();
            u = CameraUpdateFactory.newCameraPosition((CameraPosition)p);
        }
        return u;
    }

    public static final DJICameraPosition fromCameraPosition(CameraPosition cameraPosition) {
        DJICameraPosition.Builder builder = new DJICameraPosition.Builder();
        LatLng target = cameraPosition.target;
        builder.target(AMapUtils.fromLatLng(target)).zoom(cameraPosition.zoom).tilt(cameraPosition.tilt).bearing(cameraPosition.bearing);
        return builder.build();
    }

    public static final BitmapDescriptor fromDJIBitmapDescriptor(DJIBitmapDescriptor descriptor) {
        String path = descriptor.getPath();
        return switch (descriptor.getType()) {
            case DJIBitmapDescriptor.Type.BITMAP -> BitmapDescriptorFactory.fromBitmap((Bitmap)descriptor.getBitmap());
            case DJIBitmapDescriptor.Type.PATH_ABSOLUTE -> BitmapDescriptorFactory.fromPath((String)path);
            case DJIBitmapDescriptor.Type.PATH_ASSET -> BitmapDescriptorFactory.fromAsset((String)path);
            case DJIBitmapDescriptor.Type.PATH_FILEINPUT -> BitmapDescriptorFactory.fromFile((String)path);
            case DJIBitmapDescriptor.Type.RESOURCE_ID -> BitmapDescriptorFactory.fromResource((int)descriptor.getResourceId());
            case DJIBitmapDescriptor.Type.VIEW -> BitmapDescriptorFactory.fromView((View)descriptor.getView());
            default -> throw new AssertionError();
        };
    }

    public static final PolygonOptions fromDJIPolygonOptions(DJIPolygonOptions options) {
        PolygonOptions result = new PolygonOptions();
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        for (DJILatLng point : options.getPoints()) {
            points.add(AMapUtils.fromDJILatLng(point));
        }
        result.strokeWidth(options.getStrokeWidth()).zIndex(options.getZIndex()).strokeColor(options.getStrokeColor()).fillColor(options.getFillColor()).visible(options.isVisible()).addAll(points);
        return result;
    }

    public static final PolylineOptions fromDJIPolylineOptions(DJIPolylineOptions options) {
        PolylineOptions result = new PolylineOptions();
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        List<DJILatLng> originPoints = options.getPoints();
        for (DJILatLng point : originPoints) {
            points.add(AMapUtils.fromDJILatLng(point));
        }
        result.width(options.getWidth()).zIndex(options.getZIndex()).color(options.getColor()).visible(options.isVisible()).geodesic(options.isGeodesic()).addAll(points);
        if (options.isDashed()) {
            result.setDottedLine(true).setDottedLineType(0);
        }
        if (options.isEnableTexture() && options.getBitmapDescriptor() != null) {
            result.setUseTexture(true);
            BitmapDescriptor bitmapDescriptor = AMapUtils.fromDJIBitmapDescriptor(options.getBitmapDescriptor());
            result.setCustomTexture(bitmapDescriptor);
        }
        return result;
    }
}

