/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.zoom;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.visualcamera.zoom.FocalZoomWidgetView;

public class FocalZoomWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private FocalZoomWidgetView focalZoomWidgetView;

    public FocalZoomWidget(Context context) {
        super(context);
    }

    public FocalZoomWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FocalZoomWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int widthMeasureSpec = (int)this.getResources().getDimension(R.dimen.uxsdk_42_dp);
        int heightMeasureSpec = (int)this.getResources().getDimension(R.dimen.uxsdk_250_dp);
        this.focalZoomWidgetView = new FocalZoomWidgetView(context, attrs, defStyleAttr);
        ConstraintLayout.LayoutParams layoutParams = new ConstraintLayout.LayoutParams(widthMeasureSpec, heightMeasureSpec);
        this.addView(this.focalZoomWidgetView, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        if (this.focalZoomWidgetView != null) {
            return this.focalZoomWidgetView.getCameraIndex();
        }
        return ComponentIndexType.UNKNOWN;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        if (this.focalZoomWidgetView != null) {
            return this.focalZoomWidgetView.getLensType();
        }
        return CameraLensType.UNKNOWN;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        if (this.showZoomView(lensType)) {
            this.focalZoomWidgetView.setVisibility(0);
            this.focalZoomWidgetView.updateCameraSource(cameraIndex, lensType);
            return;
        }
        this.focalZoomWidgetView.setVisibility(8);
    }

    @Override
    protected void reactToModelChanges() {
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    private boolean showZoomView(CameraLensType lensType) {
        return lensType == CameraLensType.CAMERA_LENS_ZOOM || lensType == CameraLensType.CAMERA_LENS_THERMAL;
    }
}

