/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.shutter;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraShutterSpeed;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.visualcamera.shutter.CameraConfigShutterWidgetModel;

public class CameraConfigShutterWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private CameraConfigShutterWidgetModel widgetModel;
    private TextView shutterTitleTextView;
    private TextView shutterValueTextView;

    public CameraConfigShutterWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigShutterWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigShutterWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigShutterWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_base_camera_info, (ViewGroup)this);
        this.shutterTitleTextView = (TextView)this.findViewById(R.id.textview_title);
        this.shutterValueTextView = (TextView)this.findViewById(R.id.textview_value);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigShutterWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.shutterTitleTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_shutter_title));
        }
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getShutterSpeed().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
    }

    private void updateUI(@NonNull CameraShutterSpeed shutterSpeed) {
        this.shutterValueTextView.setText((CharSequence)CameraUtil.shutterSpeedDisplayName(shutterSpeed));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_base_camera_info_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setShutterTitleTextAppearance(@StyleRes int textAppearance) {
        this.shutterTitleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getShutterTitleTextColors() {
        return this.shutterTitleTextView.getTextColors();
    }

    @ColorInt
    public int getShutterTitleTextColor() {
        return this.shutterTitleTextView.getCurrentTextColor();
    }

    public void setShutterTitleTextColor(@NonNull ColorStateList colorStateList) {
        this.shutterTitleTextView.setTextColor(colorStateList);
    }

    public void setShutterTitleTextColor(@ColorInt int color2) {
        this.shutterTitleTextView.setTextColor(color2);
    }

    @Dimension
    public float getShutterTitleTextSize() {
        return this.shutterTitleTextView.getTextSize();
    }

    public void setShutterTitleTextSize(@Dimension float textSize) {
        this.shutterTitleTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getShutterTitleTextBackground() {
        return this.shutterTitleTextView.getBackground();
    }

    public void setShutterTitleTextBackground(@DrawableRes int resourceId) {
        this.shutterTitleTextView.setBackgroundResource(resourceId);
    }

    public void setShutterTitleTextBackground(@Nullable Drawable drawable2) {
        this.shutterTitleTextView.setBackground(drawable2);
    }

    public void setShutterValueTextAppearance(@StyleRes int textAppearance) {
        this.shutterValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getShutterValueTextColors() {
        return this.shutterValueTextView.getTextColors();
    }

    @ColorInt
    public int getShutterValueTextColor() {
        return this.shutterValueTextView.getCurrentTextColor();
    }

    public void setShutterValueTextColor(@NonNull ColorStateList colorStateList) {
        this.shutterValueTextView.setTextColor(colorStateList);
    }

    public void setShutterValueTextColor(@ColorInt int color2) {
        this.shutterValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getShutterValueTextSize() {
        return this.shutterValueTextView.getTextSize();
    }

    public void setShutterValueTextSize(@Dimension float textSize) {
        this.shutterValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getShutterValueTextBackground() {
        return this.shutterValueTextView.getBackground();
    }

    public void setShutterValueTextBackground(@DrawableRes int resourceId) {
        this.shutterValueTextView.setBackgroundResource(resourceId);
    }

    public void setShutterValueTextBackground(@Nullable Drawable drawable2) {
        this.shutterValueTextView.setBackground(drawable2);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable shutterValueTextBackgroundDrawable;
        int shutterValueTextColor;
        float shutterValueTextSize;
        int shutterValueTextAppearanceId;
        Drawable shutterTitleTextBackgroundDrawable;
        int shutterTitleTextColor;
        float shutterTitleTextSize;
        int shutterTitleTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigShutterWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigShutterWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.CameraConfigShutterWidget_uxsdk_lensType, 0)));
        }
        if ((shutterTitleTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigShutterWidget_uxsdk_shutterTitleTextAppearance, -1)) != -1) {
            this.setShutterTitleTextAppearance(shutterTitleTextAppearanceId);
        }
        if ((shutterTitleTextSize = typedArray.getDimension(R.styleable.CameraConfigShutterWidget_uxsdk_shutterTitleTextSize, -1.0f)) != -1.0f) {
            this.setShutterTitleTextSize(DisplayUtil.pxToSp((Context)context, (float)shutterTitleTextSize));
        }
        if ((shutterTitleTextColor = typedArray.getColor(R.styleable.CameraConfigShutterWidget_uxsdk_shutterTitleTextColor, 0)) != 0) {
            this.setShutterTitleTextColor(shutterTitleTextColor);
        }
        if ((shutterTitleTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigShutterWidget_uxsdk_shutterTitleBackgroundDrawable)) != null) {
            this.setShutterTitleTextBackground(shutterTitleTextBackgroundDrawable);
        }
        if ((shutterValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigShutterWidget_uxsdk_shutterValueTextAppearance, -1)) != -1) {
            this.setShutterValueTextAppearance(shutterValueTextAppearanceId);
        }
        if ((shutterValueTextSize = typedArray.getDimension(R.styleable.CameraConfigShutterWidget_uxsdk_shutterValueTextSize, -1.0f)) != -1.0f) {
            this.setShutterValueTextSize(DisplayUtil.pxToSp((Context)context, (float)shutterValueTextSize));
        }
        if ((shutterValueTextColor = typedArray.getColor(R.styleable.CameraConfigShutterWidget_uxsdk_shutterValueTextColor, 0)) != 0) {
            this.setShutterValueTextColor(shutterValueTextColor);
        }
        if ((shutterValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigShutterWidget_uxsdk_shutterValueBackgroundDrawable)) != null) {
            this.setShutterValueTextBackground(shutterValueTextBackgroundDrawable);
        }
        typedArray.recycle();
    }
}

