/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.gimbal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.gimbal.PostureFineTuneAxis;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.IGimbalIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.gimbal.GimbalFineTuneWidgetModel;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u00017B'\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010)\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010+\u001a\u00020*H\u0014J\b\u0010,\u001a\u00020*H\u0014J\b\u0010-\u001a\u00020*H\u0014J\u0010\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020$H\u0002J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020*2\u0006\u00106\u001a\u000204H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00068"}, d2={"Ldji/v5/ux/gimbal/GimbalFineTuneWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "Landroid/view/View$OnClickListener;", "Ldji/v5/ux/core/base/IGimbalIndex;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "widgetModel", "Ldji/v5/ux/gimbal/GimbalFineTuneWidgetModel;", "pitchTv", "Landroid/widget/TextView;", "rollTv", "yawTv", "imgMinus", "Landroid/widget/ImageView;", "tvValue", "imgPlus", "rollDegree", "", "getRollDegree", "()D", "setRollDegree", "(D)V", "pitchDegree", "getPitchDegree", "setPitchDegree", "yawDegree", "getYawDegree", "setYawDegree", "currentAxis", "Ldji/sdk/keyvalue/value/gimbal/PostureFineTuneAxis;", "getCurrentAxis", "()Ldji/sdk/keyvalue/value/gimbal/PostureFineTuneAxis;", "setCurrentAxis", "(Ldji/sdk/keyvalue/value/gimbal/PostureFineTuneAxis;)V", "initView", "", "onAttachedToWindow", "onDetachedFromWindow", "reactToModelChanges", "onClick", "v", "Landroid/view/View;", "updateViewForType", "type", "getGimbalIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "updateGimbalIndex", "gimbalIndex", "Companion", "android-sdk-v5-uxsdk_release"})
public class GimbalFineTuneWidget
extends ConstraintLayoutWidget<Object>
implements View.OnClickListener,
IGimbalIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GimbalFineTuneWidgetModel widgetModel;
    @NotNull
    private final TextView pitchTv;
    @NotNull
    private final TextView rollTv;
    @NotNull
    private final TextView yawTv;
    @NotNull
    private final ImageView imgMinus;
    @NotNull
    private final TextView tvValue;
    @NotNull
    private final ImageView imgPlus;
    private double rollDegree;
    private double pitchDegree;
    private double yawDegree;
    @NotNull
    private PostureFineTuneAxis currentAxis;
    @NotNull
    private static final String TAG = "GimbalFineTuneWidget";
    @NotNull
    private static final PostureFineTuneAxis GIMBAL_PITCH_FINE_TUNE = PostureFineTuneAxis.PITCH_AXIS;
    @NotNull
    private static final PostureFineTuneAxis GIMBAL_ROLL_FINE_TUNE = PostureFineTuneAxis.ROLL_AXIS;
    @NotNull
    private static final PostureFineTuneAxis GIMBAL_YAW_FINE_TUNE = PostureFineTuneAxis.YAW_AXIS;

    @JvmOverloads
    public GimbalFineTuneWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        this.widgetModel = new GimbalFineTuneWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
        View view = this.findViewById(R.id.fpv_left_tv);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.pitchTv = (TextView)view;
        View view2 = this.findViewById(R.id.fpv_middle_tv);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.rollTv = (TextView)view2;
        View view3 = this.findViewById(R.id.fpv_right_tv);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.yawTv = (TextView)view3;
        View view4 = this.findViewById(R.id.fpv_gimbal_finetune_minus_img);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.imgMinus = (ImageView)view4;
        View view5 = this.findViewById(R.id.fpv_gimbal_finetune_value_tv);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        this.tvValue = (TextView)view5;
        View view6 = this.findViewById(R.id.fpv_gimbal_finetune_plus_img);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        this.imgPlus = (ImageView)view6;
        this.currentAxis = PostureFineTuneAxis.PITCH_AXIS;
    }

    public /* synthetic */ GimbalFineTuneWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final double getRollDegree() {
        return this.rollDegree;
    }

    public final void setRollDegree(double d) {
        this.rollDegree = d;
    }

    public final double getPitchDegree() {
        return this.pitchDegree;
    }

    public final void setPitchDegree(double d) {
        this.pitchDegree = d;
    }

    public final double getYawDegree() {
        return this.yawDegree;
    }

    public final void setYawDegree(double d) {
        this.yawDegree = d;
    }

    @NotNull
    public final PostureFineTuneAxis getCurrentAxis() {
        return this.currentAxis;
    }

    public final void setCurrentAxis(@NotNull PostureFineTuneAxis postureFineTuneAxis) {
        Intrinsics.checkNotNullParameter((Object)postureFineTuneAxis, (String)"<set-?>");
        this.currentAxis = postureFineTuneAxis;
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_gimbal_fine_tune, (ViewGroup)((ViewGroup)this));
        this.setBackgroundResource(R.drawable.uxsdk_background_black_rectangle);
        int padding = AndUtil.dip2px((Context)this.getContext(), (float)16.0f);
        this.setPadding(padding, padding, padding, padding);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
            this.pitchTv.setOnClickListener((View.OnClickListener)this);
            this.rollTv.setOnClickListener((View.OnClickListener)this);
            this.yawTv.setOnClickListener((View.OnClickListener)this);
            this.imgMinus.setOnClickListener((View.OnClickListener)this);
            this.imgPlus.setOnClickListener((View.OnClickListener)this);
            this.tvValue.setOnClickListener((View.OnClickListener)this);
            this.updateViewForType(this.currentAxis);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.widgetModel.rollAdjustDegree().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GimbalFineTuneWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(double degree) {
                this.this$0.setRollDegree(degree);
                GimbalFineTuneWidget.access$updateViewForType(this.this$0, this.this$0.getCurrentAxis());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.widgetModel.pitchAdjustDegree().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GimbalFineTuneWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(double degree) {
                this.this$0.setPitchDegree(degree);
                GimbalFineTuneWidget.access$updateViewForType(this.this$0, this.this$0.getCurrentAxis());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.widgetModel.yawAdjustDegree().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GimbalFineTuneWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(double degree) {
                this.this$0.setYawDegree(degree);
                GimbalFineTuneWidget.access$updateViewForType(this.this$0, this.this$0.getCurrentAxis());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
    }

    public void onClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int id2 = v.getId();
        if (R.id.fpv_left_tv == id2) {
            this.updateViewForType(GIMBAL_PITCH_FINE_TUNE);
        } else if (R.id.fpv_middle_tv == id2) {
            this.updateViewForType(GIMBAL_ROLL_FINE_TUNE);
        } else if (R.id.fpv_right_tv == id2) {
            this.updateViewForType(GIMBAL_YAW_FINE_TUNE);
        } else if (R.id.fpv_gimbal_finetune_minus_img == id2) {
            this.widgetModel.fineTunePosture(this.currentAxis, -0.1).subscribe();
        } else if (R.id.fpv_gimbal_finetune_plus_img == id2) {
            this.widgetModel.fineTunePosture(this.currentAxis, 0.1).subscribe();
        } else if (R.id.fpv_gimbal_finetune_value_tv == id2) {
            this.widgetModel.fineTunePosture(this.currentAxis, 0.0).subscribe();
        }
    }

    private final void updateViewForType(PostureFineTuneAxis type) {
        this.currentAxis = type;
        this.pitchTv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_fpv_white_50));
        this.rollTv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_fpv_white_50));
        this.yawTv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_fpv_white_50));
        PostureFineTuneAxis postureFineTuneAxis = type;
        if (postureFineTuneAxis == GIMBAL_PITCH_FINE_TUNE) {
            this.pitchTv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_setting_ui_btn_hover));
            this.imgMinus.setImageResource(R.drawable.fpv_pitch_down_normal);
            this.imgPlus.setImageResource(R.drawable.fpv_pitch_up_normal);
            Locale locale = Locale.US;
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{-this.pitchDegree == -0.0 ? 0.0 : -this.pitchDegree};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
            this.tvValue.setText((CharSequence)string3);
        } else if (postureFineTuneAxis == GIMBAL_ROLL_FINE_TUNE) {
            this.rollTv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_setting_ui_btn_hover));
            this.imgMinus.setImageResource(R.drawable.fpv_roll_leftarrow_normal);
            this.imgPlus.setImageResource(R.drawable.fpv_roll_rightarrow_normal);
            Locale locale = Locale.US;
            String string4 = "%.1f";
            Object[] objectArray = new Object[]{this.rollDegree == -0.0 ? 0.0 : this.rollDegree};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, format, *args)");
            this.tvValue.setText((CharSequence)string5);
        } else if (postureFineTuneAxis == GIMBAL_YAW_FINE_TUNE) {
            this.yawTv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_setting_ui_btn_hover));
            this.imgMinus.setImageResource(R.drawable.fpv_yaw_right);
            this.imgPlus.setImageResource(R.drawable.fpv_yaw_left);
            Locale locale = Locale.US;
            String string6 = "%.1f";
            Object[] objectArray = new Object[]{-this.yawDegree == -0.0 ? 0.0 : -this.yawDegree};
            String string7 = String.format(locale, string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(locale, format, *args)");
            this.tvValue.setText((CharSequence)string7);
        } else {
            Object[] objectArray = new Object[]{"unknown type: " + this.currentAxis};
            LogUtils.e((String)TAG, (Object[])objectArray);
        }
    }

    @Override
    @NotNull
    public ComponentIndexType getGimbalIndex() {
        return this.widgetModel.getGimbalIndex();
    }

    @Override
    public void updateGimbalIndex(@NotNull ComponentIndexType gimbalIndex) {
        Intrinsics.checkNotNullParameter((Object)gimbalIndex, (String)"gimbalIndex");
        this.widgetModel.updateGimbalIndex(gimbalIndex);
    }

    @JvmOverloads
    public GimbalFineTuneWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GimbalFineTuneWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateViewForType(GimbalFineTuneWidget $this, PostureFineTuneAxis type) {
        $this.updateViewForType(type);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldji/v5/ux/gimbal/GimbalFineTuneWidget$Companion;", "", "<init>", "()V", "TAG", "", "GIMBAL_PITCH_FINE_TUNE", "Ldji/sdk/keyvalue/value/gimbal/PostureFineTuneAxis;", "GIMBAL_ROLL_FINE_TUNE", "GIMBAL_YAW_FINE_TUNE", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

