/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.verticalvelocity;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.common.Velocity3D;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferenceKeys;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.MathExtensions;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u0017H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "velocityProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/common/Velocity3D;", "kotlin.jvm.PlatformType", "unitTypeDataProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "verticalVelocityStateProcessor", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState;", "verticalVelocityState", "Lio/reactivex/rxjava3/core/Flowable;", "getVerticalVelocityState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "updateStates", "inCleanup", "VerticalVelocityState", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nVerticalVelocityWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalVelocityWidgetModel.kt\ndji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class VerticalVelocityWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<Velocity3D> velocityProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeDataProcessor;
    @NotNull
    private final DataProcessor<VerticalVelocityState> verticalVelocityStateProcessor;

    public VerticalVelocityWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.preferencesManager = preferencesManager;
        DataProcessor<Velocity3D> dataProcessor = DataProcessor.create(new Velocity3D());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.velocityProcessor = dataProcessor;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor2 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.unitTypeDataProcessor = dataProcessor2;
        DataProcessor<VerticalVelocityState.ProductDisconnected> dataProcessor3 = DataProcessor.create(VerticalVelocityState.ProductDisconnected.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.verticalVelocityStateProcessor = dataProcessor3;
    }

    @NotNull
    public final Flowable<VerticalVelocityState> getVerticalVelocityState() {
        Flowable<VerticalVelocityState> flowable = this.verticalVelocityStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        block1: {
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftVelocity), this.velocityProcessor);
            this.bindDataProcessor(GlobalPreferenceKeys.create("UnitType"), this.unitTypeDataProcessor);
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface != null) {
                globalPreferencesInterface.setUpListener();
            }
            GlobalPreferencesInterface globalPreferencesInterface2 = this.preferencesManager;
            if (globalPreferencesInterface2 == null) break block1;
            GlobalPreferencesInterface it = globalPreferencesInterface2;
            boolean bl = false;
            this.unitTypeDataProcessor.onNext(it.getUnitType());
        }
    }

    @Override
    protected void updateStates() {
        if (((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            if (this.velocityProcessor.getValue().getZ() < 0.0) {
                Double d = this.velocityProcessor.getValue().getZ();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getZ(...)");
                double d2 = Math.abs(((Number)d).doubleValue());
                UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
                double d3 = MathExtensions.toVelocity(d2, unitType);
                UnitConversionUtil.UnitType unitType2 = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType2), (String)"getValue(...)");
                this.verticalVelocityStateProcessor.onNext(new VerticalVelocityState.UpwardVelocity(d3, unitType2));
            } else if (this.velocityProcessor.getValue().getZ() > 0.0) {
                Double d = this.velocityProcessor.getValue().getZ();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getZ(...)");
                double d4 = Math.abs(((Number)d).doubleValue());
                UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
                double d5 = MathExtensions.toVelocity(d4, unitType);
                UnitConversionUtil.UnitType unitType3 = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType3), (String)"getValue(...)");
                this.verticalVelocityStateProcessor.onNext(new VerticalVelocityState.DownwardVelocity(d5, unitType3));
            } else {
                UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
                this.verticalVelocityStateProcessor.onNext(new VerticalVelocityState.Idle(unitType));
            }
        } else {
            this.verticalVelocityStateProcessor.onNext(VerticalVelocityState.ProductDisconnected.INSTANCE);
        }
    }

    @Override
    protected void inCleanup() {
        block0: {
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.cleanup();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState;", "", "<init>", "()V", "ProductDisconnected", "Idle", "UpwardVelocity", "DownwardVelocity", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$DownwardVelocity;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$Idle;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$ProductDisconnected;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$UpwardVelocity;", "android-sdk-v5-uxsdk_release"})
    public static abstract class VerticalVelocityState {
        private VerticalVelocityState() {
        }

        public /* synthetic */ VerticalVelocityState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$DownwardVelocity;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState;", "velocity", "", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(DLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getVelocity", "()D", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class DownwardVelocity
        extends VerticalVelocityState {
            private final double velocity;
            @NotNull
            private final UnitConversionUtil.UnitType unitType;

            public DownwardVelocity(double velocity, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                super(null);
                this.velocity = velocity;
                this.unitType = unitType;
            }

            public final double getVelocity() {
                return this.velocity;
            }

            @NotNull
            public final UnitConversionUtil.UnitType getUnitType() {
                return this.unitType;
            }

            public final double component1() {
                return this.velocity;
            }

            @NotNull
            public final UnitConversionUtil.UnitType component2() {
                return this.unitType;
            }

            @NotNull
            public final DownwardVelocity copy(double velocity, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                return new DownwardVelocity(velocity, unitType);
            }

            public static /* synthetic */ DownwardVelocity copy$default(DownwardVelocity downwardVelocity, double d, UnitConversionUtil.UnitType unitType, int n, Object object) {
                if ((n & 1) != 0) {
                    d = downwardVelocity.velocity;
                }
                if ((n & 2) != 0) {
                    unitType = downwardVelocity.unitType;
                }
                return downwardVelocity.copy(d, unitType);
            }

            @NotNull
            public String toString() {
                return "DownwardVelocity(velocity=" + this.velocity + ", unitType=" + this.unitType + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.velocity);
                result = result * 31 + this.unitType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DownwardVelocity)) {
                    return false;
                }
                DownwardVelocity downwardVelocity = (DownwardVelocity)other;
                if (Double.compare(this.velocity, downwardVelocity.velocity) != 0) {
                    return false;
                }
                return this.unitType == downwardVelocity.unitType;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$Idle;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState;", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class Idle
        extends VerticalVelocityState {
            @NotNull
            private final UnitConversionUtil.UnitType unitType;

            public Idle(@NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                super(null);
                this.unitType = unitType;
            }

            @NotNull
            public final UnitConversionUtil.UnitType getUnitType() {
                return this.unitType;
            }

            @NotNull
            public final UnitConversionUtil.UnitType component1() {
                return this.unitType;
            }

            @NotNull
            public final Idle copy(@NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                return new Idle(unitType);
            }

            public static /* synthetic */ Idle copy$default(Idle idle, UnitConversionUtil.UnitType unitType, int n, Object object) {
                if ((n & 1) != 0) {
                    unitType = idle.unitType;
                }
                return idle.copy(unitType);
            }

            @NotNull
            public String toString() {
                return "Idle(unitType=" + this.unitType + ")";
            }

            public int hashCode() {
                return this.unitType.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Idle)) {
                    return false;
                }
                Idle idle = (Idle)other;
                return this.unitType == idle.unitType;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$ProductDisconnected;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class ProductDisconnected
        extends VerticalVelocityState {
            @NotNull
            public static final ProductDisconnected INSTANCE = new ProductDisconnected();

            private ProductDisconnected() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState$UpwardVelocity;", "Ldji/v5/ux/core/widget/verticalvelocity/VerticalVelocityWidgetModel$VerticalVelocityState;", "velocity", "", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(DLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getVelocity", "()D", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class UpwardVelocity
        extends VerticalVelocityState {
            private final double velocity;
            @NotNull
            private final UnitConversionUtil.UnitType unitType;

            public UpwardVelocity(double velocity, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                super(null);
                this.velocity = velocity;
                this.unitType = unitType;
            }

            public final double getVelocity() {
                return this.velocity;
            }

            @NotNull
            public final UnitConversionUtil.UnitType getUnitType() {
                return this.unitType;
            }

            public final double component1() {
                return this.velocity;
            }

            @NotNull
            public final UnitConversionUtil.UnitType component2() {
                return this.unitType;
            }

            @NotNull
            public final UpwardVelocity copy(double velocity, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                return new UpwardVelocity(velocity, unitType);
            }

            public static /* synthetic */ UpwardVelocity copy$default(UpwardVelocity upwardVelocity, double d, UnitConversionUtil.UnitType unitType, int n, Object object) {
                if ((n & 1) != 0) {
                    d = upwardVelocity.velocity;
                }
                if ((n & 2) != 0) {
                    unitType = upwardVelocity.unitType;
                }
                return upwardVelocity.copy(d, unitType);
            }

            @NotNull
            public String toString() {
                return "UpwardVelocity(velocity=" + this.velocity + ", unitType=" + this.unitType + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.velocity);
                result = result * 31 + this.unitType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpwardVelocity)) {
                    return false;
                }
                UpwardVelocity upwardVelocity = (UpwardVelocity)other;
                if (Double.compare(this.velocity, upwardVelocity.velocity) != 0) {
                    return false;
                }
                return this.unitType == upwardVelocity.unitType;
            }
        }
    }
}

