/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.panel;

import android.view.View;
import androidx.annotation.IntRange;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007J\u0018\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\rJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldji/v5/ux/core/base/panel/ListPanelWidgetBaseModel;", "", "<init>", "()V", "widgetList", "Lio/reactivex/rxjava3/core/Flowable;", "", "Landroid/view/View;", "getWidgetList", "()Lio/reactivex/rxjava3/core/Flowable;", "widgetListProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "addWidgets", "", "addWidget", "widget", "index", "", "removeWidget", "removeAllWidgets", "getWidget", "size", "android-sdk-v5-uxsdk_release"})
public final class ListPanelWidgetBaseModel {
    @NotNull
    private final DataProcessor<List<View>> widgetListProcessor;

    public ListPanelWidgetBaseModel() {
        DataProcessor<List> dataProcessor = DataProcessor.create(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.widgetListProcessor = dataProcessor;
    }

    @NotNull
    public final Flowable<List<View>> getWidgetList() {
        Flowable<List<View>> flowable = this.widgetListProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    public final void addWidgets(@NotNull List<? extends View> widgetList) {
        Intrinsics.checkNotNullParameter(widgetList, (String)"widgetList");
        this.widgetListProcessor.onNext(widgetList);
    }

    public final void addWidget(@NotNull View widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        List<View> list = this.widgetListProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValue(...)");
        List newList = CollectionsKt.plus((Collection)list, (Iterable)CollectionsKt.listOf((Object)widget));
        this.widgetListProcessor.onNext(newList);
    }

    public final void addWidget(@IntRange(from=0L) int index, @NotNull View widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        List<View> list = this.widgetListProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValue(...)");
        List<View> prevList = list;
        if (index >= prevList.size()) {
            return;
        }
        int n = index;
        List newList = n == 0 ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)widget), (Iterable)prevList) : (n == prevList.size() ? CollectionsKt.plus((Collection)prevList, (Iterable)CollectionsKt.listOf((Object)widget)) : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)prevList.subList(0, index), (Iterable)CollectionsKt.listOf((Object)widget)), (Iterable)prevList.subList(index, prevList.size())));
        this.widgetListProcessor.onNext(newList);
    }

    @Nullable
    public final View removeWidget(@IntRange(from=0L) int index) {
        List<View> list = this.widgetListProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValue(...)");
        List<View> prevList = list;
        if (index >= prevList.size()) {
            return null;
        }
        List newList = CollectionsKt.minus((Iterable)prevList, (Object)prevList.get(index));
        this.widgetListProcessor.onNext(newList);
        return prevList.get(index);
    }

    public final void removeAllWidgets() {
        this.widgetListProcessor.onNext(CollectionsKt.emptyList());
    }

    @Nullable
    public final View getWidget(@IntRange(from=0L) int index) {
        List<View> list = this.widgetListProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValue(...)");
        return (View)CollectionsKt.getOrNull(list, (int)index);
    }

    public final int size() {
        return this.widgetListProcessor.getValue().size();
    }
}

