/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.widget.LinearLayout;

public class RoundedLinearLayout
extends LinearLayout {
    private int mCornerRadius = 10;
    private Paint mPaint;
    private RectF bounds = new RectF(0.0f, 0.0f, 1.0f, 1.0f);

    @TargetApi(value=11)
    public RoundedLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.onInit();
    }

    public RoundedLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onInit();
    }

    public RoundedLinearLayout(Context context) {
        super(context);
        this.onInit();
    }

    protected void onInit() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.bounds = new RectF(0.0f, 0.0f, (float)w, (float)h);
    }

    protected void dispatchDraw(Canvas canvas) {
        int width = this.bounds.width() == 0.0f ? 1 : (int)this.bounds.width();
        int height = this.bounds.height() == 0.0f ? 1 : (int)this.bounds.height();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bitmap);
        super.dispatchDraw(c);
        BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)shader);
        canvas.drawRoundRect(this.bounds, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mPaint);
    }
}

