/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracontrols.camerasettingsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.R;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.OnStateChangeCallback;

public class CameraSettingsMenuIndicatorWidget
extends FrameLayoutWidget<Object>
implements View.OnClickListener {
    private TextView foregroundTextView;
    private OnStateChangeCallback<Object> stateChangeCallback = null;

    public CameraSettingsMenuIndicatorWidget(@NonNull Context context) {
        super(context);
    }

    public CameraSettingsMenuIndicatorWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraSettingsMenuIndicatorWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraSettingsMenuIndicatorWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_camera_settings_menu_indicator, (ViewGroup)this);
        this.foregroundTextView = (TextView)this.findViewById(R.id.text_view_menu);
        this.setOnClickListener(this);
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void reactToModelChanges() {
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    public void onClick(View v) {
        if (this.stateChangeCallback != null) {
            this.stateChangeCallback.onStateChange(null);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initializeListener();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.destroyListener();
        super.onDetachedFromWindow();
    }

    private void initializeListener() {
    }

    private void destroyListener() {
        this.stateChangeCallback = null;
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraSettingsMenuIndicatorWidget);
        this.setLabelTextSize(typedArray.getDimension(R.styleable.CameraSettingsMenuIndicatorWidget_uxsdk_settingsTextSize, 12.0f));
        this.setLabelTextColor(typedArray.getColor(R.styleable.CameraSettingsMenuIndicatorWidget_uxsdk_settingsTextColor, -1));
        this.setLabelTextBackground(typedArray.getDrawable(R.styleable.CameraSettingsMenuIndicatorWidget_uxsdk_settingsTextBackground));
        typedArray.recycle();
    }

    public void setStateChangeCallback(@NonNull OnStateChangeCallback<Object> stateChangeCallback) {
        this.stateChangeCallback = stateChangeCallback;
    }

    @ColorInt
    public int getLabelTextColor() {
        return this.foregroundTextView.getCurrentTextColor();
    }

    public void setLabelTextColor(@ColorInt int color2) {
        this.foregroundTextView.setTextColor(color2);
    }

    public void setLabelTextBackground(@DrawableRes int resourceId) {
        this.foregroundTextView.setBackgroundResource(resourceId);
    }

    public void setLabelTextBackground(@Nullable Drawable drawable2) {
        this.foregroundTextView.setBackground(drawable2);
    }

    @Nullable
    public Drawable getLabelBackground() {
        return this.foregroundTextView.getBackground();
    }

    @Dimension
    public float getLabelTextSize() {
        return this.foregroundTextView.getTextSize();
    }

    public void setLabelTextSize(@Dimension float textSize) {
        this.foregroundTextView.setTextSize(textSize);
    }
}

