/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.storage;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraColor;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.camera.CameraStorageLocation;
import dji.sdk.keyvalue.value.camera.SDCardLoadState;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.visualcamera.storage.CameraConfigStorageWidgetModel;
import java.util.HashMap;
import java.util.Map;

public class CameraConfigStorageWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private static final String TAG = "ConfigStorageWidget";
    private CameraConfigStorageWidgetModel widgetModel;
    private ImageView storageIconImageView;
    private TextView cameraColorTextView;
    private TextView imageFormatTextView;
    private TextView statusCapacityTitleTextView;
    private TextView statusCapacityValueTextView;
    private Map<StorageIconState, Drawable> storageInternalIconMap;
    private Map<StorageIconState, Drawable> storageSDCardIconMap;
    private String[] cameraColorNameArray;

    public CameraConfigStorageWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigStorageWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigStorageWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigStorageWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_camera_config_storage, (ViewGroup)this);
        this.storageIconImageView = (ImageView)this.findViewById(R.id.imageview_storage_icon);
        this.cameraColorTextView = (TextView)this.findViewById(R.id.textview_camera_color);
        this.imageFormatTextView = (TextView)this.findViewById(R.id.textview_image_format);
        this.statusCapacityTitleTextView = (TextView)this.findViewById(R.id.textview_status_capacity_title);
        this.statusCapacityValueTextView = (TextView)this.findViewById(R.id.textview_status_capacity_value);
        this.storageInternalIconMap = new HashMap<StorageIconState, Drawable>();
        this.storageSDCardIconMap = new HashMap<StorageIconState, Drawable>();
        this.cameraColorNameArray = this.getResources().getStringArray(R.array.uxsdk_camera_color_type);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigStorageWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getImageFormat().observeOn(SchedulerProvider.ui()).subscribe(this::updateImageFormatText, UxErrorHandle.logErrorConsumer(TAG, "reactToUpdateImageFormat")));
        this.addReaction(this.widgetModel.getCameraStorageState().observeOn(SchedulerProvider.ui()).subscribe(this::updateStatus, UxErrorHandle.logErrorConsumer(TAG, "reactToUpdateStatus")));
        this.addReaction(this.widgetModel.getCameraColor().observeOn(SchedulerProvider.ui()).subscribe(this::updateColor, UxErrorHandle.logErrorConsumer(TAG, "reactToUpdateColor")));
    }

    private void updateImageFormatText(CameraConfigStorageWidgetModel.ImageFormat imageFormat) {
        this.imageFormatTextView.setText((CharSequence)this.getImageFormatString(imageFormat));
    }

    private void updateStatus(CameraConfigStorageWidgetModel.CameraStorageState cameraStorageState) {
        CameraMode cameraMode = cameraStorageState.getCameraMode();
        this.updateForegroundDrawable(cameraStorageState);
        String status = "";
        if (cameraStorageState.getStorageLocation() == CameraStorageLocation.SDCARD) {
            status = this.getSDCardStatus(cameraStorageState.getStorageOperationState());
        } else if (cameraStorageState.getStorageLocation() == CameraStorageLocation.INTERNAL) {
            status = this.getInternalStorageStatus(cameraStorageState.getStorageOperationState());
        }
        if (TextUtils.isEmpty((CharSequence)status)) {
            this.statusCapacityTitleTextView.setText(this.getResources().getText(R.string.uxsdk_storage_title_capacity));
            if (cameraMode == CameraMode.VIDEO_NORMAL && cameraStorageState.getAvailableRecordingTime() > 0) {
                this.statusCapacityValueTextView.setText((CharSequence)CameraUtil.formatVideoTime(this.getResources(), cameraStorageState.getAvailableRecordingTime()));
            } else if (cameraMode == CameraMode.PHOTO_NORMAL && cameraStorageState.getAvailableCaptureCount() > 0L) {
                this.statusCapacityValueTextView.setText((CharSequence)String.valueOf(cameraStorageState.getAvailableCaptureCount()));
            } else {
                this.statusCapacityValueTextView.setText((CharSequence)StringUtils.getResStr((int)R.string.uxsdk_storage_remaining_space, (Object[])new Object[]{cameraStorageState.getAvailableCapacity()}));
            }
        } else {
            this.statusCapacityTitleTextView.setText(this.getResources().getText(R.string.uxsdk_storage_title_status));
            this.statusCapacityValueTextView.setText((CharSequence)status);
        }
    }

    private void updateForegroundDrawable(CameraConfigStorageWidgetModel.CameraStorageState cameraStorageState) {
        Drawable foregroundDrawable = null;
        if (cameraStorageState.getStorageLocation() == CameraStorageLocation.SDCARD) {
            switch (cameraStorageState.getStorageOperationState()) {
                case NOT_INSERTED: {
                    foregroundDrawable = this.getSDCardStorageIcon(StorageIconState.NOT_INSERTED);
                    break;
                }
                case INSERTED: {
                    foregroundDrawable = this.getSDCardStorageIcon(StorageIconState.NORMAL);
                    break;
                }
                default: {
                    foregroundDrawable = this.getSDCardStorageIcon(StorageIconState.WARNING);
                    break;
                }
            }
        } else if (cameraStorageState.getStorageLocation() == CameraStorageLocation.INTERNAL) {
            switch (cameraStorageState.getStorageOperationState()) {
                case NOT_INSERTED: {
                    foregroundDrawable = this.getInternalStorageIcon(StorageIconState.NOT_INSERTED);
                    break;
                }
                case INSERTED: {
                    foregroundDrawable = this.getInternalStorageIcon(StorageIconState.NORMAL);
                    break;
                }
                default: {
                    foregroundDrawable = this.getInternalStorageIcon(StorageIconState.WARNING);
                }
            }
        }
        this.storageIconImageView.setImageDrawable(foregroundDrawable);
    }

    private void updateColor(CameraColor cameraColor) {
        if (cameraColor == CameraColor.NONE || cameraColor == CameraColor.UNKNOWN) {
            this.cameraColorTextView.setVisibility(8);
        } else if (cameraColor.value() < this.cameraColorNameArray.length) {
            this.cameraColorTextView.setVisibility(0);
            this.cameraColorTextView.setText((CharSequence)this.cameraColorNameArray[cameraColor.value()]);
        }
    }

    private void checkAndUpdateForegroundImage() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.getCameraStorageState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateForegroundDrawable, UxErrorHandle.logErrorConsumer(TAG, "checkAndUpdateForegroundImage")));
        }
    }

    public String getImageFormatString(CameraConfigStorageWidgetModel.ImageFormat imageFormat) {
        if (imageFormat == null || imageFormat.getResolution() == null || imageFormat.getFrameRate() == null || imageFormat.getPhotoFileFormat() == null) {
            return this.getResources().getString(R.string.uxsdk_string_default_value);
        }
        if (imageFormat.getCameraMode() == CameraMode.VIDEO_NORMAL) {
            String processedResolutionString = CameraUtil.resolutionShortDisplayName(imageFormat.getResolution());
            String processedFrameRateString = CameraUtil.frameRateDisplayName(imageFormat.getFrameRate());
            return processedResolutionString + "/" + processedFrameRateString;
        }
        return CameraUtil.convertPhotoFileFormatToString(this.getResources(), imageFormat.getPhotoFileFormat());
    }

    private String getSDCardStatus(SDCardLoadState sdCardOperationState) {
        return switch (sdCardOperationState) {
            case SDCardLoadState.NOT_INSERTED -> this.getResources().getString(R.string.uxsdk_sd_card_missing);
            default -> "";
        };
    }

    private String getInternalStorageStatus(SDCardLoadState sdCardOperationState) {
        return switch (sdCardOperationState) {
            case SDCardLoadState.NOT_INSERTED -> this.getResources().getString(R.string.uxsdk_internal_storage_missing);
            default -> "";
        };
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_base_camera_info_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setInternalStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setInternalStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setInternalStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageInternalIconMap.put(storageIconState, drawable2);
        this.checkAndUpdateForegroundImage();
    }

    @Nullable
    public Drawable getInternalStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageInternalIconMap.get((Object)storageIconState);
    }

    public void setSDCardStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setSDCardStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setSDCardStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageSDCardIconMap.put(storageIconState, drawable2);
        this.checkAndUpdateForegroundImage();
    }

    @Nullable
    public Drawable getSDCardStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageSDCardIconMap.get((Object)storageIconState);
    }

    @Nullable
    public Drawable getStorageIconBackground() {
        return this.storageIconImageView.getBackground();
    }

    public void setStorageIconBackground(@DrawableRes int resourceId) {
        this.storageIconImageView.setBackgroundResource(resourceId);
    }

    public void setStorageIconBackground(@Nullable Drawable icon) {
        this.storageIconImageView.setBackground(icon);
    }

    public void setCameraColorTextAppearance(@StyleRes int textAppearance) {
        this.cameraColorTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getCameraColorTextColors() {
        return this.cameraColorTextView.getTextColors();
    }

    @ColorInt
    public int getCameraColorTextColor() {
        return this.cameraColorTextView.getCurrentTextColor();
    }

    public void setCameraColorTextColor(@NonNull ColorStateList colorStateList) {
        this.cameraColorTextView.setTextColor(colorStateList);
    }

    public void setCameraColorTextColor(@ColorInt int color2) {
        this.cameraColorTextView.setTextColor(color2);
    }

    @Dimension
    public float getCameraColorTextSize() {
        return this.cameraColorTextView.getTextSize();
    }

    public void setCameraColorTextSize(@Dimension float textSize) {
        this.cameraColorTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getCameraColorTextBackground() {
        return this.cameraColorTextView.getBackground();
    }

    public void setCameraColorTextBackground(@Nullable Drawable drawable2) {
        this.cameraColorTextView.setBackground(drawable2);
    }

    public void setCameraColorTextBackground(@DrawableRes int resourceId) {
        this.cameraColorTextView.setBackgroundResource(resourceId);
    }

    public void setImageFormatTextAppearance(@StyleRes int textAppearance) {
        this.imageFormatTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getImageFormatTextColors() {
        return this.imageFormatTextView.getTextColors();
    }

    @ColorInt
    public int getImageFormatTextColor() {
        return this.imageFormatTextView.getCurrentTextColor();
    }

    public void setImageFormatTextColor(@NonNull ColorStateList colorStateList) {
        this.imageFormatTextView.setTextColor(colorStateList);
    }

    public void setImageFormatTextColor(@ColorInt int color2) {
        this.imageFormatTextView.setTextColor(color2);
    }

    @Dimension
    public float getImageFormatTextSize() {
        return this.imageFormatTextView.getTextSize();
    }

    public void setImageFormatTextSize(float textSize) {
        this.imageFormatTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getImageFormatTextBackground() {
        return this.imageFormatTextView.getBackground();
    }

    public void setImageFormatTextBackground(@Nullable Drawable drawable2) {
        this.imageFormatTextView.setBackground(drawable2);
    }

    public void setImageFormatTextBackground(@DrawableRes int resourceId) {
        this.imageFormatTextView.setBackgroundResource(resourceId);
    }

    public void setStatusCapacityTitleTextAppearance(@StyleRes int textAppearance) {
        this.statusCapacityTitleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getStatusCapacityTitleTextColors() {
        return this.statusCapacityTitleTextView.getTextColors();
    }

    @ColorInt
    public int getStatusCapacityTitleTextColor() {
        return this.statusCapacityTitleTextView.getCurrentTextColor();
    }

    public void setStatusCapacityTitleTextColor(@NonNull ColorStateList colorStateList) {
        this.statusCapacityTitleTextView.setTextColor(colorStateList);
    }

    public void setStatusCapacityTitleTextColor(@ColorInt int color2) {
        this.statusCapacityTitleTextView.setTextColor(color2);
    }

    @Dimension
    public float getStatusCapacityTitleTextSize() {
        return this.statusCapacityTitleTextView.getTextSize();
    }

    public void setStatusCapacityTitleTextSize(float textSize) {
        this.statusCapacityTitleTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getStatusCapacityTitleTextBackground() {
        return this.statusCapacityTitleTextView.getBackground();
    }

    public void setStatusCapacityTitleTextBackground(@Nullable Drawable drawable2) {
        this.statusCapacityTitleTextView.setBackground(drawable2);
    }

    public void setStatusCapacityTitleTextBackground(@DrawableRes int resourceId) {
        this.statusCapacityTitleTextView.setBackgroundResource(resourceId);
    }

    public void setStatusCapacityValueTextAppearance(@StyleRes int textAppearance) {
        this.statusCapacityValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getStatusCapacityValueTextColors() {
        return this.statusCapacityValueTextView.getTextColors();
    }

    @ColorInt
    public int getStatusCapacityValueTextColor() {
        return this.statusCapacityValueTextView.getCurrentTextColor();
    }

    public void setStatusCapacityValueTextColor(@NonNull ColorStateList colorStateList) {
        this.statusCapacityValueTextView.setTextColor(colorStateList);
    }

    public void setStatusCapacityValueTextColor(@ColorInt int color2) {
        this.statusCapacityValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getStatusCapacityValueTextSize() {
        return this.statusCapacityValueTextView.getTextSize();
    }

    public void setStatusCapacityValueTextSize(float textSize) {
        this.statusCapacityValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getStatusCapacityValueTextBackground() {
        return this.statusCapacityValueTextView.getBackground();
    }

    public void setStatusCapacityValueTextBackground(@Nullable Drawable drawable2) {
        this.statusCapacityValueTextView.setBackground(drawable2);
    }

    public void setStatusCapacityValueTextBackground(@DrawableRes int resourceId) {
        this.statusCapacityValueTextView.setBackgroundResource(resourceId);
    }

    private void initDefaults() {
        this.setInternalStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_config_internal_none);
        this.setInternalStorageIcon(StorageIconState.WARNING, R.drawable.uxsdk_ic_config_internal_warning);
        this.setInternalStorageIcon(StorageIconState.NORMAL, R.drawable.uxsdk_ic_config_internal_normal);
        this.setSDCardStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_config_sd_none);
        this.setSDCardStorageIcon(StorageIconState.WARNING, R.drawable.uxsdk_ic_config_sd_warning);
        this.setSDCardStorageIcon(StorageIconState.NORMAL, R.drawable.uxsdk_ic_config_sd_normal);
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        Drawable formatInfoTextBackgroundDrawable;
        int formatInfoTextColor;
        float formatInfoTextSize;
        int formatInfoTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigStorageWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigStorageWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.CameraConfigStorageWidget_uxsdk_lensType, 0)));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_internalStorageNotInsertedIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_internalStorageNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_internalStorageWarningIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.WARNING, typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_internalStorageWarningIcon));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_internalStorageNormalIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.NORMAL, typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_internalStorageNormalIcon));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_sdCardNotInsertedIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_sdCardNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_sdCardWarningIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.WARNING, typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_sdCardWarningIcon));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_sdCardNormalIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.NORMAL, typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_sdCardNormalIcon));
        }
        if (typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_storageIconBackground) != null) {
            this.setStorageIconBackground(typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_storageIconBackground));
        }
        if ((formatInfoTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigStorageWidget_uxsdk_imageFormatTextAppearance, -1)) != -1) {
            this.setImageFormatTextAppearance(formatInfoTextAppearanceId);
        }
        if ((formatInfoTextSize = typedArray.getDimension(R.styleable.CameraConfigStorageWidget_uxsdk_imageFormatTextSize, -1.0f)) != -1.0f) {
            this.setImageFormatTextSize(DisplayUtil.pxToSp((Context)context, (float)formatInfoTextSize));
        }
        if ((formatInfoTextColor = typedArray.getColor(R.styleable.CameraConfigStorageWidget_uxsdk_imageFormatTextColor, 0)) != 0) {
            this.setImageFormatTextColor(formatInfoTextColor);
        }
        if ((formatInfoTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_imageFormatTextBackground)) != null) {
            this.setImageFormatTextBackground(formatInfoTextBackgroundDrawable);
        }
        this.setStatusCapacity(context, typedArray);
        this.setCameraColorText(context, typedArray);
        typedArray.recycle();
    }

    private void setCameraColorText(Context context, TypedArray typedArray) {
        Drawable cameraColorTextBackgroundDrawable;
        int cameraColorTextColor;
        float cameraColorTextSize;
        int cameraColorTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigStorageWidget_uxsdk_cameraColorTextAppearance, -1);
        if (cameraColorTextAppearanceId != -1) {
            this.setCameraColorTextAppearance(cameraColorTextAppearanceId);
        }
        if ((cameraColorTextSize = typedArray.getDimension(R.styleable.CameraConfigStorageWidget_uxsdk_cameraColorTextSize, -1.0f)) != -1.0f) {
            this.setCameraColorTextSize(DisplayUtil.pxToSp((Context)context, (float)cameraColorTextSize));
        }
        if ((cameraColorTextColor = typedArray.getColor(R.styleable.CameraConfigStorageWidget_uxsdk_cameraColorTextColor, 0)) != 0) {
            this.setCameraColorTextColor(cameraColorTextColor);
        }
        if ((cameraColorTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_cameraColorTextBackground)) != null) {
            this.setCameraColorTextBackground(cameraColorTextBackgroundDrawable);
        }
    }

    private void setStatusCapacity(Context context, TypedArray typedArray) {
        Drawable capacityValueTextBackgroundDrawable;
        int capacityValueTextColor;
        float capacityValueTextSize;
        int capacityValueTextAppearanceId;
        Drawable capacityTextBackgroundDrawable;
        int capacityTextColor;
        float capacityTextSize;
        int capacityTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigStorageWidget_uxsdk_capacityTextAppearance, -1);
        if (capacityTextAppearanceId != -1) {
            this.setStatusCapacityTitleTextAppearance(capacityTextAppearanceId);
        }
        if ((capacityTextSize = typedArray.getDimension(R.styleable.CameraConfigStorageWidget_uxsdk_capacityTextSize, -1.0f)) != -1.0f) {
            this.setStatusCapacityTitleTextSize(DisplayUtil.pxToSp((Context)context, (float)capacityTextSize));
        }
        if ((capacityTextColor = typedArray.getColor(R.styleable.CameraConfigStorageWidget_uxsdk_capacityTextColor, 0)) != 0) {
            this.setStatusCapacityTitleTextColor(capacityTextColor);
        }
        if ((capacityTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_capacityTextBackground)) != null) {
            this.setStatusCapacityTitleTextBackground(capacityTextBackgroundDrawable);
        }
        if ((capacityValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigStorageWidget_uxsdk_capacityValueTextAppearance, -1)) != -1) {
            this.setStatusCapacityValueTextAppearance(capacityValueTextAppearanceId);
        }
        if ((capacityValueTextSize = typedArray.getDimension(R.styleable.CameraConfigStorageWidget_uxsdk_capacityValueTextSize, -1.0f)) != -1.0f) {
            this.setStatusCapacityValueTextSize(DisplayUtil.pxToSp((Context)context, (float)capacityValueTextSize));
        }
        if ((capacityValueTextColor = typedArray.getColor(R.styleable.CameraConfigStorageWidget_uxsdk_capacityValueTextColor, 0)) != 0) {
            this.setStatusCapacityValueTextColor(capacityValueTextColor);
        }
        if ((capacityValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigStorageWidget_uxsdk_capacityValueTextBackground)) != null) {
            this.setStatusCapacityValueTextBackground(capacityValueTextBackgroundDrawable);
        }
    }

    public static enum StorageIconState {
        WARNING,
        NORMAL,
        NOT_INSERTED;

    }
}

