/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.ssd;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraShootPhotoMode;
import dji.sdk.keyvalue.value.camera.CameraWorkMode;
import dji.sdk.keyvalue.value.camera.SSDClipFileNameMsg;
import dji.sdk.keyvalue.value.camera.SSDColor;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.sdk.keyvalue.value.camera.SSDVideoLicense;
import dji.sdk.keyvalue.value.camera.VideoFrameRate;
import dji.sdk.keyvalue.value.camera.VideoResolution;
import dji.sdk.keyvalue.value.camera.VideoResolutionFrameRate;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.visualcamera.ssd.CameraConfigSSDWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraConfigSSDWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private static final String TAG = "ConfigSSDWidget";
    private static final int CAPACITY_UNIT_SWITCH_LIMIT = 1024;
    private static final String NULL_STRING = "Null";
    private CameraConfigSSDWidgetModel widgetModel;
    private ImageView ssdImageView;
    private ImageView ssdStatusImageView;
    private TextView ssdClipInfoTextView;
    private TextView ssdCapacityOrLicenseTextView;
    private TextView statusInfoTextView;
    private TextView formatInfoTextView;
    private TextView ssdCapacityValueTextView;
    private String[] videoResolutionArray;
    private String[] frameRateArray;
    private String[] ssdColorArray;
    private Animation ssdSaveAnimation;
    private boolean isSSDRecording;
    private Map<SSDOperationState, Drawable> ssdIconMap;

    public CameraConfigSSDWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigSSDWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigSSDWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigSSDWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_camera_config_ssd, (ViewGroup)this);
        this.ssdImageView = (ImageView)this.findViewById(R.id.imageview_ssd_icon);
        this.ssdStatusImageView = (ImageView)this.findViewById(R.id.imageview_ssd_status_icon);
        this.ssdClipInfoTextView = (TextView)this.findViewById(R.id.textview_ssd_clip_info);
        this.ssdCapacityOrLicenseTextView = (TextView)this.findViewById(R.id.textview_ssd_capacity_license);
        this.statusInfoTextView = (TextView)this.findViewById(R.id.textview_status_info);
        this.formatInfoTextView = (TextView)this.findViewById(R.id.textview_format_info);
        this.ssdCapacityValueTextView = (TextView)this.findViewById(R.id.textview_ssd_capacity_value);
        this.videoResolutionArray = this.getResources().getStringArray(R.array.uxsdk_camera_video_resolution_name_array);
        this.frameRateArray = this.getResources().getStringArray(R.array.uxsdk_camera_video_frame_rate_real_value_array);
        this.ssdColorArray = this.getResources().getStringArray(R.array.uxsdk_camera_ssd_color_array);
        this.ssdSaveAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.uxsdk_anim_blink);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigSSDWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.initDefaultIcons();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.isSSDSupported().observeOn(SchedulerProvider.ui()).subscribe(this::updateWidgetVisibility));
        this.addReaction(this.widgetModel.getSSDLicense().observeOn(SchedulerProvider.ui()).subscribe(this::updateCapacityTitle));
        this.addReaction(this.widgetModel.getSSDRemainingSpace().observeOn(SchedulerProvider.ui()).subscribe(this::updateCapacityValue));
        this.addReaction(this.widgetModel.getSSDResolutionAndFrameRate().observeOn(SchedulerProvider.ui()).subscribe(this::updateSSDResolutionAndFrameRate));
        this.addReaction(this.reactToUpdateClipInfo());
        this.addReaction(this.reactToUpdateSSDState());
    }

    private Disposable reactToUpdateClipInfo() {
        return Flowable.combineLatest(this.widgetModel.getSSDClipName(), this.widgetModel.getSSDColor(), Pair::new).observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateClipInfo((SSDClipFileNameMsg)values.first, (SSDColor)values.second), UxErrorHandle.logErrorConsumer(TAG, "reactToUpdateClipInfo: "));
    }

    private Flowable<Pair<SSDOperationState, Boolean>> getSSDState() {
        return Flowable.combineLatest(this.widgetModel.getSSDOperationState(), this.widgetModel.getCameraMode(), this.widgetModel.getShootPhotoMode(), (ssdOperationState, cameraMode, shootPhotoMode) -> {
            boolean cameraState = shootPhotoMode == CameraShootPhotoMode.RAW_BURST && cameraMode == CameraWorkMode.SHOOT_PHOTO;
            return Pair.create((Object)ssdOperationState, (Object)cameraState);
        });
    }

    private Disposable reactToUpdateSSDState() {
        return this.getSSDState().observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateSSDState((SSDOperationState)values.first, (Boolean)values.second), UxErrorHandle.logErrorConsumer(TAG, "reactToUpdateSSDState: "));
    }

    private void checkAndUpdateSSDState() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.getSSDState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateSSDState((SSDOperationState)values.first, (Boolean)values.second), UxErrorHandle.logErrorConsumer(TAG, "checkAndUpdateSSDState: ")));
        }
    }

    private void updateWidgetVisibility(boolean isSSDSupported) {
        if (isSSDSupported) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    private void updateCapacityTitle(@NonNull List<SSDVideoLicense> licenses) {
        if (licenses.size() <= 0) {
            return;
        }
        SSDVideoLicense license = licenses.get(0);
        int titleResource = R.string.uxsdk_storage_title_capacity;
        if (license == SSDVideoLicense.CINEMA_DNG) {
            titleResource = R.string.uxsdk_camera_ssd_video_license_cdng;
        } else if (license == SSDVideoLicense.PRO_RES_422HQ) {
            titleResource = R.string.uxsdk_camera_ssd_video_license_422hq;
        } else if (license == SSDVideoLicense.PRO_RES_4444XQ) {
            titleResource = R.string.uxsdk_camera_ssd_video_license_4444xq;
        }
        this.ssdCapacityOrLicenseTextView.setText(titleResource);
    }

    private void updateCapacityValue(long remainingSpace) {
        String remainingSpaceString = remainingSpace > 1024L ? remainingSpace / 1024L + "G" : remainingSpace + "M";
        this.ssdCapacityValueTextView.setText((CharSequence)remainingSpaceString);
    }

    private void updateSSDResolutionAndFrameRate(@NonNull VideoResolutionFrameRate ssdResolutionAndFrameRate) {
        this.formatInfoTextView.setText((CharSequence)this.convertResolutionAndFrameRateToString(ssdResolutionAndFrameRate.getResolution(), ssdResolutionAndFrameRate.getFrameRate()));
    }

    private void updateClipInfo(@NonNull SSDClipFileNameMsg ssdClipFileName, @NonNull SSDColor ssdColor) {
        String ssdColorName = "";
        Integer index = this.getSSDColorIndex(ssdColor);
        if (index != null && this.ssdColorArray != null && index < this.ssdColorArray.length) {
            ssdColorName = this.ssdColorArray[index];
        }
        String clipInfoString = ssdClipFileName + " " + ssdColorName;
        this.ssdClipInfoTextView.setText((CharSequence)clipInfoString);
    }

    private void updateSSDState(@NonNull SSDOperationState ssdOperationState, boolean cameraInShootPhotoRawBurstMode) {
        boolean needShowStatus = true;
        if (ssdOperationState != SSDOperationState.SWITCHING_LICENSE) {
            this.ssdImageView.setImageDrawable(this.ssdIconMap.get(ssdOperationState));
        }
        switch (ssdOperationState) {
            case NOT_FOUND: 
            case UNKNOWN: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_error_nossd);
                needShowStatus = false;
                break;
            }
            case SAVING: {
                needShowStatus = false;
                this.statusInfoTextView.setText(R.string.uxsdk_camera_ssd_saving);
                break;
            }
            case FORMATTING: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_formatting);
                break;
            }
            case INITIALIZING: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_init);
                break;
            }
            case STATE_ERROR: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_verify_failed);
                break;
            }
            case FULL: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_full);
                break;
            }
            case POOR_CONNECTION: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_poor_connection);
                break;
            }
            case SWITCHING_LICENSE: {
                if (cameraInShootPhotoRawBurstMode) {
                    needShowStatus = false;
                    break;
                }
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_switching_mode);
                this.ssdImageView.setImageDrawable(this.ssdIconMap.get(ssdOperationState));
                break;
            }
            case FORMATTING_REQUIRED: {
                this.statusInfoTextView.setText(R.string.uxsdk_ssd_status_need_format);
                break;
            }
            default: {
                needShowStatus = false;
            }
        }
        this.performNeedShowStatus(needShowStatus, ssdOperationState);
    }

    private void performNeedShowStatus(boolean needShowStatus, SSDOperationState ssdOperationState) {
        if (needShowStatus) {
            this.statusInfoTextView.setVisibility(0);
            this.formatInfoTextView.setVisibility(8);
            this.ssdCapacityOrLicenseTextView.setVisibility(8);
            this.ssdCapacityValueTextView.setVisibility(8);
        } else {
            if (ssdOperationState == SSDOperationState.UNKNOWN || ssdOperationState == SSDOperationState.NOT_FOUND) {
                this.ssdCapacityOrLicenseTextView.setVisibility(8);
                this.ssdCapacityValueTextView.setVisibility(8);
            } else {
                this.ssdCapacityOrLicenseTextView.setVisibility(0);
                this.ssdCapacityValueTextView.setVisibility(0);
            }
            this.statusInfoTextView.setVisibility(8);
            this.formatInfoTextView.setVisibility(0);
        }
        if (ssdOperationState == SSDOperationState.SAVING) {
            if (!this.isSSDRecording) {
                this.isSSDRecording = true;
                this.ssdStatusImageView.setVisibility(0);
                this.ssdStatusImageView.startAnimation(this.ssdSaveAnimation);
            }
        } else if (this.isSSDRecording) {
            this.ssdStatusImageView.clearAnimation();
            this.ssdStatusImageView.setVisibility(8);
            this.isSSDRecording = false;
        }
    }

    private void initDefaultIcons() {
        this.ssdIconMap = new HashMap<SSDOperationState, Drawable>();
        if (this.isInEditMode()) {
            return;
        }
        this.ssdIconMap.put(SSDOperationState.NOT_FOUND, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_not_inserted_gray));
        this.ssdIconMap.put(SSDOperationState.UNKNOWN, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_not_inserted_gray));
        this.ssdIconMap.put(SSDOperationState.IDLE, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_icon));
        this.ssdIconMap.put(SSDOperationState.SAVING, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_icon));
        this.ssdIconMap.put(SSDOperationState.FORMATTING, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_icon));
        this.ssdIconMap.put(SSDOperationState.INITIALIZING, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_icon));
        this.ssdIconMap.put(SSDOperationState.STATE_ERROR, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_not_inserted_gray));
        this.ssdIconMap.put(SSDOperationState.FULL, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_full));
        this.ssdIconMap.put(SSDOperationState.POOR_CONNECTION, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_warning));
        this.ssdIconMap.put(SSDOperationState.SWITCHING_LICENSE, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_icon));
        this.ssdIconMap.put(SSDOperationState.FORMATTING_REQUIRED, this.getResources().getDrawable(R.drawable.uxsdk_ic_ssd_warning));
    }

    private String convertResolutionAndFrameRateToString(@Nullable VideoResolution resolution, @Nullable VideoFrameRate frameRate) {
        String processedResolutionString = NULL_STRING;
        if (this.videoResolutionArray != null && resolution != null && resolution.value() < this.videoResolutionArray.length) {
            processedResolutionString = this.videoResolutionArray[resolution.value()];
        }
        if (resolution == VideoResolution.RESOLUTION_UNSET) {
            return processedResolutionString;
        }
        String processedFrameRateString = NULL_STRING;
        if (this.frameRateArray != null && frameRate != null && frameRate.value() < this.frameRateArray.length) {
            processedFrameRateString = this.frameRateArray[frameRate.value()];
        }
        return processedResolutionString + "/" + processedFrameRateString;
    }

    private Integer getSSDColorIndex(@NonNull SSDColor ssdColor) {
        SSDColor[] ssdColorValueArray = SSDColor.values();
        for (int i = 0; i < ssdColorValueArray.length; ++i) {
            if (ssdColorValueArray[i] != ssdColor) continue;
            return i;
        }
        return null;
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_camera_config_ssd_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setSSDClipInfoTextAppearance(@StyleRes int textAppearance) {
        this.ssdClipInfoTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getSSDClipInfoTextColors() {
        return this.ssdClipInfoTextView.getTextColors();
    }

    @ColorInt
    public int getSSDClipInfoTextColor() {
        return this.ssdClipInfoTextView.getCurrentTextColor();
    }

    public void setSSDClipInfoTextColor(@NonNull ColorStateList colorStateList) {
        this.ssdClipInfoTextView.setTextColor(colorStateList);
    }

    public void setSSDClipInfoTextColor(@ColorInt int color2) {
        this.ssdClipInfoTextView.setTextColor(color2);
    }

    @Dimension
    public float getSSDClipInfoTextSize() {
        return this.ssdClipInfoTextView.getTextSize();
    }

    public void setSSDClipInfoTextSize(@Dimension float textSize) {
        this.ssdClipInfoTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getSSDClipInfoTextBackground() {
        return this.ssdClipInfoTextView.getBackground();
    }

    public void setSSDClipInfoTextBackground(@DrawableRes int resourceId) {
        this.ssdClipInfoTextView.setBackgroundResource(resourceId);
    }

    public void setSSDClipInfoTextBackground(@Nullable Drawable drawable2) {
        this.ssdClipInfoTextView.setBackground(drawable2);
    }

    public void setSSDCapacityOrLicenseTextAppearance(@StyleRes int textAppearance) {
        this.ssdCapacityOrLicenseTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getSSDCapacityOrLicenseTextColors() {
        return this.ssdCapacityOrLicenseTextView.getTextColors();
    }

    @ColorInt
    public int getSSDCapacityOrLicenseTextColor() {
        return this.ssdCapacityOrLicenseTextView.getCurrentTextColor();
    }

    public void setSSDCapacityOrLicenseTextColor(@NonNull ColorStateList colorStateList) {
        this.ssdCapacityOrLicenseTextView.setTextColor(colorStateList);
    }

    public void setSSDCapacityOrLicenseTextColor(@ColorInt int color2) {
        this.ssdCapacityOrLicenseTextView.setTextColor(color2);
    }

    @Dimension
    public float getSSDCapacityOrLicenseTextSize() {
        return this.ssdCapacityOrLicenseTextView.getTextSize();
    }

    public void setSSDCapacityOrLicenseTextSize(@Dimension float textSize) {
        this.ssdCapacityOrLicenseTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getSSDCapacityOrLicenseTextBackground() {
        return this.ssdCapacityOrLicenseTextView.getBackground();
    }

    public void setSSDCapacityOrLicenseTextBackground(@DrawableRes int resourceId) {
        this.ssdCapacityOrLicenseTextView.setBackgroundResource(resourceId);
    }

    public void setSSDCapacityOrLicenseTextBackground(@Nullable Drawable drawable2) {
        this.ssdCapacityOrLicenseTextView.setBackground(drawable2);
    }

    public void setStatusInfoTextAppearance(@StyleRes int textAppearance) {
        this.statusInfoTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getStatusInfoTextColors() {
        return this.statusInfoTextView.getTextColors();
    }

    @ColorInt
    public int getStatusInfoTextColor() {
        return this.statusInfoTextView.getCurrentTextColor();
    }

    public void setStatusInfoTextColor(@NonNull ColorStateList colorStateList) {
        this.statusInfoTextView.setTextColor(colorStateList);
    }

    public void setStatusInfoTextColor(@ColorInt int color2) {
        this.statusInfoTextView.setTextColor(color2);
    }

    @Dimension
    public float getStatusInfoTextSize() {
        return this.statusInfoTextView.getTextSize();
    }

    public void setStatusInfoTextSize(@Dimension float textSize) {
        this.statusInfoTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getStatusInfoTextBackground() {
        return this.statusInfoTextView.getBackground();
    }

    public void setStatusInfoTextBackground(@DrawableRes int resourceId) {
        this.statusInfoTextView.setBackgroundResource(resourceId);
    }

    public void setStatusInfoTextBackground(@Nullable Drawable drawable2) {
        this.statusInfoTextView.setBackground(drawable2);
    }

    public void setFormatInfoTextAppearance(@StyleRes int textAppearance) {
        this.formatInfoTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getFormatInfoTextColors() {
        return this.formatInfoTextView.getTextColors();
    }

    @ColorInt
    public int getFormatInfoTextColor() {
        return this.formatInfoTextView.getCurrentTextColor();
    }

    public void setFormatInfoTextColor(@NonNull ColorStateList colorStateList) {
        this.formatInfoTextView.setTextColor(colorStateList);
    }

    public void setFormatInfoTextColor(@ColorInt int color2) {
        this.formatInfoTextView.setTextColor(color2);
    }

    @Dimension
    public float getFormatInfoTextSize() {
        return this.formatInfoTextView.getTextSize();
    }

    public void setFormatInfoTextSize(@Dimension float textSize) {
        this.formatInfoTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getFormatInfoTextBackground() {
        return this.formatInfoTextView.getBackground();
    }

    public void setFormatInfoTextBackground(@DrawableRes int resourceId) {
        this.formatInfoTextView.setBackgroundResource(resourceId);
    }

    public void setFormatInfoTextBackground(@Nullable Drawable drawable2) {
        this.formatInfoTextView.setBackground(drawable2);
    }

    public void setSSDCapacityValueTextAppearance(@StyleRes int textAppearance) {
        this.ssdCapacityValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public ColorStateList getSSDCapacityValueTextColors() {
        return this.ssdCapacityValueTextView.getTextColors();
    }

    @ColorInt
    public int getSSDCapacityValueTextColor() {
        return this.ssdCapacityValueTextView.getCurrentTextColor();
    }

    public void setSSDCapacityValueTextColor(@NonNull ColorStateList colorStateList) {
        this.ssdCapacityValueTextView.setTextColor(colorStateList);
    }

    public void setSSDCapacityValueTextColor(@ColorInt int color2) {
        this.ssdCapacityValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getSSDCapacityValueTextSize() {
        return this.ssdCapacityValueTextView.getTextSize();
    }

    public void setSSDCapacityValueTextSize(@Dimension float textSize) {
        this.ssdCapacityValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getSSDCapacityValueTextBackground() {
        return this.ssdCapacityValueTextView.getBackground();
    }

    public void setSSDCapacityValueTextBackground(@DrawableRes int resourceId) {
        this.ssdCapacityValueTextView.setBackgroundResource(resourceId);
    }

    public void setSSDCapacityValueTextBackground(@Nullable Drawable drawable2) {
        this.ssdCapacityValueTextView.setBackground(drawable2);
    }

    @NonNull
    public Drawable getSSDStatusIcon() {
        return this.ssdStatusImageView.getDrawable();
    }

    public void setSSDStatusIcon(@DrawableRes int resourceId) {
        this.ssdStatusImageView.setImageResource(resourceId);
    }

    public void setSSDStatusIcon(@NonNull Drawable icon) {
        this.ssdStatusImageView.setImageDrawable(icon);
    }

    @Nullable
    public Drawable getSSDStatusIconBackground() {
        return this.ssdStatusImageView.getBackground();
    }

    public void setSSDStatusIconBackground(@DrawableRes int resourceId) {
        this.ssdStatusImageView.setBackgroundResource(resourceId);
    }

    public void setSSDStatusIconBackground(@Nullable Drawable background) {
        this.ssdStatusImageView.setBackground(background);
    }

    public void setSSDIcon(@NonNull SSDOperationState state, @DrawableRes int resourceId) {
        this.setSSDIcon(state, this.getResources().getDrawable(resourceId));
    }

    public void setSSDIcon(@NonNull SSDOperationState state, @Nullable Drawable drawable2) {
        this.ssdIconMap.put(state, drawable2);
        this.checkAndUpdateSSDState();
    }

    @Nullable
    public Drawable getSSDIcon(@NonNull SSDOperationState state) {
        return this.ssdIconMap.get(state);
    }

    @Nullable
    public Drawable getSSDIconBackground() {
        return this.ssdImageView.getBackground();
    }

    public void setSSDIconBackground(@DrawableRes int resourceId) {
        this.ssdImageView.setBackgroundResource(resourceId);
    }

    public void setSSDIconBackground(@Nullable Drawable background) {
        this.ssdImageView.setBackground(background);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable statusInfoTextBackgroundDrawable;
        int statusInfoTextColor;
        float statusInfoTextSize;
        Drawable ssdClipInfoTextBackgroundDrawable;
        int ssdClipInfoTextColor;
        float ssdClipInfoTextSize;
        int ssdClipInfoTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigSSDWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigSSDWidget_uxsdk_cameraIndex, 0)), CameraLensType.UNKNOWN);
        }
        if ((ssdClipInfoTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigSSDWidget_uxsdk_ssdClipInfoTextAppearance, -1)) != -1) {
            this.setSSDClipInfoTextAppearance(ssdClipInfoTextAppearanceId);
        }
        if ((ssdClipInfoTextSize = typedArray.getDimension(R.styleable.CameraConfigSSDWidget_uxsdk_ssdClipInfoTextSize, -1.0f)) != -1.0f) {
            this.setSSDClipInfoTextSize(DisplayUtil.pxToSp((Context)context, (float)ssdClipInfoTextSize));
        }
        if ((ssdClipInfoTextColor = typedArray.getColor(R.styleable.CameraConfigSSDWidget_uxsdk_ssdClipInfoTextColor, 0)) != 0) {
            this.setSSDClipInfoTextColor(ssdClipInfoTextColor);
        }
        if ((ssdClipInfoTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdClipInfoTextBackground)) != null) {
            this.setSSDClipInfoTextBackground(ssdClipInfoTextBackgroundDrawable);
        }
        this.performSetSSDCapacity(context, typedArray);
        int statusInfoTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigSSDWidget_uxsdk_statusInfoTextAppearance, -1);
        if (statusInfoTextAppearanceId != -1) {
            this.setStatusInfoTextAppearance(statusInfoTextAppearanceId);
        }
        if ((statusInfoTextSize = typedArray.getDimension(R.styleable.CameraConfigSSDWidget_uxsdk_statusInfoTextSize, -1.0f)) != -1.0f) {
            this.setStatusInfoTextSize(DisplayUtil.pxToSp((Context)context, (float)statusInfoTextSize));
        }
        if ((statusInfoTextColor = typedArray.getColor(R.styleable.CameraConfigSSDWidget_uxsdk_statusInfoTextColor, 0)) != 0) {
            this.setStatusInfoTextColor(statusInfoTextColor);
        }
        if ((statusInfoTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_statusInfoTextBackground)) != null) {
            this.setStatusInfoTextBackground(statusInfoTextBackgroundDrawable);
        }
        this.setFormatInfoAndSSDCapacity(context, typedArray);
        this.performSetSSDIcon(typedArray);
        typedArray.recycle();
    }

    private void setFormatInfoAndSSDCapacity(Context context, TypedArray typedArray) {
        int ssdCapacityValueTextColor;
        float ssdCapacityValueTextSize;
        int ssdCapacityValueTextAppearanceId;
        Drawable formatInfoTextBackgroundDrawable;
        int formatInfoTextColor;
        float formatInfoTextSize;
        int formatInfoTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigSSDWidget_uxsdk_imageFormatTextAppearance, -1);
        if (formatInfoTextAppearanceId != -1) {
            this.setFormatInfoTextAppearance(formatInfoTextAppearanceId);
        }
        if ((formatInfoTextSize = typedArray.getDimension(R.styleable.CameraConfigSSDWidget_uxsdk_imageFormatTextSize, -1.0f)) != -1.0f) {
            this.setFormatInfoTextSize(DisplayUtil.pxToSp((Context)context, (float)formatInfoTextSize));
        }
        if ((formatInfoTextColor = typedArray.getColor(R.styleable.CameraConfigSSDWidget_uxsdk_imageFormatTextColor, 0)) != 0) {
            this.setFormatInfoTextColor(formatInfoTextColor);
        }
        if ((formatInfoTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_imageFormatTextBackground)) != null) {
            this.setFormatInfoTextBackground(formatInfoTextBackgroundDrawable);
        }
        if ((ssdCapacityValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigSSDWidget_uxsdk_capacityValueTextAppearance, -1)) != -1) {
            this.setSSDCapacityValueTextAppearance(ssdCapacityValueTextAppearanceId);
        }
        if ((ssdCapacityValueTextSize = typedArray.getDimension(R.styleable.CameraConfigSSDWidget_uxsdk_capacityValueTextSize, -1.0f)) != -1.0f) {
            this.setSSDCapacityValueTextSize(DisplayUtil.pxToSp((Context)context, (float)ssdCapacityValueTextSize));
        }
        if ((ssdCapacityValueTextColor = typedArray.getColor(R.styleable.CameraConfigSSDWidget_uxsdk_capacityValueTextColor, 0)) != 0) {
            this.setSSDCapacityValueTextColor(ssdCapacityValueTextColor);
        }
    }

    private void performSetSSDCapacity(Context context, TypedArray typedArray) {
        Drawable ssdCapacityOrLicenseTextBackgroundDrawable;
        int ssdCapacityOrLicenseTextColor;
        float ssdCapacityOrLicenseTextSize;
        int ssdCapacityOrLicenseTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigSSDWidget_uxsdk_capacityOrLicenseTextAppearance, -1);
        if (ssdCapacityOrLicenseTextAppearanceId != -1) {
            this.setSSDCapacityOrLicenseTextAppearance(ssdCapacityOrLicenseTextAppearanceId);
        }
        if ((ssdCapacityOrLicenseTextSize = typedArray.getDimension(R.styleable.CameraConfigSSDWidget_uxsdk_capacityOrLicenseTextSize, -1.0f)) != -1.0f) {
            this.setSSDCapacityOrLicenseTextSize(DisplayUtil.pxToSp((Context)context, (float)ssdCapacityOrLicenseTextSize));
        }
        if ((ssdCapacityOrLicenseTextColor = typedArray.getColor(R.styleable.CameraConfigSSDWidget_uxsdk_capacityOrLicenseTextColor, 0)) != 0) {
            this.setSSDCapacityOrLicenseTextColor(ssdCapacityOrLicenseTextColor);
        }
        if ((ssdCapacityOrLicenseTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_capacityOrLicenseTextBackground)) != null) {
            this.setSSDCapacityOrLicenseTextBackground(ssdCapacityOrLicenseTextBackgroundDrawable);
        }
    }

    private void performSetSSDIcon(TypedArray typedArray) {
        Drawable ssdFormattingRequiredIcon;
        Drawable ssdSwitchingLicenseIcon;
        Drawable ssdPoorConnectionIcon;
        Drawable ssdFullIcon;
        Drawable ssdErrorIcon;
        Drawable ssdInitializingIcon;
        Drawable ssdFormattingIcon;
        Drawable ssdSavingIcon;
        Drawable ssdIdleIcon;
        Drawable ssdUnknownIcon;
        Drawable ssdNotFoundIcon;
        Drawable ssdStatusIcon;
        Drawable ssdCapacityValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_capacityValueTextBackground);
        if (ssdCapacityValueTextBackgroundDrawable != null) {
            this.setSSDCapacityValueTextBackground(ssdCapacityValueTextBackgroundDrawable);
        }
        if ((ssdStatusIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdStatusIcon)) != null) {
            this.setSSDStatusIcon(ssdStatusIcon);
        }
        if ((ssdNotFoundIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdNotFoundIcon)) != null) {
            this.setSSDIcon(SSDOperationState.NOT_FOUND, ssdNotFoundIcon);
        }
        if ((ssdUnknownIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdUnknownIcon)) != null) {
            this.setSSDIcon(SSDOperationState.UNKNOWN, ssdUnknownIcon);
        }
        if ((ssdIdleIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdIdleIcon)) != null) {
            this.setSSDIcon(SSDOperationState.IDLE, ssdIdleIcon);
        }
        if ((ssdSavingIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdSavingIcon)) != null) {
            this.setSSDIcon(SSDOperationState.SAVING, ssdSavingIcon);
        }
        if ((ssdFormattingIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdFormattingIcon)) != null) {
            this.setSSDIcon(SSDOperationState.FORMATTING, ssdFormattingIcon);
        }
        if ((ssdInitializingIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdInitializingIcon)) != null) {
            this.setSSDIcon(SSDOperationState.INITIALIZING, ssdInitializingIcon);
        }
        if ((ssdErrorIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdErrorIcon)) != null) {
            this.setSSDIcon(SSDOperationState.STATE_ERROR, ssdErrorIcon);
        }
        if ((ssdFullIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdFullIcon)) != null) {
            this.setSSDIcon(SSDOperationState.FULL, ssdFullIcon);
        }
        if ((ssdPoorConnectionIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdPoorConnectionIcon)) != null) {
            this.setSSDIcon(SSDOperationState.POOR_CONNECTION, ssdPoorConnectionIcon);
        }
        if ((ssdSwitchingLicenseIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdSwitchingLicenseIcon)) != null) {
            this.setSSDIcon(SSDOperationState.SWITCHING_LICENSE, ssdSwitchingLicenseIcon);
        }
        if ((ssdFormattingRequiredIcon = typedArray.getDrawable(R.styleable.CameraConfigSSDWidget_uxsdk_ssdFormattingRequiredIcon)) != null) {
            this.setSSDIcon(SSDOperationState.FORMATTING_REQUIRED, ssdFormattingRequiredIcon);
        }
    }
}

