/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.ndvi;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.ui.component.PaletteItemDecoration;
import dji.v5.ux.visualcamera.ndvi.NDVIStreamSelectionPanelWidgetModel;
import dji.v5.ux.visualcamera.ndvi.StreamAdapter;
import dji.v5.ux.visualcamera.ndvi.StreamPanelUtil;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001fH\u0016J\"\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010%\u001a\u00020!H\u0014J\b\u0010&\u001a\u00020!H\u0014J\b\u0010'\u001a\u00020!H\u0014J\u0016\u0010(\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160*H\u0002J\u0016\u0010+\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*H\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010-\u001a\u00020\u001bH\u0002R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldji/v5/ux/visualcamera/ndvi/NDVIStreamSelectionPanelWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "Ldji/v5/ux/core/base/ICameraIndex;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "widgetModel", "Ldji/v5/ux/visualcamera/ndvi/NDVIStreamSelectionPanelWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/visualcamera/ndvi/NDVIStreamSelectionPanelWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "vegetationList", "Landroidx/recyclerview/widget/RecyclerView;", "vegetationAdapter", "Ldji/v5/ux/visualcamera/ndvi/StreamAdapter;", "Ldji/v5/ux/visualcamera/ndvi/StreamPanelUtil$VegetationModel;", "narrowBandList", "narrowBandTv", "Landroid/widget/TextView;", "narrowBandAdapter", "Ldji/v5/ux/visualcamera/ndvi/StreamPanelUtil$NarrowBandModel;", "getCameraIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "getLensType", "Ldji/sdk/keyvalue/value/common/CameraLensType;", "updateCameraSource", "", "cameraIndex", "lensType", "initView", "reactToModelChanges", "onAttachedToWindow", "onDetachedFromWindow", "setVegetationData", "models", "", "setNarrowBandData", "setCurrentVegetationPosition", "position", "setCurrentNarrowBandPosition", "android-sdk-v5-uxsdk_debug"})
public class NDVIStreamSelectionPanelWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    @NotNull
    private final Lazy widgetModel$delegate;
    private RecyclerView vegetationList;
    @NotNull
    private StreamAdapter<StreamPanelUtil.VegetationModel> vegetationAdapter;
    private RecyclerView narrowBandList;
    private TextView narrowBandTv;
    @NotNull
    private StreamAdapter<StreamPanelUtil.NarrowBandModel> narrowBandAdapter;

    @JvmOverloads
    public NDVIStreamSelectionPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.widgetModel$delegate = LazyKt.lazy(NDVIStreamSelectionPanelWidget::widgetModel_delegate$lambda$0);
        this.vegetationAdapter = new StreamAdapter(arg_0 -> NDVIStreamSelectionPanelWidget.vegetationAdapter$lambda$1(this, arg_0));
        this.narrowBandAdapter = new StreamAdapter(arg_0 -> NDVIStreamSelectionPanelWidget.narrowBandAdapter$lambda$2(this, arg_0));
    }

    public /* synthetic */ NDVIStreamSelectionPanelWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final NDVIStreamSelectionPanelWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (NDVIStreamSelectionPanelWidgetModel)lazy.getValue();
    }

    @Override
    @NotNull
    public ComponentIndexType getCameraIndex() {
        ComponentIndexType componentIndexType = this.getWidgetModel().getCameraIndex();
        Intrinsics.checkNotNullExpressionValue((Object)componentIndexType, (String)"getCameraIndex(...)");
        return componentIndexType;
    }

    @Override
    @NotNull
    public CameraLensType getLensType() {
        CameraLensType cameraLensType = this.getWidgetModel().getLensType();
        Intrinsics.checkNotNullExpressionValue((Object)cameraLensType, (String)"getLensType(...)");
        return cameraLensType;
    }

    @Override
    public void updateCameraSource(@NotNull ComponentIndexType cameraIndex, @NotNull CameraLensType lensType) {
        Intrinsics.checkNotNullParameter((Object)cameraIndex, (String)"cameraIndex");
        Intrinsics.checkNotNullParameter((Object)lensType, (String)"lensType");
        this.getWidgetModel().updateCameraSource(cameraIndex, lensType);
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_ux_ndvi_stream_selection_panel, (ViewGroup)((ViewGroup)this));
        Context context2 = this.getContext();
        GridLayoutManager layoutManager3 = new GridLayoutManager(context2){

            public boolean canScrollVertically() {
                return false;
            }
        };
        Context context3 = this.getContext();
        GridLayoutManager layoutManager22 = new GridLayoutManager(context3){

            public boolean canScrollVertically() {
                return false;
            }
        };
        this.vegetationList = (RecyclerView)this.findViewById(R.id.vegetation_index_list);
        RecyclerView recyclerView = this.vegetationList;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vegetationList");
            recyclerView = null;
        }
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager3);
        RecyclerView recyclerView2 = this.vegetationList;
        if (recyclerView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vegetationList");
            recyclerView2 = null;
        }
        recyclerView2.setItemAnimator(null);
        this.narrowBandList = (RecyclerView)this.findViewById(R.id.narrow_band_list);
        this.narrowBandTv = (TextView)this.findViewById(R.id.narrow_band_tv);
        RecyclerView recyclerView3 = this.narrowBandList;
        if (recyclerView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"narrowBandList");
            recyclerView3 = null;
        }
        recyclerView3.setLayoutManager((RecyclerView.LayoutManager)layoutManager22);
        RecyclerView recyclerView4 = this.narrowBandList;
        if (recyclerView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"narrowBandList");
            recyclerView4 = null;
        }
        recyclerView4.setItemAnimator(null);
        int hEdgeSpacing = MathKt.roundToInt((float)AndUtil.getDimension((int)R.dimen.uxsdk_8_dp));
        int vSpacing = MathKt.roundToInt((float)AndUtil.getDimension((int)R.dimen.uxsdk_12_dp));
        int hSpacing = MathKt.roundToInt((float)AndUtil.getDimension((int)R.dimen.uxsdk_4_dp));
        PaletteItemDecoration decoration = new PaletteItemDecoration(3, hEdgeSpacing, vSpacing, 0, hSpacing, vSpacing);
        RecyclerView recyclerView5 = this.vegetationList;
        if (recyclerView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vegetationList");
            recyclerView5 = null;
        }
        recyclerView5.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        RecyclerView recyclerView6 = this.narrowBandList;
        if (recyclerView6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"narrowBandList");
            recyclerView6 = null;
        }
        recyclerView6.addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getCurrentNarrowBandModelProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ NDVIStreamSelectionPanelWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(StreamPanelUtil.NarrowBandModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NDVIStreamSelectionPanelWidget.access$setCurrentNarrowBandPosition(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getCurrentVegetationModelProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ NDVIStreamSelectionPanelWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(StreamPanelUtil.VegetationModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NDVIStreamSelectionPanelWidget.access$setCurrentVegetationPosition(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
    }

    @Override
    protected void onAttachedToWindow() {
        RecyclerView recyclerView;
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
        if ((recyclerView = this.vegetationList) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vegetationList");
            recyclerView = null;
        }
        recyclerView.setAdapter((RecyclerView.Adapter)this.vegetationAdapter);
        RecyclerView recyclerView2 = this.narrowBandList;
        if (recyclerView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"narrowBandList");
            recyclerView2 = null;
        }
        recyclerView2.setAdapter((RecyclerView.Adapter)this.narrowBandAdapter);
        this.setVegetationData(this.getWidgetModel().getVegetationModelList());
        this.setNarrowBandData(this.getWidgetModel().getNarrowBandModelList());
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    private final void setVegetationData(List<StreamPanelUtil.VegetationModel> models) {
        this.vegetationAdapter.getModels().clear();
        this.vegetationAdapter.getModels().addAll((Collection<StreamPanelUtil.VegetationModel>)models);
        this.vegetationAdapter.notifyDataSetChanged();
    }

    private final void setNarrowBandData(List<StreamPanelUtil.NarrowBandModel> models) {
        this.narrowBandAdapter.getModels().clear();
        this.narrowBandAdapter.getModels().addAll((Collection<StreamPanelUtil.NarrowBandModel>)models);
        this.narrowBandAdapter.notifyDataSetChanged();
    }

    private final void setCurrentVegetationPosition(StreamPanelUtil.VegetationModel position) {
        this.vegetationAdapter.setCurrentPosition(position);
        this.vegetationAdapter.notifyDataSetChanged();
    }

    private final void setCurrentNarrowBandPosition(StreamPanelUtil.NarrowBandModel position) {
        this.narrowBandAdapter.setCurrentPosition(position);
        this.narrowBandAdapter.notifyDataSetChanged();
    }

    @JvmOverloads
    public NDVIStreamSelectionPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public NDVIStreamSelectionPanelWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final NDVIStreamSelectionPanelWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new NDVIStreamSelectionPanelWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final Unit vegetationAdapter$lambda$1(NDVIStreamSelectionPanelWidget this$0, StreamPanelUtil.VegetationModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.getWidgetModel().isEnableProcessor().getValue().booleanValue()) {
            this$0.setCurrentVegetationPosition(it);
            this$0.getWidgetModel().setVegetationModel(it).subscribe();
        } else {
            ViewExtensions.showShortToast((View)this$0, R.string.uxsdk_switch_stream_unsupported);
        }
        return Unit.INSTANCE;
    }

    private static final Unit narrowBandAdapter$lambda$2(NDVIStreamSelectionPanelWidget this$0, StreamPanelUtil.NarrowBandModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.getWidgetModel().isEnableProcessor().getValue().booleanValue()) {
            this$0.setCurrentNarrowBandPosition(it);
            this$0.getWidgetModel().setNarrowBandModel(it).subscribe();
        } else {
            ViewExtensions.showShortToast((View)this$0, R.string.uxsdk_switch_stream_unsupported);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setCurrentNarrowBandPosition(NDVIStreamSelectionPanelWidget $this, StreamPanelUtil.NarrowBandModel position) {
        $this.setCurrentNarrowBandPosition(position);
    }

    public static final /* synthetic */ void access$setCurrentVegetationPosition(NDVIStreamSelectionPanelWidget $this, StreamPanelUtil.VegetationModel position) {
        $this.setCurrentVegetationPosition(position);
    }
}

