/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.sample.showcase.widgetlist;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class WidgetViewHolder<T> {
    private static final String TAG = "WidgetViewHolder";
    private ViewGroup widget;
    private final Class<T> clazz;
    private final int layoutWidthDp;
    private final int layoutHeightDp;

    public WidgetViewHolder(Class<T> clazz) {
        this(clazz, -2, -2);
    }

    public WidgetViewHolder(Class<T> clazz, int layoutWidthDp, int layoutHeightDp) {
        this.clazz = clazz;
        this.layoutWidthDp = layoutWidthDp;
        this.layoutHeightDp = layoutHeightDp;
    }

    @Nullable
    public ViewGroup getWidget(Context context) {
        int layoutWidthPx = this.layoutWidthDp == -1 || this.layoutWidthDp == -2 ? this.layoutWidthDp : (int)DisplayUtil.dipToPx((Context)context, (float)this.layoutWidthDp);
        int layoutHeightPx = this.layoutHeightDp == -1 || this.layoutHeightDp == -2 ? this.layoutHeightDp : (int)DisplayUtil.dipToPx((Context)context, (float)this.layoutHeightDp);
        try {
            Constructor<T> constructor = this.clazz.getConstructor(Context.class);
            this.widget = (ViewGroup)constructor.newInstance(context);
            LinearLayout.LayoutParams simulatorIndicatorParams = new LinearLayout.LayoutParams(layoutWidthPx, layoutHeightPx);
            this.widget.setLayoutParams((ViewGroup.LayoutParams)simulatorIndicatorParams);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LogUtils.e((String)TAG, (Object[])new Object[]{e + " " + e.getCause()});
        }
        return this.widget;
    }

    @NonNull
    public String getIdealDimensionRatioString() {
        if (this.widget instanceof ConstraintLayoutWidget) {
            return ((ConstraintLayoutWidget)this.widget).getIdealDimensionRatioString();
        }
        if (this.widget instanceof FrameLayoutWidget) {
            return ((FrameLayoutWidget)this.widget).getIdealDimensionRatioString();
        }
        return "";
    }

    public String getWidgetSize() {
        if (this.widget == null) {
            return "[0,0]";
        }
        return "[" + this.widget.getMeasuredWidth() + "," + this.widget.getMeasuredHeight() + "]";
    }
}

