/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.layers.Layer;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.mapkit.core.callback.MapScreenShotListener;
import dji.v5.ux.mapkit.core.callback.OnMapTypeLoadedListener;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.maps.DJIBaseMap;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircle;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.core.utils.DJIMapkitLog;
import dji.v5.ux.mapkit.maplibre.annotations.MaplibreCircle;
import dji.v5.ux.mapkit.maplibre.annotations.MaplibreMarker;
import dji.v5.ux.mapkit.maplibre.annotations.MaplibrePolygon;
import dji.v5.ux.mapkit.maplibre.annotations.MaplibrePolyline;
import dji.v5.ux.mapkit.maplibre.map.MProjection;
import dji.v5.ux.mapkit.maplibre.map.MUiSettings;
import dji.v5.ux.mapkit.maplibre.utils.MapboxExtension;
import dji.v5.ux.mapkit.maplibre.utils.MapboxUtil;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 d2\u00020\u0001:\u0002cdB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f*\u0012\u0012\u0004\u0012\u0002H\f0\rj\b\u0012\u0004\u0012\u0002H\f`\u000e2\u0006\u0010\u000f\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0010J/\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\f*\u0012\u0012\u0004\u0012\u0002H\f0\rj\b\u0012\u0004\u0012\u0002H\f`\u000e2\u0006\u0010\u000f\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0013J%\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\u000f\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\u000f\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0014\u0010,\u001a\u0004\u0018\u00010-2\b\u0010*\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u000b2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:H\u0016J\u001a\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u001a\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?2\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020@H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010!2\u0006\u0010*\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020!H\u0002J\u0010\u0010F\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010I\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020@2\u0006\u0010J\u001a\u00020\u001dH\u0002J\b\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020\u000bH\u0016J\u0018\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020U2\u0006\u0010D\u001a\u00020@H\u0002J\u0018\u0010V\u001a\u00020\u00122\u0006\u0010T\u001a\u00020U2\u0006\u0010D\u001a\u00020@H\u0002J\u0010\u0010W\u001a\u00020\u00122\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\\H\u0002J\u0018\u0010^\u001a\u00020\u00122\u0006\u0010_\u001a\u00020\u00072\u0006\u0010`\u001a\u00020aH\u0002J\b\u0010b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\rj\b\u0012\u0004\u0012\u00020\u001a`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\rj\b\u0012\u0004\u0012\u00020\u001d`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\rj\b\u0012\u0004\u0012\u00020\u001f`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020!0\rj\b\u0012\u0004\u0012\u00020!`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Ldji/v5/ux/mapkit/maplibre/map/MaplibreMapDelegateKt;", "Ldji/v5/ux/mapkit/core/maps/DJIBaseMap;", "mapboxMap", "Lcom/mapbox/mapboxsdk/maps/MapboxMap;", "context", "Landroid/content/Context;", "mapView", "Landroid/view/View;", "<init>", "(Lcom/mapbox/mapboxsdk/maps/MapboxMap;Landroid/content/Context;Landroid/view/View;)V", "addAndLog", "", "T", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "e", "(Ljava/util/HashSet;Ljava/lang/Object;)V", "removeAndLog", "", "(Ljava/util/HashSet;Ljava/lang/Object;)Z", "Ljava/util/TreeSet;", "(Ljava/util/TreeSet;Ljava/lang/Object;)V", "(Ljava/util/TreeSet;Ljava/lang/Object;)Z", "infoWindowAdapter", "Ldji/v5/ux/mapkit/core/maps/DJIMap$InfoWindowAdapter;", "currentSelectedMarker", "Ldji/v5/ux/mapkit/maplibre/annotations/MaplibreMarker;", "markerSet", "circleSet", "Ldji/v5/ux/mapkit/maplibre/annotations/MaplibreCircle;", "polygonSet", "Ldji/v5/ux/mapkit/maplibre/annotations/MaplibrePolygon;", "polylineSet", "Ldji/v5/ux/mapkit/maplibre/annotations/MaplibrePolyline;", "sortedLayerWithZindex", "Ldji/v5/ux/mapkit/maplibre/map/MaplibreMapDelegateKt$LayerWithZindex;", "addMarker", "Ldji/v5/ux/mapkit/core/models/annotations/DJIMarker;", "markerOptions", "Ldji/v5/ux/mapkit/core/models/annotations/DJIMarkerOptions;", "addMarkerCircle", "Ldji/v5/ux/mapkit/core/models/annotations/DJICircle;", "options", "Ldji/v5/ux/mapkit/core/models/annotations/DJICircleOptions;", "addGroupCircle", "Ldji/v5/ux/mapkit/core/models/annotations/DJIGroupCircle;", "Ldji/v5/ux/mapkit/core/models/annotations/DJIGroupCircleOptions;", "getMap", "animateCamera", "cameraUpdate", "Ldji/v5/ux/mapkit/core/camera/DJICameraUpdate;", "getCameraPosition", "Ldji/v5/ux/mapkit/core/models/DJICameraPosition;", "moveCamera", "setInfoWindowAdapter", "adapter", "setMapType", "type", "Ldji/v5/ux/mapkit/core/maps/DJIMap$MapType;", "listener", "Ldji/v5/ux/mapkit/core/callback/OnMapTypeLoadedListener;", "restoreResources", "style", "Lcom/mapbox/mapboxsdk/maps/Style;", "", "addPolyline", "Ldji/v5/ux/mapkit/core/models/annotations/DJIPolylineOptions;", "addPolylineAtZIndex", "zindex", "polyline", "addPolygon", "Ldji/v5/ux/mapkit/core/models/annotations/DJIPolygonOptions;", "addSingleCircle", "addCircleAtZIndex", "circle", "getUiSettings", "Ldji/v5/ux/mapkit/maplibre/map/MUiSettings;", "snapshot", "callback", "Ldji/v5/ux/mapkit/core/callback/MapScreenShotListener;", "getProjection", "Ldji/v5/ux/mapkit/maplibre/map/MProjection;", "clear", "addLayer", "layer", "Lcom/mapbox/mapboxsdk/style/layers/Layer;", "removeLayer", "handleClickIcon", "screenPoint", "Landroid/graphics/PointF;", "handleClickMap", "latLng", "Lcom/mapbox/mapboxsdk/geometry/LatLng;", "handleLongClickMap", "handleTouch", "v", "motionEvent", "Landroid/view/MotionEvent;", "handleCameraMove", "LayerWithZindex", "Companion", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nMaplibreMapDelegateKt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaplibreMapDelegateKt.kt\ndji/v5/ux/mapkit/maplibre/map/MaplibreMapDelegateKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1855#2,2:347\n1855#2,2:349\n1855#2,2:351\n1855#2,2:353\n1855#2,2:355\n1855#2,2:357\n1855#2,2:359\n1855#2,2:361\n1855#2,2:363\n1855#2,2:365\n1855#2,2:367\n1855#2,2:369\n1855#2,2:371\n1855#2,2:373\n1855#2,2:375\n1#3:377\n*S KotlinDebug\n*F\n+ 1 MaplibreMapDelegateKt.kt\ndji/v5/ux/mapkit/maplibre/map/MaplibreMapDelegateKt\n*L\n117#1:347,2\n127#1:349,2\n128#1:351,2\n129#1:353,2\n130#1:355,2\n135#1:357,2\n136#1:359,2\n137#1:361,2\n138#1:363,2\n139#1:365,2\n214#1:367,2\n218#1:369,2\n222#1:371,2\n226#1:373,2\n230#1:375,2\n*E\n"})
public final class MaplibreMapDelegateKt
extends DJIBaseMap {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MapboxMap mapboxMap;
    @NotNull
    private final Context context;
    @Nullable
    private DJIMap.InfoWindowAdapter infoWindowAdapter;
    @Nullable
    private MaplibreMarker currentSelectedMarker;
    @NotNull
    private final HashSet<MaplibreMarker> markerSet;
    @NotNull
    private final HashSet<MaplibreCircle> circleSet;
    @NotNull
    private final HashSet<MaplibrePolygon> polygonSet;
    @NotNull
    private final HashSet<MaplibrePolyline> polylineSet;
    @NotNull
    private final TreeSet<LayerWithZindex> sortedLayerWithZindex;
    @NotNull
    private static final String TAG = "MaplibreMapDelegateKt";

    public MaplibreMapDelegateKt(@NotNull MapboxMap mapboxMap, @NotNull Context context, @NotNull View mapView) {
        MapboxMap mapboxMap2;
        Intrinsics.checkNotNullParameter((Object)mapboxMap, (String)"mapboxMap");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        this.mapboxMap = mapboxMap;
        this.context = context;
        MapboxMap $this$_init__u24lambda_u243 = mapboxMap2 = this.mapboxMap;
        boolean bl = false;
        $this$_init__u24lambda_u243.addOnCameraMoveListener(() -> MaplibreMapDelegateKt.lambda$3$lambda$0(this));
        $this$_init__u24lambda_u243.addOnMapClickListener(arg_0 -> MaplibreMapDelegateKt.lambda$3$lambda$1(this, arg_0));
        $this$_init__u24lambda_u243.addOnMapLongClickListener(arg_0 -> MaplibreMapDelegateKt.lambda$3$lambda$2(this, arg_0));
        mapView.setOnTouchListener((arg_0, arg_1) -> MaplibreMapDelegateKt._init_$lambda$4(this, arg_0, arg_1));
        this.markerSet = new HashSet();
        this.circleSet = new HashSet();
        this.polygonSet = new HashSet();
        this.polylineSet = new HashSet();
        this.sortedLayerWithZindex = new TreeSet();
    }

    private final <T> void addAndLog(HashSet<T> $this$addAndLog, T e) {
        $this$addAndLog.add(e);
        DJIMapkitLog.i(TAG, "[add] current set " + $this$addAndLog);
    }

    private final <T> boolean removeAndLog(HashSet<T> $this$removeAndLog, T e) {
        boolean bl;
        if (!$this$removeAndLog.remove(e)) {
            DJIMapkitLog.e(TAG, "[remove] " + e + " from hash set " + $this$removeAndLog);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final <T> void addAndLog(TreeSet<T> $this$addAndLog, T e) {
        $this$addAndLog.add(e);
        DJIMapkitLog.i(TAG, "[add] current tree set " + $this$addAndLog);
    }

    private final <T> boolean removeAndLog(TreeSet<T> $this$removeAndLog, T e) {
        boolean bl;
        if (!$this$removeAndLog.remove(e)) {
            DJIMapkitLog.e(TAG, "[remove] " + e + " from tree set " + $this$removeAndLog);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    @Nullable
    public DJIMarker addMarker(@NotNull DJIMarkerOptions markerOptions) {
        MaplibreMarker maplibreMarker;
        Intrinsics.checkNotNullParameter((Object)markerOptions, (String)"markerOptions");
        if (this.mapboxMap.getStyle() == null) {
            return null;
        }
        MaplibreMarker it = maplibreMarker = new MaplibreMarker(this.context, this.mapboxMap, markerOptions, (Function2<? super Integer, ? super MaplibreMarker, Boolean>)((Function2)(arg_0, arg_1) -> MaplibreMapDelegateKt.addMarker$lambda$5(this, arg_0, arg_1)));
        boolean bl = false;
        it.setInfoWindowAdapter$android_sdk_v5_uxsdk_debug(this.infoWindowAdapter);
        this.addLayer((Layer)it.getMarkerLayer$android_sdk_v5_uxsdk_debug(), markerOptions.getZIndex());
        this.addAndLog(this.markerSet, it);
        return maplibreMarker;
    }

    @Override
    @Nullable
    public DJICircle addMarkerCircle(@Nullable DJICircleOptions options) {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @Nullable
    public DJIGroupCircle addGroupCircle(@Nullable DJIGroupCircleOptions options) {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @NotNull
    public MapboxMap getMap() {
        return this.mapboxMap;
    }

    @Override
    public void animateCamera(@NotNull DJICameraUpdate cameraUpdate) {
        Intrinsics.checkNotNullParameter((Object)cameraUpdate, (String)"cameraUpdate");
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
        this.mapboxMap.animateCamera(MapboxUtil.fromDJICameraUpdate(cameraUpdate, cameraPosition));
    }

    @Override
    @NotNull
    public DJICameraPosition getCameraPosition() {
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
        return MapboxUtil.fromCameraPosition(cameraPosition);
    }

    @Override
    public void moveCamera(@NotNull DJICameraUpdate cameraUpdate) {
        Intrinsics.checkNotNullParameter((Object)cameraUpdate, (String)"cameraUpdate");
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
        this.mapboxMap.moveCamera(MapboxUtil.fromDJICameraUpdate(cameraUpdate, cameraPosition));
    }

    @Override
    public void setInfoWindowAdapter(@NotNull DJIMap.InfoWindowAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.infoWindowAdapter = adapter;
        Iterable $this$forEach$iv = this.markerSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MaplibreMarker marker = (MaplibreMarker)element$iv;
            boolean bl = false;
            marker.setInfoWindowAdapter$android_sdk_v5_uxsdk_debug(adapter);
        }
    }

    @Override
    public void setMapType(@NotNull DJIMap.MapType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.setMapType(type, null);
    }

    @Override
    public void setMapType(@NotNull DJIMap.MapType type, @Nullable OnMapTypeLoadedListener listener2) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Iterable $this$forEach$iv = this.markerSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibreMarker)element$iv;
            boolean bl = false;
            ((MaplibreMarker)it).clearMarker$android_sdk_v5_uxsdk_debug();
        }
        $this$forEach$iv = this.circleSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibreCircle)element$iv;
            boolean bl = false;
            ((MaplibreCircle)it).clearCircle$android_sdk_v5_uxsdk_debug();
        }
        $this$forEach$iv = this.polygonSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibrePolygon)element$iv;
            boolean bl = false;
            ((MaplibrePolygon)it).clear$android_sdk_v5_uxsdk_debug();
        }
        $this$forEach$iv = this.polylineSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibrePolyline)element$iv;
            boolean bl = false;
            ((MaplibrePolyline)it).clear$android_sdk_v5_uxsdk_debug();
        }
        this.mapboxMap.setStyle(MapboxUtil.fromMapType(type), arg_0 -> MaplibreMapDelegateKt.setMapType$lambda$12(this, listener2, arg_0));
    }

    private final void restoreResources(Style style2, OnMapTypeLoadedListener listener2) {
        block5: {
            Object it;
            Iterable $this$forEach$iv = this.markerSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (MaplibreMarker)element$iv;
                boolean bl = false;
                ((MaplibreMarker)it).restore$android_sdk_v5_uxsdk_debug();
            }
            $this$forEach$iv = this.circleSet;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (MaplibreCircle)element$iv;
                boolean bl = false;
                ((MaplibreCircle)it).restore$android_sdk_v5_uxsdk_debug();
            }
            $this$forEach$iv = this.polygonSet;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (MaplibrePolygon)element$iv;
                boolean bl = false;
                ((MaplibrePolygon)it).restore$android_sdk_v5_uxsdk_debug();
            }
            $this$forEach$iv = this.polylineSet;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (MaplibrePolyline)element$iv;
                boolean bl = false;
                ((MaplibrePolyline)it).restore$android_sdk_v5_uxsdk_debug();
            }
            $this$forEach$iv = this.sortedLayerWithZindex;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LayerWithZindex)element$iv;
                boolean bl = false;
                MapboxExtension.addLayerAndLog(style2, ((LayerWithZindex)it).getLayer());
            }
            OnMapTypeLoadedListener onMapTypeLoadedListener = listener2;
            if (onMapTypeLoadedListener == null) break block5;
            onMapTypeLoadedListener.onMapTypeLoaded();
        }
    }

    @Override
    public void setMapType(int type) {
        switch (type) {
            case 1: {
                this.setMapType(DJIMap.MapType.NORMAL);
                break;
            }
            case 2: {
                this.setMapType(DJIMap.MapType.SATELLITE);
                break;
            }
            case 4: {
                this.setMapType(DJIMap.MapType.HYBRID);
                break;
            }
            default: {
                throw new IllegalArgumentException(type + " is not implemented");
            }
        }
    }

    @Override
    @Nullable
    public MaplibrePolyline addPolyline(@NotNull DJIPolylineOptions options) {
        MaplibrePolyline maplibrePolyline;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (this.mapboxMap.getStyle() == null) {
            return null;
        }
        MaplibrePolyline it = maplibrePolyline = new MaplibrePolyline(this.mapboxMap, options, (Function2<? super Integer, ? super MaplibrePolyline, Boolean>)((Function2)(arg_0, arg_1) -> MaplibreMapDelegateKt.addPolyline$lambda$18(this, arg_0, arg_1)), (Function2<? super Integer, ? super MaplibrePolyline, Unit>)((Function2)(arg_0, arg_1) -> MaplibreMapDelegateKt.addPolyline$lambda$19(this, arg_0, arg_1)));
        boolean bl = false;
        this.addPolylineAtZIndex((int)options.getZIndex(), it);
        return maplibrePolyline;
    }

    private final void addPolylineAtZIndex(int zindex, MaplibrePolyline polyline) {
        this.addLayer((Layer)polyline.getPolylineLayer$android_sdk_v5_uxsdk_debug(), zindex);
        this.addAndLog(this.polylineSet, polyline);
    }

    @Override
    @NotNull
    public MaplibrePolygon addPolygon(@NotNull DJIPolygonOptions options) {
        MaplibrePolygon maplibrePolygon;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        MaplibrePolygon it = maplibrePolygon = new MaplibrePolygon(this.mapboxMap, options, (Function2<? super Integer, ? super MaplibrePolygon, Boolean>)((Function2)(arg_0, arg_1) -> MaplibreMapDelegateKt.addPolygon$lambda$21(this, arg_0, arg_1)));
        boolean bl = false;
        this.addLayer((Layer)it.getPolygonLayer$android_sdk_v5_uxsdk_debug(), (int)options.getZIndex());
        this.addLayer((Layer)it.getBorderLayer$android_sdk_v5_uxsdk_debug(), (int)options.getZIndex());
        this.addAndLog(this.polygonSet, it);
        return maplibrePolygon;
    }

    @Override
    @NotNull
    public DJICircle addSingleCircle(@NotNull DJICircleOptions options) {
        MaplibreCircle maplibreCircle;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        MaplibreCircle it = maplibreCircle = new MaplibreCircle(this.mapboxMap, options, (Function2<? super Integer, ? super MaplibreCircle, Boolean>)((Function2)(arg_0, arg_1) -> MaplibreMapDelegateKt.addSingleCircle$lambda$23(this, arg_0, arg_1)), (Function2<? super Integer, ? super MaplibreCircle, Unit>)((Function2)(arg_0, arg_1) -> MaplibreMapDelegateKt.addSingleCircle$lambda$24(this, arg_0, arg_1)));
        boolean bl = false;
        this.addCircleAtZIndex((int)options.getZIndex(), it);
        return maplibreCircle;
    }

    private final void addCircleAtZIndex(int zindex, MaplibreCircle circle) {
        this.addLayer((Layer)circle.getCircleLayer$android_sdk_v5_uxsdk_debug(), zindex);
        this.addLayer((Layer)circle.getBorderLayer$android_sdk_v5_uxsdk_debug(), zindex);
        this.addAndLog(this.circleSet, circle);
    }

    @Override
    @NotNull
    public MUiSettings getUiSettings() {
        return new MUiSettings(this.mapboxMap.getUiSettings());
    }

    @Override
    public void snapshot(@NotNull MapScreenShotListener callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.mapboxMap.snapshot(arg_0 -> MaplibreMapDelegateKt.snapshot$lambda$26(callback, arg_0));
    }

    @Override
    @NotNull
    public MProjection getProjection() {
        return new MProjection(this.mapboxMap.getProjection());
    }

    @Override
    public void clear() {
        Object it;
        DJIMapkitLog.i(TAG, "clear");
        AbstractSet abstractSet = this.sortedLayerWithZindex;
        TreeSet<LayerWithZindex> $this$clear_u24lambda_u2428 = abstractSet;
        boolean bl = false;
        Iterable $this$forEach$iv = $this$clear_u24lambda_u2428;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LayerWithZindex)element$iv;
            boolean bl2 = false;
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) continue;
            MapboxExtension.removeLayerAndLog(style2, ((LayerWithZindex)it).getLayer());
        }
        $this$clear_u24lambda_u2428.clear();
        AbstractSet $this$clear_u24lambda_u2430 = abstractSet = this.markerSet;
        boolean bl3 = false;
        $this$forEach$iv = $this$clear_u24lambda_u2430;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibreMarker)element$iv;
            boolean bl4 = false;
            ((MaplibreMarker)it).clearMarker$android_sdk_v5_uxsdk_debug();
        }
        ((HashSet)$this$clear_u24lambda_u2430).clear();
        AbstractSet $this$clear_u24lambda_u2432 = abstractSet = this.circleSet;
        boolean bl5 = false;
        $this$forEach$iv = $this$clear_u24lambda_u2432;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibreCircle)element$iv;
            boolean bl6 = false;
            ((MaplibreCircle)it).clearCircle$android_sdk_v5_uxsdk_debug();
        }
        ((HashSet)$this$clear_u24lambda_u2432).clear();
        AbstractSet $this$clear_u24lambda_u2434 = abstractSet = this.polygonSet;
        boolean bl7 = false;
        $this$forEach$iv = $this$clear_u24lambda_u2434;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibrePolygon)element$iv;
            boolean bl8 = false;
            ((MaplibrePolygon)it).clear$android_sdk_v5_uxsdk_debug();
        }
        ((HashSet)$this$clear_u24lambda_u2434).clear();
        AbstractSet $this$clear_u24lambda_u2436 = abstractSet = this.polylineSet;
        boolean bl9 = false;
        $this$forEach$iv = $this$clear_u24lambda_u2436;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MaplibrePolyline)element$iv;
            boolean bl10 = false;
            ((MaplibrePolyline)it).clear$android_sdk_v5_uxsdk_debug();
        }
        ((HashSet)$this$clear_u24lambda_u2436).clear();
    }

    private final void addLayer(Layer layer, int zindex) {
        block0: {
            LayerWithZindex layerWithZindex;
            Style style2;
            block2: {
                block1: {
                    LayerWithZindex layerWithZindex2;
                    DJIMapkitLog.i(TAG, "[addLayer] ready to add " + layer.getId() + ", zindex " + zindex);
                    Style style3 = this.mapboxMap.getStyle();
                    if (style3 == null) break block0;
                    style2 = style3;
                    boolean bl = false;
                    LayerWithZindex it = layerWithZindex2 = new LayerWithZindex(layer, zindex);
                    boolean bl2 = false;
                    this.addAndLog(this.sortedLayerWithZindex, it);
                    layerWithZindex = layerWithZindex2;
                    if (this.sortedLayerWithZindex.size() != 1) break block1;
                    MapboxExtension.addLayerAndLog(style2, layer);
                    break block0;
                }
                LayerWithZindex lower = this.sortedLayerWithZindex.lower(layerWithZindex);
                if (lower == null) break block2;
                style2.addLayerAbove(layer, lower.getLayer().getId());
                break block0;
            }
            LayerWithZindex layerWithZindex3 = this.sortedLayerWithZindex.higher(layerWithZindex);
            if (layerWithZindex3 == null) break block0;
            LayerWithZindex it = layerWithZindex3;
            boolean bl = false;
            style2.addLayerBelow(layer, it.getLayer().getId());
        }
    }

    private final boolean removeLayer(Layer layer, int zindex) {
        return this.removeAndLog(this.sortedLayerWithZindex, new LayerWithZindex(layer, zindex));
    }

    private final boolean handleClickIcon(PointF screenPoint) {
        Iterator<MaplibreMarker> iterator = this.markerSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<MaplibreMarker> iterator2 = iterator;
        while (iterator2.hasNext()) {
            List selectedMarkerFeatureList;
            MaplibreMarker marker;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            String[] stringArray = new String[]{marker.getMarkerLayerId$android_sdk_v5_uxsdk_debug()};
            Intrinsics.checkNotNullExpressionValue((Object)this.mapboxMap.queryRenderedFeatures(screenPoint, stringArray), (String)"queryRenderedFeatures(...)");
            if (!(!((Collection)selectedMarkerFeatureList).isEmpty())) continue;
            this.onMarkerClick(marker);
            if (marker.isInfoWindowShown()) {
                marker.hideInfoWindow();
            } else {
                marker.showInfoWindow();
            }
            return true;
        }
        return false;
    }

    private final boolean handleClickMap(LatLng latLng) {
        PointF pointF = this.mapboxMap.getProjection().toScreenLocation(latLng);
        Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"toScreenLocation(...)");
        boolean isIconClick = this.handleClickIcon(pointF);
        if (!isIconClick) {
            this.onMapClick(MapboxUtil.fromLatLng(latLng));
        }
        return true;
    }

    private final boolean handleLongClickMap(LatLng latLng) {
        PointF pointF = this.mapboxMap.getProjection().toScreenLocation(latLng);
        Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"toScreenLocation(...)");
        PointF pointF2 = pointF;
        Iterator<MaplibreMarker> iterator = this.markerSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<MaplibreMarker> iterator2 = iterator;
        while (iterator2.hasNext()) {
            List selectedMarkerFeatureList;
            MaplibreMarker marker;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            String[] stringArray = new String[]{marker.getMarkerLayerId$android_sdk_v5_uxsdk_debug()};
            Intrinsics.checkNotNullExpressionValue((Object)this.mapboxMap.queryRenderedFeatures(pointF2, stringArray), (String)"queryRenderedFeatures(...)");
            if (!(!((Collection)selectedMarkerFeatureList).isEmpty())) continue;
            if (marker.isDraggable()) {
                this.currentSelectedMarker = marker;
                this.onMarkerDragStart(marker);
                return true;
            }
            return false;
        }
        this.onMapLongClick(MapboxUtil.fromLatLng(latLng));
        return true;
    }

    private final boolean handleTouch(View v, MotionEvent motionEvent) {
        boolean bl;
        Object[] objectArray = new Object[]{"view is null" + v};
        LogUtils.e((String)TAG, (Object[])objectArray);
        int action = motionEvent.getAction();
        if (action == 1) {
            if (this.currentSelectedMarker != null) {
                this.onMarkerDragEnd(this.currentSelectedMarker);
            }
            this.currentSelectedMarker = null;
        }
        if (this.currentSelectedMarker != null) {
            if (action == 2) {
                float x = motionEvent.getX();
                float y = motionEvent.getY();
                LatLng latLng = this.mapboxMap.getProjection().fromScreenLocation(new PointF(x, y));
                Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"fromScreenLocation(...)");
                LatLng latLng2 = latLng;
                MaplibreMarker maplibreMarker = this.currentSelectedMarker;
                if (maplibreMarker != null) {
                    maplibreMarker.setPosition(MaplibreUtils.fromLatLng(latLng2));
                }
                this.onMarkerDrag(this.currentSelectedMarker);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void handleCameraMove() {
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
        CameraPosition p = cameraPosition;
        DJICameraPosition cameraPosition2 = MapboxUtil.fromCameraPosition(p);
        this.onCameraChange(cameraPosition2);
    }

    private static final void lambda$3$lambda$0(MaplibreMapDelegateKt this$0) {
        this$0.handleCameraMove();
    }

    private static final boolean lambda$3$lambda$1(MaplibreMapDelegateKt this$0, LatLng it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleClickMap(it);
    }

    private static final boolean lambda$3$lambda$2(MaplibreMapDelegateKt this$0, LatLng it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleLongClickMap(it);
    }

    private static final boolean _init_$lambda$4(MaplibreMapDelegateKt this$0, View v, MotionEvent event) {
        Intrinsics.checkNotNull((Object)v);
        Intrinsics.checkNotNull((Object)event);
        return this$0.handleTouch(v, event);
    }

    private static final boolean addMarker$lambda$5(MaplibreMapDelegateKt this$0, int zindex, MaplibreMarker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        boolean removeMarker = this$0.removeAndLog(this$0.markerSet, marker);
        boolean removeLayer = this$0.removeLayer((Layer)marker.getMarkerLayer$android_sdk_v5_uxsdk_debug(), zindex);
        return removeLayer && removeMarker;
    }

    private static final void setMapType$lambda$12(MaplibreMapDelegateKt this$0, OnMapTypeLoadedListener $listener, Style it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.restoreResources(it, $listener);
    }

    private static final boolean addPolyline$lambda$18(MaplibreMapDelegateKt this$0, int zindex, MaplibrePolyline polyline) {
        Intrinsics.checkNotNullParameter((Object)polyline, (String)"polyline");
        boolean removePolyline = this$0.removeAndLog(this$0.polylineSet, polyline);
        boolean removeLayer = this$0.removeLayer((Layer)polyline.getPolylineLayer$android_sdk_v5_uxsdk_debug(), zindex);
        return removePolyline && removeLayer;
    }

    private static final Unit addPolyline$lambda$19(MaplibreMapDelegateKt this$0, int zindex, MaplibrePolyline polyline) {
        Intrinsics.checkNotNullParameter((Object)polyline, (String)"polyline");
        this$0.addPolylineAtZIndex(zindex, polyline);
        return Unit.INSTANCE;
    }

    private static final boolean addPolygon$lambda$21(MaplibreMapDelegateKt this$0, int zindex, MaplibrePolygon polygon) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        boolean removePolygon = this$0.removeAndLog(this$0.polygonSet, polygon);
        boolean removeLayer = this$0.removeLayer((Layer)polygon.getPolygonLayer$android_sdk_v5_uxsdk_debug(), zindex);
        boolean removeBorder = this$0.removeLayer((Layer)polygon.getBorderLayer$android_sdk_v5_uxsdk_debug(), zindex);
        return removePolygon && removeLayer && removeBorder;
    }

    private static final boolean addSingleCircle$lambda$23(MaplibreMapDelegateKt this$0, int zindex, MaplibreCircle circle) {
        Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
        boolean removeCircle = this$0.removeAndLog(this$0.circleSet, circle);
        boolean removeLayer = this$0.removeLayer((Layer)circle.getCircleLayer$android_sdk_v5_uxsdk_debug(), zindex);
        boolean removeBorder = this$0.removeLayer((Layer)circle.getBorderLayer$android_sdk_v5_uxsdk_debug(), zindex);
        return removeCircle && removeLayer && removeBorder;
    }

    private static final Unit addSingleCircle$lambda$24(MaplibreMapDelegateKt this$0, int zindex, MaplibreCircle circle) {
        Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
        this$0.addCircleAtZIndex(zindex, circle);
        return Unit.INSTANCE;
    }

    private static final void snapshot$lambda$26(MapScreenShotListener $callback, Bitmap it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $callback.onMapScreenShot(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/mapkit/maplibre/map/MaplibreMapDelegateKt$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/mapkit/maplibre/map/MaplibreMapDelegateKt$LayerWithZindex;", "", "layer", "Lcom/mapbox/mapboxsdk/style/layers/Layer;", "zindex", "", "<init>", "(Lcom/mapbox/mapboxsdk/style/layers/Layer;I)V", "getLayer", "()Lcom/mapbox/mapboxsdk/style/layers/Layer;", "getZindex", "()I", "compareTo", "other", "toString", "", "component1", "component2", "copy", "equals", "", "", "hashCode", "android-sdk-v5-uxsdk_debug"})
    private static final class LayerWithZindex
    implements Comparable<LayerWithZindex> {
        @NotNull
        private final Layer layer;
        private final int zindex;

        public LayerWithZindex(@NotNull Layer layer, int zindex) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            this.layer = layer;
            this.zindex = zindex;
        }

        @NotNull
        public final Layer getLayer() {
            return this.layer;
        }

        public final int getZindex() {
            return this.zindex;
        }

        @Override
        public int compareTo(@NotNull LayerWithZindex other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int zindexResult = this.zindex - other.zindex;
            if (zindexResult != 0) {
                n = zindexResult;
            } else {
                String string2 = this.layer.getId();
                String string3 = other.layer.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
                n = string2.compareTo(string3);
            }
            return n;
        }

        @NotNull
        public String toString() {
            return "LayerWithZindex(layer=" + this.layer.getId() + ", zindex=" + this.zindex + ")";
        }

        @NotNull
        public final Layer component1() {
            return this.layer;
        }

        public final int component2() {
            return this.zindex;
        }

        @NotNull
        public final LayerWithZindex copy(@NotNull Layer layer, int zindex) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            return new LayerWithZindex(layer, zindex);
        }

        public static /* synthetic */ LayerWithZindex copy$default(LayerWithZindex layerWithZindex, Layer layer, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                layer = layerWithZindex.layer;
            }
            if ((n2 & 2) != 0) {
                n = layerWithZindex.zindex;
            }
            return layerWithZindex.copy(layer, n);
        }

        public int hashCode() {
            int result = this.layer.hashCode();
            result = result * 31 + Integer.hashCode(this.zindex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LayerWithZindex)) {
                return false;
            }
            LayerWithZindex layerWithZindex = (LayerWithZindex)other;
            if (!Intrinsics.areEqual((Object)this.layer, (Object)layerWithZindex.layer)) {
                return false;
            }
            return this.zindex == layerWithZindex.zindex;
        }
    }
}

