/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.places;

import android.content.Context;
import androidx.annotation.NonNull;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.mapkit.core.Mapkit;
import dji.v5.ux.mapkit.core.MapkitOptions;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.places.DJIPoiItem;
import dji.v5.ux.mapkit.core.places.DJIPoiSearchQuery;
import dji.v5.ux.mapkit.core.places.DJIRegeocodeResult;
import dji.v5.ux.mapkit.core.places.IInternalPlacesClient;
import dji.v5.ux.mapkit.core.providers.MapProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class DJIPlacesClient {
    private static final String TAG = LogUtils.getTag((String)DJIPlacesClient.class.getSimpleName());
    private IInternalPlacesClient client;

    public DJIPlacesClient(@NonNull Context context, @NonNull MapkitOptions mapkitOptions) {
        List<Integer> providerList = mapkitOptions.getProviderList();
        for (int i = 0; i < providerList.size(); ++i) {
            String className = Mapkit.getMapProviderClassName(providerList.get(i));
            try {
                Class<?> c = Class.forName(className);
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object object = constructor.newInstance(new Object[0]);
                this.client = ((MapProvider)object).dispatchGeocodingClientRequest(context, mapkitOptions);
                if (this.client == null) continue;
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    public void setOnPoiSearchListener(OnPoiSearchListener onPoiSearchListener) {
        this.client.setOnPoiSearchListener(onPoiSearchListener);
    }

    public void setPoiSearchQuery(DJIPoiSearchQuery poiSearchQuery) {
        this.client.setPoiSearchQuery(poiSearchQuery);
    }

    public void searchPOIAsyn(DJILatLng latLng) {
        this.client.searchPOIAsyn(latLng);
    }

    public void searchPOIAsyn(DJILatLng latLng, int radius) {
        this.client.searchPOIAsyn(latLng, radius);
    }

    public void regeocodeSearchAsyn(DJILatLng latLng) {
        this.client.regeocodeSearchAsyn(latLng);
    }

    public void setOnRegeocodeSearchListener(OnRegeocodeSearchListener onRegeocodeSearchListener) {
        this.client.setOnRegeocodeSearchListener(onRegeocodeSearchListener);
    }

    public static interface OnPoiSearchListener {
        public void onPoiSearched(List<DJIPoiItem> var1);

        public void onPoiSearchFailed();
    }

    public static interface OnRegeocodeSearchListener {
        public void onSearched(DJIRegeocodeResult var1);
    }
}

