/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;

public class NetworkStateReceiver
extends BroadcastReceiver {
    private static final String TAG = "NetworkStateReceiver";
    private OnNetworkStateChangeListener listener;

    public NetworkStateReceiver(OnNetworkStateChangeListener listener2) {
        this.listener = listener2;
    }

    public void onReceive(Context context, Intent intent) {
        boolean isConnected = false;
        if (Build.VERSION.SDK_INT < 21) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo wifiNetworkInfo = connectivityManager.getNetworkInfo(1);
            NetworkInfo dataNetworkInfo = connectivityManager.getNetworkInfo(0);
            isConnected = wifiNetworkInfo != null && wifiNetworkInfo.isConnected() ? true : dataNetworkInfo != null && dataNetworkInfo.isConnected();
        } else {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            Network[] networks = connectivityManager.getAllNetworks();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < networks.length; ++i) {
                NetworkInfo networkInfo = connectivityManager.getNetworkInfo(networks[i]);
                sb.append(" " + networkInfo.getTypeName() + " connect is " + networkInfo.isConnected());
                isConnected = isConnected || networkInfo.isConnected();
            }
            Log.i((String)TAG, (String)("network infos: " + sb.toString()));
        }
        this.listener.onNetworkStateChange(isConnected);
    }

    public static interface OnNetworkStateChangeListener {
        public void onNetworkStateChange(boolean var1);
    }
}

