/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import android.content.Context;
import android.location.Location;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.remotecontroller.RCMode;
import dji.sdk.keyvalue.value.remotecontroller.RcGPSInfo;
import dji.v5.common.utils.GpsUtils;
import dji.v5.utils.common.LocationUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.flight.flightparam.HomeSetWidgetModel;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;

public class HomePointWidget
extends ConstraintLayoutWidget<Object> {
    private HomeSetWidgetModel widgetModel = new HomeSetWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    private ImageView rcAHomePointIv;
    private ImageView rcBHomePointIv;

    public HomePointWidget(@NonNull Context context) {
        super(context);
    }

    public HomePointWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public HomePointWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        HomePointWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_aircraft_home_set_layout, (ViewGroup)this);
        this.findViewById(R.id.setting_menu_flyc_homepoint_now).setOnClickListener(view -> this.prepareToSetHomePoint(0));
        this.rcAHomePointIv = (ImageView)this.findViewById(R.id.setting_menu_flyc_homepoint_rc_a);
        this.rcAHomePointIv.setOnClickListener(view -> this.prepareToSetHomePoint(1));
        this.rcBHomePointIv = (ImageView)this.findViewById(R.id.setting_menu_flyc_homepoint_rc_b);
        this.rcBHomePointIv.setOnClickListener(view -> this.prepareToSetHomePoint(2));
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(connected -> {
            if (!connected.booleanValue()) {
                this.updateHomePointViewWithSingleRc();
            }
        }));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    public void prepareToSetHomePoint(int index) {
        if (index == 0) {
            this.setAircraftHome();
        } else if (!this.widgetModel.isSupportMultiRc()) {
            this.prepareToSetCurRcHomePoint();
        } else {
            RCMode mode;
            RCMode rCMode = mode = index == 1 ? RCMode.CHANNEL_A : RCMode.CHANNEL_B;
            if (this.widgetModel.isCurrentRc(mode)) {
                this.prepareToSetCurRcHomePoint();
            } else {
                this.setRcHome(this.widgetModel.getOtherRcLocation(), false);
            }
        }
    }

    private void setAircraftHome() {
        this.widgetModel.setHomeLocationUseingAircraftLoc().subscribe(new CompletableObserver(){

            public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
            }

            public void onComplete() {
                ViewUtil.showToast(HomePointWidget.this.getContext(), R.string.uxsdk_fpv_toast_homepoint_setting_drone, 0);
            }

            public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
                ViewUtil.showToast(HomePointWidget.this.getContext(), R.string.uxsdk_fpv_toast_homepoint_setting_failed, 0);
            }
        });
    }

    private void prepareToSetCurRcHomePoint() {
        Location location = LocationUtil.getLastLocation();
        if (location == null) {
            RcGPSInfo gpsInfo = this.widgetModel.getRcGPSInfo();
            if (gpsInfo == null || !gpsInfo.getIsValid().booleanValue()) {
                ViewUtil.showToast(this.getContext(), R.string.uxsdk_fpv_toast_homepoint_gps_weak, 0);
                return;
            }
            location = GpsUtils.convertToLocation((RcGPSInfo)gpsInfo);
        }
        Location newLocation = location;
        int distance = this.widgetModel.checkRcGpsValid(location.getLatitude(), location.getLongitude(), location.getAccuracy());
        if (distance == -1) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_fpv_toast_homepoint_gps_weak, 0);
        } else {
            this.setRcHome(newLocation, true);
        }
    }

    private void setRcHome(Location location, boolean isCurrentRc) {
        if (location == null) {
            return;
        }
        LogUtils.i((String)"RcHome", (Object[])new Object[]{"isCurrentRc keep " + isCurrentRc});
        LocationCoordinate2D location2D = new LocationCoordinate2D(Double.valueOf(location.getLatitude()), Double.valueOf(location.getLongitude()));
        if (!GpsUtils.isValid((double)location2D.getLatitude(), (double)location2D.getLongitude())) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_fpv_toast_homepoint_setting_failed, 0);
            return;
        }
        this.widgetModel.setHomeLocation(location2D).subscribe(new CompletableObserver(){

            public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
            }

            public void onComplete() {
                ViewUtil.showToast(HomePointWidget.this.getContext(), R.string.uxsdk_fpv_toast_homepoint_setting_current_rc, 0);
            }

            public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
                ViewUtil.showToast(HomePointWidget.this.getContext(), R.string.uxsdk_fpv_toast_homepoint_setting_failed, 0);
            }
        });
    }

    private void selectHomePointView(ImageView view, @DrawableRes int iconRes) {
        if (view == null) {
            return;
        }
        view.setVisibility(0);
        view.setImageResource(iconRes);
    }

    private void hideHomePointView(ImageView view) {
        if (view == null) {
            return;
        }
        view.setVisibility(8);
    }

    private void updateHomePointViewWithSingleRc() {
        if (this.widgetModel.isChannelA()) {
            this.selectHomePointView(this.rcAHomePointIv, R.drawable.uxsdk_ic_fpv_setting_rc_a);
            this.hideHomePointView(this.rcBHomePointIv);
        } else if (this.widgetModel.isChannelB()) {
            this.selectHomePointView(this.rcBHomePointIv, R.drawable.uxsdk_ic_fpv_setting_rc_b);
            this.hideHomePointView(this.rcAHomePointIv);
        }
    }
}

