/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.systemstatus;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.v5.manager.diagnostic.DJIDeviceStatus;
import dji.v5.manager.diagnostic.DJIDeviceStatusChangeListener;
import dji.v5.manager.diagnostic.DeviceStatusManager;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.model.VoiceNotificationType;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001*B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020#H\u0014J\b\u0010%\u001a\u00020#H\u0014J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006+"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "systemStatusProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/v5/manager/diagnostic/DJIDeviceStatus;", "areMotorsOnDataProcessor", "", "maxHeightProcessor", "", "unitTypeProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "warningStatusMessageProcessor", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidgetModel$WarningStatusMessageData;", "sendVoiceNotificationKey", "Ldji/v5/ux/core/communication/UXKey;", "deviceStatusChangeListener", "Ldji/v5/manager/diagnostic/DJIDeviceStatusChangeListener;", "systemStatus", "Lio/reactivex/rxjava3/core/Flowable;", "getSystemStatus", "()Lio/reactivex/rxjava3/core/Flowable;", "isMotorOn", "warningStatusMessageData", "getWarningStatusMessageData", "sendVoiceNotification", "Lio/reactivex/rxjava3/core/Completable;", "inSetup", "", "inCleanup", "updateStates", "getMaxHeight", "", "maxHeight", "unitType", "WarningStatusMessageData", "android-sdk-v5-uxsdk_debug"})
public final class SystemStatusWidgetModel
extends WidgetModel {
    @NotNull
    private final ObservableInMemoryKeyedStore keyedStore;
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<DJIDeviceStatus> systemStatusProcessor;
    @NotNull
    private final DataProcessor<Boolean> areMotorsOnDataProcessor;
    @NotNull
    private final DataProcessor<Integer> maxHeightProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeProcessor;
    @NotNull
    private final DataProcessor<WarningStatusMessageData> warningStatusMessageProcessor;
    @NotNull
    private final UXKey sendVoiceNotificationKey;
    @NotNull
    private final DJIDeviceStatusChangeListener deviceStatusChangeListener;

    public SystemStatusWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.keyedStore = keyedStore;
        this.preferencesManager = preferencesManager;
        DataProcessor<DJIDeviceStatus> dataProcessor = DataProcessor.create(DJIDeviceStatus.NORMAL);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.systemStatusProcessor = dataProcessor;
        DataProcessor<Boolean> dataProcessor2 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.areMotorsOnDataProcessor = dataProcessor2;
        DataProcessor<Integer> dataProcessor3 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.maxHeightProcessor = dataProcessor3;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor4 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.unitTypeProcessor = dataProcessor4;
        DataProcessor<WarningStatusMessageData> dataProcessor5 = DataProcessor.create(new WarningStatusMessageData("", 0.0f, UnitConversionUtil.UnitType.METRIC));
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.warningStatusMessageProcessor = dataProcessor5;
        UXKey uXKey = UXKeys.create("SendVoiceNotification");
        Intrinsics.checkNotNullExpressionValue((Object)uXKey, (String)"create(...)");
        this.sendVoiceNotificationKey = uXKey;
        this.deviceStatusChangeListener = (arg_0, arg_1) -> SystemStatusWidgetModel.deviceStatusChangeListener$lambda$0(this, arg_0, arg_1);
        if (this.preferencesManager != null) {
            this.unitTypeProcessor.onNext(this.preferencesManager.getUnitType());
        }
    }

    @NotNull
    public final Flowable<DJIDeviceStatus> getSystemStatus() {
        Flowable<DJIDeviceStatus> flowable = this.systemStatusProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<Boolean> isMotorOn() {
        Flowable<Boolean> flowable = this.areMotorsOnDataProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<WarningStatusMessageData> getWarningStatusMessageData() {
        Flowable<WarningStatusMessageData> flowable = this.warningStatusMessageProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Completable sendVoiceNotification() {
        VoiceNotificationType notificationType = VoiceNotificationType.ATTI;
        Completable completable = this.keyedStore.setValue(this.sendVoiceNotificationKey, (Object)notificationType);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"setValue(...)");
        return completable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), this.areMotorsOnDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyFlightLimitHeight), this.maxHeightProcessor);
        UXKey unitKey = UXKeys.create("UnitType");
        this.bindDataProcessor(unitKey, this.unitTypeProcessor);
        GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
        if (globalPreferencesInterface != null) {
            globalPreferencesInterface.setUpListener();
        }
        DeviceStatusManager.getInstance().addDJIDeviceStatusChangeListener(this.deviceStatusChangeListener);
    }

    @Override
    protected void inCleanup() {
        GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
        if (globalPreferencesInterface != null) {
            globalPreferencesInterface.cleanup();
        }
        DeviceStatusManager.getInstance().removeDJIDeviceStatusChangeListener(this.deviceStatusChangeListener);
    }

    @Override
    protected void updateStates() {
        String string2 = this.systemStatusProcessor.getValue().description();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"description(...)");
        float f = ((Number)this.maxHeightProcessor.getValue()).intValue();
        UnitConversionUtil.UnitType unitType = this.unitTypeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
        float f2 = this.getMaxHeight(f, unitType);
        UnitConversionUtil.UnitType unitType2 = this.unitTypeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType2), (String)"getValue(...)");
        this.warningStatusMessageProcessor.onNext(new WarningStatusMessageData(string2, f2, unitType2));
    }

    private final float getMaxHeight(float maxHeight, UnitConversionUtil.UnitType unitType) {
        return unitType == UnitConversionUtil.UnitType.IMPERIAL ? UnitConversionUtil.convertMetersToFeet(maxHeight) : maxHeight;
    }

    private static final void deviceStatusChangeListener$lambda$0(SystemStatusWidgetModel this$0, DJIDeviceStatus dJIDeviceStatus, DJIDeviceStatus to) {
        this$0.systemStatusProcessor.onNext(to);
        this$0.updateStates();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidgetModel$WarningStatusMessageData;", "", "message", "", "maxHeight", "", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(Ljava/lang/String;FLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getMessage", "()Ljava/lang/String;", "getMaxHeight", "()F", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "android-sdk-v5-uxsdk_debug"})
    public static final class WarningStatusMessageData {
        @NotNull
        private final String message;
        private final float maxHeight;
        @NotNull
        private final UnitConversionUtil.UnitType unitType;

        public WarningStatusMessageData(@NotNull String message, float maxHeight, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            this.message = message;
            this.maxHeight = maxHeight;
            this.unitType = unitType;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final float getMaxHeight() {
            return this.maxHeight;
        }

        @NotNull
        public final UnitConversionUtil.UnitType getUnitType() {
            return this.unitType;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        public final float component2() {
            return this.maxHeight;
        }

        @NotNull
        public final UnitConversionUtil.UnitType component3() {
            return this.unitType;
        }

        @NotNull
        public final WarningStatusMessageData copy(@NotNull String message, float maxHeight, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            return new WarningStatusMessageData(message, maxHeight, unitType);
        }

        public static /* synthetic */ WarningStatusMessageData copy$default(WarningStatusMessageData warningStatusMessageData, String string2, float f, UnitConversionUtil.UnitType unitType, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = warningStatusMessageData.message;
            }
            if ((n & 2) != 0) {
                f = warningStatusMessageData.maxHeight;
            }
            if ((n & 4) != 0) {
                unitType = warningStatusMessageData.unitType;
            }
            return warningStatusMessageData.copy(string2, f, unitType);
        }

        @NotNull
        public String toString() {
            return "WarningStatusMessageData(message=" + this.message + ", maxHeight=" + this.maxHeight + ", unitType=" + this.unitType + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + Float.hashCode(this.maxHeight);
            result = result * 31 + this.unitType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WarningStatusMessageData)) {
                return false;
            }
            WarningStatusMessageData warningStatusMessageData = (WarningStatusMessageData)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)warningStatusMessageData.message)) {
                return false;
            }
            if (Float.compare(this.maxHeight, warningStatusMessageData.maxHeight) != 0) {
                return false;
            }
            return this.unitType == warningStatusMessageData.unitType;
        }
    }
}

