/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.common;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.battery.IndustryBatteryType;
import dji.sdk.keyvalue.value.camera.CameraType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.BytesUtil;
import dji.v5.utils.common.LogPath;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.TextCell;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.widget.battery.BatteryResourceUtil;
import dji.v5.ux.core.widget.common.CommonAboutWidgetModel;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CommonAboutWidget
extends FrameLayoutWidget<Object> {
    public static final String NO_VALUE = "N/A";
    protected CommonAboutWidgetModel widgetModel = new CommonAboutWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    protected TextCell fcVerCell;
    protected TextCell rcVerCell;
    protected LinearLayout gimbalVersionLy;
    protected LinearLayout cameraVersionLy;
    protected TextCell camera1SnCell;
    protected TextCell camera2SnCell;
    protected TextCell camera3SnCell;
    protected TextCell flycSerialCell;
    protected TextCell rcSerialCell;
    protected TextCell rtkSerialCell;
    protected LinearLayout batterVersionLayout;
    protected int textCellHeight;
    private int batteryNumber;
    protected final Map<ComponentIndexType, CameraType> cameraTypeMap = new HashMap<ComponentIndexType, CameraType>();
    protected final HashMap<Integer, View> cameraViews = new HashMap();
    protected CompositeDisposable batteryDisposable;

    public CommonAboutWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CommonAboutWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CommonAboutWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CommonAboutWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_about, (ViewGroup)this);
        this.fcVerCell = (TextCell)this.findViewById(R.id.common_menu_fc_version);
        this.rcVerCell = (TextCell)this.findViewById(R.id.common_menu_rc_version);
        this.gimbalVersionLy = (LinearLayout)this.findViewById(R.id.common_menu_gimbal_version_ly);
        this.cameraVersionLy = (LinearLayout)this.findViewById(R.id.common_menu_camera_version_ly);
        this.camera1SnCell = (TextCell)this.findViewById(R.id.common_menu_camera1_sn);
        this.camera2SnCell = (TextCell)this.findViewById(R.id.common_menu_camera2_sn);
        this.camera3SnCell = (TextCell)this.findViewById(R.id.common_menu_camera3_sn);
        this.flycSerialCell = (TextCell)this.findViewById(R.id.common_menu_flyc_serial);
        this.rcSerialCell = (TextCell)this.findViewById(R.id.common_menu_rc_serial);
        this.rtkSerialCell = (TextCell)this.findViewById(R.id.common_menu_rtk_serial);
        this.batterVersionLayout = (LinearLayout)this.findViewById(R.id.common_menu_battery_version_layout);
        this.textCellHeight = this.getResources().getDimensionPixelSize(R.dimen.uxsdk_58_dp);
    }

    @Override
    protected void reactToModelChanges() {
        this.addDisposable(this.widgetModel.rcConnectionProcessor.toFlowableOnUI().subscribe(value -> this.updateRCVersion()));
        this.addDisposable(Observable.combineLatest(this.widgetModel.gimbal1ConnectionProcessor.toObservableOnUI(), this.widgetModel.gimbal2ConnectionProcessor.toObservableOnUI(), this.widgetModel.gimbal3ConnectionProcessor.toObservableOnUI(), CameraUtil::getConnectionCameraList).subscribe(this::updateGimbalVersion));
        this.addDisposable(Observable.combineLatest(this.widgetModel.camera1ConnectionProcessor.toObservableOnUI(), this.widgetModel.camera2ConnectionProcessor.toObservableOnUI(), this.widgetModel.camera3ConnectionProcessor.toObservableOnUI(), CameraUtil::getConnectionCameraList).subscribe(this::updateCameraView));
        this.addDisposable(this.widgetModel.fcConnectionProcessor.toFlowableOnUI().subscribe(value -> {
            if (Boolean.TRUE.equals(value)) {
                this.addDisposable(this.widgetModel.getFCSerialNumber().subscribe(this::updateFlycSerialNumber, throwable -> LogUtils.e((LogPath)LogPath.COMMON, (Object[])new Object[]{throwable.getMessage()})));
                this.addDisposable(this.widgetModel.getProductVersion().subscribe(this::updateProductVersion, throwable -> LogUtils.e((LogPath)LogPath.COMMON, (Object[])new Object[]{throwable.getMessage()})));
            } else {
                this.updateFlycSerialNumber(NO_VALUE);
                this.updateProductVersion(NO_VALUE);
            }
        }));
        this.addDisposable(this.widgetModel.rcSerialNumberProcessor.toFlowableOnUI().subscribe(this::updateRcSerialNumber));
        this.addDisposable(this.widgetModel.rtkConnectionProcessor.toFlowableOnUI().subscribe(value -> {
            if (Boolean.TRUE.equals(value)) {
                this.addDisposable(this.widgetModel.getRTKSerialNumber().subscribe(this::updateRTKSerialNumber));
            } else {
                this.updateRTKSerialNumber("");
            }
        }));
        this.addDisposable(this.widgetModel.batteryOverviewProcessor.toFlowableOnUI().subscribe(overviewValues -> {
            if (this.batteryNumber != overviewValues.size() || this.batterVersionLayout.getChildCount() == 0) {
                this.batteryNumber = overviewValues.size();
                this.updateBatteryView();
            }
        }));
        if (ProductUtil.isM350Product() || ProductUtil.isM400Product() || ProductUtil.isM300Product()) {
            this.addDisposable(Observable.combineLatest(this.widgetModel.camera1SerialNumberProcessor.toObservableOnUI(), this.widgetModel.camera2SerialNumberProcessor.toObservableOnUI(), this.widgetModel.camera3SerialNumberProcessor.toObservableOnUI(), (camera1, camera2, camera3) -> {
                this.updateCameraSerialNumber(this.camera1SnCell, (String)camera1, ComponentIndexType.LEFT_OR_MAIN);
                this.updateCameraSerialNumber(this.camera2SnCell, (String)camera2, ComponentIndexType.RIGHT);
                this.updateCameraSerialNumber(this.camera3SnCell, (String)camera3, ComponentIndexType.UP);
                return new Object();
            }).subscribe());
        }
    }

    private void updateRCVersion() {
        this.addDisposable(this.widgetModel.doForceUpdateCache().andThen(this.widgetModel.getRCVersion()).subscribe((version, throwable) -> {
            if (throwable == null) {
                this.rcVerCell.setContent((String)version);
            } else {
                this.rcVerCell.setContent(NO_VALUE);
            }
        }));
    }

    private void updateGimbalVersion(Collection<ComponentIndexType> cameraIndexList) {
        this.gimbalVersionLy.removeAllViews();
        for (ComponentIndexType cameraIndex : cameraIndexList) {
            this.addDisposable(this.widgetModel.getGimbalVersion(cameraIndex).delay((long)cameraIndex.value() * 100L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((version, throwable) -> {
                for (int i = 0; i < this.gimbalVersionLy.getChildCount(); ++i) {
                    View v = this.gimbalVersionLy.getChildAt(i);
                    if (v.getTag() != cameraIndex) continue;
                    this.gimbalVersionLy.removeViewAt(i);
                }
                TextCell gimbalTc = new TextCell(this.getContext());
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, this.textCellHeight);
                gimbalTc.setTag(cameraIndex);
                this.gimbalVersionLy.addView((View)gimbalTc, (ViewGroup.LayoutParams)layoutParams);
                gimbalTc.setContent((String)version);
                if (cameraIndexList.size() > 1) {
                    gimbalTc.setTitle(this.getResources().getString(R.string.uxsdk_setting_menu_common_gimbal_version, new Object[]{String.valueOf(cameraIndex.value() + 1)}));
                } else {
                    gimbalTc.setTitle(this.getResources().getString(R.string.uxsdk_setting_menu_common_gimbal_version, new Object[]{""}));
                }
            }));
        }
    }

    private void updateCameraView(Collection<ComponentIndexType> cameraIndexList) {
        this.cameraVersionLy.removeAllViews();
        for (ComponentIndexType cameraIndex : cameraIndexList) {
            this.addDisposable(this.widgetModel.getCameraType(cameraIndex).delay((long)cameraIndex.value() * 100L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).doOnSuccess(cameraType -> this.cameraTypeMap.put(cameraIndex, (CameraType)cameraType)).flatMap(cameraType -> {
                this.cameraTypeMap.put(cameraIndex, (CameraType)cameraType);
                if (cameraType == CameraType.PAYLOAD) {
                    return Single.zip(this.widgetModel.getPayloadCameraVersion(cameraIndex), this.widgetModel.getPayloadCameraName(cameraIndex), (version, cameraName) -> {
                        this.updateCameraVersion(cameraIndex, (String)version, (String)cameraName);
                        return version;
                    });
                }
                return Single.zip(this.widgetModel.getCameraVersion(cameraIndex), (SingleSource)Single.just((Object)CameraUtil.getCameraDisplayName(cameraType)), (version, cameraName) -> {
                    this.updateCameraVersion(cameraIndex, (String)version, (String)cameraName);
                    return version;
                });
            }).subscribe());
        }
    }

    private void updateCameraVersion(ComponentIndexType cameraIndex, String version, String cameraName) {
        TextCell[] textCells;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, this.textCellHeight);
        if (CameraType.ZENMUSE_XT2 == this.cameraTypeMap.get(cameraIndex)) {
            if (this.cameraViews.get(cameraIndex.value()) != null && this.cameraViews.get(cameraIndex.value() + 1) != null) {
                this.cameraVersionLy.removeView(this.cameraViews.get(cameraIndex.value() + 1));
                this.cameraVersionLy.removeView(this.cameraViews.get(cameraIndex.value()));
            }
            textCells = new TextCell[]{new TextCell(this.getContext()), new TextCell(this.getContext())};
            this.cameraViews.put(cameraIndex.value(), (View)textCells[0]);
            this.cameraViews.put(cameraIndex.value() + 1, (View)textCells[1]);
            this.cameraVersionLy.addView((View)textCells[0], (ViewGroup.LayoutParams)layoutParams);
            this.cameraVersionLy.addView((View)textCells[1], (ViewGroup.LayoutParams)layoutParams);
        } else {
            if (this.cameraViews.get(cameraIndex.value()) != null) {
                this.cameraVersionLy.removeView(this.cameraViews.get(cameraIndex.value()));
            }
            textCells = new TextCell[]{new TextCell(this.getContext())};
            this.cameraViews.put(cameraIndex.value(), (View)textCells[0]);
            this.cameraVersionLy.addView((View)textCells[0], (ViewGroup.LayoutParams)layoutParams);
        }
        if (textCells.length == 1) {
            textCells[0].setContent(version);
            textCells[0].setTitle(this.getResources().getString(R.string.uxsdk_setting_menu_common_camera_version, new Object[]{cameraName}));
        } else {
            textCells[0].setContent(version);
            textCells[0].setTitle(this.getResources().getString(R.string.uxsdk_setting_menu_common_camera_version, new Object[]{cameraName}) + "1");
            textCells[1].setContent(this.getXT2Version(version));
            textCells[1].setTitle(this.getResources().getString(R.string.uxsdk_setting_menu_common_camera_version, new Object[]{cameraName}) + "2");
        }
    }

    private String getXT2Version(String origin) {
        int dotIndex = origin.lastIndexOf(46);
        String forthNum = origin.substring(dotIndex + 1);
        String remain = origin.substring(0, dotIndex);
        dotIndex = remain.lastIndexOf(46);
        String thirdNum = remain.substring(dotIndex + 1);
        remain = remain.substring(0, dotIndex);
        int realValue = Integer.parseInt(forthNum) + 100 * Integer.parseInt(thirdNum);
        byte[] bytes = BytesUtil.getBytes((int)(realValue & 0xFFFF));
        return remain + "." + (BytesUtil.getInt((byte)bytes[1]) >= 10 ? "" : "0") + BytesUtil.getInt((byte)bytes[1]) + "." + (BytesUtil.getInt((byte)bytes[0]) > 10 ? "" : "0") + BytesUtil.getInt((byte)bytes[0]);
    }

    private void updateCameraSerialNumber(TextCell cell, String sn, ComponentIndexType cameraIndex) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            cell.setVisibility(8);
            return;
        }
        this.addDisposable(this.widgetModel.getCameraName(cameraIndex).subscribe(name -> {
            cell.setVisibility(0);
            cell.setTitle(this.getResources().getString(R.string.uxsdk_setting_menu_common_camera_version, new Object[]{name}) + this.getResources().getString(R.string.uxsdk_setting_menu_common_serial));
            cell.setContent(sn);
        }));
    }

    public void updateProductVersion(String version) {
        this.fcVerCell.setContent(version);
    }

    public void updateFlycSerialNumber(String serialNum) {
        this.flycSerialCell.setContent(serialNum);
    }

    public void updateRcSerialNumber(String serialNum) {
        this.rcSerialCell.setContent(serialNum);
    }

    private void updateRTKSerialNumber(String sn) {
        if (!TextUtils.isEmpty((CharSequence)sn) && (ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct())) {
            this.rtkSerialCell.setContent(sn);
            this.rtkSerialCell.setVisibility(0);
        } else {
            this.rtkSerialCell.setVisibility(8);
        }
    }

    private void updateBatteryView() {
        this.batterVersionLayout.removeAllViews();
        if (this.batteryDisposable != null && !this.batteryDisposable.isDisposed()) {
            this.batteryDisposable.dispose();
        }
        this.batteryDisposable = new CompositeDisposable();
        for (int i = 0; i < this.batteryNumber; ++i) {
            TextCell textCell = new TextCell(this.getContext());
            this.batterVersionLayout.addView((View)textCell);
            this.onBatteryVersionGet(i, null);
            int finalI = i;
            this.batteryDisposable.add(this.widgetModel.getBatteryConnection(i, this.batteryDisposable).toObservable().flatMap(value -> {
                if (Boolean.TRUE.equals(value)) {
                    return this.widgetModel.getBatteryVersion(finalI).toObservable();
                }
                return Observable.just((Object)"");
            }).subscribe(version -> {
                if (!TextUtils.isEmpty((CharSequence)version)) {
                    this.onBatteryVersionGet(finalI, (String)version);
                } else {
                    this.onBatteryVersionGet(finalI, null);
                }
            }));
        }
    }

    private void onBatteryVersionGet(int index, String versionStr) {
        TextCell textCell = (TextCell)this.batterVersionLayout.getChildAt(index);
        if (textCell != null) {
            if (!TextUtils.isEmpty((CharSequence)versionStr)) {
                textCell.setContent(versionStr);
                textCell.setVisibility(0);
            } else {
                textCell.setVisibility(8);
            }
            String batteryTitle = BatteryResourceUtil.INSTANCE.getBatteryTitle(index);
            textCell.setTitle(batteryTitle);
            if (ProductUtil.isM350Product() || ProductUtil.isM400Product() || ProductUtil.isM300Product()) {
                this.batteryDisposable.add(this.widgetModel.getIndustryBatteryType(index).subscribe(type -> {
                    if (type != null) {
                        textCell.setTitle(batteryTitle + " (" + BatteryResourceUtil.INSTANCE.productName((IndustryBatteryType)type) + ")");
                    }
                }));
            }
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        if (this.batteryDisposable != null) {
            this.batteryDisposable.dispose();
            this.batteryDisposable = null;
        }
    }
}

