/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;

public class VerticalSeekBar
extends View {
    private static final int MAX_LEVEL = 10000;
    protected final String logTag = LogUtils.getTag((Object)((Object)this));
    protected Drawable mProgressDrawable = null;
    protected int mProgressWidth = 0;
    protected Drawable mThumb = null;
    protected int mMax = 1;
    protected int mProgress = 0;
    protected int mSecondaryProgress = 0;
    protected Drawable mSecondaryThumb = null;
    private int mScaledTouchSlop = 0;
    private float mTouchDownY = 0.0f;
    private boolean mIsDragging = false;
    private OnVSBChangeListener mOnChangedListener = null;

    public VerticalSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        Drawable sThumb;
        this.initAttrs(context);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.VerticalSeekBar, 0, 0);
        this.mProgressWidth = ta.getDimensionPixelSize(R.styleable.VerticalSeekBar_uxsdk_progressHeight, this.mProgressWidth);
        Drawable drawable2 = ta.getDrawable(R.styleable.VerticalSeekBar_uxsdk_progressDrawable);
        if (null != drawable2) {
            this.setProgressDrawable(drawable2);
        }
        this.setMax(ta.getInt(R.styleable.VerticalSeekBar_uxsdk_max, this.mMax));
        this.setProgress(ta.getInt(R.styleable.VerticalSeekBar_uxsdk_progress, this.mProgress));
        this.setSecondaryProgress(ta.getInt(R.styleable.VerticalSeekBar_uxsdk_secondaryProgress, this.mSecondaryProgress));
        Drawable thumb = ta.getDrawable(R.styleable.VerticalSeekBar_uxsdk_thumb);
        if (null != thumb) {
            this.setThumb(thumb);
        }
        if (null != (sThumb = ta.getDrawable(R.styleable.VerticalSeekBar_uxsdk_secondaryThumb))) {
            this.setSecondaryThumb(sThumb);
        }
        ta.recycle();
    }

    public VerticalSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs);
    }

    public VerticalSeekBar(Context context) {
        this(context, null);
    }

    public void setOnChangeListener(OnVSBChangeListener listener2) {
        this.mOnChangedListener = listener2;
    }

    public void setProgressDrawable(Drawable d) {
        boolean needUpdate;
        if (!this.isInEditMode()) {
            d = this.tileify(d, false, 0);
        }
        if (this.mProgressDrawable != null && d != this.mProgressDrawable) {
            this.mProgressDrawable.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
        }
        this.mProgressDrawable = d;
        this.postInvalidate();
        if (needUpdate) {
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.doRefreshProgress(16908301, this.mProgress, false, false);
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    public void setThumb(Drawable thumb) {
        boolean needUpdate = false;
        if (this.mThumb != null && thumb != this.mThumb) {
            needUpdate = true;
        }
        if (thumb != null && needUpdate && (thumb.getIntrinsicWidth() != this.mThumb.getIntrinsicWidth() || thumb.getIntrinsicHeight() != this.mThumb.getIntrinsicHeight())) {
            this.requestLayout();
        }
        this.mThumb = thumb;
        this.invalidate();
        if (needUpdate) {
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
        }
    }

    public void setSecondaryThumb(Drawable thumb) {
        this.mSecondaryThumb = thumb;
        this.setDrawableBounds(this.getWidth(), this.getHeight(), this.mSecondaryThumb, this.mMax == 0 ? 0.0f : (float)this.mSecondaryProgress / (float)this.mMax);
        this.invalidate();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int max) {
        if (max < 0) {
            max = 0;
        }
        if (max != this.mMax) {
            this.mMax = max;
            if (this.mProgress > max) {
                this.mProgress = max;
            }
            this.setDrawableBounds(this.getWidth(), this.getHeight(), this.mThumb, this.mMax == 0 ? 0.0f : (float)this.mProgress / (float)this.mMax);
            this.postInvalidate();
            this.doRefreshProgress(16908301, this.mProgress, false, false);
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int progress) {
        this.setProgress(progress, false);
    }

    private void setProgress(int progress, boolean fromUser) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > this.mMax) {
            progress = this.mMax;
        }
        if (progress != this.mProgress) {
            this.mProgress = progress;
            this.doRefreshProgress(16908301, this.mProgress, fromUser, true);
        }
    }

    public int getSecondaryProgress() {
        return this.mSecondaryProgress;
    }

    public void setSecondaryProgress(int secondProgress) {
        if (secondProgress < 0) {
            secondProgress = 0;
        }
        if (secondProgress > this.mMax) {
            secondProgress = this.mMax;
        }
        if (secondProgress != this.mSecondaryProgress) {
            this.mSecondaryProgress = secondProgress;
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    protected void updateDrawableBounds(int w, int h) {
        Drawable d = this.mProgressDrawable;
        Drawable thumb = this.mThumb;
        int thumbWidth = thumb == null ? 0 : thumb.getIntrinsicWidth();
        int trackWidth = this.mProgressWidth;
        int max = this.mMax;
        float scale = max > 0 ? (float)this.mProgress / (float)max : 0.0f;
        this.setDrawableBounds(w, h, thumb, scale);
        int gapForCenteringTrack = (thumbWidth - trackWidth) / 2;
        int bottom = h - this.getPaddingTop() - this.getPaddingBottom();
        if (d != null) {
            d.setBounds(gapForCenteringTrack, 0, gapForCenteringTrack + trackWidth, bottom);
        }
    }

    protected void setDrawableBounds(int w, int h, Drawable thumb, float scale) {
        if (thumb == null) {
            return;
        }
        int available = h - this.getPaddingTop() - this.getPaddingBottom();
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        int thumbLeft = (w - thumbWidth) / 2;
        int thumbPos = (available -= thumbHeight) + this.getPaddingTop() - (int)(scale * (float)available);
        thumb.setBounds(thumbLeft, thumbPos, thumbLeft + thumbWidth, thumbPos + thumbHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.onTouchDown(event);
                break;
            }
            case 2: {
                this.onTouchMove(event);
                break;
            }
            case 1: {
                this.onTouchUp(event);
                break;
            }
            case 3: {
                this.onTouchCancel();
                break;
            }
        }
        return true;
    }

    private void onTouchDown(MotionEvent event) {
        if (this.isInScrollingContainer()) {
            this.mTouchDownY = event.getY();
        } else {
            this.setPressed(true);
            if (this.mThumb != null) {
                this.invalidate(this.mThumb.getBounds());
            }
            this.onStartTrackingTouch();
            this.trackTouchEvent(event);
            this.attemptClaimDrag();
        }
    }

    private void onTouchMove(MotionEvent event) {
        if (this.mIsDragging) {
            this.trackTouchEvent(event);
        } else {
            float y = event.getY();
            if (Math.abs(y - this.mTouchDownY) > (float)this.mScaledTouchSlop) {
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
            }
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (this.mIsDragging) {
            this.trackTouchEvent(event);
            this.onStopTrackingTouch();
            this.setPressed(false);
        } else {
            this.onStartTrackingTouch();
            this.trackTouchEvent(event);
            this.onStopTrackingTouch();
        }
        this.invalidate();
    }

    private void onTouchCancel() {
        if (this.mIsDragging) {
            this.onStopTrackingTouch();
            this.setPressed(false);
        }
        this.invalidate();
    }

    private void trackTouchEvent(MotionEvent event) {
        float scale;
        int height = this.getHeight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int available = height - paddingTop - paddingBottom;
        int y = (int)event.getY();
        float progress = 0.0f;
        if (y > height - paddingBottom) {
            scale = 0.0f;
        } else if (y < paddingTop) {
            scale = 1.0f;
        } else {
            scale = (float)(available - y + paddingTop) / (float)available;
            progress = 0.0f;
        }
        int max = this.getMax();
        this.setProgress((int)(progress += scale * (float)max), true);
    }

    private void attemptClaimDrag() {
        ViewParent vp = this.getParent();
        if (null != vp) {
            vp.requestDisallowInterceptTouchEvent(true);
        }
    }

    void onStartTrackingTouch() {
        this.mIsDragging = true;
        if (null != this.mOnChangedListener) {
            this.mOnChangedListener.onStartTrackingTouch(this);
        }
    }

    void onStopTrackingTouch() {
        this.mIsDragging = false;
        if (null != this.mOnChangedListener) {
            this.mOnChangedListener.onStopTrackingTouch(this);
        }
    }

    protected boolean isInScrollingContainer() {
        ViewParent vp = this.getParent();
        while (vp instanceof ViewGroup) {
            if (((ViewGroup)vp).shouldDelayChildPressedState()) {
                return true;
            }
            vp = vp.getParent();
        }
        return false;
    }

    public Drawable getThumb() {
        return this.mThumb;
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mProgressDrawable || who == this.mThumb || who == this.mSecondaryThumb || super.verifyDrawable(who);
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.getScrollX() + this.getPaddingLeft();
            int scrollY = this.getScrollY() + this.getPaddingRight();
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        } else {
            super.invalidateDrawable(drawable2);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateDrawableBounds(w, h);
        this.setDrawableBounds(w, h, this.mSecondaryThumb, this.mMax == 0 ? 0.0f : (float)this.mSecondaryProgress / (float)this.mMax);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int thumbWidth = this.mThumb == null ? 0 : this.mThumb.getIntrinsicWidth();
        int dw = this.mProgressWidth;
        int dh = View.MeasureSpec.getSize((int)heightMeasureSpec);
        dw = Math.max(thumbWidth, dw);
        LogUtils.i((String)this.logTag, (Object[])new Object[]{"onMeasure", dw += this.getPaddingLeft() + this.getPaddingRight(), dh += this.getPaddingTop() + this.getPaddingBottom()});
        this.setMeasuredDimension(dw, dh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable d = this.mProgressDrawable;
        if (null != d) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            d.draw(canvas);
            canvas.restore();
        }
        if (null != this.mSecondaryThumb) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            this.mSecondaryThumb.draw(canvas);
            canvas.restore();
        }
        if (null != this.mThumb) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            this.mThumb.draw(canvas);
            canvas.restore();
        }
    }

    private synchronized void doRefreshProgress(int id2, int progress, boolean fromUser, boolean callToApp) {
        float scale = this.mMax > 0 ? (float)progress / (float)this.mMax : 0.0f;
        Drawable d = this.mProgressDrawable;
        if (d != null) {
            Drawable progressDrawable = null;
            if (d instanceof LayerDrawable) {
                progressDrawable = ((LayerDrawable)d).findDrawableByLayerId(id2);
            }
            int level = (int)(scale * 10000.0f);
            (progressDrawable != null ? progressDrawable : d).setLevel(level);
        } else {
            this.invalidate();
        }
        if (id2 == 16908301) {
            this.setDrawableBounds(this.getWidth(), this.getHeight(), this.mThumb, scale);
            this.invalidate();
            if (callToApp && null != this.mOnChangedListener) {
                this.mOnChangedListener.onProgressChanged(this, progress, fromUser);
            }
        } else if (id2 == 16908303) {
            this.setDrawableBounds(this.getWidth(), this.getHeight(), this.mSecondaryThumb, scale);
            this.invalidate();
        }
    }

    protected void initAttrs(Context context) {
        this.mProgressWidth = DisplayUtil.dip2px((Context)context, (float)4.0f);
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    private Shape getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    private Drawable tileify(Drawable drawable2, boolean clip, int drawableId) {
        if (drawable2 instanceof LayerDrawable) {
            LayerDrawable background = (LayerDrawable)drawable2;
            int N = background.getNumberOfLayers();
            Drawable[] outDrawables = new Drawable[N];
            for (int i = 0; i < N; ++i) {
                int id2 = background.getId(i);
                outDrawables[i] = this.tileify(background.getDrawable(i), id2 == 16908301 || id2 == 16908303, id2);
            }
            LayerDrawable newBg = new LayerDrawable(outDrawables);
            for (int i = 0; i < N; ++i) {
                newBg.setId(i, background.getId(i));
            }
            return newBg;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap tileBitmap = ((BitmapDrawable)drawable2).getBitmap();
            ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            BitmapShader bitmapShader = new BitmapShader(tileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader((Shader)bitmapShader);
            if (0x1020000 == drawableId) {
                this.mProgressWidth = tileBitmap.getWidth();
            }
            return clip ? new ClipDrawable((Drawable)shapeDrawable, 80, 2) : shapeDrawable;
        }
        return drawable2;
    }

    public static interface OnVSBChangeListener {
        public void onProgressChanged(VerticalSeekBar var1, int var2, boolean var3);

        public void onStartTrackingTouch(VerticalSeekBar var1);

        public void onStopTrackingTouch(VerticalSeekBar var1);
    }
}

