/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.panel.listitem.maxaltitude;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.StyleRes;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.UXSDKError;
import dji.v5.ux.core.base.WidgetSizeDescription;
import dji.v5.ux.core.base.panel.listitem.ListItemEditTextButtonWidget;
import dji.v5.ux.core.communication.GlobalPreferencesManager;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.panel.listitem.maxaltitude.MaxAltitudeListItemWidget;
import dji.v5.ux.core.panel.listitem.maxaltitude.MaxAltitudeListItemWidgetModel;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002LMB'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020&H\u0014J\b\u0010(\u001a\u00020&H\u0014J\b\u0010)\u001a\u00020&H\u0016J\u0012\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020&H\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020&2\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020&H\u0002J\u0012\u00108\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u00010,H\u0002J \u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0002J \u0010?\u001a\u00020&2\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010@\u001a\u00020&2\u0006\u0010;\u001a\u00020\bH\u0002J\b\u0010A\u001a\u00020&H\u0002J\n\u0010B\u001a\u0004\u0018\u00010,H\u0016J\u001a\u0010G\u001a\u00020&2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0016J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00020IH\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0014\u0010C\u001a\u00020DX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010F\u00a8\u0006N"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget;", "Ldji/v5/ux/core/base/panel/listitem/ListItemEditTextButtonWidget;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleArr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "confirmationDialogIcon", "Landroid/graphics/drawable/Drawable;", "getConfirmationDialogIcon", "()Landroid/graphics/drawable/Drawable;", "setConfirmationDialogIcon", "(Landroid/graphics/drawable/Drawable;)V", "errorDialogIcon", "getErrorDialogIcon", "setErrorDialogIcon", "toastMessagesEnabled", "", "getToastMessagesEnabled", "()Z", "setToastMessagesEnabled", "(Z)V", "dialogTheme", "getDialogTheme", "()I", "setDialogTheme", "(I)V", "widgetModel", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "onAttachedToWindow", "", "onDetachedFromWindow", "reactToModelChanges", "onButtonClick", "onEditorTextChanged", "currentText", "", "onKeyboardDoneAction", "updateUI", "maxAltitudeState", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel$MaxAltitudeState;", "updateMaxAltitudeValue", "maxAltitudeListItemState", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel$MaxAltitudeState$MaxAltitudeValue;", "updateNoviceMode", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "updateProductDisconnectedState", "showToast", "message", "showOverAlarmLimitDialog", "currentValue", "currentReturnToHomeValue", "isOverAlarmLimit", "currentVal", "verifyReturnHomeAltitudeValue", "setMaxAltitudeValue", "resetToDefaultValue", "getIdealDimensionRatioString", "widgetSizeDescription", "Ldji/v5/ux/core/base/WidgetSizeDescription;", "getWidgetSizeDescription", "()Ldji/v5/ux/core/base/WidgetSizeDescription;", "initAttributes", "getUIStateUpdates", "Lio/reactivex/rxjava3/core/Flowable;", "Ldji/v5/ux/core/base/panel/listitem/ListItemEditTextButtonWidget$UIState;", "getWidgetStateUpdate", "DialogType", "ModelState", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nMaxAltitudeListItemWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxAltitudeListItemWidget.kt\ndji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget\n+ 2 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 3 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,442:1\n233#2:443\n234#2,2:457\n125#3,5:444\n101#3,2:449\n103#3:452\n101#3,2:453\n103#3:456\n1#4:451\n1#4:455\n*S KotlinDebug\n*F\n+ 1 MaxAltitudeListItemWidget.kt\ndji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget\n*L\n359#1:443\n359#1:457,2\n361#1:444,5\n364#1:449,2\n364#1:452\n367#1:453,2\n367#1:456\n364#1:451\n367#1:455\n*E\n"})
public class MaxAltitudeListItemWidget
extends ListItemEditTextButtonWidget<ModelState> {
    @Nullable
    private Drawable confirmationDialogIcon;
    @Nullable
    private Drawable errorDialogIcon;
    private boolean toastMessagesEnabled;
    @StyleRes
    private int dialogTheme;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private final WidgetSizeDescription widgetSizeDescription;

    @JvmOverloads
    public MaxAltitudeListItemWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleArr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleArr, ListItemEditTextButtonWidget.WidgetType.EDIT, R.style.UXSDKMaxAltitudeListItem);
        this.confirmationDialogIcon = ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_alert_yellow);
        this.errorDialogIcon = ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_alert_error);
        this.toastMessagesEnabled = true;
        this.dialogTheme = R.style.UXSDKDialogTheme;
        this.widgetModel$delegate = LazyKt.lazy(MaxAltitudeListItemWidget::widgetModel_delegate$lambda$0);
        this.initAttributes(context, attrs);
        this.widgetSizeDescription = new WidgetSizeDescription(WidgetSizeDescription.SizeType.OTHER, WidgetSizeDescription.Dimension.EXPAND, WidgetSizeDescription.Dimension.WRAP);
    }

    public /* synthetic */ MaxAltitudeListItemWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final Drawable getConfirmationDialogIcon() {
        return this.confirmationDialogIcon;
    }

    public final void setConfirmationDialogIcon(@Nullable Drawable drawable2) {
        this.confirmationDialogIcon = drawable2;
    }

    @Nullable
    public final Drawable getErrorDialogIcon() {
        return this.errorDialogIcon;
    }

    public final void setErrorDialogIcon(@Nullable Drawable drawable2) {
        this.errorDialogIcon = drawable2;
    }

    public final boolean getToastMessagesEnabled() {
        return this.toastMessagesEnabled;
    }

    public final void setToastMessagesEnabled(boolean bl) {
        this.toastMessagesEnabled = bl;
    }

    public final int getDialogTheme() {
        return this.dialogTheme;
    }

    public final void setDialogTheme(int n) {
        this.dialogTheme = n;
    }

    private final MaxAltitudeListItemWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (MaxAltitudeListItemWidgetModel)lazy.getValue();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getMaxAltitudeState().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ MaxAltitudeListItemWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(MaxAltitudeListItemWidgetModel.MaxAltitudeState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MaxAltitudeListItemWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.MaxAltitudeStateUpdated(it));
                MaxAltitudeListItemWidget.access$updateUI(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ MaxAltitudeListItemWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MaxAltitudeListItemWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.ProductConnected(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
    }

    @Override
    public void onButtonClick() {
    }

    @Override
    public void onEditorTextChanged(@Nullable String currentText) {
        CharSequence charSequence = currentText;
        this.setListItemEditTextColor(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && StringsKt.toIntOrNull((String)currentText) != null && this.getWidgetModel().isInputInRange(Integer.parseInt(currentText)) ? this.getEditTextNormalColor() : this.getErrorValueColor());
    }

    @Override
    public void onKeyboardDoneAction() {
        Integer currentValue;
        String string2 = this.getListItemEditTextValue();
        Integer n = currentValue = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
        if (currentValue != null && this.getWidgetModel().isInputInRange(currentValue)) {
            Disposable disposable = this.getWidgetModel().getMaxAltitudeState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this, currentValue){
                final /* synthetic */ MaxAltitudeListItemWidget this$0;
                final /* synthetic */ Integer $currentValue;
                {
                    this.this$0 = $receiver;
                    this.$currentValue = $currentValue;
                }

                public final void accept(MaxAltitudeListItemWidgetModel.MaxAltitudeState it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it instanceof MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue) {
                        if (MaxAltitudeListItemWidget.access$isOverAlarmLimit(this.this$0, this.$currentValue, ((MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue)it).getUnitType())) {
                            MaxAltitudeListItemWidget.access$showOverAlarmLimitDialog(this.this$0, this.$currentValue, ((MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue)it).getReturnToHomeHeight(), ((MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue)it).getUnitType());
                        } else {
                            MaxAltitudeListItemWidget.access$verifyReturnHomeAltitudeValue(this.this$0, this.$currentValue, ((MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue)it).getReturnToHomeHeight(), ((MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue)it).getUnitType());
                        }
                    }
                }
            }, (Consumer)onKeyboardDoneAction.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
            this.addDisposable(disposable);
        } else {
            this.showToast(ViewExtensions.getString((View)this, R.string.uxsdk_list_item_value_out_of_range, new Object[0]));
            this.resetToDefaultValue();
        }
    }

    private final void updateUI(MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState) {
        MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState2 = maxAltitudeState;
        if (Intrinsics.areEqual((Object)maxAltitudeState2, (Object)MaxAltitudeListItemWidgetModel.MaxAltitudeState.ProductDisconnected.INSTANCE)) {
            this.updateProductDisconnectedState();
        } else if (maxAltitudeState2 instanceof MaxAltitudeListItemWidgetModel.MaxAltitudeState.NoviceMode) {
            this.updateNoviceMode(((MaxAltitudeListItemWidgetModel.MaxAltitudeState.NoviceMode)maxAltitudeState).getUnitType());
        } else if (maxAltitudeState2 instanceof MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue) {
            this.updateMaxAltitudeValue((MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue)maxAltitudeState);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void updateMaxAltitudeValue(MaxAltitudeListItemWidgetModel.MaxAltitudeState.MaxAltitudeValue maxAltitudeListItemState) {
        String string2;
        this.setListItemEditTextVisibility(true);
        this.setListItemHintVisibility(true);
        if (maxAltitudeListItemState.getUnitType() == UnitConversionUtil.UnitType.METRIC) {
            Object[] objectArray = new Object[]{maxAltitudeListItemState.getMinAltitudeLimit(), maxAltitudeListItemState.getMaxAltitudeLimit()};
            string2 = ViewExtensions.getString((View)this, R.string.uxsdk_altitude_range_meters, objectArray);
        } else {
            Object[] objectArray = new Object[]{maxAltitudeListItemState.getMinAltitudeLimit(), maxAltitudeListItemState.getMaxAltitudeLimit()};
            string2 = ViewExtensions.getString((View)this, R.string.uxsdk_altitude_range_feet, objectArray);
        }
        this.setListItemHint(string2);
        this.setListItemEditTextValue(String.valueOf(maxAltitudeListItemState.getAltitudeLimit()));
        this.setEnabled(true);
        this.setListItemEditTextColor(this.getEditTextNormalColor());
    }

    private final void updateNoviceMode(UnitConversionUtil.UnitType unitType) {
        this.setListItemEditTextVisibility(true);
        this.setListItemHintVisibility(false);
        this.setListItemEditTextValue(unitType == UnitConversionUtil.UnitType.METRIC ? ViewExtensions.getString((View)this, R.string.uxsdk_novice_mode_altitude_meters, new Object[0]) : ViewExtensions.getString((View)this, R.string.uxsdk_novice_mode_altitude_feet, new Object[0]));
        this.setEnabled(false);
        this.setListItemEditTextColor(this.getDisconnectedValueColor());
    }

    private final void updateProductDisconnectedState() {
        this.setListItemEditTextVisibility(true);
        this.setListItemHintVisibility(false);
        this.setListItemEditTextValue(ViewExtensions.getString((View)this, R.string.uxsdk_string_default_value, new Object[0]));
        this.setEnabled(false);
        this.setListItemEditTextColor(this.getDisconnectedValueColor());
    }

    private final void showToast(String message) {
        if (this.toastMessagesEnabled) {
            ViewExtensions.showShortToast((View)this, message);
        }
    }

    private final void showOverAlarmLimitDialog(int currentValue, int currentReturnToHomeValue, UnitConversionUtil.UnitType unitType) {
        DialogInterface.OnClickListener dialogListener = (arg_0, arg_1) -> MaxAltitudeListItemWidget.showOverAlarmLimitDialog$lambda$1(this, currentValue, currentReturnToHomeValue, unitType, arg_0, arg_1);
        DialogInterface.OnDismissListener dialogDismissListener = arg_0 -> MaxAltitudeListItemWidget.showOverAlarmLimitDialog$lambda$2(this, arg_0);
        ViewExtensions.showConfirmationDialog((View)this, this.dialogTheme, ViewExtensions.getString((View)this, R.string.uxsdk_list_item_max_flight_altitude, new Object[0]), this.confirmationDialogIcon, ViewExtensions.getString((View)this, R.string.uxsdk_limit_high_notice, new Object[0]), dialogListener, dialogDismissListener);
        this.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogDisplayed(DialogType.MaxAltitudeOverAlarmConfirmation.INSTANCE));
    }

    private final boolean isOverAlarmLimit(int currentVal, UnitConversionUtil.UnitType unitType) {
        return unitType == UnitConversionUtil.UnitType.METRIC ? currentVal > 120 : currentVal > 400;
    }

    private final void verifyReturnHomeAltitudeValue(int currentValue, int currentReturnToHomeValue, UnitConversionUtil.UnitType unitType) {
        if (currentValue < currentReturnToHomeValue) {
            int metricHeight = unitType == UnitConversionUtil.UnitType.METRIC ? currentValue : MathKt.roundToInt((float)UnitConversionUtil.convertFeetToMeters(currentValue));
            int imperialHeight = unitType == UnitConversionUtil.UnitType.METRIC ? MathKt.roundToInt((float)UnitConversionUtil.convertMetersToFeet(currentValue)) : currentValue;
            DialogInterface.OnClickListener dialogListener = (arg_0, arg_1) -> MaxAltitudeListItemWidget.verifyReturnHomeAltitudeValue$lambda$3(this, currentValue, arg_0, arg_1);
            DialogInterface.OnDismissListener dialogDismissListener = arg_0 -> MaxAltitudeListItemWidget.verifyReturnHomeAltitudeValue$lambda$4(this, arg_0);
            int n = this.dialogTheme;
            Drawable drawable2 = this.confirmationDialogIcon;
            String string2 = ViewExtensions.getString((View)this, R.string.uxsdk_list_item_max_flight_altitude, new Object[0]);
            Object[] objectArray = new Object[]{imperialHeight, metricHeight};
            String string3 = ViewExtensions.getString((View)this, R.string.uxsdk_limit_return_home_warning, objectArray);
            ViewExtensions.showConfirmationDialog((View)this, n, string2, drawable2, string3, dialogListener, dialogDismissListener);
            this.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogDisplayed(DialogType.ReturnHomeAltitudeUpdate.INSTANCE));
        } else {
            this.setMaxAltitudeValue(currentValue);
        }
    }

    private final void setMaxAltitudeValue(int currentValue) {
        Disposable disposable = this.getWidgetModel().setFlightMaxAltitude(currentValue).observeOn(SchedulerProvider.ui()).subscribe(() -> MaxAltitudeListItemWidget.setMaxAltitudeValue$lambda$5(this), new Consumer(this){
            final /* synthetic */ MaxAltitudeListItemWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                MaxAltitudeListItemWidget.access$resetToDefaultValue(this.this$0);
                if (error instanceof UXSDKError) {
                    MaxAltitudeListItemWidget.access$showToast(this.this$0, ((UXSDKError)error).getDJIError().description());
                    MaxAltitudeListItemWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.SetMaxAltitudeFailed((UXSDKError)error));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    private final void resetToDefaultValue() {
        Disposable disposable = this.getWidgetModel().getMaxAltitudeState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ MaxAltitudeListItemWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(MaxAltitudeListItemWidgetModel.MaxAltitudeState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MaxAltitudeListItemWidget.access$updateUI(this.this$0, it);
            }
        }, (Consumer)resetToDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @Override
    @NotNull
    public WidgetSizeDescription getWidgetSizeDescription() {
        return this.widgetSizeDescription;
    }

    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        Drawable it;
        boolean bl;
        TypedArray $this$getDrawableAndUse$iv;
        Drawable drawable$iv;
        TypedArray $this$getResourceIdAndUse$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaxAltitudeListItemWidget, 0, this.getDefaultStyle());
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl2 = false;
        this.toastMessagesEnabled = typedArray2.getBoolean(R.styleable.MaxAltitudeListItemWidget_uxsdk_toast_messages_enabled, this.toastMessagesEnabled);
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.MaxAltitudeListItemWidget_uxsdk_list_item_dialog_theme;
        boolean $i$f$getResourceIdAndUse = false;
        int resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it2 = resourceId$iv;
            boolean bl3 = false;
            this.dialogTheme = it2;
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.SDCardStatusListItemWidget_uxsdk_list_item_confirmation_dialog_icon;
        boolean $i$f$getDrawableAndUse = false;
        Drawable drawable2 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable2 != null) {
            Drawable it$iv = drawable2;
            bl = false;
            it = drawable$iv;
            boolean bl4 = false;
            this.confirmationDialogIcon = it;
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SDCardStatusListItemWidget_uxsdk_list_item_error_dialog_icon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable3 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable3 != null) {
            Drawable it$iv = drawable3;
            bl = false;
            it = drawable$iv;
            boolean bl5 = false;
            this.errorDialogIcon = it;
        }
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl6 = false;
        $this$use$iv.recycle();
    }

    @Override
    @NotNull
    public Flowable<ListItemEditTextButtonWidget.UIState> getUIStateUpdates() {
        Flowable flowable = this.getUiUpdateStateProcessor().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"onBackpressureBuffer(...)");
        return flowable;
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @JvmOverloads
    public MaxAltitudeListItemWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MaxAltitudeListItemWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final MaxAltitudeListItemWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new MaxAltitudeListItemWidgetModel(dJISDKModel, observableInMemoryKeyedStore, GlobalPreferencesManager.getInstance());
    }

    private static final void showOverAlarmLimitDialog$lambda$1(MaxAltitudeListItemWidget this$0, int $currentValue, int $currentReturnToHomeValue, UnitConversionUtil.UnitType $unitType, DialogInterface dialogInterface, int buttonId) {
        if (buttonId == -1) {
            this$0.verifyReturnHomeAltitudeValue($currentValue, $currentReturnToHomeValue, $unitType);
            this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogActionConfirmed(DialogType.MaxAltitudeOverAlarmConfirmation.INSTANCE));
        } else {
            this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogActionCanceled(DialogType.MaxAltitudeOverAlarmConfirmation.INSTANCE));
            this$0.resetToDefaultValue();
        }
        dialogInterface.dismiss();
    }

    private static final void showOverAlarmLimitDialog$lambda$2(MaxAltitudeListItemWidget this$0, DialogInterface it) {
        this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogDismissed(DialogType.MaxAltitudeOverAlarmConfirmation.INSTANCE));
    }

    private static final void verifyReturnHomeAltitudeValue$lambda$3(MaxAltitudeListItemWidget this$0, int $currentValue, DialogInterface dialogInterface, int buttonId) {
        if (buttonId == -1) {
            this$0.setMaxAltitudeValue($currentValue);
            this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogActionConfirmed(DialogType.ReturnHomeAltitudeUpdate.INSTANCE));
        } else {
            this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogActionCanceled(DialogType.ReturnHomeAltitudeUpdate.INSTANCE));
            this$0.resetToDefaultValue();
        }
        dialogInterface.dismiss();
    }

    private static final void verifyReturnHomeAltitudeValue$lambda$4(MaxAltitudeListItemWidget this$0, DialogInterface it) {
        this$0.getUiUpdateStateProcessor().onNext((Object)new ListItemEditTextButtonWidget.UIState.DialogDismissed(DialogType.ReturnHomeAltitudeUpdate.INSTANCE));
    }

    private static final void setMaxAltitudeValue$lambda$5(MaxAltitudeListItemWidget this$0) {
        this$0.showToast(ViewExtensions.getString((View)this$0, R.string.uxsdk_success, new Object[0]));
        this$0.getWidgetStateDataProcessor().onNext((Object)ModelState.SetMaxAltitudeSucceeded.INSTANCE);
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(MaxAltitudeListItemWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    public static final /* synthetic */ void access$updateUI(MaxAltitudeListItemWidget $this, MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState) {
        $this.updateUI(maxAltitudeState);
    }

    public static final /* synthetic */ boolean access$isOverAlarmLimit(MaxAltitudeListItemWidget $this, int currentVal, UnitConversionUtil.UnitType unitType) {
        return $this.isOverAlarmLimit(currentVal, unitType);
    }

    public static final /* synthetic */ void access$showOverAlarmLimitDialog(MaxAltitudeListItemWidget $this, int currentValue, int currentReturnToHomeValue, UnitConversionUtil.UnitType unitType) {
        $this.showOverAlarmLimitDialog(currentValue, currentReturnToHomeValue, unitType);
    }

    public static final /* synthetic */ void access$verifyReturnHomeAltitudeValue(MaxAltitudeListItemWidget $this, int currentValue, int currentReturnToHomeValue, UnitConversionUtil.UnitType unitType) {
        $this.verifyReturnHomeAltitudeValue(currentValue, currentReturnToHomeValue, unitType);
    }

    public static final /* synthetic */ void access$resetToDefaultValue(MaxAltitudeListItemWidget $this) {
        $this.resetToDefaultValue();
    }

    public static final /* synthetic */ void access$showToast(MaxAltitudeListItemWidget $this, String message) {
        $this.showToast(message);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType;", "", "<init>", "()V", "MaxAltitudeOverAlarmConfirmation", "FlightLimitNeededError", "ReturnHomeAltitudeUpdate", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType$FlightLimitNeededError;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType$MaxAltitudeOverAlarmConfirmation;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType$ReturnHomeAltitudeUpdate;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class DialogType {
        private DialogType() {
        }

        public /* synthetic */ DialogType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType$FlightLimitNeededError;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class FlightLimitNeededError
        extends DialogType {
            @NotNull
            public static final FlightLimitNeededError INSTANCE = new FlightLimitNeededError();

            private FlightLimitNeededError() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType$MaxAltitudeOverAlarmConfirmation;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class MaxAltitudeOverAlarmConfirmation
        extends DialogType {
            @NotNull
            public static final MaxAltitudeOverAlarmConfirmation INSTANCE = new MaxAltitudeOverAlarmConfirmation();

            private MaxAltitudeOverAlarmConfirmation() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType$ReturnHomeAltitudeUpdate;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$DialogType;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class ReturnHomeAltitudeUpdate
        extends DialogType {
            @NotNull
            public static final ReturnHomeAltitudeUpdate INSTANCE = new ReturnHomeAltitudeUpdate();

            private ReturnHomeAltitudeUpdate() {
                super(null);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "SetMaxAltitudeSucceeded", "SetMaxAltitudeFailed", "MaxAltitudeStateUpdated", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$MaxAltitudeStateUpdated;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$SetMaxAltitudeFailed;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$SetMaxAltitudeSucceeded;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$MaxAltitudeStateUpdated;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState;", "maxAltitudeState", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel$MaxAltitudeState;", "<init>", "(Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel$MaxAltitudeState;)V", "getMaxAltitudeState", "()Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidgetModel$MaxAltitudeState;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class MaxAltitudeStateUpdated
        extends ModelState {
            @NotNull
            private final MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState;

            public MaxAltitudeStateUpdated(@NotNull MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState) {
                Intrinsics.checkNotNullParameter((Object)maxAltitudeState, (String)"maxAltitudeState");
                super(null);
                this.maxAltitudeState = maxAltitudeState;
            }

            @NotNull
            public final MaxAltitudeListItemWidgetModel.MaxAltitudeState getMaxAltitudeState() {
                return this.maxAltitudeState;
            }

            @NotNull
            public final MaxAltitudeListItemWidgetModel.MaxAltitudeState component1() {
                return this.maxAltitudeState;
            }

            @NotNull
            public final MaxAltitudeStateUpdated copy(@NotNull MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState) {
                Intrinsics.checkNotNullParameter((Object)maxAltitudeState, (String)"maxAltitudeState");
                return new MaxAltitudeStateUpdated(maxAltitudeState);
            }

            public static /* synthetic */ MaxAltitudeStateUpdated copy$default(MaxAltitudeStateUpdated maxAltitudeStateUpdated, MaxAltitudeListItemWidgetModel.MaxAltitudeState maxAltitudeState, int n, Object object) {
                if ((n & 1) != 0) {
                    maxAltitudeState = maxAltitudeStateUpdated.maxAltitudeState;
                }
                return maxAltitudeStateUpdated.copy(maxAltitudeState);
            }

            @NotNull
            public String toString() {
                return "MaxAltitudeStateUpdated(maxAltitudeState=" + this.maxAltitudeState + ")";
            }

            public int hashCode() {
                return this.maxAltitudeState.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MaxAltitudeStateUpdated)) {
                    return false;
                }
                MaxAltitudeStateUpdated maxAltitudeStateUpdated = (MaxAltitudeStateUpdated)other;
                return Intrinsics.areEqual((Object)this.maxAltitudeState, (Object)maxAltitudeStateUpdated.maxAltitudeState);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$SetMaxAltitudeFailed;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState;", "error", "Ldji/v5/ux/core/base/UXSDKError;", "<init>", "(Ldji/v5/ux/core/base/UXSDKError;)V", "getError", "()Ldji/v5/ux/core/base/UXSDKError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class SetMaxAltitudeFailed
        extends ModelState {
            @NotNull
            private final UXSDKError error;

            public SetMaxAltitudeFailed(@NotNull UXSDKError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final UXSDKError getError() {
                return this.error;
            }

            @NotNull
            public final UXSDKError component1() {
                return this.error;
            }

            @NotNull
            public final SetMaxAltitudeFailed copy(@NotNull UXSDKError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new SetMaxAltitudeFailed(error);
            }

            public static /* synthetic */ SetMaxAltitudeFailed copy$default(SetMaxAltitudeFailed setMaxAltitudeFailed, UXSDKError uXSDKError, int n, Object object) {
                if ((n & 1) != 0) {
                    uXSDKError = setMaxAltitudeFailed.error;
                }
                return setMaxAltitudeFailed.copy(uXSDKError);
            }

            @NotNull
            public String toString() {
                return "SetMaxAltitudeFailed(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SetMaxAltitudeFailed)) {
                    return false;
                }
                SetMaxAltitudeFailed setMaxAltitudeFailed = (SetMaxAltitudeFailed)other;
                return Intrinsics.areEqual((Object)this.error, (Object)setMaxAltitudeFailed.error);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState$SetMaxAltitudeSucceeded;", "Ldji/v5/ux/core/panel/listitem/maxaltitude/MaxAltitudeListItemWidget$ModelState;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class SetMaxAltitudeSucceeded
        extends ModelState {
            @NotNull
            public static final SetMaxAltitudeSucceeded INSTANCE = new SetMaxAltitudeSucceeded();

            private SetMaxAltitudeSucceeded() {
                super(null);
            }
        }
    }
}

