/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.focusmode;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.camera.CameraFocusMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.focusmode.FocusModeWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.GlobalPreferencesManager;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;

public class FocusModeWidget
extends FrameLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "FocusModeWidget";
    private FocusModeWidgetModel widgetModel;
    private TextView titleTextView;
    private int activeColor;
    private int inactiveColor;

    public FocusModeWidget(Context context) {
        super(context);
    }

    public FocusModeWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FocusModeWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        FocusModeWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_focus_mode_switch, (ViewGroup)this);
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.uxsdk_background_black_rectangle);
        }
        this.titleTextView = (TextView)this.findViewById(R.id.text_view_camera_control_af);
        if (!this.isInEditMode()) {
            this.widgetModel = new FocusModeWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance(), GlobalPreferencesManager.getInstance());
        }
        this.setOnClickListener(this);
        this.activeColor = this.getResources().getColor(R.color.uxsdk_green);
        this.inactiveColor = this.getResources().getColor(R.color.uxsdk_white);
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.isFocusModeChangeSupported().observeOn(SchedulerProvider.ui()).subscribe(this::updateVisibility));
        this.addReaction(this.reactToFocusModeChange());
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    @SuppressLint(value={"CheckResult"})
    public void onClick(View v) {
        this.addReaction(this.widgetModel.toggleFocusMode().observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "switch focus mode: ")));
    }

    private void checkAndUpdateUI() {
        if (!this.isInEditMode()) {
            this.addDisposable(Flowable.combineLatest(this.widgetModel.isAFCEnabled(), this.widgetModel.getFocusMode(), Pair::new).firstOrError().observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateUI((Boolean)values.first, (CameraFocusMode)values.second), UxErrorHandle.logErrorConsumer(TAG, "check and update focus mode: ")));
        }
    }

    private Disposable reactToFocusModeChange() {
        return Flowable.combineLatest(this.widgetModel.isAFCEnabled(), this.widgetModel.getFocusMode(), Pair::new).observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateUI((Boolean)values.first, (CameraFocusMode)values.second), UxErrorHandle.logErrorConsumer(TAG, "react to Focus Mode Change: "));
    }

    private void updateVisibility(boolean isFocusModeChangeSupported) {
        if (isFocusModeChangeSupported) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    private void updateUI(boolean isAFCEnabled, CameraFocusMode focusMode) {
        int autoFocusTextColor;
        int manualFocusTextColor;
        if (focusMode == CameraFocusMode.MANUAL) {
            manualFocusTextColor = this.activeColor;
            autoFocusTextColor = this.inactiveColor;
        } else {
            autoFocusTextColor = this.activeColor;
            manualFocusTextColor = this.inactiveColor;
        }
        String autoFocusText = isAFCEnabled ? this.getResources().getString(R.string.uxsdk_widget_focus_mode_afc) : this.getResources().getString(R.string.uxsdk_widget_focus_mode_auto);
        this.makeSpannableString(autoFocusText, autoFocusTextColor, manualFocusTextColor);
    }

    private void makeSpannableString(String autoFocusText, int autoFocusColor, int manualFocusColor) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        SpannableString str1 = new SpannableString((CharSequence)autoFocusText);
        str1.setSpan((Object)new ForegroundColorSpan(autoFocusColor), 0, str1.length(), 0);
        builder.append((CharSequence)str1);
        SpannableString str2 = new SpannableString((CharSequence)this.getResources().getString(R.string.uxsdk_widget_focus_mode_separator));
        str2.setSpan((Object)new ForegroundColorSpan(this.inactiveColor), 0, str2.length(), 0);
        builder.append((CharSequence)str2);
        SpannableString str3 = new SpannableString((CharSequence)this.getResources().getString(R.string.uxsdk_widget_focus_mode_manual));
        str3.setSpan((Object)new ForegroundColorSpan(manualFocusColor), 0, str3.length(), 0);
        builder.append((CharSequence)str3);
        this.titleTextView.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FocusModeWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.FocusModeWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.FocusModeWidget_uxsdk_lensType, 0)));
        }
        this.activeColor = typedArray.getColor(R.styleable.FocusModeWidget_uxsdk_activeModeTextColor, this.getResources().getColor(R.color.uxsdk_green));
        this.inactiveColor = typedArray.getColor(R.styleable.FocusModeWidget_uxsdk_inactiveModeTextColor, this.getResources().getColor(R.color.uxsdk_white));
        Drawable background = typedArray.getDrawable(R.styleable.FocusModeWidget_uxsdk_widgetTitleBackground);
        this.setTitleBackground(background);
        float textSize = typedArray.getDimension(R.styleable.FocusModeWidget_uxsdk_widgetTitleTextSize, -1.0f);
        if (textSize != -1.0f) {
            this.setTitleTextSize(DisplayUtil.pxToSp((Context)context, (float)textSize));
        }
        typedArray.recycle();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @ColorInt
    public int getActiveModeTextColor() {
        return this.activeColor;
    }

    public void setActiveModeTextColor(@ColorInt int color2) {
        this.activeColor = color2;
        this.checkAndUpdateUI();
    }

    @ColorInt
    public int getInactiveModeTextColor() {
        return this.inactiveColor;
    }

    public void setInactiveModeTextColor(@ColorInt int color2) {
        this.inactiveColor = color2;
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getTitleBackground() {
        return this.titleTextView.getBackground();
    }

    public void setTitleBackground(@DrawableRes int resourceId) {
        this.setTitleBackground(this.getResources().getDrawable(resourceId));
    }

    public void setTitleBackground(@Nullable Drawable drawable2) {
        this.titleTextView.setBackground(drawable2);
    }

    @Dimension
    public float getTitleTextSize() {
        return this.titleTextView.getTextSize();
    }

    public void setTitleTextSize(@Dimension float textSize) {
        this.titleTextView.setTextSize(textSize);
    }
}

