/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.mapkit.core.exceptions.MapkitInitializerException;
import java.util.HashMap;

public class Mapkit {
    private static final String TAG = LogUtils.getTag((String)Mapkit.class.getSimpleName());
    private static final String MAPBOX_TOKEN_KEY = "com.dji.mapkit.maplibre.apikey";
    private static String MAPBOX_ACCESS_TOKEN;
    private static volatile Boolean sIsInMainlandChina;
    private static volatile Boolean sIsInHongKong;
    private static volatile Boolean sIsInMacau;
    private static int sMapProvider;
    private static int sMapType;
    private static int sGeocodingProvider;
    private static final HashMap<Integer, String> providerClassName;
    private static final String CLASS_PROVIDER_MAPLIBRE = "dji.v5.ux.mapkit.maplibre.provider.MaplibreProvider";
    private static final String CLASS_PROVIDER_GOOGLE = "com.dji.mapkit.google.provider.GoogleProvider";

    public static void init(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            MAPBOX_ACCESS_TOKEN = appInfo.metaData.getString(MAPBOX_TOKEN_KEY);
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
        }
    }

    private Mapkit() {
    }

    public static void mapboxAccessToken(@NonNull String accessToken) {
        MAPBOX_ACCESS_TOKEN = accessToken;
    }

    public static String getMapboxAccessToken() {
        if (MAPBOX_ACCESS_TOKEN == null) {
            throw new MapkitInitializerException("Mapbox token is not set yet.");
        }
        return MAPBOX_ACCESS_TOKEN;
    }

    public static void inMainlandChina(boolean inMainlandChina) {
        sIsInMainlandChina = inMainlandChina;
    }

    public static boolean isInMainlandChina() {
        if (sIsInMainlandChina == null) {
            throw new MapkitInitializerException("You should set if Mapkit is used in mainland China, so that Mapkit can correct the coordinate offset.");
        }
        return sIsInMainlandChina;
    }

    public static void inHongKong(boolean inHongKong) {
        sIsInHongKong = inHongKong;
    }

    public static boolean isInHongKong() {
        if (sIsInHongKong == null) {
            throw new MapkitInitializerException("You should set if Mapkit is used in Hong Kong, so that Mapkit can correct the coordinate offset.");
        }
        return sIsInHongKong;
    }

    public static void inMacau(boolean inMacau) {
        sIsInMacau = inMacau;
    }

    public static boolean isInMacau() {
        if (sIsInMacau == null) {
            throw new MapkitInitializerException("You should set if Mapkit is used in Macau, so that Mapkit can correct the coordinate offset.");
        }
        return sIsInMacau;
    }

    @MapProviderConstant
    public static int getMapProvider() {
        return sMapProvider;
    }

    public static int getMapType() {
        return sMapType;
    }

    public static int getGeocodingProvider() {
        return sGeocodingProvider;
    }

    public static void mapProvider(@MapProviderConstant int provider) {
        sMapProvider = provider;
    }

    public static void mapType(int mapType) {
        sMapType = mapType;
    }

    public static void geocodingProvider(int provider) {
        sGeocodingProvider = provider;
    }

    public static String getMapProviderClassName(@MapProviderConstant int provider) {
        return providerClassName.get(provider);
    }

    static {
        sMapProvider = 0;
        sMapType = 1;
        sGeocodingProvider = 0;
        providerClassName = new HashMap();
        providerClassName.put(1, CLASS_PROVIDER_GOOGLE);
        providerClassName.put(3, CLASS_PROVIDER_MAPLIBRE);
    }

    public static @interface MapProviderConstant {
        public static final int INVALID_PROVIDER = 0;
        public static final int GOOGLE_MAP_PROVIDER = 1;
        public static final int AMAP_PROVIDER = 2;
        public static final int MAPLIBRE_MAP_PROVIDER = 3;
        public static final int HERE_MAP_PROVIDER = 4;
    }
}

