/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.taplayout;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.taplayout.QTabView;
import dji.v5.ux.core.ui.setting.taplayout.TabAdapter;
import dji.v5.ux.core.ui.setting.taplayout.TabView;

public class VerticalTabLayout
extends ScrollView {
    private Context mContext;
    private TabStrip mTabStrip;
    private int mColorIndicator;
    private TabView mSelectedTab;
    private int mTabMargin;
    private int mIndicatorWidth;
    private int mIndicatorGravity;
    private float mIndicatorCorners;
    private int mTabMode;
    private int mTabHeight;
    public static int TAB_MODE_FIXED = 10;
    public static int TAB_MODE_SCROLLABLE = 11;
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    protected TabAdapter mTabAdapter;
    private OnTabSelectedListener mTabSelectedListener;
    private OnTabPageChangeListener mTabPageChangeListener;
    private DataSetObserver mPagerAdapterObserver;

    public VerticalTabLayout(Context context) {
        this(context, null);
    }

    public VerticalTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setFillViewport(true);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VerticalTabLayout);
        this.mColorIndicator = typedArray.getColor(R.styleable.VerticalTabLayout_uxsdk_indicator_color, context.getResources().getColor(R.color.uxsdk_blue_highlight));
        this.mIndicatorWidth = (int)typedArray.getDimension(R.styleable.VerticalTabLayout_uxsdk_indicator_width, (float)this.dp2px(3.0f));
        this.mIndicatorCorners = typedArray.getDimension(R.styleable.VerticalTabLayout_uxsdk_indicator_corners, 0.0f);
        this.mIndicatorGravity = typedArray.getInteger(R.styleable.VerticalTabLayout_uxsdk_indicator_gravity, 3);
        this.mTabMargin = (int)typedArray.getDimension(R.styleable.VerticalTabLayout_uxsdk_tab_margin, 0.0f);
        this.mTabMode = typedArray.getInteger(R.styleable.VerticalTabLayout_uxsdk_tab_mode, TAB_MODE_FIXED);
        this.mTabHeight = (int)typedArray.getDimension(R.styleable.VerticalTabLayout_uxsdk_tab_height, -2.0f);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        this.initTabStrip();
    }

    private void initTabStrip() {
        this.mTabStrip = new TabStrip(this.mContext);
        this.addView((View)this.mTabStrip, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void removeAllTabs() {
        this.mTabStrip.removeAllViews();
        this.mSelectedTab = null;
    }

    public TabView getTabAt(int position) {
        return (TabView)this.mTabStrip.getChildAt(position);
    }

    private void addTabWithMode(TabView tabView) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.initTabWithMode(params);
        this.mTabStrip.addView((View)tabView, (ViewGroup.LayoutParams)params);
        if (this.mTabStrip.indexOfChild((View)tabView) == 0) {
            tabView.setChecked(true);
            params = (LinearLayout.LayoutParams)tabView.getLayoutParams();
            if (this.mTabMode == TAB_MODE_SCROLLABLE) {
                params.height = this.mTabHeight;
            }
            params.setMargins(0, 0, 0, 0);
            tabView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mSelectedTab = tabView;
        }
    }

    private void initTabWithMode(LinearLayout.LayoutParams params) {
        if (this.mTabMode == TAB_MODE_FIXED) {
            params.height = 0;
            params.weight = 1.0f;
            params.setMargins(0, 0, 0, 0);
        } else if (this.mTabMode == TAB_MODE_SCROLLABLE) {
            params.height = this.mTabHeight;
            params.weight = 0.0f;
            params.setMargins(0, this.mTabMargin, 0, 0);
        }
    }

    private void scrollTab(TabView tabView) {
        tabView.post(() -> {
            int y = this.getScrollY();
            int tabTop = tabView.getTop() + tabView.getHeight() / 2 - y;
            int target = this.getHeight() / 2;
            this.smoothScrollBy(0, tabTop - target);
        });
    }

    public void addTab(TabView tabView) {
        if (tabView == null) {
            throw new IllegalStateException("tabview can't be null");
        }
        this.addTabWithMode(tabView);
        tabView.setOnClickListener(view -> {
            int position = this.mTabStrip.indexOfChild(view);
            if (position >= 0 && position < this.mTabStrip.getChildCount()) {
                this.setTabSelected(position);
            }
        });
    }

    public void setTabSelected(int position) {
        TabView view = this.getTabAt(position);
        if (view != this.mSelectedTab) {
            this.mSelectedTab.setChecked(false);
            view.setChecked(true);
            if (this.mViewPager == null) {
                this.mTabStrip.moveIndicator(position);
            }
            this.mSelectedTab = view;
            this.notifyTabSelected(view, position);
            this.scrollTab(this.mSelectedTab);
        }
    }

    private void notifyTabSelected(TabView view, int position) {
        if (this.mTabSelectedListener != null) {
            this.mTabSelectedListener.onTabSelected(view, position);
        }
    }

    public void setTabBadge(int position, int num) {
        this.getTabAt(position).setBadge(num);
    }

    public void setTabMode(int mode) {
        if (mode != TAB_MODE_FIXED && mode != TAB_MODE_SCROLLABLE) {
            throw new IllegalStateException("only support TAB_MODE_FIXED or TAB_MODE_SCROLLABLE");
        }
        if (mode == this.mTabMode) {
            return;
        }
        this.mTabMode = mode;
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View view = this.mTabStrip.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            this.initTabWithMode(params);
            if (i == 0) {
                params.setMargins(0, 0, 0, 0);
            }
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTabStrip.invalidate();
        this.mTabStrip.post(() -> this.mTabStrip.updataIndicatorMargin());
    }

    public void setTabMargin(int margin) {
        if (margin == this.mTabMargin) {
            return;
        }
        this.mTabMargin = margin;
        if (this.mTabMode == TAB_MODE_FIXED) {
            return;
        }
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View view = this.mTabStrip.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            params.setMargins(0, i == 0 ? 0 : this.mTabMargin, 0, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTabStrip.invalidate();
        this.mTabStrip.post(() -> this.mTabStrip.updataIndicatorMargin());
    }

    public void setTabHeight(int height) {
        if (height == this.mTabHeight) {
            return;
        }
        this.mTabHeight = height;
        if (this.mTabMode == TAB_MODE_FIXED) {
            return;
        }
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View view = this.mTabStrip.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            params.height = this.mTabHeight;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTabStrip.invalidate();
        this.mTabStrip.post(() -> this.mTabStrip.updataIndicatorMargin());
    }

    public void setIndicatorColor(int color2) {
        this.mColorIndicator = color2;
        this.mTabStrip.invalidate();
    }

    public void setIndicatorWidth(int width) {
        this.mIndicatorWidth = width;
        this.mTabStrip.setIndicatorGravity();
    }

    public void setIndicatorCorners(int corners) {
        this.mIndicatorCorners = corners;
        this.mTabStrip.invalidate();
    }

    public void setIndicatorGravity(int gravity) {
        if (gravity != 3 && gravity != 5 && 119 != gravity) {
            throw new IllegalStateException("only support Gravity.LEFT,Gravity.RIGHT,Gravity.FILL");
        }
        this.mIndicatorGravity = gravity;
        this.mTabStrip.setIndicatorGravity();
    }

    public void setOnTabSelectedListener(OnTabSelectedListener listener2) {
        this.mTabSelectedListener = listener2;
    }

    public void setTabAdapter(TabAdapter adapter) {
        this.removeAllTabs();
        if (adapter != null) {
            this.mTabAdapter = adapter;
            for (int i = 0; i < adapter.getCount(); ++i) {
                this.addTab(new QTabView(this.mContext).setIcon(adapter.getIcon(i)).setTitle(adapter.getTitle(i)).setBadge(adapter.getBadge(i)).setBackground(adapter.getBackground(i)));
            }
        } else {
            this.removeAllTabs();
        }
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        if (this.mViewPager != null && this.mTabPageChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mTabPageChangeListener);
        }
        if (viewPager != null) {
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter == null) {
                throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
            }
            this.mViewPager = viewPager;
            if (this.mTabPageChangeListener == null) {
                this.mTabPageChangeListener = new OnTabPageChangeListener();
            }
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mTabPageChangeListener);
            this.setOnTabSelectedListener((tab, position) -> viewPager.setCurrentItem(position, false));
            this.setPagerAdapter(adapter, true);
        } else {
            this.mViewPager = null;
            this.setOnTabSelectedListener(null);
            this.setPagerAdapter(null, true);
        }
    }

    private void setPagerAdapter(@Nullable PagerAdapter adapter, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    private void populateFromPagerAdapter() {
        this.removeAllTabs();
        if (this.mPagerAdapter != null) {
            int curItem;
            int adapterCount = this.mPagerAdapter.getCount();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(i);
            }
            if (this.mViewPager != null && adapterCount > 0 && (curItem = this.mViewPager.getCurrentItem()) != this.getSelectedTabPosition() && curItem < this.getTabCount()) {
                this.setTabSelected(curItem);
            }
            return;
        }
        this.removeAllTabs();
    }

    private void addTab(int i) {
        if (this.mPagerAdapter instanceof TabAdapter) {
            this.mTabAdapter = (TabAdapter)this.mPagerAdapter;
            this.addTab(new QTabView(this.mContext).setIcon(this.mTabAdapter.getIcon(i)).setTitle(this.mTabAdapter.getTitle(i)).setBadge(this.mTabAdapter.getBadge(i)).setBackground(this.mTabAdapter.getBackground(i)));
        } else {
            String title = this.mPagerAdapter.getPageTitle(i) == null ? "tab" + i : this.mPagerAdapter.getPageTitle(i).toString();
            this.addTab(new QTabView(this.mContext).setTitle(new QTabView.TabTitle.Builder(this.mContext).setContent(title).build()));
        }
    }

    private int getTabCount() {
        return this.mTabStrip.getChildCount();
    }

    private int getSelectedTabPosition() {
        int index = this.mTabStrip.indexOfChild((View)this.mSelectedTab);
        return index == -1 ? 0 : index;
    }

    protected int dp2px(float dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    private class TabStrip
    extends LinearLayout {
        private float mIndicatorY;
        private int mIndicatorX;
        private int mLastWidth;
        private int mIndicatorHeight;
        private Paint mIndicatorPaint;

        public TabStrip(Context context) {
            super(context);
            this.setWillNotDraw(false);
            this.setOrientation(1);
            this.mIndicatorPaint = new Paint();
            VerticalTabLayout.this.mIndicatorGravity = VerticalTabLayout.this.mIndicatorGravity == 0 ? 3 : VerticalTabLayout.this.mIndicatorGravity;
            this.setIndicatorGravity();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.getChildCount() > 0) {
                View childView = this.getChildAt(0);
                this.mIndicatorHeight = childView.getMeasuredHeight();
            }
        }

        public void updataIndicatorMargin() {
            int index = VerticalTabLayout.this.getSelectedTabPosition();
            this.mIndicatorY = this.calcIndicatorY(index);
            this.invalidate();
        }

        public void setIndicatorGravity() {
            if (VerticalTabLayout.this.mIndicatorGravity == 3) {
                this.mIndicatorX = 0;
                if (this.mLastWidth != 0) {
                    VerticalTabLayout.this.mIndicatorWidth = this.mLastWidth;
                }
                this.setPadding(VerticalTabLayout.this.mIndicatorWidth, 0, 0, 0);
            } else if (VerticalTabLayout.this.mIndicatorGravity == 5) {
                if (this.mLastWidth != 0) {
                    VerticalTabLayout.this.mIndicatorWidth = this.mLastWidth;
                }
                this.setPadding(0, 0, VerticalTabLayout.this.mIndicatorWidth, 0);
            } else if (VerticalTabLayout.this.mIndicatorGravity == 119) {
                this.mIndicatorX = 0;
                this.setPadding(0, 0, 0, 0);
            }
            this.post(() -> {
                if (VerticalTabLayout.this.mIndicatorGravity == 5) {
                    this.mIndicatorX = this.getWidth() - VerticalTabLayout.this.mIndicatorWidth;
                } else if (VerticalTabLayout.this.mIndicatorGravity == 119) {
                    this.mLastWidth = VerticalTabLayout.this.mIndicatorWidth;
                    VerticalTabLayout.this.mIndicatorWidth = this.getWidth();
                }
                this.invalidate();
            });
        }

        private float calcIndicatorY(float offset) {
            if (VerticalTabLayout.this.mTabMode == TAB_MODE_FIXED) {
                return offset * (float)this.mIndicatorHeight;
            }
            return offset * (float)(this.mIndicatorHeight + VerticalTabLayout.this.mTabMargin);
        }

        public void moveIndicator(float offset) {
            this.mIndicatorY = this.calcIndicatorY(offset);
            this.invalidate();
        }

        public void moveIndicator(int index) {
            float target = this.calcIndicatorY(index);
            if (this.mIndicatorY == target) {
                return;
            }
            this.post(() -> {
                ValueAnimator anime = ValueAnimator.ofFloat((float[])new float[]{this.mIndicatorY, target});
                anime.addUpdateListener(animation -> {
                    float value;
                    this.mIndicatorY = value = Float.parseFloat(animation.getAnimatedValue().toString());
                    this.invalidate();
                });
                anime.setDuration(200L).start();
            });
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.mIndicatorPaint.setColor(VerticalTabLayout.this.mColorIndicator);
            RectF r = new RectF((float)this.mIndicatorX * 1.0f, this.mIndicatorY * 1.0f, (float)this.mIndicatorX + (float)VerticalTabLayout.this.mIndicatorWidth * 1.0f, this.mIndicatorY + (float)this.mIndicatorHeight * 1.0f);
            if (VerticalTabLayout.this.mIndicatorCorners != 0.0f) {
                canvas.drawRoundRect(r, VerticalTabLayout.this.mIndicatorCorners, VerticalTabLayout.this.mIndicatorCorners, this.mIndicatorPaint);
            } else {
                canvas.drawRect(r, this.mIndicatorPaint);
            }
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(TabView var1, int var2);
    }

    private class OnTabPageChangeListener
    implements ViewPager.OnPageChangeListener {
        public void onPageScrollStateChanged(int state) {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            VerticalTabLayout.this.mTabStrip.moveIndicator(positionOffset + (float)position);
        }

        public void onPageSelected(int position) {
            if (position != VerticalTabLayout.this.getSelectedTabPosition()) {
                VerticalTabLayout.this.setTabSelected(position);
            }
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private PagerAdapterObserver() {
        }

        public void onChanged() {
            VerticalTabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            VerticalTabLayout.this.populateFromPagerAdapter();
        }
    }
}

