/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi.dashboard;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.v5.common.utils.UnitUtils;
import dji.v5.manager.aircraft.perception.data.ObstacleAvoidanceType;
import dji.v5.manager.aircraft.perception.data.ObstacleData;
import dji.v5.manager.aircraft.perception.radar.RadarInformation;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.hsi.config.IOmniAbility;
import dji.v5.ux.core.ui.hsi.dashboard.ScrollableAttributeDashBoard;
import dji.v5.ux.core.util.DrawUtils;
import dji.v5.ux.core.util.FontUtils;
import dji.v5.ux.core.widget.hsi.AttitudeDisplayModel;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.CompositeDisposable;

public class AttitudeDashBoard
extends ScrollableAttributeDashBoard {
    private static final String TAG = "AttitudeDashBoard";
    private static final int UPWARD = -1;
    private static final int DOWNWARD = 1;
    private static final int PREDICT_TIME_IN_SECONDS = 6;
    private int mUpMaxPerceptionDistanceInMeter;
    private int mDownMaxPerceptionDistanceInMeter;
    private static final float SPEED_THRESHOLD = 0.001f;
    private static final int PFD_BARRIER_OFF_TEXT_DISTANCE = 20;
    private final int mAvoidanceMaxHeight;
    private final int mBarrierDistanceTextSize;
    private final int mBarrierIndicatorColor;
    private final int mAvoidanceIndicatorColor;
    private final int mAvoidanceIndicatorWidth;
    private final int mAvoidanceIndicatorStrokeWidth;
    private final int mDistancePredictWidth;
    private final int mReturnToHomeIndicatorWidth;
    private final CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private float mUserSetUpBarrierAvoidanceDistance;
    private float mUserSetUpBarrierWarnDistance;
    private float mUserSetDownBarrierAvoidanceDistance;
    private float mUserSetDownBarrierWarnDistance;
    private float mSpeedZ;
    private float mHeight;
    private boolean mUpwardVisualEnable;
    private boolean mShowDownwardVisualPerceptionInfo;
    private boolean mUpwardRadarEnable;
    private RadarInformation radarInformation = new RadarInformation();
    private float mUpwardRadarDistance;
    private Bitmap mBarrierUp;
    private Bitmap mBarrierDown;
    private float mBarrierOriginLineWidth;
    private float mBarrierOriginLineLength;
    private float mBarrierTextMargin;
    private IBarrierDistanceStrategy mBarrierDistanceStrategy;
    @NonNull
    private final boolean[] mVisionPerceptionWorkingState = new boolean[]{false, false};
    private AttitudeDisplayModel mWidgetModel;
    private ObstacleData mPerceptionObstacleData = new ObstacleData();
    private String mUpBarrierString;
    private final Object mUpBarrierStringLock = new Object();
    private String mDownBarrierString;
    private final Object mDownBarrierStringLock = new Object();

    public void setModel(AttitudeDisplayModel model) {
        this.mWidgetModel = model;
    }

    public AttitudeDashBoard(Context context) {
        this(context, null);
    }

    public AttitudeDashBoard(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AttitudeDashBoard(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AttitudeDashBoard);
        this.mAvoidanceMaxHeight = typedArray.getDimensionPixelSize(R.styleable.AttitudeDashBoard_uxsdk_avoidance_max_height, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_38_dp));
        this.mBarrierDistanceTextSize = typedArray.getDimensionPixelSize(R.styleable.AttitudeDashBoard_uxsdk_barrier_distance_text_size, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_7_dp));
        this.mAvoidanceIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.AttitudeDashBoard_uxsdk_avoidance_indicator_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_3_dp));
        this.mAvoidanceIndicatorStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.AttitudeDashBoard_uxsdk_avoidance_indicator_stroke_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_0_5_dp));
        this.mDistancePredictWidth = typedArray.getDimensionPixelSize(R.styleable.AttitudeDashBoard_uxsdk_distance_predict_line_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_2_dp));
        this.mReturnToHomeIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.AttitudeDashBoard_uxsdk_return_to_home_indicator_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_22_dp));
        this.mBarrierIndicatorColor = typedArray.getColor(R.styleable.AttitudeDashBoard_uxsdk_barrier_indicator_color, this.getResources().getColor(R.color.uxsdk_pfd_barrier_color));
        Drawable up = typedArray.getDrawable(R.styleable.AttitudeDashBoard_uxsdk_barrier_drawable_up);
        if (up != null) {
            this.mBarrierUp = DrawUtils.drawable2Bitmap(up);
        }
        Drawable down = typedArray.getDrawable(R.styleable.AttitudeDashBoard_uxsdk_barrier_drawable_down);
        if (up != null) {
            this.mBarrierDown = DrawUtils.drawable2Bitmap(down);
        }
        this.mAvoidanceIndicatorColor = typedArray.getColor(R.styleable.AttitudeDashBoard_uxsdk_avoidance_indicator_color, this.getResources().getColor(R.color.uxsdk_pfd_avoidance_color));
        this.mUpwardRadarDistance = typedArray.getInt(R.styleable.AttitudeDashBoard_uxsdk_barrier_distance, Integer.MAX_VALUE);
        this.mBarrierOriginLineWidth = this.getResources().getDimension(R.dimen.uxsdk_1_dp);
        this.mBarrierOriginLineLength = this.getResources().getDimension(R.dimen.uxsdk_6_dp);
        typedArray.recycle();
        if (!this.isInEditMode()) {
            this.mUpMaxPerceptionDistanceInMeter = IOmniAbility.Companion.getCurrent().getUpDetectionCapability();
            this.mDownMaxPerceptionDistanceInMeter = IOmniAbility.Companion.getCurrent().getDownDetectionCapability();
        }
        this.mBarrierTextMargin = this.getResources().getDimension(R.dimen.uxsdk_1_dp);
        Log.d((String)TAG, (String)("isShowFramework=" + this.isShowFramework()));
        this.mBarrierDistanceStrategy = this.isShowFramework() ? new PfdBarrierDistanceStrategy() : new HsiBarrierDistanceStrategy();
        this.mWaypointIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.uxsdk_fpv_pfd_waypoint_right);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.mCompositeDisposable.add(this.mWidgetModel.getPerceptionInfoProcessor().toFlowable().subscribe(info -> {
            boolean isBypass = info.getObstacleAvoidanceType() == ObstacleAvoidanceType.BYPASS;
            this.mUpwardVisualEnable = info.isUpwardObstacleAvoidanceEnabled() || isBypass;
            this.mUserSetUpBarrierAvoidanceDistance = (float)info.getUpwardObstacleAvoidanceBrakingDistance();
            this.mUserSetUpBarrierWarnDistance = (float)info.getUpwardObstacleAvoidanceWarningDistance();
            this.mShowDownwardVisualPerceptionInfo = info.isDownwardObstacleAvoidanceEnabled() || isBypass;
            this.mUserSetDownBarrierAvoidanceDistance = (float)info.getDownwardObstacleAvoidanceBrakingDistance();
            this.mUserSetDownBarrierWarnDistance = (float)info.getDownwardObstacleAvoidanceWarningDistance() / 10.0f;
            this.mVisionPerceptionWorkingState[0] = info.getUpwardObstacleAvoidanceWorking() == Boolean.TRUE;
            this.mVisionPerceptionWorkingState[1] = info.getDownwardObstacleAvoidanceWorking() == Boolean.TRUE;
            this.updateWidget();
        }));
        this.mCompositeDisposable.add(this.mWidgetModel.getPerceptionObstacleDataProcessor().toFlowable().subscribe(data -> {
            this.mPerceptionObstacleData = data;
            this.updateWidget();
        }));
        this.mCompositeDisposable.add(this.mWidgetModel.getRadarInfoProcessor().toFlowable().subscribe(info -> {
            this.mUpwardRadarEnable = info.isUpwardObstacleAvoidanceEnabled();
            this.radarInformation = info;
            this.updateWidget();
        }));
        this.mCompositeDisposable.add(this.mWidgetModel.getRadarObstacleDataProcessor().toFlowable().subscribe(data -> {
            if (this.radarInformation.isConnected()) {
                LogUtils.e((String)TAG, (Object[])new Object[]{"\u96f7\u8fbe\u5df2\u8fde\u63a5"});
                this.mUpwardRadarDistance = (float)data.getUpwardObstacleDistance() * 1.0f / 1000.0f;
                this.updateWidget();
            }
        }));
        this.mCompositeDisposable.add(this.mWidgetModel.getVelocityProcessor().toFlowable().subscribe(velocity3D -> {
            this.mSpeedZ = velocity3D.getZ().floatValue();
            this.updateWidget();
        }));
        this.mCompositeDisposable.add(this.mWidgetModel.getAltitudeProcessor().toFlowable().subscribeOn(AndroidSchedulers.mainThread()).subscribe(altitude -> {
            this.mHeight = altitude.floatValue();
            this.setCurrentValue(this.mHeight);
        }));
        this.mCompositeDisposable.add(this.mWidgetModel.getGoHomeHeightProcessor().toFlowable().subscribe(integer2 -> this.updateWidget()));
        this.mCompositeDisposable.add(this.mWidgetModel.getLimitMaxFlightHeightInMeterProcessor().toFlowable().subscribe(integer2 -> this.updateWidget()));
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCompositeDisposable.dispose();
    }

    @Override
    protected int getMinHeight() {
        return Math.max(this.getFrameworkHeight(), this.getAvoidanceHeight());
    }

    private int getAvoidanceHeight() {
        return this.mAvoidanceMaxHeight * 2 + this.getBarrierUpIndicatorHeight() + this.getBarrierDownIndicatorHeight();
    }

    private int getBarrierUpIndicatorHeight() {
        if (this.mBarrierUp == null) {
            return 0;
        }
        return this.mBarrierUp.getHeight();
    }

    private int getBarrierDownIndicatorHeight() {
        if (this.mBarrierDown == null) {
            return 0;
        }
        return this.mBarrierDown.getHeight();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        float barrierRightOffset = this.isShowFramework() ? (float)this.mFrameworkPaddingStart - (float)this.mFrameworkStrokeWidth / 2.0f : (float)this.mFrameworkPaddingStart + this.mBarrierOriginLineLength;
        canvas.translate(barrierRightOffset, (float)this.getHeight() / 2.0f);
        this.drawDistancePredict(canvas);
        this.drawBarrierBackground(canvas);
        this.drawBarrierInfo(canvas);
        this.drawBarrierOriginLine(canvas);
        canvas.restore();
    }

    private void drawBarrierBackground(Canvas canvas) {
        this.drawBarrierBackground(canvas, -1);
        this.drawBarrierBackground(canvas, 1);
    }

    private void drawBarrierBackground(Canvas canvas, int orientation) {
        float bottom;
        float top;
        if (this.isShowFramework() && !this.isUserDisable(orientation)) {
            return;
        }
        float bgHeight = this.isShowFramework() ? this.getViewHeightForDistance(20.0f) : (float)this.mAvoidanceMaxHeight;
        if (orientation == -1) {
            top = bgHeight * (float)orientation;
            bottom = 0.0f;
        } else {
            top = 0.0f;
            bottom = bgHeight * (float)orientation;
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        float strokeWidth = this.getBarStrokeWidth();
        float halfStrokeWidth = strokeWidth / 2.0f;
        this.mPaint.setStrokeWidth(strokeWidth);
        int strokeColor = this.getBarStrokeColor();
        this.mPaint.setColor(strokeColor);
        float left = -this.mAvoidanceIndicatorWidth;
        float right = 0.0f;
        canvas.drawRect(left + halfStrokeWidth, top - halfStrokeWidth * (float)orientation, right - halfStrokeWidth, bottom + halfStrokeWidth, this.mPaint);
        int bgColor = this.getBarFillColor();
        this.mPaint.setColor(bgColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawRect(left + strokeWidth, top, right - strokeWidth, bottom, this.mPaint);
        if (!this.isShowFramework() && (this.needBarrierInfo(orientation) || this.isUserDisable(orientation))) {
            float baseline = orientation == -1 ? FontUtils.getDigitalBaselineFromTop(this.mPaint, top) : FontUtils.getDigitalBaselineFromBottom(this.mPaint, bottom);
            this.drawBarrierText(canvas, orientation, baseline, (float)(this.mBarrierUp.getWidth() - this.mAvoidanceIndicatorWidth) / 2.0f);
        }
    }

    private int getBarFillColor() {
        return AndUtil.getResColor((int)R.color.uxsdk_white_20_percent);
    }

    private int getBarStrokeColor() {
        return this.mStrokeConfig.getStrokeDeepColor();
    }

    private float getBarStrokeWidth() {
        if (this.isShowFramework()) {
            return this.mStrokeConfig.getStrokeBoldWidth();
        }
        return this.mStrokeConfig.getStrokeThinWidth();
    }

    private void calcBarrierString(int orientation) {
        this.mDataHandler.post(() -> {
            String newString = "";
            if (orientation == -1) {
                float barrierDistance = this.getUpwardBarrierDistance();
                newString = this.getBarrierString(orientation, barrierDistance);
                Object object = this.mUpBarrierStringLock;
                synchronized (object) {
                    if (!newString.equals(this.mUpBarrierString)) {
                        this.mUpBarrierString = newString;
                        this.updateWidget();
                    }
                }
            }
            float barrierDistance = this.getDownVisionDistance();
            newString = this.getBarrierString(orientation, barrierDistance);
            Object object = this.mDownBarrierStringLock;
            synchronized (object) {
                if (!newString.equals(this.mDownBarrierString)) {
                    this.mDownBarrierString = newString;
                    this.updateWidget();
                }
            }
        });
    }

    private String getBarrierString(int orientation, float barrierDistance) {
        if (this.isUserDisable(orientation)) {
            return "OFF";
        }
        float displayValue = this.getDisplayValue(barrierDistance);
        if (displayValue >= 99.95f) {
            return String.format("%3.0f", Float.valueOf(displayValue));
        }
        return String.format("%2.1f", Float.valueOf(displayValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBarrierText(Canvas canvas, int orientation, float baseline, float textOffsetX) {
        String barrierString;
        Object object;
        float dangerDistance;
        float barrierDistance;
        this.calcBarrierString(orientation);
        this.mPaint.setTextSize((float)this.mBarrierDistanceTextSize);
        if (orientation == -1) {
            barrierDistance = this.getUpwardBarrierDistance();
            dangerDistance = this.mUserSetUpBarrierAvoidanceDistance;
            object = this.mUpBarrierStringLock;
            synchronized (object) {
                barrierString = this.mUpBarrierString;
            }
        }
        barrierDistance = this.getDownVisionDistance();
        dangerDistance = this.mUserSetDownBarrierAvoidanceDistance;
        object = this.mUpBarrierStringLock;
        synchronized (object) {
            barrierString = this.mDownBarrierString;
        }
        if (barrierString == null) {
            return;
        }
        if (this.isShowFramework()) {
            textOffsetX -= this.mPaint.measureText(barrierString);
        }
        int textColor = this.getBarrierTextColor(orientation, barrierDistance, dangerDistance);
        this.drawTextWithStroke(canvas, barrierString, textOffsetX, baseline, this.mStrokeConfig.getStrokeBoldWidth(), this.mStrokeConfig.getStrokeDeepColor(), textColor);
    }

    private int getBarrierTextColor(int orientation, float barrierDistance, float dangerDistance) {
        int result = this.isUserDisable(orientation) || barrierDistance <= dangerDistance ? this.mBarrierIndicatorColor : this.mAvoidanceIndicatorColor;
        return result;
    }

    boolean isUserDisable(int orientation) {
        return orientation == -1 && this.isUpwardUserDisable() || orientation == 1 && this.isDownwardUserDisable();
    }

    boolean isUpwardUserDisable() {
        return !this.mUpwardVisualEnable && !this.mUpwardRadarEnable;
    }

    boolean isDownwardUserDisable() {
        return !this.mShowDownwardVisualPerceptionInfo;
    }

    private void drawDistancePredict(Canvas canvas) {
        float bottom;
        float top;
        if (Math.abs(this.mSpeedZ) <= 0.001f) {
            return;
        }
        canvas.save();
        float predictDistance = 6.0f * this.mSpeedZ;
        float ratio = (float)this.mAvoidanceMaxHeight / (float)this.getMaxPerceptionDistanceInMeter(this.mSpeedZ > 0.0f ? -1 : 1);
        float predictArea = Math.abs(predictDistance * ratio);
        this.mPaint.setColor(-1);
        if (this.isShowFramework()) {
            canvas.translate((float)this.mFrameworkStrokeWidth / 2.0f, 0.0f);
        }
        float halfHeight = this.mBarrierOriginLineWidth / 2.0f;
        if (predictDistance < 0.0f) {
            top = -((int)predictArea);
            bottom = halfHeight;
        } else {
            bottom = (int)predictArea;
            top = -halfHeight;
        }
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, top, (float)this.mDistancePredictWidth, bottom, this.mPaint);
        canvas.restore();
    }

    private float getViewHeightForDistance(float distance) {
        if (!this.isShowFramework()) {
            return 0.0f;
        }
        return distance / this.mAttributeOffsetPerUnit * (float)this.getFrameworkHeight() / (float)this.mVisibleCalibrationUnitCount;
    }

    private void drawBarrierOriginLine(Canvas canvas) {
        float halfHeight = this.mBarrierOriginLineWidth / 2.0f;
        if (!this.isShowFramework()) {
            this.mPaint.setColor(-1);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(-this.mBarrierOriginLineLength, halfHeight, 0.0f, -halfHeight, this.mPaint);
            this.mPaint.setColor(this.mStrokeConfig.getStrokeDeepColor());
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.getShadowLineStrokeWidth());
            canvas.drawRect(-this.mBarrierOriginLineLength, halfHeight, 0.0f, -halfHeight, this.mPaint);
        }
    }

    private void drawBarrierInfo(Canvas canvas) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.getUpVisionDistance() == 2.1474836E9f && this.mUpwardRadarDistance == 2.1474836E9f && this.getDownVisionDistance() == 2.1474836E9f) {
            return;
        }
        canvas.save();
        if (ProductUtil.isM300Product() && this.isUserDisable(-1)) {
            if (this.isShowFramework()) {
                this.drawPfdBarrierUserDisableText(canvas, -1);
            }
        } else if (this.needUpwardBarrierInfo()) {
            canvas.save();
            this.drawBarrierInfo(canvas, -1);
            canvas.restore();
        }
        if (ProductUtil.isM300Product() && this.isUserDisable(1)) {
            if (this.isShowFramework()) {
                this.drawPfdBarrierUserDisableText(canvas, 1);
            }
        } else if (this.needDownwardBarrierInfo()) {
            canvas.save();
            this.drawBarrierInfo(canvas, 1);
            canvas.restore();
        }
        canvas.restore();
    }

    private void drawPfdBarrierUserDisableText(Canvas canvas, int orientation) {
        float strokeWidth = this.mStrokeConfig.getStrokeThinWidth();
        this.mPaint.setStrokeWidth(strokeWidth);
        float textOffsetX = (float)(-this.mAvoidanceIndicatorWidth) - this.mBarrierTextMargin;
        float textOffsetY = this.getViewHeightForDistance(20.0f);
        float baseline = orientation == -1 ? FontUtils.getDigitalBaselineFromTop(this.mPaint, -textOffsetY) : FontUtils.getDigitalBaselineFromBottom(this.mPaint, textOffsetY);
        this.drawBarrierText(canvas, orientation, baseline, textOffsetX);
    }

    public int getMaxPerceptionDistanceInMeter(int orientation) {
        return orientation == -1 ? this.mUpMaxPerceptionDistanceInMeter : this.mDownMaxPerceptionDistanceInMeter;
    }

    boolean needBarrierInfo(int orientation) {
        return orientation == -1 && this.needUpwardBarrierInfo() || orientation == 1 && this.needDownwardBarrierInfo();
    }

    private boolean needDownwardBarrierInfo() {
        return this.getDownVisionDistance() <= (float)this.getMaxPerceptionDistanceInMeter(1) && (!ProductUtil.isM300Product() || this.mShowDownwardVisualPerceptionInfo);
    }

    private boolean needUpwardBarrierInfo() {
        int maxPerceptionDistanceInMeter = this.getMaxPerceptionDistanceInMeter(-1);
        return this.getUpVisionDistance() <= (float)maxPerceptionDistanceInMeter && (!ProductUtil.isM300Product() || this.mUpwardVisualEnable) || (!ProductUtil.isM300Product() || this.mUpwardRadarEnable) && this.mUpwardRadarDistance <= (float)maxPerceptionDistanceInMeter;
    }

    private void drawBarrierInfo(Canvas canvas, int orientation) {
        float[] canvasOffsetY = new float[1];
        float offsetY = this.isShowFramework() ? 0.0f : this.mBarrierOriginLineWidth / 2.0f;
        float avoidanceMaxHeight = this.mAvoidanceMaxHeight;
        int maxPerceptionDistanceInMeter = this.getMaxPerceptionDistanceInMeter(orientation);
        if (this.isShowFramework()) {
            avoidanceMaxHeight = this.getViewHeightForDistance(maxPerceptionDistanceInMeter);
        }
        float barrierIndicatorHeight = avoidanceMaxHeight - offsetY;
        float maxPerceptionDistanceBarrierValue = this.mBarrierDistanceStrategy.getBarrierValue(maxPerceptionDistanceInMeter);
        if (maxPerceptionDistanceBarrierValue <= 0.0f) {
            LogUtils.e((String)TAG, (Object[])new Object[]{"mMaxPerceptionDistanceInMeter must large than zero."});
            return;
        }
        canvas.translate(0.0f, offsetY * (float)orientation);
        float ratio = barrierIndicatorHeight / maxPerceptionDistanceBarrierValue;
        int restArea = this.drawMaxPerceptionIndicator(canvas, orientation, (int)barrierIndicatorHeight, ratio, canvasOffsetY);
        if (restArea > 0) {
            restArea = this.drawSettingPerceptionIndicator(canvas, orientation, restArea, ratio, canvasOffsetY);
            this.drawBarrierIndicator(canvas, orientation, restArea, ratio, canvasOffsetY);
        }
        this.drawBarrier(canvas, orientation, canvasOffsetY);
        canvas.translate(0.0f, -offsetY * (float)orientation);
    }

    private int drawMaxPerceptionIndicator(Canvas canvas, int orientation, int barrierIndicatorHeight, float ratio, float[] canvasOffsetY) {
        float barrierDistance = orientation == -1 ? this.getUpwardBarrierDistance() : this.getDownVisionDistance();
        float perceptionDistance = orientation == -1 ? this.mUserSetUpBarrierWarnDistance : this.mUserSetDownBarrierWarnDistance;
        float barrierValue = this.mBarrierDistanceStrategy.getBarrierValue(barrierDistance);
        float perceptionValue = this.mBarrierDistanceStrategy.getBarrierValue(perceptionDistance);
        this.mPaint.setColor(this.mAvoidanceIndicatorColor);
        int strokeWidth = this.mAvoidanceIndicatorStrokeWidth;
        float halfStrokeWidth = (float)this.mAvoidanceIndicatorStrokeWidth / 2.0f;
        this.mPaint.setStrokeWidth((float)strokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        float outOfPerceptionDistanceRange = barrierValue - perceptionValue;
        int restArea = barrierIndicatorHeight;
        if (outOfPerceptionDistanceRange > 0.0f) {
            float outOfPerceptionArea = outOfPerceptionDistanceRange * ratio;
            if (outOfPerceptionArea > (float)restArea) {
                outOfPerceptionArea = restArea;
            }
            if (this.isShowFramework()) {
                float bottom;
                float top;
                if (orientation == -1) {
                    top = (float)(-((int)outOfPerceptionArea)) + halfStrokeWidth;
                    bottom = 0.0f;
                } else {
                    top = 0.0f;
                    bottom = (float)((int)outOfPerceptionArea) - halfStrokeWidth;
                }
                canvas.drawRect((float)(-this.mAvoidanceIndicatorWidth) + halfStrokeWidth, top, 0.0f - halfStrokeWidth, bottom, this.mPaint);
            }
            int dy = (int)outOfPerceptionArea * orientation;
            canvasOffsetY[0] = canvasOffsetY[0] + (float)dy;
            canvas.translate(0.0f, (float)dy);
            restArea -= (int)outOfPerceptionArea;
        }
        return restArea;
    }

    private int drawSettingPerceptionIndicator(Canvas canvas, int orientation, int restArea, float ratio, float[] canvasOffsetY) {
        float barrierDistance = orientation == -1 ? this.getUpwardBarrierDistance() : this.getDownVisionDistance();
        float perceptionDistance = orientation == -1 ? this.mUserSetUpBarrierWarnDistance : this.mUserSetDownBarrierWarnDistance;
        float barrierAvoidanceDistance = orientation == -1 ? this.mUserSetUpBarrierAvoidanceDistance : this.mUserSetDownBarrierAvoidanceDistance;
        float barrierValue = this.mBarrierDistanceStrategy.getBarrierValue(barrierDistance);
        float perceptionValue = this.mBarrierDistanceStrategy.getBarrierValue(perceptionDistance);
        float barrierAvoidanceValue = this.mBarrierDistanceStrategy.getBarrierValue(barrierAvoidanceDistance);
        this.mPaint.setColor(this.mAvoidanceIndicatorColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        float upPerceptionArea = perceptionValue > barrierValue ? (barrierValue - barrierAvoidanceValue) * ratio : (perceptionValue - barrierAvoidanceValue) * ratio;
        if (upPerceptionArea > 0.0f) {
            int bottom;
            int top;
            if (upPerceptionArea > (float)restArea) {
                upPerceptionArea = restArea;
                restArea = 0;
            } else {
                restArea = (int)((float)restArea - upPerceptionArea);
            }
            if (orientation == -1) {
                top = -((int)upPerceptionArea);
                bottom = 0;
            } else {
                top = 0;
                bottom = (int)upPerceptionArea;
            }
            RECT.set(-this.mAvoidanceIndicatorWidth, top, 0, bottom);
            canvas.drawRect(RECT, this.mPaint);
            int dy = (int)upPerceptionArea * orientation;
            canvasOffsetY[0] = canvasOffsetY[0] + (float)dy;
            canvas.translate(0.0f, (float)dy);
        }
        return restArea;
    }

    private int drawBarrierIndicator(Canvas canvas, int orientation, int restArea, float ratio, float[] canvasOffsetY) {
        float barrierAvoidanceValue;
        float barrierDistance = orientation == -1 ? this.getUpwardBarrierDistance() : this.getDownVisionDistance();
        float barrierAvoidanceDistance = orientation == -1 ? this.mUserSetUpBarrierAvoidanceDistance : this.mUserSetDownBarrierAvoidanceDistance;
        float barrierValue = this.mBarrierDistanceStrategy.getBarrierValue(barrierDistance);
        float upBarrierArea = Math.min(barrierValue, barrierAvoidanceValue = this.mBarrierDistanceStrategy.getBarrierValue(barrierAvoidanceDistance)) * ratio;
        if (upBarrierArea > 0.0f) {
            int bottom;
            int top;
            this.mPaint.setColor(this.mBarrierIndicatorColor);
            if (upBarrierArea > (float)restArea) {
                upBarrierArea = restArea;
                restArea = 0;
            } else {
                restArea = (int)((float)restArea - upBarrierArea);
            }
            if (orientation == -1) {
                top = -((int)upBarrierArea);
                bottom = 0;
            } else {
                top = 0;
                bottom = (int)upBarrierArea;
            }
            RECT.set(-this.mAvoidanceIndicatorWidth, top, 0, bottom);
            canvas.drawRect(RECT, this.mPaint);
            int dy = (int)upBarrierArea * orientation;
            canvasOffsetY[0] = canvasOffsetY[0] + (float)dy;
            canvas.translate(0.0f, (float)dy);
        }
        return restArea;
    }

    private void drawBarrier(Canvas canvas, int orientation, float[] canvasOffsetY) {
        float canvasOffset = canvasOffsetY[0];
        Bitmap barrier = orientation == -1 ? this.mBarrierUp : this.mBarrierDown;
        if (barrier == null) {
            return;
        }
        float offsetX = this.isShowFramework() ? (float)(-this.mAvoidanceIndicatorWidth) : (float)(-this.mAvoidanceIndicatorWidth) / 2.0f - (float)barrier.getWidth() / 2.0f;
        float offsetY = orientation == -1 ? (float)(-barrier.getHeight()) : 0.0f;
        canvas.drawBitmap(barrier, offsetX, offsetY, this.mPaint);
        if (this.isShowFramework()) {
            this.drawPfdBarrierText(canvas, orientation, canvasOffset, barrier, offsetX);
        }
    }

    private void drawPfdBarrierText(Canvas canvas, int orientation, float canvasOffset, Bitmap barrier, float offsetX) {
        float baseline;
        float strokeWidth = this.mStrokeConfig.getStrokeThinWidth();
        this.mPaint.setStrokeWidth(strokeWidth);
        float textOffsetY = (FontUtils.getDigitalTextDrawHeight(this.mPaint) + this.mBarrierTextMargin) * (float)orientation;
        if (orientation == -1) {
            float top = Math.min(textOffsetY - canvasOffset, (float)(-barrier.getHeight()));
            baseline = FontUtils.getDigitalBaselineFromTop(this.mPaint, top) - this.mBarrierTextMargin;
        } else {
            float bottom = Math.max(textOffsetY - canvasOffset, (float)barrier.getHeight());
            baseline = FontUtils.getDigitalBaselineFromBottom(this.mPaint, bottom) + this.mBarrierTextMargin;
        }
        this.drawBarrierText(canvas, orientation, baseline, offsetX - this.mBarrierTextMargin);
    }

    @Override
    protected String getCurrentValueDisplayFormat(boolean shorthand) {
        return shorthand ? "%04.0f" : "%05.1f";
    }

    @Override
    protected String getAttributeUnit() {
        return UnitUtils.getUintStrByLength((UnitUtils.UnitType)(UnitUtils.isMetricUnits() ? UnitUtils.UnitType.METRIC : UnitUtils.UnitType.IMPERIAL));
    }

    @Override
    protected float getDisplayValue(float value) {
        return UnitUtils.getValueFromMetricByLength((float)value, (UnitUtils.UnitType)(UnitUtils.isMetricUnits() ? UnitUtils.UnitType.METRIC : UnitUtils.UnitType.IMPERIAL));
    }

    @Override
    protected int getIndicatorLineLength() {
        return this.mReturnToHomeIndicatorWidth;
    }

    private float getUpwardBarrierDistance() {
        if (this.mUpwardVisualEnable && this.mUpwardRadarEnable) {
            return Math.min(this.mUpwardRadarDistance, this.getUpVisionDistance());
        }
        if (this.mUpwardRadarEnable) {
            return this.mUpwardRadarDistance;
        }
        return this.getUpVisionDistance();
    }

    private float getUpVisionDistance() {
        return (float)this.mPerceptionObstacleData.getUpwardObstacleDistance() / 1000.0f;
    }

    private float getDownVisionDistance() {
        return (float)this.mPerceptionObstacleData.getDownwardObstacleDistance() / 1000.0f;
    }

    private static class PfdBarrierDistanceStrategy
    implements IBarrierDistanceStrategy {
        private PfdBarrierDistanceStrategy() {
        }

        @Override
        public float getBarrierValue(float distance) {
            Log.d((String)AttitudeDashBoard.TAG, (String)("PfdBarrierDistanceStrategy getBarrierValue=" + distance));
            return distance;
        }
    }

    private static class HsiBarrierDistanceStrategy
    implements IBarrierDistanceStrategy {
        private HsiBarrierDistanceStrategy() {
        }

        @Override
        public float getBarrierValue(float distance) {
            if (distance <= 0.0f) {
                return 0.0f;
            }
            if (distance <= 2.0f) {
                return distance / 2.0f;
            }
            if (distance <= 5.0f) {
                return (distance + 1.0f) / 3.0f;
            }
            return (float)((double)0.3045f + (double)1.0769f * Math.log(distance));
        }
    }

    static interface IBarrierDistanceStrategy {
        public float getBarrierValue(float var1);
    }
}

