/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.amap.annotations;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Polyline;
import dji.v5.ux.mapkit.amap.utils.AMapUtils;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import java.util.ArrayList;
import java.util.List;

public class APolyline
implements DJIPolyline {
    private Polyline mPolyline;
    private DJIPolylineOptions mDJIPolylineOptions;

    public APolyline(@NonNull Polyline polyline) {
        this.mPolyline = polyline;
    }

    public APolyline(Polyline polyline, DJIPolylineOptions options) {
        this.mPolyline = polyline;
        this.mDJIPolylineOptions = options;
    }

    @Override
    public void remove() {
        this.mPolyline.remove();
    }

    @Override
    public void setWidth(float width) {
        this.mPolyline.setWidth(width);
    }

    @Override
    public float getWidth() {
        return this.mPolyline.getWidth();
    }

    @Override
    public void setPoints(List<DJILatLng> points) {
        ArrayList<LatLng> aPoints = new ArrayList<LatLng>(points.size());
        for (DJILatLng latLng : points) {
            aPoints.add(AMapUtils.fromDJILatLng(latLng));
        }
        this.mPolyline.setPoints(aPoints);
    }

    @Override
    public List<DJILatLng> getPoints() {
        ArrayList<DJILatLng> djiPoints = new ArrayList<DJILatLng>(this.mPolyline.getPoints().size());
        for (LatLng latLng : this.mPolyline.getPoints()) {
            djiPoints.add(AMapUtils.fromLatLng(latLng));
        }
        return djiPoints;
    }

    @Override
    public void setZIndex(float zIndex) {
        this.mPolyline.setZIndex(zIndex);
    }

    @Override
    public float getZIndex() {
        return this.mPolyline.getZIndex();
    }

    @Override
    public void setColor(@ColorInt int color2) {
        this.mPolyline.setColor(color2);
    }

    @Override
    @ColorInt
    public int getColor() {
        return this.mPolyline.getColor();
    }

    public DJIPolylineOptions getOptions() {
        return this.mDJIPolylineOptions;
    }

    public void setOptions(DJIPolylineOptions options) {
        this.mDJIPolylineOptions = options;
        this.mPolyline.setOptions(AMapUtils.fromDJIPolylineOptions(options));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APolyline aPolyline = (APolyline)o;
        return this.mPolyline.equals((Object)aPolyline.mPolyline);
    }

    public int hashCode() {
        return this.mPolyline.hashCode();
    }
}

