/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.compass;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import dji.v5.ux.R;
import dji.v5.ux.core.extension.ViewExtensions;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ,2\u00020\u0001:\u0001,B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010+\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R(\u0010\u0018\u001a\u00020\r2\b\b\u0001\u0010\u0018\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010\u0013\u00a8\u0006-"}, d2={"Ldji/v5/ux/core/widget/compass/VisualCompassView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "paint", "Landroid/graphics/Paint;", "distance", "", "interval", "lineInterval", "getLineInterval", "()I", "setLineInterval", "(I)V", "lines", "numberOfLines", "getNumberOfLines", "setNumberOfLines", "strokeWidth", "getStrokeWidth", "()F", "setStrokeWidth", "(F)V", "color", "lineColor", "getLineColor", "setLineColor", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "findMod", "getVirtualColor", "mod", "drawDistance", "drawObstacleInfo", "setDistance", "Companion", "android-sdk-v5-uxsdk_debug"})
public final class VisualCompassView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint paint;
    private float distance;
    private int lineInterval;
    private int numberOfLines;
    @Px
    @FloatRange(from=1.0, to=4.0)
    private float strokeWidth;
    private int lineColor;
    public static final int MAX_LINE_WIDTH = 4;

    @JvmOverloads
    public VisualCompassView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint();
        this.distance = 400.0f;
        this.lineInterval = 100;
        this.numberOfLines = 4;
        this.strokeWidth = ViewExtensions.getDimension(this, R.dimen.uxsdk_line_width);
        this.lineColor = ViewExtensions.getColor(this, R.color.uxsdk_white_47_percent);
        this.init();
    }

    public /* synthetic */ VisualCompassView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getLineInterval() {
        return this.lineInterval;
    }

    public final void setLineInterval(int interval) {
        this.lineInterval = interval;
        this.postInvalidate();
    }

    public final int getNumberOfLines() {
        return this.numberOfLines;
    }

    public final void setNumberOfLines(int lines) {
        this.numberOfLines = lines;
        this.postInvalidate();
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(@FloatRange(from=1.0, to=4.0) float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.postInvalidate();
    }

    @ColorInt
    public final int getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(int color2) {
        this.lineColor = color2;
        this.postInvalidate();
    }

    private final void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.paint.setAntiAlias(true);
        this.paint.setColor(ViewExtensions.getColor(this, R.color.uxsdk_white_20_percent));
        this.paint.setStyle(Paint.Style.STROKE);
        if (this.strokeWidth > 4.0f) {
            this.setStrokeWidth(4.0f);
        }
        this.paint.setStrokeWidth(this.strokeWidth);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawObstacleInfo(canvas);
    }

    private final float findMod(float distance) {
        float radarRadius = (float)this.lineInterval * (float)this.numberOfLines;
        float result = 0.0f;
        if (distance > radarRadius) {
            result = (float)(Math.log((double)distance / (double)(this.lineInterval * this.numberOfLines)) / Math.log(2.0));
            result -= (float)((int)result);
        }
        return result;
    }

    private final int getVirtualColor(float mod) {
        int color2 = this.lineColor;
        int alpha = Color.alpha((int)color2);
        alpha = (int)((float)alpha * (1.0f - mod));
        color2 = Color.argb((int)alpha, (int)Color.red((int)this.lineColor), (int)Color.green((int)this.lineColor), (int)Color.blue((int)this.lineColor));
        return color2;
    }

    private final void drawDistance(Canvas canvas) {
        float mod = this.findMod(this.distance);
        int width = this.getWidth() - 2;
        float radius = (float)width * 0.5f;
        float center = radius + 1.0f;
        float unitRadius = radius / (4.0f * (mod + 1.0f));
        int vColor = this.getVirtualColor(mod);
        float dRadius = 0.0f;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.lineColor);
        canvas.drawCircle(center, center, radius, this.paint);
        int i = 1;
        while ((float)i * unitRadius < radius) {
            if (i % 2 == 0) {
                this.paint.setColor(this.lineColor);
            } else {
                this.paint.setColor(vColor);
            }
            dRadius = (float)i * unitRadius;
            canvas.drawCircle(center, center, dRadius, this.paint);
            ++i;
        }
    }

    private final void drawObstacleInfo(Canvas canvas) {
        this.drawDistance(canvas);
    }

    public final void setDistance(float distance) {
        if (!(this.distance == distance)) {
            this.distance = distance;
            this.postInvalidate();
        }
    }

    @JvmOverloads
    public VisualCompassView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VisualCompassView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/widget/compass/VisualCompassView$Companion;", "", "<init>", "()V", "MAX_LINE_WIDTH", "", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

