/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.ui;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.ui.AppFragment;
import dji.v5.ux.core.ui.setting.ui.Loader;

public abstract class MenuFragment
extends AppFragment {
    private Loader initLoader;

    protected abstract String getPreferencesTitle();

    protected static void addFragment(FragmentManager fm, MenuFragment menuFragment) {
        MenuFragment.addFragment(fm, menuFragment, false);
    }

    protected static void addFragment(FragmentManager fm, MenuFragment menuFragment, boolean isAnimated) {
        if (fm == null || menuFragment == null) {
            return;
        }
        FragmentTransaction transaction = fm.beginTransaction();
        if (isAnimated) {
            transaction.setCustomAnimations(R.anim.uxsdk_push_right_in, R.anim.uxsdk_fade_out, R.anim.uxsdk_fade_in, R.anim.uxsdk_push_right_out);
        }
        transaction.replace(R.id.fragment_content, (Fragment)menuFragment);
        transaction.addToBackStack(menuFragment.getPreferencesTitle());
        transaction.commitAllowingStateLoss();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.initLoader = Loader.createLoader();
        this.initLoader.setListener(new Loader.LoaderListener(){

            @Override
            public void onCreateView() {
                MenuFragment.this.onPrepareView();
            }

            @Override
            public void onCreateData() {
                MenuFragment.this.onPrepareDataInBackground();
            }

            @Override
            public void onRefreshView() {
                MenuFragment.this.onRefreshDataOnView();
            }
        }).start();
        return view;
    }

    @UiThread
    protected void onPrepareView() {
    }

    @WorkerThread
    protected void onPrepareDataInBackground() {
    }

    @UiThread
    protected void onRefreshDataOnView() {
    }

    protected static void popBackFragmentStack(FragmentManager fm) {
        if (fm.getBackStackEntryCount() > 1) {
            fm.popBackStackImmediate();
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (this.initLoader != null) {
            this.initLoader.cancel();
            this.initLoader = null;
        }
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }
}

