/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.popover;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.extension.ContextExtKt;
import dji.v5.ux.core.popover.DispatchViewKeyEventToActivityListener;
import dji.v5.ux.core.popover.PopoverView;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u00045678B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010(\u001a\u00020\u000fH\u0002J\u0006\u0010)\u001a\u00020\u001aJ\u001e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011J\b\u0010-\u001a\u0004\u0018\u00010.J\b\u0010/\u001a\u00020\u001cH\u0002J\u0006\u00100\u001a\u00020\u001aJ\u0006\u00101\u001a\u00020\u0016J\u000e\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u0014J\u0006\u00104\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldji/v5/ux/core/popover/Popover;", "", "builder", "Ldji/v5/ux/core/popover/Popover$Builder;", "<init>", "(Ldji/v5/ux/core/popover/Popover$Builder;)V", "getBuilder", "()Ldji/v5/ux/core/popover/Popover$Builder;", "tag", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "popupWindow", "Landroid/widget/PopupWindow;", "popoverView", "Ldji/v5/ux/core/popover/PopoverView;", "width", "", "height", "mDismissListener", "Landroid/widget/PopupWindow$OnDismissListener;", "isTextContent", "", "onPopupWindowDismiss", "requestLayoutRunnable", "Lkotlin/Function0;", "", "getShowLocation", "", "anchorViewLocationInScreen", "popoverWidth", "popoverHeight", "anchorWidth", "anchorHeight", "adjustPopupWindowLayoutParams", "location", "screenWidth", "screenHeight", "configShadow", "configPopupWindow", "createPopoverView", "show", "gravity", "x", "y", "getContentView", "Landroid/view/View;", "initPopover", "dismiss", "isShowing", "setOnDismissListener", "dismissListener", "requestLayout", "Align", "Position", "Builder", "DropShadow", "android-sdk-v5-uxsdk_debug"})
public final class Popover {
    @NotNull
    private final Builder builder;
    private final String tag;
    @NotNull
    private PopupWindow popupWindow;
    private PopoverView popoverView;
    private int width;
    private int height;
    @Nullable
    private PopupWindow.OnDismissListener mDismissListener;
    private boolean isTextContent;
    @NotNull
    private final PopupWindow.OnDismissListener onPopupWindowDismiss;
    @NotNull
    private final Function0<Unit> requestLayoutRunnable;

    public Popover(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.tag = LogUtils.getTag((Object)this);
        this.popupWindow = new PopupWindow();
        this.onPopupWindowDismiss = () -> Popover.onPopupWindowDismiss$lambda$1(this);
        this.requestLayoutRunnable = () -> Popover.requestLayoutRunnable$lambda$2(this);
        this.popupWindow.setOnDismissListener(this.onPopupWindowDismiss);
    }

    @NotNull
    public final Builder getBuilder() {
        return this.builder;
    }

    private final int[] getShowLocation(int[] anchorViewLocationInScreen, int popoverWidth, int popoverHeight, int anchorWidth, int anchorHeight, PopoverView popoverView) {
        int[] location = new int[2];
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[this.builder.getPosition().ordinal()]) {
            case 1: {
                location[0] = anchorViewLocationInScreen[0] - popoverWidth + popoverView.getPaddingLeft();
                switch (WhenMappings.$EnumSwitchMapping$0[this.builder.getAlign().ordinal()]) {
                    case 1: {
                        location[1] = anchorViewLocationInScreen[1] - popoverView.getPaddingTop();
                        break block0;
                    }
                    case 2: {
                        location[1] = anchorViewLocationInScreen[1] + anchorHeight - popoverHeight + popoverView.getPaddingTop();
                        break block0;
                    }
                }
                location[1] = anchorViewLocationInScreen[1] + anchorHeight / 2 - popoverHeight / 2;
                break;
            }
            case 2: {
                location[0] = anchorViewLocationInScreen[0] + anchorWidth - popoverView.getPaddingLeft();
                switch (WhenMappings.$EnumSwitchMapping$0[this.builder.getAlign().ordinal()]) {
                    case 1: {
                        location[1] = anchorViewLocationInScreen[1] - popoverView.getPaddingTop();
                        break block0;
                    }
                    case 2: {
                        location[1] = anchorViewLocationInScreen[1] + anchorHeight - popoverHeight + popoverView.getPaddingTop();
                        break block0;
                    }
                }
                location[1] = anchorViewLocationInScreen[1] + anchorHeight / 2 - popoverHeight / 2;
                break;
            }
            case 3: {
                location[1] = anchorViewLocationInScreen[1] - popoverHeight + popoverView.getPaddingTop();
                switch (WhenMappings.$EnumSwitchMapping$0[this.builder.getAlign().ordinal()]) {
                    case 3: {
                        location[0] = anchorViewLocationInScreen[0] - popoverView.getPaddingLeft();
                        break block0;
                    }
                    case 4: {
                        location[0] = anchorViewLocationInScreen[0] + anchorWidth - popoverWidth + popoverView.getPaddingLeft();
                        break block0;
                    }
                }
                location[0] = anchorViewLocationInScreen[0] + anchorWidth / 2 - popoverWidth / 2;
                break;
            }
            case 4: {
                location[1] = anchorViewLocationInScreen[1] + anchorHeight - popoverView.getPaddingTop();
                switch (WhenMappings.$EnumSwitchMapping$0[this.builder.getAlign().ordinal()]) {
                    case 3: {
                        location[0] = anchorViewLocationInScreen[0] - popoverView.getPaddingLeft();
                        break block0;
                    }
                    case 4: {
                        location[0] = anchorViewLocationInScreen[0] + anchorWidth - popoverWidth + popoverView.getPaddingLeft();
                        break block0;
                    }
                }
                location[0] = anchorViewLocationInScreen[0] + anchorWidth / 2 - popoverWidth / 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return location;
    }

    private final void adjustPopupWindowLayoutParams(int[] location, int popoverWidth, int popoverHeight, int screenWidth, int screenHeight, PopoverView popoverView) {
        if (location[0] + popoverWidth - popoverView.getPaddingLeft() > screenWidth - this.builder.getRightScreenMargin()) {
            location[0] = screenWidth - popoverWidth + popoverView.getPaddingLeft() - this.builder.getRightScreenMargin();
        }
        if (location[0] < this.builder.getLeftScreenMargin()) {
            location[0] = -popoverView.getPaddingLeft() + this.builder.getLeftScreenMargin();
        }
        if (this.builder.getPosition() != Position.TOP && this.builder.getPosition() != Position.BOTTOM) {
            if (location[1] + popoverHeight > screenHeight - this.builder.getBottomScreenMargin()) {
                location[1] = screenHeight - popoverHeight + popoverView.getPaddingBottom() - this.builder.getBottomScreenMargin();
            }
            if (location[1] < this.builder.getTopScreenMargin()) {
                location[1] = -popoverView.getPaddingTop() + this.builder.getTopScreenMargin();
            }
        } else if (this.builder.getPosition() == Position.BOTTOM && location[1] + popoverHeight > screenHeight - this.builder.getBottomScreenMargin()) {
            this.popupWindow.setHeight(screenHeight - location[1] - this.builder.getBottomScreenMargin());
        } else if (this.builder.getPosition() == Position.TOP && location[1] < this.builder.getTopScreenMargin()) {
            location[1] = -popoverView.getPaddingTop() + this.builder.getTopScreenMargin();
            this.popupWindow.setHeight((int)(this.builder.getAnchor().getY() - (float)this.builder.getTopScreenMargin()));
        }
    }

    private final void configShadow(PopoverView popoverView) {
        if (this.builder.getEnableShadow()) {
            popoverView.setDropShadow(this.builder.getDropShadow().getBlurRadius(), this.builder.getDropShadow().getDx(), this.builder.getDropShadow().getDy(), this.builder.getDropShadow().getColor());
        }
    }

    private final int[] configPopupWindow(PopoverView popoverView) {
        this.popupWindow.setContentView((View)popoverView);
        this.popupWindow.setWidth(-2);
        this.popupWindow.setHeight(-2);
        this.popupWindow.setFocusable(this.builder.getFocusable());
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setAnimationStyle(16973826);
        this.popupWindow.setClippingEnabled(false);
        this.mDismissListener = this.builder.getDismissListener();
        popoverView.setClickable(true);
        popoverView.setOnClickListener(arg_0 -> Popover.configPopupWindow$lambda$3(this, arg_0));
        int[] anchorViewLocationInScreen = new int[2];
        this.builder.getAnchor().getLocationOnScreen(anchorViewLocationInScreen);
        this.popupWindow.getContentView().measure(0, 0);
        int popoverWidth = this.popupWindow.getContentView().getMeasuredWidth();
        int popoverHeight = this.popupWindow.getContentView().getMeasuredHeight();
        if (this.isTextContent) {
            this.popupWindow.setWidth(popoverWidth);
            this.popupWindow.setHeight(popoverHeight);
        }
        int anchorWidth = this.builder.getAnchor().getWidth();
        int anchorHeight = this.builder.getAnchor().getHeight();
        Context context = this.builder.getAnchor().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int screenWidth = ContextExtKt.getLandScreenSize(context).getWidth();
        Context context2 = this.builder.getAnchor().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        int screenHeight = ContextExtKt.getLandScreenSize(context2).getHeight();
        int[] popupWindowLocation = this.getShowLocation(anchorViewLocationInScreen, popoverWidth, popoverHeight, anchorWidth, anchorHeight, popoverView);
        this.adjustPopupWindowLayoutParams(popupWindowLocation, popoverWidth, popoverHeight, screenWidth, screenHeight, popoverView);
        float arrowPosition = switch (WhenMappings.$EnumSwitchMapping$1[this.builder.getPosition().ordinal()]) {
            case 3, 4 -> (float)(anchorViewLocationInScreen[0] + anchorWidth / 2 - popupWindowLocation[0] - popoverView.getPaddingLeft()) / (float)(popoverWidth - popoverView.getPaddingLeft() * 2);
            default -> (float)(anchorViewLocationInScreen[1] + anchorHeight / 2 - popupWindowLocation[1] - popoverView.getPaddingTop()) / (float)(popoverHeight - popoverView.getPaddingTop() * 2);
        };
        popoverView.setArrowOffset(arrowPosition);
        return popupWindowLocation;
    }

    private final PopoverView createPopoverView() {
        this.isTextContent = false;
        PopoverView.ArrowPosition arrowPosition = switch (WhenMappings.$EnumSwitchMapping$1[this.builder.getPosition().ordinal()]) {
            case 1 -> PopoverView.ArrowPosition.RIGHT;
            case 2 -> PopoverView.ArrowPosition.LEFT;
            case 3 -> PopoverView.ArrowPosition.BOTTOM;
            case 4 -> PopoverView.ArrowPosition.TOP;
            default -> throw new NoWhenBranchMatchedException();
        };
        Context context = this.builder.getAnchor().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = context;
        int n = this.builder.getBackgroundColor();
        int n2 = this.builder.getArrowColor();
        boolean bl = this.builder.getShowArrow();
        float f = this.builder.getAnchor().getResources().getDimension(R.dimen.uxsdk_4_dp);
        PopoverView popoverView = new PopoverView(context2, n, n2, f, bl, 0.0f, arrowPosition, 32, null);
        if (this.builder.getCustomView() != null) {
            View view = this.builder.getCustomView();
            Intrinsics.checkNotNull((Object)view);
            popoverView.setContentView(view, this.builder.getLayoutParams());
        } else if (this.builder.getCustomLayoutRes() != 0) {
            View view = LayoutInflater.from((Context)this.builder.getAnchor().getContext()).inflate(this.builder.getCustomLayoutRes(), (ViewGroup)popoverView, false);
            Intrinsics.checkNotNull((Object)view);
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            Intrinsics.checkNotNullExpressionValue((Object)layoutParams, (String)"getLayoutParams(...)");
            popoverView.setContentView(view, layoutParams);
        } else if (this.builder.getContent() != null) {
            this.isTextContent = true;
            TextView textView = new TextView(this.builder.getAnchor().getContext());
            textView.setText(this.builder.getContent());
            textView.setTextColor(this.builder.getAnchor().getResources().getColor(this.builder.getTextColor()));
            textView.setTextSize(1, 12.0f);
            textView.setTypeface(textView.getTypeface(), 1);
            int padding = (int)this.builder.getAnchor().getResources().getDimension(R.dimen.uxsdk_8_dp);
            textView.setPadding(padding, padding, padding, padding);
            popoverView.setContentView((View)textView, this.builder.getLayoutParams());
        }
        return popoverView;
    }

    public final void show() {
        int[] popupWindowLocation = this.initPopover();
        this.popupWindow.showAtLocation(this.builder.getAnchor(), 0, popupWindowLocation[0] + this.builder.getXOffset(), popupWindowLocation[1] + this.builder.getYOffset());
    }

    public final void show(int gravity, int x, int y) {
        this.initPopover();
        this.popupWindow.showAtLocation(this.builder.getAnchor(), gravity, x, y);
    }

    @Nullable
    public final View getContentView() {
        return this.popupWindow.getContentView();
    }

    private final int[] initPopover() {
        int[] popupWindowLocation;
        block6: {
            this.popoverView = this.createPopoverView();
            PopoverView popoverView = this.popoverView;
            if (popoverView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView = null;
            }
            this.configShadow(popoverView);
            PopoverView popoverView2 = this.popoverView;
            if (popoverView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView2 = null;
            }
            popupWindowLocation = this.configPopupWindow(popoverView2);
            PopoverView popoverView3 = this.popoverView;
            if (popoverView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView3 = null;
            }
            this.width = popoverView3.getMeasuredWidth();
            PopoverView popoverView4 = this.popoverView;
            if (popoverView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView4 = null;
            }
            this.height = popoverView4.getMeasuredHeight();
            PopoverView popoverView5 = this.popoverView;
            if (popoverView5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView5 = null;
            }
            popoverView5.addOnLayoutChangeListener((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> Popover.initPopover$lambda$4(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8));
            if (!this.popupWindow.isFocusable()) break block6;
            View view = this.popupWindow.getContentView();
            if (view != null) {
                View it = view;
                boolean bl = false;
                it.setFocusable(true);
                it.setFocusableInTouchMode(true);
                it.requestFocus();
                it.setOnKeyListener((View.OnKeyListener)new DispatchViewKeyEventToActivityListener());
            }
        }
        return popupWindowLocation;
    }

    public final void dismiss() {
        this.popupWindow.dismiss();
    }

    public final boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public final void setOnDismissListener(@NotNull PopupWindow.OnDismissListener dismissListener) {
        Intrinsics.checkNotNullParameter((Object)dismissListener, (String)"dismissListener");
        this.mDismissListener = dismissListener;
    }

    public final void requestLayout() {
        PopoverView popoverView = this.popoverView;
        if (popoverView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
            popoverView = null;
        }
        popoverView.post(() -> Popover.requestLayout$lambda$6(this.requestLayoutRunnable));
    }

    private static final void onPopupWindowDismiss$lambda$1$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void onPopupWindowDismiss$lambda$1(Popover this$0) {
        block1: {
            PopoverView popoverView = this$0.popoverView;
            if (popoverView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView = null;
            }
            popoverView.removeCallbacks(() -> Popover.onPopupWindowDismiss$lambda$1$lambda$0(this$0.requestLayoutRunnable));
            PopupWindow.OnDismissListener onDismissListener = this$0.mDismissListener;
            if (onDismissListener == null) break block1;
            onDismissListener.onDismiss();
        }
    }

    private static final Unit requestLayoutRunnable$lambda$2(Popover this$0) {
        if (!this$0.isTextContent) {
            int n;
            int n2;
            PopoverView popoverView = this$0.popoverView;
            if (popoverView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView = null;
            }
            int[] newLocation = this$0.configPopupWindow(popoverView);
            int n3 = this$0.popupWindow.getContentView().getRootView().getHeight();
            PopoverView popoverView2 = this$0.popoverView;
            if (popoverView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView2 = null;
            }
            if (n3 > popoverView2.getMeasuredHeight()) {
                PopoverView popoverView3 = this$0.popoverView;
                if (popoverView3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                    popoverView3 = null;
                }
                n2 = popoverView3.getMeasuredHeight();
            } else {
                n2 = this$0.popupWindow.getHeight();
            }
            int height = n2;
            int n4 = this$0.popupWindow.getContentView().getRootView().getLayoutParams().width;
            PopoverView popoverView4 = this$0.popoverView;
            if (popoverView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                popoverView4 = null;
            }
            if (n4 > popoverView4.getMeasuredWidth()) {
                PopoverView popoverView5 = this$0.popoverView;
                if (popoverView5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"popoverView");
                    popoverView5 = null;
                }
                n = popoverView5.getMeasuredWidth();
            } else {
                n = this$0.popupWindow.getWidth();
            }
            int width = n;
            this$0.popupWindow.update(newLocation[0] + this$0.builder.getXOffset(), newLocation[1] + this$0.builder.getYOffset(), width, height);
        }
        return Unit.INSTANCE;
    }

    private static final void configPopupWindow$lambda$3(Popover this$0, View it) {
        this$0.dismiss();
    }

    private static final void initPopover$lambda$4(Popover this$0, View view, int left, int top, int right, int bottom, int n, int n2, int n3, int n4) {
        int newWidth = right - left;
        int newHeight = bottom - top;
        if (newWidth != this$0.width || newHeight != this$0.height) {
            this$0.width = newWidth;
            this$0.height = newHeight;
            this$0.requestLayout();
        }
    }

    private static final void requestLayout$lambda$6(Function0 $tmp0) {
        $tmp0.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ldji/v5/ux/core/popover/Popover$Align;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "CENTER", "TOP", "BOTTOM", "android-sdk-v5-uxsdk_debug"})
    public static final class Align
    extends Enum<Align> {
        public static final /* enum */ Align LEFT = new Align();
        public static final /* enum */ Align RIGHT = new Align();
        public static final /* enum */ Align CENTER = new Align();
        public static final /* enum */ Align TOP = new Align();
        public static final /* enum */ Align BOTTOM = new Align();
        private static final /* synthetic */ Align[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Align[] values() {
            return (Align[])$VALUES.clone();
        }

        public static Align valueOf(String value) {
            return Enum.valueOf(Align.class, value);
        }

        @NotNull
        public static EnumEntries<Align> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = alignArray = new Align[]{Align.LEFT, Align.RIGHT, Align.CENTER, Align.TOP, Align.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010]\u001a\u00020\u0013J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010^\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u000f\u001a\u00020\u00002\b\b\u0001\u0010_\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u000e\u00100\u001a\u00020\u00002\u0006\u00100\u001a\u00020+J\u000e\u00103\u001a\u00020\u00002\u0006\u00103\u001a\u00020+J\u000e\u00106\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0013J\u000e\u00109\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u000e\u0010c\u001a\u00020\u00002\u0006\u0010?\u001a\u00020@J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0013J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0013J\u000e\u0010d\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0013J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0013J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0013J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0013J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u0013J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u0013J\u0006\u0010g\u001a\u00020hJ\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\u0005R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\u001a\u00103\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010-\"\u0004\b5\u0010/R\u001a\u00106\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0015\"\u0004\b8\u0010\u0017R\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001c\u0010?\u001a\u0004\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0015\"\u0004\bG\u0010\u0017R\u001a\u0010H\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0015\"\u0004\bJ\u0010\u0017R\u001a\u0010K\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u0015\"\u0004\bM\u0010\u0017R\u001a\u0010N\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\u0015\"\u0004\bP\u0010\u0017R\u001a\u0010Q\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u0015\"\u0004\bS\u0010\u0017R\u001a\u0010T\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010\u0015\"\u0004\bV\u0010\u0017R\u001a\u0010W\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\u0015\"\u0004\bY\u0010\u0017R\u001a\u0010Z\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\u0015\"\u0004\b\\\u0010\u0017\u00a8\u0006i"}, d2={"Ldji/v5/ux/core/popover/Popover$Builder;", "", "anchor", "Landroid/view/View;", "<init>", "(Landroid/view/View;)V", "getAnchor", "()Landroid/view/View;", "setAnchor", "content", "", "getContent", "()Ljava/lang/CharSequence;", "setContent", "(Ljava/lang/CharSequence;)V", "customView", "getCustomView", "setCustomView", "customLayoutRes", "", "getCustomLayoutRes", "()I", "setCustomLayoutRes", "(I)V", "layoutParams", "Landroid/view/ViewGroup$LayoutParams;", "getLayoutParams", "()Landroid/view/ViewGroup$LayoutParams;", "setLayoutParams", "(Landroid/view/ViewGroup$LayoutParams;)V", "align", "Ldji/v5/ux/core/popover/Popover$Align;", "getAlign", "()Ldji/v5/ux/core/popover/Popover$Align;", "setAlign", "(Ldji/v5/ux/core/popover/Popover$Align;)V", "position", "Ldji/v5/ux/core/popover/Popover$Position;", "getPosition", "()Ldji/v5/ux/core/popover/Popover$Position;", "setPosition", "(Ldji/v5/ux/core/popover/Popover$Position;)V", "enableShadow", "", "getEnableShadow", "()Z", "setEnableShadow", "(Z)V", "showArrow", "getShowArrow", "setShowArrow", "focusable", "getFocusable", "setFocusable", "backgroundColor", "getBackgroundColor", "setBackgroundColor", "dropShadow", "Ldji/v5/ux/core/popover/Popover$DropShadow;", "getDropShadow", "()Ldji/v5/ux/core/popover/Popover$DropShadow;", "setDropShadow", "(Ldji/v5/ux/core/popover/Popover$DropShadow;)V", "dismissListener", "Landroid/widget/PopupWindow$OnDismissListener;", "getDismissListener", "()Landroid/widget/PopupWindow$OnDismissListener;", "setDismissListener", "(Landroid/widget/PopupWindow$OnDismissListener;)V", "xOffset", "getXOffset", "setXOffset", "yOffset", "getYOffset", "setYOffset", "leftScreenMargin", "getLeftScreenMargin", "setLeftScreenMargin", "rightScreenMargin", "getRightScreenMargin", "setRightScreenMargin", "topScreenMargin", "getTopScreenMargin", "setTopScreenMargin", "bottomScreenMargin", "getBottomScreenMargin", "setBottomScreenMargin", "arrowColor", "getArrowColor", "setArrowColor", "textColor", "getTextColor", "setTextColor", "contentRes", "view", "layoutRes", "size", "width", "height", "onDismiss", "allScreenMargin", "margin", "color", "build", "Ldji/v5/ux/core/popover/Popover;", "android-sdk-v5-uxsdk_debug"})
    public static final class Builder {
        @NotNull
        private View anchor;
        @Nullable
        private CharSequence content;
        @Nullable
        private View customView;
        private int customLayoutRes;
        @NotNull
        private ViewGroup.LayoutParams layoutParams;
        @NotNull
        private Align align;
        @NotNull
        private Position position;
        private boolean enableShadow;
        private boolean showArrow;
        private boolean focusable;
        private int backgroundColor;
        @NotNull
        private DropShadow dropShadow;
        @Nullable
        private PopupWindow.OnDismissListener dismissListener;
        private int xOffset;
        private int yOffset;
        private int leftScreenMargin;
        private int rightScreenMargin;
        private int topScreenMargin;
        private int bottomScreenMargin;
        private int arrowColor;
        private int textColor;

        public Builder(@NotNull View anchor) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            this.anchor = anchor;
            this.layoutParams = new ViewGroup.LayoutParams(-2, -2);
            this.align = Align.CENTER;
            this.position = Position.BOTTOM;
            this.enableShadow = true;
            this.showArrow = true;
            this.focusable = true;
            this.arrowColor = this.backgroundColor = Color.parseColor((String)"#FFCC00");
            this.textColor = R.color.uxsdk_black;
            this.dropShadow = new DropShadow(this.anchor.getResources().getColor(R.color.uxsdk_black_20_percent), 0.0f, this.anchor.getResources().getDimension(R.dimen.uxsdk_4_dp), this.anchor.getResources().getDimension(R.dimen.uxsdk_16_dp));
        }

        @NotNull
        public final View getAnchor() {
            return this.anchor;
        }

        public final void setAnchor(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.anchor = view;
        }

        @Nullable
        public final CharSequence getContent() {
            return this.content;
        }

        public final void setContent(@Nullable CharSequence charSequence) {
            this.content = charSequence;
        }

        @Nullable
        public final View getCustomView() {
            return this.customView;
        }

        public final void setCustomView(@Nullable View view) {
            this.customView = view;
        }

        public final int getCustomLayoutRes() {
            return this.customLayoutRes;
        }

        public final void setCustomLayoutRes(int n) {
            this.customLayoutRes = n;
        }

        @NotNull
        public final ViewGroup.LayoutParams getLayoutParams() {
            return this.layoutParams;
        }

        public final void setLayoutParams(@NotNull ViewGroup.LayoutParams layoutParams) {
            Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"<set-?>");
            this.layoutParams = layoutParams;
        }

        @NotNull
        public final Align getAlign() {
            return this.align;
        }

        public final void setAlign(@NotNull Align align) {
            Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"<set-?>");
            this.align = align;
        }

        @NotNull
        public final Position getPosition() {
            return this.position;
        }

        public final void setPosition(@NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"<set-?>");
            this.position = position;
        }

        public final boolean getEnableShadow() {
            return this.enableShadow;
        }

        public final void setEnableShadow(boolean bl) {
            this.enableShadow = bl;
        }

        public final boolean getShowArrow() {
            return this.showArrow;
        }

        public final void setShowArrow(boolean bl) {
            this.showArrow = bl;
        }

        public final boolean getFocusable() {
            return this.focusable;
        }

        public final void setFocusable(boolean bl) {
            this.focusable = bl;
        }

        public final int getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(int n) {
            this.backgroundColor = n;
        }

        @NotNull
        public final DropShadow getDropShadow() {
            return this.dropShadow;
        }

        public final void setDropShadow(@NotNull DropShadow dropShadow) {
            Intrinsics.checkNotNullParameter((Object)dropShadow, (String)"<set-?>");
            this.dropShadow = dropShadow;
        }

        @Nullable
        public final PopupWindow.OnDismissListener getDismissListener() {
            return this.dismissListener;
        }

        public final void setDismissListener(@Nullable PopupWindow.OnDismissListener onDismissListener) {
            this.dismissListener = onDismissListener;
        }

        public final int getXOffset() {
            return this.xOffset;
        }

        public final void setXOffset(int n) {
            this.xOffset = n;
        }

        public final int getYOffset() {
            return this.yOffset;
        }

        public final void setYOffset(int n) {
            this.yOffset = n;
        }

        public final int getLeftScreenMargin() {
            return this.leftScreenMargin;
        }

        public final void setLeftScreenMargin(int n) {
            this.leftScreenMargin = n;
        }

        public final int getRightScreenMargin() {
            return this.rightScreenMargin;
        }

        public final void setRightScreenMargin(int n) {
            this.rightScreenMargin = n;
        }

        public final int getTopScreenMargin() {
            return this.topScreenMargin;
        }

        public final void setTopScreenMargin(int n) {
            this.topScreenMargin = n;
        }

        public final int getBottomScreenMargin() {
            return this.bottomScreenMargin;
        }

        public final void setBottomScreenMargin(int n) {
            this.bottomScreenMargin = n;
        }

        public final int getArrowColor() {
            return this.arrowColor;
        }

        public final void setArrowColor(int n) {
            this.arrowColor = n;
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(int n) {
            this.textColor = n;
        }

        @NotNull
        public final Builder content(@Nullable CharSequence content) {
            this.content = content;
            return this;
        }

        @NotNull
        public final Builder content(@StringRes int contentRes) {
            this.content = this.anchor.getContext().getString(contentRes);
            return this;
        }

        @NotNull
        public final Builder customView(@Nullable View view) {
            this.customView = view;
            return this;
        }

        @NotNull
        public final Builder customView(@LayoutRes int layoutRes) {
            this.customLayoutRes = layoutRes;
            return this;
        }

        @NotNull
        public final Builder layoutParams(@NotNull ViewGroup.LayoutParams layoutParams) {
            Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"layoutParams");
            this.layoutParams = layoutParams;
            return this;
        }

        @NotNull
        public final Builder size(int width, int height) {
            this.layoutParams = new ViewGroup.LayoutParams(width, height);
            return this;
        }

        @NotNull
        public final Builder align(@NotNull Align align) {
            Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
            this.align = align;
            return this;
        }

        @NotNull
        public final Builder position(@NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
            this.position = position;
            return this;
        }

        @NotNull
        public final Builder enableShadow(boolean enableShadow) {
            this.enableShadow = enableShadow;
            return this;
        }

        @NotNull
        public final Builder showArrow(boolean showArrow) {
            this.showArrow = showArrow;
            return this;
        }

        @NotNull
        public final Builder focusable(boolean focusable) {
            this.focusable = focusable;
            return this;
        }

        @NotNull
        public final Builder backgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @NotNull
        public final Builder dropShadow(@NotNull DropShadow dropShadow) {
            Intrinsics.checkNotNullParameter((Object)dropShadow, (String)"dropShadow");
            this.dropShadow = dropShadow;
            return this;
        }

        @NotNull
        public final Builder onDismiss(@NotNull PopupWindow.OnDismissListener dismissListener) {
            Intrinsics.checkNotNullParameter((Object)dismissListener, (String)"dismissListener");
            this.dismissListener = dismissListener;
            return this;
        }

        @NotNull
        public final Builder xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        @NotNull
        public final Builder yOffset(int yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        @NotNull
        public final Builder allScreenMargin(int margin) {
            this.topScreenMargin = margin;
            this.rightScreenMargin = margin;
            this.bottomScreenMargin = margin;
            this.leftScreenMargin = margin;
            return this;
        }

        @NotNull
        public final Builder rightScreenMargin(int margin) {
            this.rightScreenMargin = margin;
            return this;
        }

        @NotNull
        public final Builder bottomScreenMargin(int margin) {
            this.bottomScreenMargin = margin;
            return this;
        }

        @NotNull
        public final Builder leftScreenMargin(int margin) {
            this.leftScreenMargin = margin;
            return this;
        }

        @NotNull
        public final Builder topScreenMargin(int margin) {
            this.topScreenMargin = margin;
            return this;
        }

        @NotNull
        public final Builder arrowColor(int color2) {
            this.arrowColor = color2;
            return this;
        }

        @NotNull
        public final Popover build() {
            return new Popover(this);
        }

        @NotNull
        public final Builder textColor(int color2) {
            this.textColor = color2;
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ldji/v5/ux/core/popover/Popover$DropShadow;", "", "color", "", "dx", "", "dy", "blurRadius", "<init>", "(IFFF)V", "getColor", "()I", "setColor", "(I)V", "getDx", "()F", "setDx", "(F)V", "getDy", "setDy", "getBlurRadius", "setBlurRadius", "android-sdk-v5-uxsdk_debug"})
    public static final class DropShadow {
        private int color;
        private float dx;
        private float dy;
        private float blurRadius;

        public DropShadow(int color2, float dx, float dy, float blurRadius) {
            this.color = color2;
            this.dx = dx;
            this.dy = dy;
            this.blurRadius = blurRadius;
        }

        public /* synthetic */ DropShadow(int n, float f, float f2, float f3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                f = 0.0f;
            }
            if ((n2 & 4) != 0) {
                f2 = 0.0f;
            }
            if ((n2 & 8) != 0) {
                f3 = 0.0f;
            }
            this(n, f, f2, f3);
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final float getDx() {
            return this.dx;
        }

        public final void setDx(float f) {
            this.dx = f;
        }

        public final float getDy() {
            return this.dy;
        }

        public final void setDy(float f) {
            this.dy = f;
        }

        public final float getBlurRadius() {
            return this.blurRadius;
        }

        public final void setBlurRadius(float f) {
            this.blurRadius = f;
        }

        public DropShadow() {
            this(0, 0.0f, 0.0f, 0.0f, 15, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/popover/Popover$Position;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "TOP", "BOTTOM", "android-sdk-v5-uxsdk_debug"})
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position LEFT = new Position();
        public static final /* enum */ Position RIGHT = new Position();
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.LEFT, Position.RIGHT, Position.TOP, Position.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Align.values().length];
            try {
                nArray[Align.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Position.values().length];
            try {
                nArray[Position.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

