/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.panel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.Guideline;
import dji.v5.ux.R;
import dji.v5.ux.core.base.WidgetSizeDescription;
import dji.v5.ux.core.base.panel.PanelItem;
import dji.v5.ux.core.base.panel.PanelWidget;
import dji.v5.ux.core.base.panel.PanelWidgetConfiguration;
import dji.v5.ux.core.base.panel.PanelWidgetType;
import dji.v5.ux.core.util.ViewIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001yB/\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\bH\u0015J\b\u0010=\u001a\u00020;H\u0014J0\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\b\b\u0001\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020DH\u0002J.\u0010E\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020DH\u0002J.\u0010H\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020DH\u0002J\u001e\u0010I\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010J\u001a\u00020\nH\u0002J&\u0010I\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010J\u001a\u00020\nH\u0002J\u001e\u0010K\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010L\u001a\u00020#H\u0002J&\u0010K\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010L\u001a\u00020#H\u0002J\u0014\u0010M\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\nH\u0016J\u001b\u0010N\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040OH\u0016\u00a2\u0006\u0002\u0010PJ\b\u0010Q\u001a\u00020\nH\u0016J\u001a\u0010R\u001a\u00020;2\b\b\u0001\u0010B\u001a\u00020\n2\u0006\u0010S\u001a\u00020\u0004H\u0016J\u0014\u0010T\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\nH\u0016J\b\u0010U\u001a\u00020;H\u0016J\u0012\u0010V\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\nJ\u0019\u0010W\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040O\u00a2\u0006\u0002\u0010PJ\u0006\u0010X\u001a\u00020\nJ\u0018\u0010Y\u001a\u00020;2\b\b\u0001\u0010B\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\u0004J\u0012\u0010[\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\nJ\u0006\u0010\\\u001a\u00020;J\u0012\u0010]\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\nJ\u0019\u0010^\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040O\u00a2\u0006\u0002\u0010PJ\u0006\u0010_\u001a\u00020\nJ\u0018\u0010`\u001a\u00020;2\b\b\u0001\u0010B\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\u0004J\u0012\u0010a\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\nJ\u0006\u0010b\u001a\u00020;J\"\u0010V\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010B\u001a\u00020\n2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000406H\u0002J)\u0010c\u001a\u00020;2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00040O2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u000406H\u0002\u00a2\u0006\u0002\u0010fJ(\u0010g\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010Z\u001a\u00020\u00042\b\b\u0001\u0010h\u001a\u00020\nH\u0002J\"\u0010i\u001a\u0004\u0018\u00010\u00042\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\b\b\u0001\u0010h\u001a\u00020\nH\u0002J\u0016\u0010j\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000406H\u0002J\u0012\u0010k\u001a\u00020D2\b\b\u0001\u0010B\u001a\u00020\nH\u0004J \u0010l\u001a\u00020D2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020\u0004062\b\b\u0001\u0010B\u001a\u00020\nH\u0004J\u001b\u0010n\u001a\u00020;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040OH\u0004\u00a2\u0006\u0002\u0010PJ\f\u0010o\u001a\u00020\n*\u00020\u0004H\u0002J\f\u0010p\u001a\u00020\n*\u00020\u0004H\u0002J\f\u0010q\u001a\u00020\n*\u00020\u0004H\u0002J\f\u0010r\u001a\u00020\n*\u00020\u0004H\u0002J\f\u0010s\u001a\u00020D*\u00020tH\u0002J\f\u0010u\u001a\u00020D*\u00020tH\u0002J\u0010\u0010v\u001a\u00020\n2\u0006\u0010B\u001a\u00020\nH\u0002J\u001e\u0010w\u001a\u00020\n2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0006\u0010B\u001a\u00020\nH\u0002J\f\u0010x\u001a\u00020\n*\u00020\nH\u0003R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R&\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R&\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R&\u0010 \u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R&\u0010$\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020#8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R&\u0010)\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020#8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R&\u0010,\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0014\"\u0004\b.\u0010\u0016R&\u0010/\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u0010\u0016R&\u00102\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020#8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010&\"\u0004\b4\u0010(R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u000406X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u000406X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Ldji/v5/ux/core/base/panel/BarPanelWidget;", "T", "", "Ldji/v5/ux/core/base/panel/PanelWidget;", "Ldji/v5/ux/core/base/panel/PanelItem;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "orientation", "Ldji/v5/ux/core/base/panel/BarPanelWidget$BarPanelWidgetOrientation;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;ILdji/v5/ux/core/base/panel/BarPanelWidget$BarPanelWidgetOrientation;)V", "getOrientation", "()Ldji/v5/ux/core/base/panel/BarPanelWidget$BarPanelWidgetOrientation;", "value", "itemsMarginLeft", "getItemsMarginLeft", "()I", "setItemsMarginLeft", "(I)V", "itemsMarginTop", "getItemsMarginTop", "setItemsMarginTop", "itemsMarginRight", "getItemsMarginRight", "setItemsMarginRight", "itemsMarginBottom", "getItemsMarginBottom", "setItemsMarginBottom", "itemSpacing", "getItemSpacing", "setItemSpacing", "", "leftBias", "getLeftBias", "()F", "setLeftBias", "(F)V", "rightBias", "getRightBias", "setRightBias", "leftChainStyle", "getLeftChainStyle", "setLeftChainStyle", "rightChainStyle", "getRightChainStyle", "setRightChainStyle", "guidelinePercent", "getGuidelinePercent", "setGuidelinePercent", "leftPanelItems", "", "rightPanelItems", "midGuideline", "Landroidx/constraintlayout/widget/Guideline;", "setUpContainers", "", "initAttributes", "updateUI", "connectPanelItem", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "panelItems", "index", "isLeftSide", "", "connectToPreviousView", "currentIndex", "isLeft", "connectToNextView", "setChainStyle", "chainStyle", "setChainBias", "bias", "getWidget", "addWidgets", "", "([Ldji/v5/ux/core/base/panel/PanelItem;)V", "size", "addWidget", "item", "removeWidget", "removeAllWidgets", "getLeftWidget", "addLeftWidgets", "leftWidgetsSize", "addLeftWidget", "panelItem", "removeLeftWidget", "removeAllLeftWidgets", "getRightWidget", "addRightWidgets", "rightWidgetsSize", "addRightWidget", "removeRightWidget", "removeAllRightWidgets", "addPanelItems", "fromPanelItems", "toPanelItems", "([Ldji/v5/ux/core/base/panel/PanelItem;Ljava/util/List;)V", "insertPanelItem", "atIndex", "removePanelItem", "removeAllPanelItem", "isFirstItem", "isLastItem", "list", "addViews", "getDefaultItemMarginLeft", "getDefaultItemMarginTop", "getDefaultItemMarginRight", "getDefaultItemMarginBottom", "widthShouldWrap", "Ldji/v5/ux/core/base/WidgetSizeDescription;", "heightShouldWrap", "getStartTopMargin", "getEndBottomMargin", "toChainStyle", "BarPanelWidgetOrientation", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nBarPanelWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarPanelWidget.kt\ndji/v5/ux/core/base/panel/BarPanelWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 4 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,641:1\n1#2:642\n233#3:643\n234#3,2:694\n88#4,5:644\n88#4,5:649\n88#4,5:654\n88#4,5:659\n88#4,5:664\n138#4,5:669\n138#4,5:674\n138#4,5:679\n112#4,5:684\n112#4,5:689\n1864#5,3:696\n1864#5,3:699\n1855#5,2:702\n13579#6,2:704\n*S KotlinDebug\n*F\n+ 1 BarPanelWidget.kt\ndji/v5/ux/core/base/panel/BarPanelWidget\n*L\n219#1:643\n219#1:694,2\n220#1:644,5\n223#1:649,5\n226#1:654,5\n229#1:659,5\n232#1:664,5\n235#1:669,5\n238#1:674,5\n241#1:679,5\n244#1:684,5\n247#1:689,5\n261#1:696,3\n264#1:699,3\n552#1:702,2\n576#1:704,2\n*E\n"})
public abstract class BarPanelWidget<T>
extends PanelWidget<PanelItem, T> {
    @NotNull
    private final BarPanelWidgetOrientation orientation;
    @IntRange(from=0L)
    private int itemsMarginLeft;
    @IntRange(from=0L)
    private int itemsMarginTop;
    @IntRange(from=0L)
    private int itemsMarginRight;
    @IntRange(from=0L)
    private int itemsMarginBottom;
    @IntRange(from=0L)
    private int itemSpacing;
    @FloatRange(from=0.0, to=1.0)
    private float leftBias;
    @FloatRange(from=0.0, to=1.0)
    private float rightBias;
    @IntRange(from=0L, to=2L)
    private int leftChainStyle;
    @IntRange(from=0L, to=2L)
    private int rightChainStyle;
    @FloatRange(from=0.0, to=1.0)
    private float guidelinePercent;
    @NotNull
    private List<PanelItem> leftPanelItems;
    @NotNull
    private List<PanelItem> rightPanelItems;
    @NotNull
    private final Guideline midGuideline;

    @JvmOverloads
    public BarPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull BarPanelWidgetOrientation orientation) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            super(context, attrs, defStyleAttr, new PanelWidgetConfiguration(context, orientation.toPanelWidgetType(), false, false, null, 0, 60, null));
            this.orientation = orientation;
            this.rightBias = 1.0f;
            this.leftChainStyle = 2;
            this.rightChainStyle = 2;
            this.guidelinePercent = 0.5f;
            this.leftPanelItems = new ArrayList();
            this.rightPanelItems = new ArrayList();
            this.midGuideline = new Guideline(context);
            if (!this.getPanelWidgetConfiguration().isBarPanelWidget()) {
                boolean $i$a$-check-BarPanelWidget$22 = false;
                String $i$a$-check-BarPanelWidget$22 = "PanelWidgetConfiguration.panelWidgetType should be PanelWidgetType.BAR_VERTICAL or PanelWidgetType.BAR_HORIZONTAL";
                throw new IllegalStateException($i$a$-check-BarPanelWidget$22.toString());
            }
            this.setUpContainers();
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block1;
            AttributeSet it = attributeSet;
            boolean bl = false;
            this.initAttributes(it);
        }
    }

    public /* synthetic */ BarPanelWidget(Context context, AttributeSet attributeSet, int n, BarPanelWidgetOrientation barPanelWidgetOrientation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n, barPanelWidgetOrientation);
    }

    @NotNull
    public final BarPanelWidgetOrientation getOrientation() {
        return this.orientation;
    }

    public final int getItemsMarginLeft() {
        return this.itemsMarginLeft;
    }

    public final void setItemsMarginLeft(int value) {
        this.itemsMarginLeft = value;
        this.updateUI();
    }

    public final int getItemsMarginTop() {
        return this.itemsMarginTop;
    }

    public final void setItemsMarginTop(int value) {
        this.itemsMarginTop = value;
        this.updateUI();
    }

    public final int getItemsMarginRight() {
        return this.itemsMarginRight;
    }

    public final void setItemsMarginRight(int value) {
        this.itemsMarginRight = value;
        this.updateUI();
    }

    public final int getItemsMarginBottom() {
        return this.itemsMarginBottom;
    }

    public final void setItemsMarginBottom(int value) {
        this.itemsMarginBottom = value;
        this.updateUI();
    }

    public final int getItemSpacing() {
        return this.itemSpacing;
    }

    public final void setItemSpacing(int value) {
        this.itemSpacing = value;
        this.updateUI();
    }

    public final float getLeftBias() {
        return this.leftBias;
    }

    public final void setLeftBias(float value) {
        this.leftBias = value;
        this.setChainBias(this.leftPanelItems, value);
    }

    public final float getRightBias() {
        return this.rightBias;
    }

    public final void setRightBias(float value) {
        this.rightBias = value;
        this.setChainBias(this.rightPanelItems, value);
    }

    public final int getLeftChainStyle() {
        return this.leftChainStyle;
    }

    public final void setLeftChainStyle(int value) {
        this.leftChainStyle = value;
        this.setChainStyle(this.leftPanelItems, value);
    }

    public final int getRightChainStyle() {
        return this.rightChainStyle;
    }

    public final void setRightChainStyle(int value) {
        this.rightChainStyle = value;
        this.setChainStyle(this.leftPanelItems, value);
    }

    public final float getGuidelinePercent() {
        return this.guidelinePercent;
    }

    public final void setGuidelinePercent(float value) {
        this.guidelinePercent = value;
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        constraintSet.setGuidelinePercent(this.midGuideline.getId(), this.guidelinePercent);
        constraintSet.applyTo((ConstraintLayout)this);
    }

    private final void setUpContainers() {
        int guidelineOrientation = this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 1 : 0;
        this.midGuideline.setId(ViewIDGenerator.INSTANCE.generateViewId());
        this.addView((View)this.midGuideline);
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        constraintSet.create(this.midGuideline.getId(), guidelineOrientation);
        constraintSet.setGuidelinePercent(this.midGuideline.getId(), this.guidelinePercent);
        constraintSet.applyTo((ConstraintLayout)this);
    }

    @SuppressLint(value={"Recycle"})
    protected void initAttributes(@NotNull AttributeSet attrs) {
        Unit unit;
        TypedArray $this$getIntAndUse$iv;
        TypedArray $this$getFloatAndUse$iv;
        float it;
        TypedArray $this$getDimensionAndUse$iv;
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BarPanelWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl = false;
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.BarPanelWidget_uxsdk_itemsMarginLeft;
        boolean $i$f$getDimensionAndUse = false;
        float dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            it = dimension$iv;
            boolean bl2 = false;
            this.setItemsMarginLeft((int)it);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_itemsMarginTop;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            it = dimension$iv;
            boolean bl3 = false;
            this.setItemsMarginTop((int)it);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_itemsMarginRight;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            it = dimension$iv;
            boolean bl4 = false;
            this.setItemsMarginRight((int)it);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_itemsMarginBottom;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            it = dimension$iv;
            boolean bl5 = false;
            this.setItemsMarginBottom((int)it);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_itemsSpacing;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            it = dimension$iv;
            boolean bl6 = false;
            this.setItemSpacing((int)it);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_guidelinePercent;
        boolean $i$f$getFloatAndUse = false;
        float floatValue$iv = $this$getFloatAndUse$iv.getFloat(index$iv, -1.0f);
        if (!(floatValue$iv == -1.0f)) {
            it = floatValue$iv;
            boolean bl7 = false;
            this.setGuidelinePercent(it);
        }
        $this$getFloatAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_leftBias;
        $i$f$getFloatAndUse = false;
        floatValue$iv = $this$getFloatAndUse$iv.getFloat(index$iv, -1.0f);
        if (!(floatValue$iv == -1.0f)) {
            it = floatValue$iv;
            boolean bl8 = false;
            this.setLeftBias(it);
        }
        $this$getFloatAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_rightBias;
        $i$f$getFloatAndUse = false;
        floatValue$iv = $this$getFloatAndUse$iv.getFloat(index$iv, -1.0f);
        if (!(floatValue$iv == -1.0f)) {
            it = floatValue$iv;
            boolean bl9 = false;
            this.setRightBias(it);
        }
        $this$getFloatAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_leftChainStyle;
        boolean $i$f$getIntAndUse = false;
        int int$iv = $this$getIntAndUse$iv.getInt(index$iv, -1);
        if (int$iv != -1) {
            int it2 = int$iv;
            boolean bl10 = false;
            this.setLeftChainStyle(this.toChainStyle(it2));
        }
        $this$getIntAndUse$iv = typedArray2;
        index$iv = R.styleable.BarPanelWidget_uxsdk_rightChainStyle;
        $i$f$getIntAndUse = false;
        int$iv = $this$getIntAndUse$iv.getInt(index$iv, -1);
        if (int$iv != -1) {
            int it3 = int$iv;
            boolean bl11 = false;
            this.setLeftChainStyle(this.toChainStyle(it3));
        }
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl12 = false;
        $this$use$iv.recycle();
    }

    @Override
    protected void updateUI() {
        int index;
        int n;
        if (this.leftPanelItems.isEmpty() && this.rightPanelItems.isEmpty()) {
            return;
        }
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        Iterable $this$forEachIndexed$iv = this.leftPanelItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PanelItem cfr_ignored_0 = (PanelItem)item$iv;
            index = n;
            boolean bl = false;
            this.connectPanelItem(constraintSet, this.leftPanelItems, index, true);
        }
        $this$forEachIndexed$iv = this.rightPanelItems;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PanelItem cfr_ignored_1 = (PanelItem)item$iv;
            index = n;
            boolean bl = false;
            this.connectPanelItem(constraintSet, this.rightPanelItems, index, false);
        }
        this.setChainStyle(constraintSet, this.leftPanelItems, this.leftChainStyle);
        this.setChainStyle(constraintSet, this.rightPanelItems, this.rightChainStyle);
        this.setChainBias(constraintSet, this.leftPanelItems, this.leftBias);
        this.setChainBias(constraintSet, this.rightPanelItems, this.rightBias);
        constraintSet.applyTo((ConstraintLayout)this);
    }

    private final void connectPanelItem(ConstraintSet constraintSet, List<PanelItem> panelItems, @IntRange(from=0L) int index, boolean isLeftSide) {
        if (index < panelItems.size()) {
            WidgetSizeDescription widgetSizeDescription;
            String ratioString;
            PanelItem barPanelItem = panelItems.get(index);
            String string2 = barPanelItem.getRatioString();
            if (string2 == null) {
                string2 = ratioString = this.getDefaultRatioString();
            }
            if ((widgetSizeDescription = barPanelItem.getWidgetSizeDescription()) == null) {
                widgetSizeDescription = new WidgetSizeDescription(WidgetSizeDescription.SizeType.RATIO, WidgetSizeDescription.Dimension.EXPAND, WidgetSizeDescription.Dimension.EXPAND);
            }
            WidgetSizeDescription widgetSizeDescription2 = widgetSizeDescription;
            View currentView = barPanelItem.getView();
            if (!(widgetSizeDescription2.getSizeType() != WidgetSizeDescription.SizeType.OTHER || this.widthShouldWrap(widgetSizeDescription2) || this.isFirstItem(index) || this.isLastItem(panelItems, index))) {
                throw new IllegalStateException("Should not add a fill view in the middle of the list");
            }
            int width = this.widthShouldWrap(widgetSizeDescription2) ? -2 : 0;
            int height = this.heightShouldWrap(widgetSizeDescription2) ? -2 : 0;
            constraintSet.constrainWidth(currentView.getId(), width);
            constraintSet.constrainHeight(currentView.getId(), height);
            if (widgetSizeDescription2.getSizeType() == WidgetSizeDescription.SizeType.RATIO) {
                constraintSet.setDimensionRatio(currentView.getId(), ratioString);
            }
            if (this.orientation == BarPanelWidgetOrientation.HORIZONTAL) {
                this.constraintToParentTop(constraintSet, currentView, this.getDefaultItemMarginTop(barPanelItem));
                this.constraintToParentBottom(constraintSet, currentView, this.getDefaultItemMarginBottom(barPanelItem));
            } else {
                this.constraintToParentStart(constraintSet, currentView, this.getDefaultItemMarginLeft(barPanelItem));
                this.constraintToParentEnd(constraintSet, currentView, this.getDefaultItemMarginRight(barPanelItem));
            }
            this.connectToPreviousView(constraintSet, panelItems, index, isLeftSide);
            this.connectToNextView(constraintSet, panelItems, index, isLeftSide);
        }
    }

    private final void connectToPreviousView(ConstraintSet constraintSet, List<PanelItem> panelItems, int currentIndex, boolean isLeft) {
        int endID;
        int panelItemSide;
        PanelItem currentPanelItem = panelItems.get(currentIndex);
        int n = panelItemSide = this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 6 : 3;
        int n2 = this.isFirstItem(currentIndex) ? (isLeft ? 0 : this.midGuideline.getId()) : (endID = panelItems.get(currentIndex - 1).getView().getId());
        int endSide = this.isFirstItem(currentIndex) ? (this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 6 : 3) : (this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 7 : 4);
        constraintSet.connect(currentPanelItem.getView().getId(), panelItemSide, endID, endSide, this.getStartTopMargin(currentIndex));
    }

    private final void connectToNextView(ConstraintSet constraintSet, List<PanelItem> panelItems, int currentIndex, boolean isLeft) {
        int endID;
        int panelItemSide;
        PanelItem currentPanelItem = panelItems.get(currentIndex);
        int n = panelItemSide = this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 7 : 4;
        int n2 = this.isLastItem(panelItems, currentIndex) ? (isLeft ? this.midGuideline.getId() : 0) : (endID = panelItems.get(currentIndex + 1).getView().getId());
        int endSide = this.isLastItem(panelItems, currentIndex) ? (this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 7 : 4) : (this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? 6 : 3);
        constraintSet.connect(currentPanelItem.getView().getId(), panelItemSide, endID, endSide, this.getEndBottomMargin(panelItems, currentIndex));
    }

    private final void setChainStyle(List<PanelItem> panelItems, int chainStyle) {
        ConstraintSet constraintSet = new ConstraintSet();
        this.setChainStyle(constraintSet, panelItems, chainStyle);
        constraintSet.applyTo((ConstraintLayout)this);
    }

    private final void setChainStyle(ConstraintSet constraintSet, List<PanelItem> panelItems, int chainStyle) {
        if (!((Collection)panelItems).isEmpty()) {
            if (this.orientation == BarPanelWidgetOrientation.HORIZONTAL) {
                constraintSet.setHorizontalChainStyle(panelItems.get(0).getView().getId(), chainStyle);
            } else {
                constraintSet.setVerticalChainStyle(panelItems.get(0).getView().getId(), chainStyle);
            }
        }
    }

    private final void setChainBias(List<PanelItem> panelItems, float bias) {
        ConstraintSet constraintSet = new ConstraintSet();
        this.setChainBias(constraintSet, panelItems, bias);
        constraintSet.applyTo((ConstraintLayout)this);
    }

    private final void setChainBias(ConstraintSet constraintSet, List<PanelItem> panelItems, float bias) {
        if (!((Collection)panelItems).isEmpty()) {
            if (this.orientation == BarPanelWidgetOrientation.HORIZONTAL) {
                constraintSet.setHorizontalBias(panelItems.get(0).getView().getId(), bias);
            } else {
                constraintSet.setVerticalBias(panelItems.get(0).getView().getId(), bias);
            }
        }
    }

    @Override
    @Nullable
    public PanelItem getWidget(@IntRange(from=0L) int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Try getLeftPanelItem or getRightPanelItem instead");
    }

    public void addWidgets(@NotNull PanelItem[] panelItems) throws UnsupportedOperationException {
        Intrinsics.checkNotNullParameter((Object)panelItems, (String)"panelItems");
        throw new UnsupportedOperationException("Try addLeftPanelItems or addRightPanelItems instead");
    }

    @Override
    public int size() {
        return this.leftPanelItems.size() + this.rightPanelItems.size();
    }

    @Override
    public void addWidget(@IntRange(from=0L) int index, @NotNull PanelItem item) throws UnsupportedOperationException {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        throw new UnsupportedOperationException("Call either");
    }

    @Override
    @Nullable
    public PanelItem removeWidget(@IntRange(from=0L) int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Try removeLeftPanelItem or removeRightPanelItem instead");
    }

    @Override
    public void removeAllWidgets() {
        this.removeAllLeftWidgets();
        this.removeAllRightWidgets();
    }

    @Nullable
    public final PanelItem getLeftWidget(@IntRange(from=0L) int index) {
        return this.getLeftWidget(index, this.leftPanelItems);
    }

    public final void addLeftWidgets(@NotNull PanelItem[] panelItems) {
        Intrinsics.checkNotNullParameter((Object)panelItems, (String)"panelItems");
        this.addPanelItems(panelItems, this.leftPanelItems);
    }

    public final int leftWidgetsSize() {
        return this.leftPanelItems.size();
    }

    public final void addLeftWidget(@IntRange(from=0L) int index, @NotNull PanelItem panelItem) {
        Intrinsics.checkNotNullParameter((Object)panelItem, (String)"panelItem");
        this.insertPanelItem(this.leftPanelItems, panelItem, index);
    }

    @Nullable
    public final PanelItem removeLeftWidget(@IntRange(from=0L) int index) {
        return this.removePanelItem(this.leftPanelItems, index);
    }

    public final void removeAllLeftWidgets() {
        this.removeAllPanelItem(this.rightPanelItems);
    }

    @Nullable
    public final PanelItem getRightWidget(@IntRange(from=0L) int index) {
        return this.getLeftWidget(index, this.rightPanelItems);
    }

    public final void addRightWidgets(@NotNull PanelItem[] panelItems) {
        Intrinsics.checkNotNullParameter((Object)panelItems, (String)"panelItems");
        this.addPanelItems(panelItems, this.rightPanelItems);
    }

    public final int rightWidgetsSize() {
        return this.rightPanelItems.size();
    }

    public final void addRightWidget(@IntRange(from=0L) int index, @NotNull PanelItem panelItem) {
        Intrinsics.checkNotNullParameter((Object)panelItem, (String)"panelItem");
        this.insertPanelItem(this.rightPanelItems, panelItem, index);
    }

    @Nullable
    public final PanelItem removeRightWidget(@IntRange(from=0L) int index) {
        return this.removePanelItem(this.rightPanelItems, index);
    }

    public final void removeAllRightWidgets() {
        this.removeAllPanelItem(this.rightPanelItems);
    }

    private final PanelItem getLeftWidget(@IntRange(from=0L) int index, List<PanelItem> panelItems) {
        return (PanelItem)CollectionsKt.getOrNull(panelItems, (int)index);
    }

    private final void addPanelItems(PanelItem[] fromPanelItems, List<PanelItem> toPanelItems) {
        CollectionsKt.addAll((Collection)toPanelItems, (Object[])fromPanelItems);
        this.addViews(fromPanelItems);
        this.updateUI();
    }

    private final void insertPanelItem(List<PanelItem> panelItems, PanelItem panelItem, @IntRange(from=0L) int atIndex) {
        panelItems.add(atIndex, panelItem);
        this.addView(panelItem.getView());
        this.updateUI();
    }

    private final PanelItem removePanelItem(List<PanelItem> panelItems, @IntRange(from=0L) int atIndex) {
        if (atIndex >= panelItems.size()) {
            return null;
        }
        PanelItem removedPanelItem = panelItems.remove(atIndex);
        this.removeView(removedPanelItem.getView());
        this.updateUI();
        return removedPanelItem;
    }

    private final void removeAllPanelItem(List<PanelItem> panelItems) {
        Iterable $this$forEach$iv = panelItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PanelItem it = (PanelItem)element$iv;
            boolean bl = false;
            this.removeView(it.getView());
        }
        panelItems.clear();
        this.updateUI();
    }

    protected final boolean isFirstItem(@IntRange(from=0L) int index) {
        return index == 0;
    }

    protected final boolean isLastItem(@NotNull List<PanelItem> list, @IntRange(from=0L) int index) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        return index == list.size() - 1;
    }

    protected final void addViews(@NotNull PanelItem[] panelItems) {
        Intrinsics.checkNotNullParameter((Object)panelItems, (String)"panelItems");
        PanelItem[] $this$forEach$iv = panelItems;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            PanelItem element$iv;
            PanelItem it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.addView(it.getView());
        }
    }

    private final int getDefaultItemMarginLeft(PanelItem $this$getDefaultItemMarginLeft) {
        Integer n = $this$getDefaultItemMarginLeft.getItemMarginLeft();
        return n != null ? n : this.itemsMarginLeft;
    }

    private final int getDefaultItemMarginTop(PanelItem $this$getDefaultItemMarginTop) {
        Integer n = $this$getDefaultItemMarginTop.getItemMarginTop();
        return n != null ? n : this.itemsMarginTop;
    }

    private final int getDefaultItemMarginRight(PanelItem $this$getDefaultItemMarginRight) {
        Integer n = $this$getDefaultItemMarginRight.getItemMarginRight();
        return n != null ? n : this.itemsMarginRight;
    }

    private final int getDefaultItemMarginBottom(PanelItem $this$getDefaultItemMarginBottom) {
        Integer n = $this$getDefaultItemMarginBottom.getItemMarginBottom();
        return n != null ? n : this.itemsMarginBottom;
    }

    private final boolean widthShouldWrap(WidgetSizeDescription $this$widthShouldWrap) {
        return $this$widthShouldWrap.getWidthDimension() == WidgetSizeDescription.Dimension.WRAP;
    }

    private final boolean heightShouldWrap(WidgetSizeDescription $this$heightShouldWrap) {
        return $this$heightShouldWrap.getHeightDimension() == WidgetSizeDescription.Dimension.WRAP;
    }

    private final int getStartTopMargin(int index) {
        int margin = this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? this.itemsMarginLeft : this.itemsMarginTop;
        return this.isFirstItem(index) ? margin : this.itemSpacing / 2;
    }

    private final int getEndBottomMargin(List<PanelItem> panelItems, int index) {
        int margin = this.orientation == BarPanelWidgetOrientation.HORIZONTAL ? this.itemsMarginRight : this.itemsMarginBottom;
        return this.isLastItem(panelItems, index) ? margin : this.itemSpacing / 2;
    }

    @IntRange(from=0L, to=2L)
    private final int toChainStyle(int $this$toChainStyle) {
        return switch ($this$toChainStyle) {
            case 0 -> 0;
            case 1 -> 1;
            default -> 2;
        };
    }

    @JvmOverloads
    public BarPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs, @NotNull BarPanelWidgetOrientation orientation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this(context, attrs, 0, orientation, 4, null);
    }

    @JvmOverloads
    public BarPanelWidget(@NotNull Context context, @NotNull BarPanelWidgetOrientation orientation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this(context, null, 0, orientation, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/base/panel/BarPanelWidget$BarPanelWidgetOrientation;", "", "<init>", "(Ljava/lang/String;I)V", "VERTICAL", "HORIZONTAL", "toPanelWidgetType", "Ldji/v5/ux/core/base/panel/PanelWidgetType;", "android-sdk-v5-uxsdk_debug"})
    public static final class BarPanelWidgetOrientation
    extends Enum<BarPanelWidgetOrientation> {
        public static final /* enum */ BarPanelWidgetOrientation VERTICAL = new BarPanelWidgetOrientation();
        public static final /* enum */ BarPanelWidgetOrientation HORIZONTAL = new BarPanelWidgetOrientation();
        private static final /* synthetic */ BarPanelWidgetOrientation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final PanelWidgetType toPanelWidgetType() {
            return this == HORIZONTAL ? PanelWidgetType.BAR_HORIZONTAL : PanelWidgetType.BAR_VERTICAL;
        }

        public static BarPanelWidgetOrientation[] values() {
            return (BarPanelWidgetOrientation[])$VALUES.clone();
        }

        public static BarPanelWidgetOrientation valueOf(String value) {
            return Enum.valueOf(BarPanelWidgetOrientation.class, value);
        }

        @NotNull
        public static EnumEntries<BarPanelWidgetOrientation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = barPanelWidgetOrientationArray = new BarPanelWidgetOrientation[]{BarPanelWidgetOrientation.VERTICAL, BarPanelWidgetOrientation.HORIZONTAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

