/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory;

import dji.sdk.keyvalue.value.rtkbasestation.RTKReferenceStationSource;
import dji.sdk.keyvalue.value.rtkbasestation.RTKServiceState;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationConnetState;
import dji.sdk.keyvalue.value.rtkmobilestation.RTKLocation;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.aircraft.rtk.RTKLocationInfo;
import dji.v5.manager.aircraft.rtk.RTKLocationInfoListener;
import dji.v5.manager.aircraft.rtk.RTKSystemState;
import dji.v5.manager.aircraft.rtk.RTKSystemStateListener;
import dji.v5.manager.aircraft.rtk.network.INetworkServiceInfoListener;
import dji.v5.manager.aircraft.rtk.station.RTKStationConnectStatusListener;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003EFGB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u000207H\u0014J\u0010\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\u0002072\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0006\u0010?\u001a\u000207J\b\u0010@\u001a\u000207H\u0002J\b\u0010A\u001a\u000207H\u0002J\u0012\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010;H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140+8G\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020 0+8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010-R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0+8G\u00a2\u0006\u0006\u001a\u0004\b3\u0010-R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u001e0+8G\u00a2\u0006\u0006\u001a\u0004\b5\u0010-\u00a8\u0006H"}, d2={"Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "uxKeyManager", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "rtkCenter", "Ldji/v5/manager/interfaces/IRTKCenter;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;Ldji/v5/manager/interfaces/IRTKCenter;)V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "rtkLocationInfoProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/v5/manager/aircraft/rtk/RTKLocationInfo;", "rtkSystemStateProcessor", "Ldji/v5/manager/aircraft/rtk/RTKSystemState;", "rtkStationConnectStateProcessor", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKStationConnetState;", "rtkNetworkServiceInfoProcessor", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKServiceState;", "unitTypeProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "rtkBaseStationStateProcessor", "Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$RTKBaseStationState;", "rtkNetworkServiceStateProcessor", "Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$RTKNetworkServiceState;", "standardDeviationProcessor", "Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$StandardDeviation;", "rtkLocationInfoListener", "Ldji/v5/manager/aircraft/rtk/RTKLocationInfoListener;", "rtkSystemStateListener", "Ldji/v5/manager/aircraft/rtk/RTKSystemStateListener;", "stationConnectStatusListener", "Ldji/v5/manager/aircraft/rtk/station/RTKStationConnectStatusListener;", "mRTKServiceState", "networkServiceInfoListener", "Ldji/v5/manager/aircraft/rtk/network/INetworkServiceInfoListener;", "rtkLocationInfo", "Lio/reactivex/rxjava3/core/Flowable;", "getRTKLocationInfo", "()Lio/reactivex/rxjava3/core/Flowable;", "rtkSystemState", "getRTKSystemState", "standardDeviation", "getStandardDeviation", "rtkBaseStationState", "getRTKBaseStationState", "rtkNetworkServiceState", "getRTKNetworkServiceState", "inSetup", "", "inCleanup", "updateRTKListener", "rtkSource", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "updateStandardDeviation", "rtkLocation", "Ldji/sdk/keyvalue/value/rtkmobilestation/RTKLocation;", "updateRTKConnectionState", "updateNetworkServiceState", "updateBaseStationState", "isNetworkServiceOpen", "", "rtkSignal", "RTKNetworkServiceState", "RTKBaseStationState", "StandardDeviation", "android-sdk-v5-uxsdk_debug"})
public final class RTKSatelliteStatusWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final IRTKCenter rtkCenter;
    private final String TAG;
    @NotNull
    private final DataProcessor<RTKLocationInfo> rtkLocationInfoProcessor;
    @NotNull
    private final DataProcessor<RTKSystemState> rtkSystemStateProcessor;
    @NotNull
    private final DataProcessor<RTKStationConnetState> rtkStationConnectStateProcessor;
    @NotNull
    private final DataProcessor<RTKServiceState> rtkNetworkServiceInfoProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeProcessor;
    @NotNull
    private final DataProcessor<RTKBaseStationState> rtkBaseStationStateProcessor;
    @NotNull
    private final DataProcessor<RTKNetworkServiceState> rtkNetworkServiceStateProcessor;
    @NotNull
    private final DataProcessor<StandardDeviation> standardDeviationProcessor;
    @NotNull
    private final RTKLocationInfoListener rtkLocationInfoListener;
    @NotNull
    private final RTKSystemStateListener rtkSystemStateListener;
    @NotNull
    private final RTKStationConnectStatusListener stationConnectStatusListener;
    @NotNull
    private RTKServiceState mRTKServiceState;
    @NotNull
    private final INetworkServiceInfoListener networkServiceInfoListener;

    public RTKSatelliteStatusWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore uxKeyManager, @Nullable GlobalPreferencesInterface preferencesManager, @NotNull IRTKCenter rtkCenter) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)uxKeyManager, (String)"uxKeyManager");
        Intrinsics.checkNotNullParameter((Object)rtkCenter, (String)"rtkCenter");
        super(djiSdkModel, uxKeyManager);
        this.preferencesManager = preferencesManager;
        this.rtkCenter = rtkCenter;
        this.TAG = LogUtils.getTag((Object)this);
        DataProcessor<RTKLocationInfo> dataProcessor = DataProcessor.create(new RTKLocationInfo());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.rtkLocationInfoProcessor = dataProcessor;
        DataProcessor<RTKSystemState> dataProcessor2 = DataProcessor.create(new RTKSystemState());
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.rtkSystemStateProcessor = dataProcessor2;
        DataProcessor<RTKStationConnetState> dataProcessor3 = DataProcessor.create(RTKStationConnetState.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.rtkStationConnectStateProcessor = dataProcessor3;
        DataProcessor<RTKServiceState> dataProcessor4 = DataProcessor.create(RTKServiceState.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.rtkNetworkServiceInfoProcessor = dataProcessor4;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor5 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.unitTypeProcessor = dataProcessor5;
        DataProcessor<RTKBaseStationState> dataProcessor6 = DataProcessor.create(RTKBaseStationState.DISCONNECTED);
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.rtkBaseStationStateProcessor = dataProcessor6;
        DataProcessor<RTKNetworkServiceState> dataProcessor7 = DataProcessor.create(new RTKNetworkServiceState(RTKServiceState.UNKNOWN, false, false, RTKReferenceStationSource.UNKNOWN));
        Intrinsics.checkNotNullExpressionValue(dataProcessor7, (String)"create(...)");
        this.rtkNetworkServiceStateProcessor = dataProcessor7;
        DataProcessor<StandardDeviation> dataProcessor8 = DataProcessor.create(new StandardDeviation(0.0f, 0.0f, 0.0f, UnitConversionUtil.UnitType.METRIC));
        Intrinsics.checkNotNullExpressionValue(dataProcessor8, (String)"create(...)");
        this.standardDeviationProcessor = dataProcessor8;
        this.rtkLocationInfoListener = arg_0 -> RTKSatelliteStatusWidgetModel.rtkLocationInfoListener$lambda$0(this, arg_0);
        this.rtkSystemStateListener = arg_0 -> RTKSatelliteStatusWidgetModel.rtkSystemStateListener$lambda$1(this, arg_0);
        this.stationConnectStatusListener = arg_0 -> RTKSatelliteStatusWidgetModel.stationConnectStatusListener$lambda$2(this, arg_0);
        this.mRTKServiceState = RTKServiceState.UNKNOWN;
        this.networkServiceInfoListener = new INetworkServiceInfoListener(this){
            final /* synthetic */ RTKSatelliteStatusWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceStateUpdate(RTKServiceState state) {
                block1: {
                    RTKServiceState rTKServiceState = state;
                    if (rTKServiceState == null) break block1;
                    RTKServiceState rTKServiceState2 = rTKServiceState;
                    RTKSatelliteStatusWidgetModel rTKSatelliteStatusWidgetModel = this.this$0;
                    RTKServiceState it = rTKServiceState2;
                    boolean bl = false;
                    if (RTKSatelliteStatusWidgetModel.access$getMRTKServiceState$p(rTKSatelliteStatusWidgetModel) != state) {
                        Object[] objectArray = new Object[]{"onServiceStateUpdate RTKServiceState=" + state};
                        LogUtils.i((String)RTKSatelliteStatusWidgetModel.access$getTAG$p(rTKSatelliteStatusWidgetModel), (Object[])objectArray);
                        RTKSatelliteStatusWidgetModel.access$setMRTKServiceState$p(rTKSatelliteStatusWidgetModel, state);
                        RTKSatelliteStatusWidgetModel.access$getRtkNetworkServiceInfoProcessor$p(rTKSatelliteStatusWidgetModel).onNext(it);
                        rTKSatelliteStatusWidgetModel.updateRTKConnectionState();
                    }
                }
            }

            public void onErrorCodeUpdate(IDJIError error) {
                block0: {
                    IDJIError iDJIError = error;
                    if (iDJIError == null) break block0;
                    IDJIError iDJIError2 = iDJIError;
                    RTKSatelliteStatusWidgetModel rTKSatelliteStatusWidgetModel = this.this$0;
                    IDJIError it = iDJIError2;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{error.toString()};
                    LogUtils.e((String)RTKSatelliteStatusWidgetModel.access$getTAG$p(rTKSatelliteStatusWidgetModel), (Object[])objectArray);
                }
            }
        };
        if (this.preferencesManager != null) {
            this.unitTypeProcessor.onNext(this.preferencesManager.getUnitType());
        }
    }

    @JvmName(name="getRTKLocationInfo")
    @NotNull
    public final Flowable<RTKLocationInfo> getRTKLocationInfo() {
        Flowable<RTKLocationInfo> flowable = this.rtkLocationInfoProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @JvmName(name="getRTKSystemState")
    @NotNull
    public final Flowable<RTKSystemState> getRTKSystemState() {
        Flowable<RTKSystemState> flowable = this.rtkSystemStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<StandardDeviation> getStandardDeviation() {
        Flowable<StandardDeviation> flowable = this.standardDeviationProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @JvmName(name="getRTKBaseStationState")
    @NotNull
    public final Flowable<RTKBaseStationState> getRTKBaseStationState() {
        Flowable<RTKBaseStationState> flowable = this.rtkBaseStationStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @JvmName(name="getRTKNetworkServiceState")
    @NotNull
    public final Flowable<RTKNetworkServiceState> getRTKNetworkServiceState() {
        Flowable<RTKNetworkServiceState> flowable = this.rtkNetworkServiceStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.rtkCenter.addRTKLocationInfoListener(this.rtkLocationInfoListener);
        this.rtkCenter.addRTKSystemStateListener(this.rtkSystemStateListener);
        this.rtkCenter.getQXRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCustomRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCMCCRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getRTKStationManager().addRTKStationConnectStatusListener(this.stationConnectStatusListener);
        this.getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ RTKSatelliteStatusWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.updateRTKConnectionState();
            }
        });
        UXKey unitKey = UXKeys.create("UnitType");
        this.bindDataProcessor(unitKey, this.unitTypeProcessor);
        this.updateRTKConnectionState();
    }

    @Override
    protected void inCleanup() {
        this.rtkCenter.removeRTKLocationInfoListener(this.rtkLocationInfoListener);
        this.rtkCenter.removeRTKSystemStateListener(this.rtkSystemStateListener);
        this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.stationConnectStatusListener);
        this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
    }

    private final void updateRTKListener(RTKReferenceStationSource rtkSource) {
        switch (WhenMappings.$EnumSwitchMapping$0[rtkSource.ordinal()]) {
            case 1: {
                this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.stationConnectStatusListener);
                this.rtkCenter.getQXRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                break;
            }
            case 2: {
                this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.stationConnectStatusListener);
                this.rtkCenter.getCustomRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                break;
            }
            case 3: {
                this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.stationConnectStatusListener);
                this.rtkCenter.getCMCCRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                break;
            }
            case 4: {
                this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().addRTKStationConnectStatusListener(this.stationConnectStatusListener);
            }
        }
    }

    private final void updateStandardDeviation(RTKLocation rtkLocation) {
        float stdLatitude = 0.0f;
        float stdLongitude = 0.0f;
        float stdAltitude = 0.0f;
        RTKLocation rTKLocation = rtkLocation;
        if (rTKLocation != null) {
            RTKLocation it = rTKLocation;
            boolean bl = false;
            if (this.unitTypeProcessor.getValue() == UnitConversionUtil.UnitType.IMPERIAL) {
                stdLatitude = UnitConversionUtil.convertMetersToFeet((float)it.getStdLatitude().doubleValue());
                stdLongitude = UnitConversionUtil.convertMetersToFeet((float)it.getStdLongitude().doubleValue());
                stdAltitude = UnitConversionUtil.convertMetersToFeet((float)it.getStdAltitude().doubleValue());
            } else {
                stdLatitude = (float)it.getStdLatitude().doubleValue();
                stdLongitude = (float)it.getStdLongitude().doubleValue();
                stdAltitude = (float)it.getStdAltitude().doubleValue();
            }
        }
        UnitConversionUtil.UnitType unitType = this.unitTypeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
        this.standardDeviationProcessor.onNext(new StandardDeviation(stdLatitude, stdLongitude, stdAltitude, unitType));
    }

    public final void updateRTKConnectionState() {
        block2: {
            RTKReferenceStationSource rTKReferenceStationSource = this.rtkSystemStateProcessor.getValue().getRtkReferenceStationSource();
            if (rTKReferenceStationSource == null) break block2;
            RTKReferenceStationSource it = rTKReferenceStationSource;
            boolean bl = false;
            if (this.isNetworkServiceOpen(it)) {
                this.updateNetworkServiceState();
            } else {
                this.updateBaseStationState();
            }
        }
    }

    private final void updateNetworkServiceState() {
        this.rtkNetworkServiceStateProcessor.onNext(new RTKNetworkServiceState(this.rtkNetworkServiceInfoProcessor.getValue(), this.rtkSystemStateProcessor.getValue().getRTKHealthy(), this.isNetworkServiceOpen(this.rtkSystemStateProcessor.getValue().getRtkReferenceStationSource()), this.rtkSystemStateProcessor.getValue().getRtkReferenceStationSource()));
    }

    private final void updateBaseStationState() {
        if (this.rtkStationConnectStateProcessor.getValue() == RTKStationConnetState.CONNECTED && ((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            if (this.rtkSystemStateProcessor.getValue().getRTKHealthy()) {
                this.rtkBaseStationStateProcessor.onNext(RTKBaseStationState.CONNECTED_IN_USE);
            } else {
                this.rtkBaseStationStateProcessor.onNext(RTKBaseStationState.CONNECTED_NOT_IN_USE);
            }
        } else {
            this.rtkBaseStationStateProcessor.onNext(RTKBaseStationState.DISCONNECTED);
        }
    }

    private final boolean isNetworkServiceOpen(RTKReferenceStationSource rtkSignal) {
        return rtkSignal == RTKReferenceStationSource.QX_NETWORK_SERVICE || rtkSignal == RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE || rtkSignal == RTKReferenceStationSource.NTRIP_NETWORK_SERVICE;
    }

    private static final void rtkLocationInfoListener$lambda$0(RTKSatelliteStatusWidgetModel this$0, RTKLocationInfo it) {
        this$0.rtkLocationInfoProcessor.onNext(it);
        this$0.updateStandardDeviation(it.getRtkLocation());
    }

    private static final void rtkSystemStateListener$lambda$1(RTKSatelliteStatusWidgetModel this$0, RTKSystemState it) {
        this$0.rtkSystemStateProcessor.onNext(it);
        this$0.updateRTKConnectionState();
        RTKReferenceStationSource rTKReferenceStationSource = it.getRtkReferenceStationSource();
        Intrinsics.checkNotNullExpressionValue((Object)rTKReferenceStationSource, (String)"getRtkReferenceStationSource(...)");
        this$0.updateRTKListener(rTKReferenceStationSource);
    }

    private static final void stationConnectStatusListener$lambda$2(RTKSatelliteStatusWidgetModel this$0, RTKStationConnetState it) {
        Object[] objectArray = new Object[]{it};
        LogUtils.i((String)this$0.TAG, (Object[])objectArray);
        this$0.rtkStationConnectStateProcessor.onNext(it);
        this$0.updateRTKConnectionState();
    }

    public static final /* synthetic */ RTKServiceState access$getMRTKServiceState$p(RTKSatelliteStatusWidgetModel $this) {
        return $this.mRTKServiceState;
    }

    public static final /* synthetic */ String access$getTAG$p(RTKSatelliteStatusWidgetModel $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$setMRTKServiceState$p(RTKSatelliteStatusWidgetModel $this, RTKServiceState rTKServiceState) {
        $this.mRTKServiceState = rTKServiceState;
    }

    public static final /* synthetic */ DataProcessor access$getRtkNetworkServiceInfoProcessor$p(RTKSatelliteStatusWidgetModel $this) {
        return $this.rtkNetworkServiceInfoProcessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$RTKBaseStationState;", "", "<init>", "(Ljava/lang/String;I)V", "CONNECTED_IN_USE", "CONNECTED_NOT_IN_USE", "DISCONNECTED", "android-sdk-v5-uxsdk_debug"})
    public static final class RTKBaseStationState
    extends Enum<RTKBaseStationState> {
        public static final /* enum */ RTKBaseStationState CONNECTED_IN_USE = new RTKBaseStationState();
        public static final /* enum */ RTKBaseStationState CONNECTED_NOT_IN_USE = new RTKBaseStationState();
        public static final /* enum */ RTKBaseStationState DISCONNECTED = new RTKBaseStationState();
        private static final /* synthetic */ RTKBaseStationState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RTKBaseStationState[] values() {
            return (RTKBaseStationState[])$VALUES.clone();
        }

        public static RTKBaseStationState valueOf(String value) {
            return Enum.valueOf(RTKBaseStationState.class, value);
        }

        @NotNull
        public static EnumEntries<RTKBaseStationState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rTKBaseStationStateArray = new RTKBaseStationState[]{RTKBaseStationState.CONNECTED_IN_USE, RTKBaseStationState.CONNECTED_NOT_IN_USE, RTKBaseStationState.DISCONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J>\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0004\u0010\rR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0006\u0010\rR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$RTKNetworkServiceState;", "", "state", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKServiceState;", "isRTKBeingUsed", "", "isNetworkServiceOpen", "rtkSignal", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "<init>", "(Ldji/sdk/keyvalue/value/rtkbasestation/RTKServiceState;Ljava/lang/Boolean;Ljava/lang/Boolean;Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;)V", "getState", "()Ldji/sdk/keyvalue/value/rtkbasestation/RTKServiceState;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getRTKSignal", "()Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "component1", "component2", "component3", "component4", "copy", "(Ldji/sdk/keyvalue/value/rtkbasestation/RTKServiceState;Ljava/lang/Boolean;Ljava/lang/Boolean;Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;)Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$RTKNetworkServiceState;", "equals", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class RTKNetworkServiceState {
        @Nullable
        private final RTKServiceState state;
        @Nullable
        private final Boolean isRTKBeingUsed;
        @Nullable
        private final Boolean isNetworkServiceOpen;
        @Nullable
        private final RTKReferenceStationSource rtkSignal;

        public RTKNetworkServiceState(@Nullable RTKServiceState state, @Nullable Boolean isRTKBeingUsed, @Nullable Boolean isNetworkServiceOpen, @Nullable RTKReferenceStationSource rtkSignal) {
            this.state = state;
            this.isRTKBeingUsed = isRTKBeingUsed;
            this.isNetworkServiceOpen = isNetworkServiceOpen;
            this.rtkSignal = rtkSignal;
        }

        @Nullable
        public final RTKServiceState getState() {
            return this.state;
        }

        @Nullable
        public final Boolean isRTKBeingUsed() {
            return this.isRTKBeingUsed;
        }

        @Nullable
        public final Boolean isNetworkServiceOpen() {
            return this.isNetworkServiceOpen;
        }

        @JvmName(name="getRTKSignal")
        @Nullable
        public final RTKReferenceStationSource getRTKSignal() {
            return this.rtkSignal;
        }

        @Nullable
        public final RTKServiceState component1() {
            return this.state;
        }

        @Nullable
        public final Boolean component2() {
            return this.isRTKBeingUsed;
        }

        @Nullable
        public final Boolean component3() {
            return this.isNetworkServiceOpen;
        }

        @Nullable
        public final RTKReferenceStationSource component4() {
            return this.rtkSignal;
        }

        @NotNull
        public final RTKNetworkServiceState copy(@Nullable RTKServiceState state, @Nullable Boolean isRTKBeingUsed, @Nullable Boolean isNetworkServiceOpen, @Nullable RTKReferenceStationSource rtkSignal) {
            return new RTKNetworkServiceState(state, isRTKBeingUsed, isNetworkServiceOpen, rtkSignal);
        }

        public static /* synthetic */ RTKNetworkServiceState copy$default(RTKNetworkServiceState rTKNetworkServiceState, RTKServiceState rTKServiceState, Boolean bl, Boolean bl2, RTKReferenceStationSource rTKReferenceStationSource, int n, Object object) {
            if ((n & 1) != 0) {
                rTKServiceState = rTKNetworkServiceState.state;
            }
            if ((n & 2) != 0) {
                bl = rTKNetworkServiceState.isRTKBeingUsed;
            }
            if ((n & 4) != 0) {
                bl2 = rTKNetworkServiceState.isNetworkServiceOpen;
            }
            if ((n & 8) != 0) {
                rTKReferenceStationSource = rTKNetworkServiceState.rtkSignal;
            }
            return rTKNetworkServiceState.copy(rTKServiceState, bl, bl2, rTKReferenceStationSource);
        }

        @NotNull
        public String toString() {
            return "RTKNetworkServiceState(state=" + this.state + ", isRTKBeingUsed=" + this.isRTKBeingUsed + ", isNetworkServiceOpen=" + this.isNetworkServiceOpen + ", rtkSignal=" + this.rtkSignal + ")";
        }

        public int hashCode() {
            int result = this.state == null ? 0 : this.state.hashCode();
            result = result * 31 + (this.isRTKBeingUsed == null ? 0 : ((Object)this.isRTKBeingUsed).hashCode());
            result = result * 31 + (this.isNetworkServiceOpen == null ? 0 : ((Object)this.isNetworkServiceOpen).hashCode());
            result = result * 31 + (this.rtkSignal == null ? 0 : this.rtkSignal.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RTKNetworkServiceState)) {
                return false;
            }
            RTKNetworkServiceState rTKNetworkServiceState = (RTKNetworkServiceState)other;
            if (this.state != rTKNetworkServiceState.state) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isRTKBeingUsed, (Object)rTKNetworkServiceState.isRTKBeingUsed)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isNetworkServiceOpen, (Object)rTKNetworkServiceState.isNetworkServiceOpen)) {
                return false;
            }
            return this.rtkSignal == rTKNetworkServiceState.rtkSignal;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Ldji/v5/ux/accessory/RTKSatelliteStatusWidgetModel$StandardDeviation;", "", "latitude", "", "longitude", "altitude", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(FFFLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getLatitude", "()F", "getLongitude", "getAltitude", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class StandardDeviation {
        private final float latitude;
        private final float longitude;
        private final float altitude;
        @NotNull
        private final UnitConversionUtil.UnitType unitType;

        public StandardDeviation(float latitude, float longitude, float altitude, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            this.latitude = latitude;
            this.longitude = longitude;
            this.altitude = altitude;
            this.unitType = unitType;
        }

        public final float getLatitude() {
            return this.latitude;
        }

        public final float getLongitude() {
            return this.longitude;
        }

        public final float getAltitude() {
            return this.altitude;
        }

        @NotNull
        public final UnitConversionUtil.UnitType getUnitType() {
            return this.unitType;
        }

        public final float component1() {
            return this.latitude;
        }

        public final float component2() {
            return this.longitude;
        }

        public final float component3() {
            return this.altitude;
        }

        @NotNull
        public final UnitConversionUtil.UnitType component4() {
            return this.unitType;
        }

        @NotNull
        public final StandardDeviation copy(float latitude, float longitude, float altitude, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            return new StandardDeviation(latitude, longitude, altitude, unitType);
        }

        public static /* synthetic */ StandardDeviation copy$default(StandardDeviation standardDeviation, float f, float f2, float f3, UnitConversionUtil.UnitType unitType, int n, Object object) {
            if ((n & 1) != 0) {
                f = standardDeviation.latitude;
            }
            if ((n & 2) != 0) {
                f2 = standardDeviation.longitude;
            }
            if ((n & 4) != 0) {
                f3 = standardDeviation.altitude;
            }
            if ((n & 8) != 0) {
                unitType = standardDeviation.unitType;
            }
            return standardDeviation.copy(f, f2, f3, unitType);
        }

        @NotNull
        public String toString() {
            return "StandardDeviation(latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + ", unitType=" + this.unitType + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.latitude);
            result = result * 31 + Float.hashCode(this.longitude);
            result = result * 31 + Float.hashCode(this.altitude);
            result = result * 31 + this.unitType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StandardDeviation)) {
                return false;
            }
            StandardDeviation standardDeviation = (StandardDeviation)other;
            if (Float.compare(this.latitude, standardDeviation.latitude) != 0) {
                return false;
            }
            if (Float.compare(this.longitude, standardDeviation.longitude) != 0) {
                return false;
            }
            if (Float.compare(this.altitude, standardDeviation.altitude) != 0) {
                return false;
            }
            return this.unitType == standardDeviation.unitType;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RTKReferenceStationSource.values().length];
            try {
                nArray[RTKReferenceStationSource.QX_NETWORK_SERVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.NTRIP_NETWORK_SERVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.BASE_STATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

