/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.fpvinteraction;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.R;

public class GimbalControlView
extends FrameLayout {
    protected static final int DEFAULT_VIBRATION_DURATION = 100;
    private ImageView gimbalPoint;
    private ImageView gimbalMove;
    private ImageView gimbalArrow;
    private Vibrator vibrator;
    private int gimbalArrowW = 0;
    private int gimbalArrowH = 0;
    private boolean isVibrationEnabled;
    private int vibrationDuration;

    public GimbalControlView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public GimbalControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public GimbalControlView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public void initView(Context context) {
        GimbalControlView.inflate((Context)context, (int)R.layout.uxsdk_view_gimbal_control, (ViewGroup)this);
        this.gimbalPoint = (ImageView)this.findViewById(R.id.gimbal_control_point);
        this.gimbalMove = (ImageView)this.findViewById(R.id.gimbal_control_move);
        this.gimbalArrow = (ImageView)this.findViewById(R.id.gimbal_control_arrow);
        if (!this.isInEditMode()) {
            this.vibrator = (Vibrator)context.getSystemService("vibrator");
        }
        this.isVibrationEnabled = true;
        this.vibrationDuration = 100;
    }

    public void show(float x, float y) {
        this.gimbalPoint.setX(x - (float)this.gimbalPoint.getWidth() / 2.0f);
        this.gimbalPoint.setY(y - (float)this.gimbalPoint.getHeight() / 2.0f);
        this.gimbalMove.setX(x - (float)this.gimbalMove.getWidth() / 2.0f);
        this.gimbalMove.setY(y - (float)this.gimbalMove.getHeight() / 2.0f);
        this.gimbalPoint.setVisibility(0);
        this.gimbalMove.setVisibility(0);
        if (this.gimbalArrowW == 0) {
            this.gimbalArrowW = this.gimbalArrow.getWidth();
            this.gimbalArrowH = this.gimbalArrow.getHeight();
        }
        this.vibrator.vibrate((long)this.vibrationDuration);
    }

    public void hide() {
        if (this.isVisible()) {
            this.gimbalPoint.setVisibility(8);
            this.gimbalMove.setVisibility(8);
            this.gimbalArrow.setVisibility(8);
        }
    }

    public boolean isVisible() {
        return this.gimbalPoint.getVisibility() == 0;
    }

    public void onMove(float firstX, float firstY, float x, float y, boolean canRotateGimbalYaw) {
        if (canRotateGimbalYaw) {
            this.gimbalMove.setX(x - (float)this.gimbalMove.getWidth() / 2.0f);
        }
        this.gimbalMove.setY(y - (float)this.gimbalMove.getHeight() / 2.0f);
        this.transformArrow(firstX, firstY, x, y, canRotateGimbalYaw);
    }

    private void transformArrow(float firstX, float firstY, float x, float y, boolean canRotateGimbalYaw) {
        float offsetY;
        float curDistance;
        float dirDistance;
        float offsetX = x - firstX;
        if (!canRotateGimbalYaw) {
            offsetX = 0.0f;
        }
        if ((dirDistance = (float)Math.pow(curDistance = (float)Math.sqrt(offsetX * offsetX + (offsetY = y - firstY) * offsetY), 0.7)) < (float)this.gimbalArrowW * 0.6f || curDistance < 1.0f) {
            this.gimbalArrow.setVisibility(8);
        } else {
            this.gimbalArrow.setVisibility(0);
            float ratio = dirDistance / curDistance;
            float dirOffsetX = offsetX * ratio;
            float dirOffsetY = offsetY * ratio;
            this.gimbalArrow.setX(firstX + dirOffsetX - (float)this.gimbalArrowW / 2.0f);
            this.gimbalArrow.setY(firstY + dirOffsetY - (float)this.gimbalArrowH / 2.0f);
            float alpha = Math.min(0.7f, dirDistance / (float)this.gimbalArrowW / 3.0f);
            this.gimbalArrow.setAlpha(alpha);
            double angrad = Math.asin(dirOffsetY / dirDistance);
            if (dirOffsetX < 0.0f) {
                angrad = Math.PI - angrad;
            }
            double angDeg = Math.toDegrees(angrad);
            this.gimbalArrow.setRotation((float)angDeg);
            float scale = (float)(1.0 + Math.min(0.5, (double)(dirDistance / (float)this.gimbalArrowW) / 10.0));
            this.gimbalArrow.setScaleX(scale);
            this.gimbalArrow.setScaleY(scale);
        }
    }

    @Nullable
    public Drawable getGimbalPointIcon() {
        return this.gimbalPoint.getDrawable();
    }

    public void setGimbalPointIcon(@Nullable Drawable gimbalPointIcon) {
        this.gimbalPoint.setImageDrawable(gimbalPointIcon);
    }

    @Nullable
    public Drawable getGimbalMoveIcon() {
        return this.gimbalMove.getDrawable();
    }

    public void setGimbalMoveIcon(@Nullable Drawable gimbalMoveIcon) {
        this.gimbalMove.setImageDrawable(gimbalMoveIcon);
    }

    @Nullable
    public Drawable getGimbalArrowIcon() {
        return this.gimbalArrow.getDrawable();
    }

    public void setGimbalArrowIcon(@Nullable Drawable gimbalArrowIcon) {
        this.gimbalArrow.setImageDrawable(gimbalArrowIcon);
    }

    public boolean isVibrationEnabled() {
        return this.isVibrationEnabled;
    }

    public void setVibrationEnabled(boolean vibrationEnabled) {
        this.isVibrationEnabled = vibrationEnabled;
    }

    public int getVibrationDuration() {
        return this.vibrationDuration;
    }

    public void setVibrationDuration(@IntRange(from=0L) int vibrationDuration) {
        this.vibrationDuration = vibrationDuration;
    }
}

