/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.remainingflighttime;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.widget.remainingflighttime.RemainingFlightTimeWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b&\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002bcB'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010G\u001a\u00020H2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020KH\u0014J\b\u0010L\u001a\u00020HH\u0014J\b\u0010M\u001a\u00020HH\u0014J\b\u0010N\u001a\u00020HH\u0014J\b\u0010O\u001a\u00020\u001cH\u0016J\u0010\u0010P\u001a\u00020H2\u0006\u0010Q\u001a\u00020RH\u0002J \u0010S\u001a\u00020H2\u0006\u0010J\u001a\u00020K2\u0006\u0010T\u001a\u00020!2\u0006\u0010U\u001a\u00020!H\u0002J\b\u0010V\u001a\u00020WH\u0002J\u0018\u0010X\u001a\u00020H2\u0006\u0010Y\u001a\u00020R2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020\bH\u0002J\u0018\u0010^\u001a\u00020H2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\b\u0010_\u001a\u00020HH\u0002J\u000e\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00020aH\u0016R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010*\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u0010/\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R$\u00102\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010,\"\u0004\b4\u0010.R$\u00105\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010,\"\u0004\b7\u0010.R$\u00108\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010,\"\u0004\b:\u0010.R$\u0010;\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010,\"\u0004\b=\u0010.R$\u0010>\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010,\"\u0004\b@\u0010.R$\u0010A\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010,\"\u0004\bC\u0010.R$\u0010D\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010,\"\u0004\bF\u0010.\u00a8\u0006d"}, d2={"Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget;", "Ldji/v5/ux/core/base/widget/FrameLayoutWidget;", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "widgetModel", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "batteryRequiredToLandPaint", "Landroid/graphics/Paint;", "batteryChargeRemainingPaint", "batteryRequiredToGoHomePaint", "flightTimeRoundedBackgroundPaint", "flightTimeTextPaint", "lowBatteryThresholdDotPaint", "seriousLowBatteryThresholdDotPaint", "homePointBackgroundPaint", "homeLetterPaint", "flightTimeText", "", "flightTimeTextBounds", "Landroid/graphics/Rect;", "homeLetterBounds", "batteryRequiredToLandPercentage", "", "remainingBatteryChargePercentage", "batteryRequiredToGoHomePercentage", "seriousLowBatteryThresholdPercentage", "lowBatteryThresholdPercentage", "viewHeight", "usableViewWidth", "homeLetterWidth", "color", "batteryChargeRemainingColor", "getBatteryChargeRemainingColor", "()I", "setBatteryChargeRemainingColor", "(I)V", "batteryToReturnHomeColor", "getBatteryToReturnHomeColor", "setBatteryToReturnHomeColor", "batteryRequiredToLandColor", "getBatteryRequiredToLandColor", "setBatteryRequiredToLandColor", "seriousLowBatteryThresholdDotColor", "getSeriousLowBatteryThresholdDotColor", "setSeriousLowBatteryThresholdDotColor", "lowBatteryThresholdDotColor", "getLowBatteryThresholdDotColor", "setLowBatteryThresholdDotColor", "flightTimeTextColor", "getFlightTimeTextColor", "setFlightTimeTextColor", "flightTimeBackgroundColor", "getFlightTimeBackgroundColor", "setFlightTimeBackgroundColor", "homeLetterColor", "getHomeLetterColor", "setHomeLetterColor", "homeLetterBackgroundColor", "getHomeLetterBackgroundColor", "setHomeLetterBackgroundColor", "initView", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onAttachedToWindow", "onDetachedFromWindow", "reactToModelChanges", "getIdealDimensionRatioString", "updateVisibility", "isProductConnected", "", "drawFlightText", "roundedBgWidth", "textWidth", "reactToRemainingFlightTimeChange", "Lio/reactivex/rxjava3/disposables/Disposable;", "onRemainingFlightTimeChange", "isAircraftFlying", "remainingFlightTimeData", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidgetModel$RemainingFlightTimeData;", "getFormattedString", "flightTime", "initAttributes", "initDefaults", "getWidgetStateUpdate", "Lio/reactivex/rxjava3/core/Flowable;", "ModelState", "Companion", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nRemainingFlightTimeWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemainingFlightTimeWidget.kt\ndji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget\n+ 2 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 3 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n*L\n1#1,506:1\n233#2:507\n234#2,2:553\n64#3,5:508\n64#3,5:513\n64#3,5:518\n64#3,5:523\n64#3,5:528\n64#3,5:533\n64#3,5:538\n64#3,5:543\n64#3,5:548\n*S KotlinDebug\n*F\n+ 1 RemainingFlightTimeWidget.kt\ndji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget\n*L\n397#1:507\n397#1:553,2\n398#1:508,5\n401#1:513,5\n404#1:518,5\n407#1:523,5\n410#1:528,5\n413#1:533,5\n416#1:538,5\n419#1:543,5\n422#1:548,5\n*E\n"})
public class RemainingFlightTimeWidget
extends FrameLayoutWidget<ModelState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private final Paint batteryRequiredToLandPaint;
    @NotNull
    private final Paint batteryChargeRemainingPaint;
    @NotNull
    private final Paint batteryRequiredToGoHomePaint;
    @NotNull
    private final Paint flightTimeRoundedBackgroundPaint;
    @NotNull
    private final Paint flightTimeTextPaint;
    @NotNull
    private final Paint lowBatteryThresholdDotPaint;
    @NotNull
    private final Paint seriousLowBatteryThresholdDotPaint;
    @NotNull
    private final Paint homePointBackgroundPaint;
    @NotNull
    private final Paint homeLetterPaint;
    @NotNull
    private String flightTimeText;
    @NotNull
    private final Rect flightTimeTextBounds;
    @NotNull
    private final Rect homeLetterBounds;
    private float batteryRequiredToLandPercentage;
    private float remainingBatteryChargePercentage;
    private float batteryRequiredToGoHomePercentage;
    private float seriousLowBatteryThresholdPercentage;
    private float lowBatteryThresholdPercentage;
    private float viewHeight;
    private float usableViewWidth;
    private float homeLetterWidth;
    @NotNull
    private static final String TAG = "FlightTimeWidget";
    @NotNull
    private static final String DISCONNECTED_STRING = "--:--";
    @NotNull
    private static final String MINUTE_FLIGHT_TIME_FORMAT_STRING = "%02d:%02d";
    @NotNull
    private static final String HOUR_FLIGHT_TIME_FORMAT_STRING = "%01d:%02d:%02d";
    private static final int MINUTE_CONVERSION_CONSTANT = 60;
    private static final int HOUR_CONVERSION_CONSTANT = 3600;

    @JvmOverloads
    public RemainingFlightTimeWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.widgetModel$delegate = LazyKt.lazy(RemainingFlightTimeWidget::widgetModel_delegate$lambda$0);
        this.batteryRequiredToLandPaint = new Paint();
        this.batteryChargeRemainingPaint = new Paint();
        this.batteryRequiredToGoHomePaint = new Paint();
        this.flightTimeRoundedBackgroundPaint = new Paint(1);
        this.flightTimeTextPaint = new Paint(1);
        this.lowBatteryThresholdDotPaint = new Paint(1);
        this.seriousLowBatteryThresholdDotPaint = new Paint(1);
        this.homePointBackgroundPaint = new Paint(1);
        this.homeLetterPaint = new Paint(1);
        this.flightTimeText = DISCONNECTED_STRING;
        this.flightTimeTextBounds = new Rect();
        this.homeLetterBounds = new Rect();
        this.setWillNotDraw(false);
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    public /* synthetic */ RemainingFlightTimeWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final RemainingFlightTimeWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (RemainingFlightTimeWidgetModel)lazy.getValue();
    }

    public final int getBatteryChargeRemainingColor() {
        return this.batteryChargeRemainingPaint.getColor();
    }

    public final void setBatteryChargeRemainingColor(int color2) {
        this.batteryChargeRemainingPaint.setColor(color2);
        this.invalidate();
    }

    public final int getBatteryToReturnHomeColor() {
        return this.batteryRequiredToGoHomePaint.getColor();
    }

    public final void setBatteryToReturnHomeColor(int color2) {
        this.batteryRequiredToGoHomePaint.setColor(color2);
        this.invalidate();
    }

    public final int getBatteryRequiredToLandColor() {
        return this.batteryRequiredToLandPaint.getColor();
    }

    public final void setBatteryRequiredToLandColor(int color2) {
        this.batteryRequiredToLandPaint.setColor(color2);
        this.invalidate();
    }

    public final int getSeriousLowBatteryThresholdDotColor() {
        return this.seriousLowBatteryThresholdDotPaint.getColor();
    }

    public final void setSeriousLowBatteryThresholdDotColor(int color2) {
        this.seriousLowBatteryThresholdDotPaint.setColor(color2);
        this.invalidate();
    }

    public final int getLowBatteryThresholdDotColor() {
        return this.lowBatteryThresholdDotPaint.getColor();
    }

    public final void setLowBatteryThresholdDotColor(int color2) {
        this.lowBatteryThresholdDotPaint.setColor(color2);
        this.invalidate();
    }

    public final int getFlightTimeTextColor() {
        return this.flightTimeTextPaint.getColor();
    }

    public final void setFlightTimeTextColor(int color2) {
        this.flightTimeTextPaint.setColor(color2);
        this.invalidate();
    }

    public final int getFlightTimeBackgroundColor() {
        return this.flightTimeRoundedBackgroundPaint.getColor();
    }

    public final void setFlightTimeBackgroundColor(int color2) {
        this.flightTimeRoundedBackgroundPaint.setColor(color2);
        this.invalidate();
    }

    public final int getHomeLetterColor() {
        return this.homeLetterPaint.getColor();
    }

    public final void setHomeLetterColor(int color2) {
        this.homeLetterPaint.setColor(color2);
        this.invalidate();
    }

    public final int getHomeLetterBackgroundColor() {
        return this.homePointBackgroundPaint.getColor();
    }

    public final void setHomeLetterBackgroundColor(int color2) {
        this.homePointBackgroundPaint.setColor(color2);
        this.invalidate();
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        String homeLetter = ViewExtensions.getString((View)this, R.string.uxsdk_home_location_letter, new Object[0]);
        if (this.viewHeight == 0.0f) {
            this.viewHeight = this.getHeight();
            this.usableViewWidth = this.getWidth();
            this.batteryRequiredToLandPaint.setStrokeWidth(this.viewHeight / 6.0f);
            this.batteryChargeRemainingPaint.setStrokeWidth(this.viewHeight / 6.0f);
            this.batteryRequiredToGoHomePaint.setStrokeWidth(this.viewHeight / 6.0f);
            this.flightTimeRoundedBackgroundPaint.setStrokeWidth(this.viewHeight / 1.1f);
            this.seriousLowBatteryThresholdDotPaint.setStrokeWidth(this.viewHeight / 2.4f);
            this.lowBatteryThresholdDotPaint.setStrokeWidth(this.viewHeight / 2.4f);
            this.homePointBackgroundPaint.setStrokeWidth(this.viewHeight / 1.6f);
            this.flightTimeTextPaint.setTextSize(this.viewHeight / 1.5f);
            this.homeLetterPaint.setTextSize(this.viewHeight / 2.5f);
            this.homeLetterWidth = this.homeLetterPaint.measureText(homeLetter);
            this.homeLetterPaint.getTextBounds(homeLetter, 0, 1, this.homeLetterBounds);
            this.flightTimeTextPaint.getTextBounds(this.flightTimeText, 0, 1, this.flightTimeTextBounds);
        } else {
            float textWidth = this.flightTimeTextPaint.measureText(this.flightTimeText);
            float roundedBgWidth = textWidth * 1.55f;
            canvas.drawLine(0.0f, this.viewHeight / 2.0f, this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.batteryChargeRemainingPaint);
            if (this.batteryRequiredToGoHomePercentage <= this.remainingBatteryChargePercentage) {
                canvas.drawLine(0.0f, this.viewHeight / 2.0f, this.usableViewWidth * this.batteryRequiredToGoHomePercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.batteryRequiredToGoHomePaint);
            } else {
                canvas.drawLine(0.0f, this.viewHeight / 2.0f, this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.batteryRequiredToGoHomePaint);
            }
            if (this.batteryRequiredToLandPercentage <= this.remainingBatteryChargePercentage) {
                canvas.drawLine(0.0f, this.viewHeight / 2.0f, this.usableViewWidth * this.batteryRequiredToLandPercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.batteryRequiredToLandPaint);
            } else {
                canvas.drawLine(0.0f, this.viewHeight / 2.0f, this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.batteryRequiredToLandPaint);
            }
            if (this.seriousLowBatteryThresholdPercentage <= this.remainingBatteryChargePercentage) {
                canvas.drawPoint(this.usableViewWidth * this.seriousLowBatteryThresholdPercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.seriousLowBatteryThresholdDotPaint);
            }
            if (this.lowBatteryThresholdPercentage <= this.remainingBatteryChargePercentage) {
                canvas.drawPoint(this.usableViewWidth * this.lowBatteryThresholdPercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.lowBatteryThresholdDotPaint);
            }
            if (this.batteryRequiredToGoHomePercentage <= this.remainingBatteryChargePercentage) {
                canvas.drawPoint(this.usableViewWidth * this.batteryRequiredToGoHomePercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.homePointBackgroundPaint);
                canvas.drawText(homeLetter, this.usableViewWidth * this.batteryRequiredToGoHomePercentage / 100.0f - this.homeLetterWidth / 2.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f + (float)this.homeLetterBounds.height() / 2.0f, this.homeLetterPaint);
            } else {
                canvas.drawPoint(this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f, this.homePointBackgroundPaint);
                canvas.drawText(homeLetter, this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - this.homeLetterWidth / 2.0f - roundedBgWidth / (float)2, this.viewHeight / 2.0f + (float)this.homeLetterBounds.height() / 2.0f, this.homeLetterPaint);
            }
            this.drawFlightText(canvas, roundedBgWidth, textWidth);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ RemainingFlightTimeWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(boolean isProductConnected) {
                RemainingFlightTimeWidget.access$updateVisibility(this.this$0, isProductConnected);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        this.addReaction(this.reactToRemainingFlightTimeChange());
        Disposable disposable2 = this.getWidgetModel().isAircraftFlying().observeOn(SchedulerProvider.io()).subscribe(new Consumer(this){
            final /* synthetic */ RemainingFlightTimeWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RemainingFlightTimeWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.AircraftFlyingUpdated(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getWidgetModel().getRemainingFlightTimeData().observeOn(SchedulerProvider.io()).subscribe(new Consumer(this){
            final /* synthetic */ RemainingFlightTimeWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(RemainingFlightTimeWidgetModel.RemainingFlightTimeData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RemainingFlightTimeWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.FlightTimeDataUpdated(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
    }

    @Override
    @NotNull
    public String getIdealDimensionRatioString() {
        return ViewExtensions.getString((View)this, R.string.uxsdk_widget_remaining_flight_time_ratio, new Object[0]);
    }

    private final void updateVisibility(boolean isProductConnected) {
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.ProductConnected(isProductConnected));
        this.setVisibility(isProductConnected ? 0 : 8);
    }

    private final void drawFlightText(Canvas canvas, float roundedBgWidth, float textWidth) {
        this.flightTimeRoundedBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
        float start = this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth > 0.0f ? this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2 - textWidth / 2.5f : this.flightTimeRoundedBackgroundPaint.getStrokeWidth() / 2.0f;
        float end = this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth > 0.0f ? this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2 + textWidth / 2.5f : roundedBgWidth / (float)2 + textWidth / 2.5f;
        float textStart = this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth > 0.0f ? this.usableViewWidth * this.remainingBatteryChargePercentage / 100.0f - roundedBgWidth / (float)2 - textWidth / (float)2 : this.flightTimeRoundedBackgroundPaint.getStrokeWidth() / 2.5f;
        canvas.drawPoint(start, this.viewHeight / 2.0f, this.flightTimeRoundedBackgroundPaint);
        canvas.drawPoint(end, this.viewHeight / 2.0f, this.flightTimeRoundedBackgroundPaint);
        canvas.drawLine(start, this.viewHeight / 2.0f, end, this.viewHeight / 2.0f, this.flightTimeRoundedBackgroundPaint);
        canvas.drawText(this.flightTimeText, textStart, this.viewHeight / 2.0f + (this.flightTimeTextBounds.height() > this.homeLetterBounds.height() ? (float)this.flightTimeTextBounds.height() / 2.5f : (float)this.homeLetterBounds.height() / 1.5f), this.flightTimeTextPaint);
    }

    private final Disposable reactToRemainingFlightTimeChange() {
        Disposable disposable = Flowable.combineLatest((Publisher)((Publisher)this.getWidgetModel().isAircraftFlying()), (Publisher)((Publisher)this.getWidgetModel().getRemainingFlightTimeData()), RemainingFlightTimeWidget::reactToRemainingFlightTimeChange$lambda$1).observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> RemainingFlightTimeWidget.reactToRemainingFlightTimeChange$lambda$2(this, arg_0), UxErrorHandle.logErrorConsumer(TAG, "react to flight time update: "));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        return disposable;
    }

    private final void onRemainingFlightTimeChange(boolean isAircraftFlying, RemainingFlightTimeWidgetModel.RemainingFlightTimeData remainingFlightTimeData) {
        this.flightTimeText = isAircraftFlying ? this.getFormattedString(remainingFlightTimeData.getFlightTime()) : DISCONNECTED_STRING;
        this.batteryRequiredToLandPercentage = remainingFlightTimeData.getBatteryNeededToLand();
        this.batteryRequiredToGoHomePercentage = remainingFlightTimeData.getBatteryNeededToGoHome();
        this.remainingBatteryChargePercentage = remainingFlightTimeData.getRemainingCharge();
        this.seriousLowBatteryThresholdPercentage = remainingFlightTimeData.getSeriousLowBatteryThreshold();
        this.lowBatteryThresholdPercentage = remainingFlightTimeData.getLowBatteryThreshold();
        this.invalidate();
    }

    private final String getFormattedString(int flightTime) {
        String string2;
        if (flightTime / 60 > 59) {
            String string3 = HOUR_FLIGHT_TIME_FORMAT_STRING;
            Object[] objectArray = new Object[]{flightTime / 3600, flightTime / 3600 % 60, flightTime % 3600 % 60};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        } else {
            String string5 = MINUTE_FLIGHT_TIME_FORMAT_STRING;
            Object[] objectArray = new Object[]{flightTime / 60, flightTime % 60};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
        }
        return string2;
    }

    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        int it;
        TypedArray $this$getColorAndUse$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RemainingFlightTimeWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl = false;
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_homeLetterBackgroundColor;
        boolean $i$f$getColorAndUse = false;
        int colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl2 = false;
            this.setHomeLetterBackgroundColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_homeLetterColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl3 = false;
            this.setHomeLetterColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_flightTimeBackgroundColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl4 = false;
            this.setFlightTimeBackgroundColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_flightTimeTextColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl5 = false;
            this.setFlightTimeTextColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_lowBatteryThresholdColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl6 = false;
            this.setLowBatteryThresholdDotColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_seriousLowBatteryThresholdColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl7 = false;
            this.setSeriousLowBatteryThresholdDotColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_batteryRequiredToLandColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl8 = false;
            this.setBatteryRequiredToLandColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_batteryRequiredToGoHomeColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl9 = false;
            this.setBatteryToReturnHomeColor(it);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.RemainingFlightTimeWidget_uxsdk_batteryChargeRemainingColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            it = colorInt$iv;
            boolean bl10 = false;
            this.setBatteryChargeRemainingColor(it);
        }
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl11 = false;
        $this$use$iv.recycle();
    }

    private final void initDefaults() {
        this.batteryRequiredToLandPaint.setColor(-65536);
        this.batteryRequiredToLandPaint.setStyle(Paint.Style.STROKE);
        this.batteryRequiredToLandPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.batteryChargeRemainingPaint.setColor(-16711936);
        this.batteryChargeRemainingPaint.setStyle(Paint.Style.STROKE);
        this.batteryChargeRemainingPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.batteryRequiredToGoHomePaint.setColor(-256);
        this.batteryRequiredToGoHomePaint.setStyle(Paint.Style.STROKE);
        this.batteryRequiredToGoHomePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.flightTimeRoundedBackgroundPaint.setColor(-1);
        this.flightTimeRoundedBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.flightTimeRoundedBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
        this.flightTimeTextPaint.setColor(-16777216);
        this.flightTimeTextPaint.setStyle(Paint.Style.FILL);
        this.seriousLowBatteryThresholdDotPaint.setColor(-1);
        this.seriousLowBatteryThresholdDotPaint.setStyle(Paint.Style.STROKE);
        this.seriousLowBatteryThresholdDotPaint.setStrokeCap(Paint.Cap.ROUND);
        this.lowBatteryThresholdDotPaint.setColor(-1);
        this.lowBatteryThresholdDotPaint.setStyle(Paint.Style.STROKE);
        this.lowBatteryThresholdDotPaint.setStrokeCap(Paint.Cap.ROUND);
        this.homeLetterPaint.setColor(-16777216);
        this.homeLetterPaint.setStyle(Paint.Style.FILL);
        this.homeLetterPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.homePointBackgroundPaint.setColor(-256);
        this.homePointBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.homePointBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @JvmOverloads
    public RemainingFlightTimeWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RemainingFlightTimeWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final RemainingFlightTimeWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new RemainingFlightTimeWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final Pair reactToRemainingFlightTimeChange$lambda$1(boolean first, RemainingFlightTimeWidgetModel.RemainingFlightTimeData second) {
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return new Pair((Object)first, (Object)second);
    }

    private static final void reactToRemainingFlightTimeChange$lambda$2(RemainingFlightTimeWidget this$0, Pair values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this$0.onRemainingFlightTimeChange((Boolean)values.getFirst(), (RemainingFlightTimeWidgetModel.RemainingFlightTimeData)values.getSecond());
    }

    public static final /* synthetic */ void access$updateVisibility(RemainingFlightTimeWidget $this, boolean isProductConnected) {
        $this.updateVisibility(isProductConnected);
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(RemainingFlightTimeWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$Companion;", "", "<init>", "()V", "TAG", "", "DISCONNECTED_STRING", "MINUTE_FLIGHT_TIME_FORMAT_STRING", "HOUR_FLIGHT_TIME_FORMAT_STRING", "MINUTE_CONVERSION_CONSTANT", "", "HOUR_CONVERSION_CONSTANT", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "AircraftFlyingUpdated", "FlightTimeDataUpdated", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState$AircraftFlyingUpdated;", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState$FlightTimeDataUpdated;", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState$ProductConnected;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState$AircraftFlyingUpdated;", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState;", "isAircraftFlying", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class AircraftFlyingUpdated
        extends ModelState {
            private final boolean isAircraftFlying;

            public AircraftFlyingUpdated(boolean isAircraftFlying) {
                super(null);
                this.isAircraftFlying = isAircraftFlying;
            }

            public final boolean isAircraftFlying() {
                return this.isAircraftFlying;
            }

            public final boolean component1() {
                return this.isAircraftFlying;
            }

            @NotNull
            public final AircraftFlyingUpdated copy(boolean isAircraftFlying) {
                return new AircraftFlyingUpdated(isAircraftFlying);
            }

            public static /* synthetic */ AircraftFlyingUpdated copy$default(AircraftFlyingUpdated aircraftFlyingUpdated, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = aircraftFlyingUpdated.isAircraftFlying;
                }
                return aircraftFlyingUpdated.copy(bl);
            }

            @NotNull
            public String toString() {
                return "AircraftFlyingUpdated(isAircraftFlying=" + this.isAircraftFlying + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isAircraftFlying);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AircraftFlyingUpdated)) {
                    return false;
                }
                AircraftFlyingUpdated aircraftFlyingUpdated = (AircraftFlyingUpdated)other;
                return this.isAircraftFlying == aircraftFlyingUpdated.isAircraftFlying;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState$FlightTimeDataUpdated;", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState;", "remainingFlightTimeData", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidgetModel$RemainingFlightTimeData;", "<init>", "(Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidgetModel$RemainingFlightTimeData;)V", "getRemainingFlightTimeData", "()Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidgetModel$RemainingFlightTimeData;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class FlightTimeDataUpdated
        extends ModelState {
            @NotNull
            private final RemainingFlightTimeWidgetModel.RemainingFlightTimeData remainingFlightTimeData;

            public FlightTimeDataUpdated(@NotNull RemainingFlightTimeWidgetModel.RemainingFlightTimeData remainingFlightTimeData) {
                Intrinsics.checkNotNullParameter((Object)remainingFlightTimeData, (String)"remainingFlightTimeData");
                super(null);
                this.remainingFlightTimeData = remainingFlightTimeData;
            }

            @NotNull
            public final RemainingFlightTimeWidgetModel.RemainingFlightTimeData getRemainingFlightTimeData() {
                return this.remainingFlightTimeData;
            }

            @NotNull
            public final RemainingFlightTimeWidgetModel.RemainingFlightTimeData component1() {
                return this.remainingFlightTimeData;
            }

            @NotNull
            public final FlightTimeDataUpdated copy(@NotNull RemainingFlightTimeWidgetModel.RemainingFlightTimeData remainingFlightTimeData) {
                Intrinsics.checkNotNullParameter((Object)remainingFlightTimeData, (String)"remainingFlightTimeData");
                return new FlightTimeDataUpdated(remainingFlightTimeData);
            }

            public static /* synthetic */ FlightTimeDataUpdated copy$default(FlightTimeDataUpdated flightTimeDataUpdated, RemainingFlightTimeWidgetModel.RemainingFlightTimeData remainingFlightTimeData, int n, Object object) {
                if ((n & 1) != 0) {
                    remainingFlightTimeData = flightTimeDataUpdated.remainingFlightTimeData;
                }
                return flightTimeDataUpdated.copy(remainingFlightTimeData);
            }

            @NotNull
            public String toString() {
                return "FlightTimeDataUpdated(remainingFlightTimeData=" + this.remainingFlightTimeData + ")";
            }

            public int hashCode() {
                return this.remainingFlightTimeData.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FlightTimeDataUpdated)) {
                    return false;
                }
                FlightTimeDataUpdated flightTimeDataUpdated = (FlightTimeDataUpdated)other;
                return Intrinsics.areEqual((Object)this.remainingFlightTimeData, (Object)flightTimeDataUpdated.remainingFlightTimeData);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/remainingflighttime/RemainingFlightTimeWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }
    }
}

