/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hsi;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.common.DoubleMinMax;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.hsi.dashboard.FpvStrokeConfig;
import dji.v5.ux.core.util.FontUtils;
import dji.v5.ux.core.widget.hsi.GimbalPitchBarModel;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Schedulers;

public class GimbalPitchBarWidget
extends FrameLayoutWidget<Boolean>
implements ICameraIndex {
    protected int mMinValue = -120;
    protected int mMaxValue = 120;
    protected int mValue = 0;
    protected boolean mInvalidDrawable = true;
    private Paint mBarPaint;
    private Paint mBarStrokePaint;
    private Paint mHighlightPaint;
    private Paint mInnerPaint;
    private Paint mOnBarPaint;
    private Paint mTextPaint;
    private Paint mTextStrokePaint;
    private float mBarWidth;
    private float mOriginWidth;
    private float mOriginLength;
    private int[] mHighlightValues;
    private int mTextHighlightColor;
    private float mInnerWidth;
    private int mInnerValue;
    private int mInnerMaxValue;
    private int mOnBarMaxValue;
    private int[] mOnBarColors;
    @Nullable
    private int[] mOnBarIndicator;
    private float mOriginPadding;
    private Drawable mIndicatorDrawable;
    private boolean mAlignLeft;
    private boolean mTextOnTop;
    private float mDrawableSizeFactor = 1.0f;
    private final RectF mBarRect = new RectF();
    private final RectF mTmpRect = new RectF();
    private String mText;
    private float mTextSize;
    private float mTextPadding;
    private FpvStrokeConfig mStrokeConfig;
    private ComponentIndexType componentIndexType = ComponentIndexType.UNKNOWN;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private GimbalPitchBarModel widgetModel = new GimbalPitchBarModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());

    public GimbalPitchBarWidget(Context context) {
        this(context, null);
    }

    public GimbalPitchBarWidget(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GimbalPitchBarWidget(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private int getColor(int colorId) {
        return this.getResources().getColor(colorId);
    }

    private float getDimen(int dimenId) {
        return this.getResources().getDimension(dimenId);
    }

    protected void initParams(Context context, AttributeSet attrs) {
        int onBarColors;
        super.setWillNotDraw(false);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.GimbalPitchBarV2);
        this.mAlignLeft = typedArray.getBoolean(R.styleable.GimbalPitchBarV2_uxsdk_gpb_align_left, false);
        this.mMaxValue = typedArray.getInt(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_max_value, 0);
        this.mMinValue = typedArray.getInt(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_min_value, 0);
        this.mValue = typedArray.getInt(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_value, 0);
        this.mText = typedArray.getString(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_text);
        this.mTextSize = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_text_size, this.getDimen(R.dimen.uxsdk_7_dp));
        this.mTextPadding = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_text_padding, this.getDimen(R.dimen.uxsdk_2_dp));
        this.mTextOnTop = typedArray.getBoolean(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_text_on_top, false);
        this.mBarWidth = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_width, this.getDimen(R.dimen.uxsdk_3_dp));
        int barColor = typedArray.getColor(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_color, this.getColor(R.color.uxsdk_white_10_percent));
        float barStrokeWidth = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_stroke_width, this.getDimen(R.dimen.uxsdk_0_5_dp));
        int barStrokeColor = typedArray.getColor(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_stroke_color, this.getColor(R.color.uxsdk_black_30_percent));
        this.mOriginPadding = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_bar_origin_padding, this.getDimen(R.dimen.uxsdk_2_dp));
        this.mOriginWidth = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_origin_width, this.getDimen(R.dimen.uxsdk_1_dp));
        this.mOriginLength = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_origin_length, this.getDimen(R.dimen.uxsdk_6_dp));
        int highlightValuesId = typedArray.getResourceId(R.styleable.GimbalPitchBarV2_uxsdk_gpb_highlight_values, 0);
        if (highlightValuesId != 0) {
            this.mHighlightValues = this.getResources().getIntArray(highlightValuesId);
        }
        float highlightWidth = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_highlight_width, this.getDimen(R.dimen.uxsdk_0_5_dp));
        int highlightColor = typedArray.getColor(R.styleable.GimbalPitchBarV2_uxsdk_gpb_highlight_color, this.getColor(R.color.uxsdk_white));
        this.mIndicatorDrawable = typedArray.getDrawable(R.styleable.GimbalPitchBarV2_uxsdk_gpb_indicator_drawable);
        this.mDrawableSizeFactor = typedArray.getFloat(R.styleable.GimbalPitchBarV2_uxsdk_gpb_indicator_drawable_factor, 1.0f);
        this.mInnerWidth = typedArray.getDimension(R.styleable.GimbalPitchBarV2_uxsdk_gpb_inner_width, this.getDimen(R.dimen.uxsdk_3_dp));
        this.mInnerValue = typedArray.getInt(R.styleable.GimbalPitchBarV2_uxsdk_gpb_inner_value, 0);
        this.mInnerMaxValue = typedArray.getInt(R.styleable.GimbalPitchBarV2_uxsdk_gpb_inner_max_value, 0);
        this.mOnBarMaxValue = typedArray.getInt(R.styleable.GimbalPitchBarV2_uxsdk_gpb_on_bar_max_value, 0);
        int onBarValues = typedArray.getResourceId(R.styleable.GimbalPitchBarV2_uxsdk_gpb_on_bar_values, 0);
        if (onBarValues != 0) {
            this.mOnBarIndicator = this.getResources().getIntArray(onBarValues);
        }
        if ((onBarColors = typedArray.getResourceId(R.styleable.GimbalPitchBarV2_uxsdk_gpb_on_bar_colors, 0)) != 0) {
            this.mOnBarColors = this.getResources().getIntArray(onBarColors);
        }
        typedArray.recycle();
        this.mTextHighlightColor = this.getResources().getColor(R.color.uxsdk_yellow_in_light);
        this.mStrokeConfig = new FpvStrokeConfig(context);
        Typeface typeface = Typeface.create((String)"sans-serif-condensed", (int)1);
        Paint barPaint = new Paint(5);
        barPaint.setStyle(Paint.Style.FILL);
        barPaint.setColor(barColor);
        this.mBarPaint = barPaint;
        Paint barStrokePaint = new Paint(5);
        barStrokePaint.setColor(barStrokeColor);
        barStrokePaint.setStyle(Paint.Style.STROKE);
        barStrokePaint.setStrokeWidth(barStrokeWidth);
        this.mBarStrokePaint = barStrokePaint;
        Paint highlightPaint = new Paint(5);
        highlightPaint.setColor(highlightColor);
        highlightPaint.setStyle(Paint.Style.FILL);
        highlightPaint.setStrokeWidth(highlightWidth);
        this.mHighlightPaint = highlightPaint;
        Paint textPaint = new Paint(5);
        textPaint.setColor(-1);
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setStrokeWidth(10.0f);
        textPaint.setTextSize(this.mTextSize);
        textPaint.setTypeface(typeface);
        this.mTextPaint = textPaint;
        Paint paint = new Paint(5);
        paint.setColor(this.mStrokeConfig.getStrokeDeepColor());
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(this.mStrokeConfig.getStrokeBoldWidth());
        paint.setTextSize(this.mTextSize);
        paint.setTypeface(typeface);
        this.mTextStrokePaint = paint;
        Paint onBarPaint = new Paint(5);
        onBarPaint.setStyle(Paint.Style.FILL);
        this.mOnBarPaint = onBarPaint;
        Paint innerPaint = new Paint(5);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setColor(-1);
        this.mInnerPaint = innerPaint;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF bar = this.mBarRect;
        bar.right = this.mAlignLeft ? this.mOriginPadding + this.mOriginLength + this.mBarWidth : (float)this.getWidth() - (this.mOriginPadding + this.mOriginLength) + this.mBarWidth;
        bar.left = bar.right - this.mBarWidth;
        bar.top = this.getPaddingTop();
        bar.bottom = (float)this.getHeight() - (float)this.getPaddingBottom();
        this.drawBackground(canvas, bar);
        if (this.mMaxValue != this.mMinValue) {
            this.drawHighlightValues(canvas, bar);
        }
        this.drawOnBarIndicator(canvas, bar);
        this.drawInnerIndicator(canvas, bar);
        if (this.mOriginLength > 0.0f) {
            this.drawOriginValue(canvas, bar);
        }
        if (this.mMaxValue != this.mMinValue) {
            this.drawIndicator(canvas, bar);
        }
        this.drawCurrentValue(canvas, bar);
    }

    private void drawCurrentValue(Canvas canvas, RectF bar) {
        float left;
        if (TextUtils.isEmpty((CharSequence)this.mText)) {
            return;
        }
        float len = this.mTextPaint.measureText(this.mText);
        float baseline = this.mTextOnTop ? FontUtils.getDigitalBaselineFromBottom(this.mTextPaint, bar.top - this.mTextPadding) - this.mTextPaint.getFontMetrics().bottom : FontUtils.getDigitalBaselineFromTop(this.mTextPaint, bar.top);
        if (this.mTextOnTop) {
            left = (bar.left + bar.right - len) / 2.0f;
            if (!this.mAlignLeft) {
                left = Math.min(left, (float)this.getWidth() - len);
            }
        } else {
            left = this.mAlignLeft ? bar.right + this.mTextPadding : bar.left - this.mTextPadding - len;
        }
        canvas.drawText(this.mText, left, baseline, this.mTextStrokePaint);
        canvas.drawText(this.mText, left, baseline, this.mTextPaint);
    }

    private void drawInnerIndicator(Canvas canvas, RectF rect) {
        if (this.mInnerMaxValue == 0) {
            return;
        }
        int lastValue = this.mInnerValue;
        float centerY = rect.centerY();
        float lastY = centerY - this.innerValue2Height(rect.height(), lastValue);
        float left = this.mAlignLeft ? rect.right : rect.left - this.mInnerWidth;
        float right = left + this.mInnerWidth;
        canvas.drawRect(left, centerY, right, lastY, this.mInnerPaint);
    }

    private void drawOnBarIndicator(Canvas canvas, RectF rect) {
        if (this.mOnBarMaxValue == 0) {
            return;
        }
        int[] onBarIndicator = this.mOnBarIndicator;
        if (onBarIndicator == null || onBarIndicator.length < 2) {
            return;
        }
        if (this.mOnBarColors == null || this.mOnBarColors.length == 0) {
            return;
        }
        float centerY = rect.centerY();
        float lastY = centerY - this.onBarValue2Height(rect.height(), onBarIndicator[0]);
        for (int i = 1; i < onBarIndicator.length; ++i) {
            float currentY = centerY - this.onBarValue2Height(rect.height(), onBarIndicator[i]);
            this.mOnBarPaint.setColor(this.mOnBarColors[(i - 1) % this.mOnBarColors.length]);
            canvas.drawRect(rect.left, lastY, rect.right, currentY, this.mOnBarPaint);
            lastY = currentY;
        }
    }

    private void drawOriginValue(Canvas canvas, RectF rect) {
        float left;
        float right;
        float barHeight = rect.height();
        float halfStrokeWidth = this.mBarStrokePaint.getStrokeWidth() / 2.0f;
        float y = this.getMaxValue() == this.getMinValue() ? rect.centerY() : this.indicatorValue2Height(barHeight, 0) + rect.top;
        if (this.mAlignLeft) {
            right = rect.right - halfStrokeWidth;
            left = right - Math.max(this.mOriginLength, rect.width());
        } else {
            left = rect.left + halfStrokeWidth;
            right = left + Math.max(rect.width(), this.mOriginLength);
        }
        float halfWidth = this.mOriginWidth / 2.0f;
        canvas.drawRect(left, y - halfWidth, right, y + halfWidth, this.mHighlightPaint);
        canvas.drawRect(left - halfStrokeWidth, y - halfWidth - halfStrokeWidth, right + halfStrokeWidth, y + halfWidth + halfStrokeWidth, this.mBarStrokePaint);
    }

    private void drawIndicator(Canvas canvas, RectF rect) {
        Drawable drawable2 = this.mIndicatorDrawable;
        if (drawable2 == null) {
            return;
        }
        float barHeight = rect.height();
        float y = this.indicatorValue2Height(barHeight, this.getValue()) + rect.top;
        float width = (float)drawable2.getMinimumWidth() * this.mDrawableSizeFactor;
        float height = (float)drawable2.getMinimumHeight() * this.mDrawableSizeFactor;
        int right = this.mAlignLeft ? (int)(rect.left + width) : (int)rect.right;
        int left = (int)((float)right - width);
        int top = (int)(y - height / 2.0f);
        int bottom = (int)((float)top + height);
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    private void drawHighlightValues(Canvas canvas, RectF rect) {
        if (this.mHighlightValues == null) {
            return;
        }
        float barHeight = rect.height();
        float halfStrokeWidth = this.mBarStrokePaint.getStrokeWidth() / 2.0f;
        float halfHighLightWidth = this.mHighlightPaint.getStrokeWidth() / 2.0f;
        for (int highlightValue : this.mHighlightValues) {
            float highlightY = this.indicatorValue2Height(barHeight, highlightValue) + rect.top;
            if (highlightValue == 0 && this.mOriginLength != 0.0f) continue;
            canvas.drawRect(rect.left + halfStrokeWidth, highlightY - halfStrokeWidth - halfHighLightWidth, rect.right - halfStrokeWidth, highlightY + halfStrokeWidth + halfHighLightWidth, this.mBarStrokePaint);
            canvas.drawLine(rect.left + halfStrokeWidth, highlightY, rect.right - halfStrokeWidth, highlightY, this.mHighlightPaint);
        }
    }

    private float indicatorValue2Height(float barHeight, int value) {
        return barHeight * (float)(this.getMaxValue() - value) / (float)(this.getMaxValue() - this.getMinValue());
    }

    private float onBarValue2Height(float barHeight, int value) {
        return (float)value * barHeight / 2.0f / (float)this.mOnBarMaxValue;
    }

    private float innerValue2Height(float barHeight, int value) {
        return (float)value * barHeight / 2.0f / (float)this.mInnerMaxValue;
    }

    private void drawBackground(Canvas canvas, RectF bar) {
        this.mTmpRect.set(bar);
        float halfStrokeWidth = this.mBarStrokePaint.getStrokeWidth() / 2.0f;
        this.mTmpRect.inset(-halfStrokeWidth, -halfStrokeWidth);
        canvas.drawRect(this.mTmpRect, this.mBarStrokePaint);
        canvas.drawRect(bar, this.mBarPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mInvalidDrawable = true;
    }

    protected void onValueChanged(int value) {
        this.mTextPaint.setColor(this.isTextHighLight(value) ? this.mTextHighlightColor : -1);
        this.mText = value + "\u00b0";
    }

    private boolean isTextHighLight(int value) {
        return value == 0 || value == -45 || value == -90;
    }

    public int getOnBarMaxValue() {
        return this.mOnBarMaxValue;
    }

    public int[] getOnBarIndicator() {
        return this.mOnBarIndicator;
    }

    public void setOnBarIndicator(int[] onBarIndicator) {
        this.mOnBarIndicator = onBarIndicator;
    }

    public int[] getHighlightValues() {
        return this.mHighlightValues;
    }

    public void setHighlightValues(int[] highlightValues) {
        this.mHighlightValues = highlightValues;
    }

    protected void init(Context context, AttributeSet attrs) {
        this.initParams(context, attrs);
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public void setMinValue(int minValue) {
        this.mMinValue = minValue;
        this.mInvalidDrawable = true;
        this.postInvalidate();
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        this.mMaxValue = maxValue;
        this.mInvalidDrawable = true;
        this.postInvalidate();
    }

    public int getValue() {
        return this.mValue;
    }

    public void setValue(int value) {
        if (this.mValue != value) {
            this.mValue = value;
            if (this.mValue > this.mMaxValue) {
                this.mValue = this.mMaxValue;
            }
            if (value < this.mMinValue) {
                this.mValue = this.mMinValue;
            }
        }
        this.onValueChanged(value);
        this.postInvalidate();
    }

    public void setGimbalDrawable(ComponentIndexType cameraIndex) {
        int resId = cameraIndex == ComponentIndexType.LEFT_OR_MAIN ? R.drawable.uxsdk_fpv_hsi_pitch_guide_gimbal_3 : (cameraIndex == ComponentIndexType.RIGHT ? R.drawable.uxsdk_fpv_hsi_pitch_guide_gimbal_1 : (cameraIndex == ComponentIndexType.UP ? R.drawable.uxsdk_fpv_hsi_pitch_guide_gimbal_2 : 0));
        this.mIndicatorDrawable = resId == 0 ? null : this.getResources().getDrawable(resId);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
        Log.e((String)"testMM", (String)("updateCameraSource" + this.componentIndexType + "---" + cameraIndex));
        if (this.componentIndexType != cameraIndex) {
            this.componentIndexType = cameraIndex;
            this.onStop();
            this.onStart(cameraIndex);
        }
    }

    private void startListener() {
        if (this.getCameraIndex().value() >= 3 || this.widgetModel.getGimbalAttitudeInDegreesProcessorList().size() <= 0) {
            return;
        }
        this.compositeDisposable.add(this.widgetModel.getGimbalAttitudeInDegreesProcessorList().get(this.getCameraIndex().value()).toFlowable().observeOn(AndroidSchedulers.mainThread()).map(attitude -> (int)Math.round(attitude.getPitch())).subscribeOn(Schedulers.io()).subscribe(this::setValue));
        this.compositeDisposable.add(this.widgetModel.getGimbalAttitudeGimbalAttitudeRangeProcessorList().get(this.getCameraIndex().value()).toFlowable().subscribe(gimbalAttitudeRange -> {
            DoubleMinMax pitch = gimbalAttitudeRange.getPitch();
            if (pitch == null) {
                return;
            }
            int pitchMax = (int)Math.round(pitch.getMax());
            int pitchMin = (int)Math.round(pitch.getMin());
            int absMax = Math.abs(pitchMax);
            int absMin = Math.abs(pitchMin);
            int max = Math.max(absMax, absMin);
            int min = -max;
            this.setMaxValue(max);
            this.setMinValue(min);
            if (absMax < absMin) {
                this.setHighlightValues(new int[]{30, -45, -90});
            } else {
                this.setHighlightValues(new int[]{-30, 45, 90});
            }
        }));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
            this.startListener();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        this.onStop();
    }

    private void onStart(ComponentIndexType cameraIndex) {
        if (this.compositeDisposable != null) {
            this.compositeDisposable.clear();
        } else {
            this.compositeDisposable = new CompositeDisposable();
        }
        this.setGimbalDrawable(cameraIndex);
        this.startListener();
    }

    private void onStop() {
        if (this.compositeDisposable != null && !this.compositeDisposable.isDisposed()) {
            this.compositeDisposable.dispose();
            this.compositeDisposable = null;
        }
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    }

    @Override
    protected void reactToModelChanges() {
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }
}

