/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.TextCell;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.BandWidthSelectWidgetModel;

public class BandWidthWidget
extends ConstraintLayoutWidget<Object> {
    private ChannelSelectionMode mChannelMode = ChannelSelectionMode.UNKNOWN;
    private FrequencyBand mFrequencyBand = FrequencyBand.UNKNOWN;
    private TextCell bandWidthTextCell;
    BandWidthSelectWidgetModel widgetModel = new BandWidthSelectWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());

    public BandWidthWidget(Context context) {
        this(context, null);
    }

    public BandWidthWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BandWidthWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private void updateVisible() {
        if (this.mChannelMode == ChannelSelectionMode.AUTO || this.mFrequencyBand == FrequencyBand.BAND_1_DOT_4G) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        BandWidthWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_sdr_band_width_layout, (ViewGroup)this);
        this.bandWidthTextCell = (TextCell)this.findViewById(R.id.tsc_setting_menu_sdr_band_width);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getBandwidth().subscribe(bandwidth -> {
            if (bandwidth == Bandwidth.BANDWIDTH_10MHZ) {
                this.bandWidthTextCell.setContent("10MHz");
            } else if (bandwidth == Bandwidth.BANDWIDTH_20MHZ) {
                this.bandWidthTextCell.setContent("20MHz");
            } else if (bandwidth == Bandwidth.BANDWIDTH_40MHZ) {
                this.bandWidthTextCell.setContent("40MHz");
            }
        }));
        this.addReaction(this.widgetModel.getChannelSelectionMode().subscribe(value -> {
            this.mChannelMode = value;
            this.updateVisible();
        }));
        this.addReaction(this.widgetModel.getFrequencyBand().subscribe(value -> {
            this.mFrequencyBand = value;
            this.updateVisible();
        }));
    }
}

