/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.AirLinkKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class BandWidthSelectWidgetModel
extends WidgetModel {
    private DataProcessor<Bandwidth> bandwidthDataProcessor = DataProcessor.create(Bandwidth.UNKNOWN);
    private DataProcessor<ChannelSelectionMode> channelSelectionModeDataProcessor = DataProcessor.create(ChannelSelectionMode.UNKNOWN);
    private DataProcessor<FrequencyBand> frequencyBandDataProcessor = DataProcessor.create(FrequencyBand.UNKNOWN);

    protected BandWidthSelectWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyBandwidth), this.bandwidthDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyChannelSelectionMode), this.channelSelectionModeDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyBand), this.frequencyBandDataProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Flowable<Bandwidth> getBandwidth() {
        return this.bandwidthDataProcessor.toFlowableOnUI();
    }

    public Flowable<ChannelSelectionMode> getChannelSelectionMode() {
        return this.channelSelectionModeDataProcessor.toFlowableOnUI();
    }

    public Flowable<FrequencyBand> getFrequencyBand() {
        return this.frequencyBandDataProcessor.toFlowableOnUI();
    }

    public Completable setBandwidth(Bandwidth value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyBandwidth), value);
    }
}

