/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.taplayout;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.ContextUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.taplayout.TabView;

public class QTabView
extends TabView {
    private Context mContext;
    private ImageView mIcon;
    private TextView mTitle;
    private TextView mBadge;
    private int mMinHeight;
    private TabIcon mTabIcon;
    private TabTitle mTabTitle;
    private boolean mChecked;
    private LinearLayout mContainer;
    private GradientDrawable gd;

    public QTabView(Context context) {
        super(context);
        this.mContext = context;
        this.gd = new GradientDrawable();
        this.gd.setColor(-1552832);
        this.mMinHeight = this.dp2px(30.0f);
        this.mTabIcon = new TabIcon.Builder().build();
        this.mTabTitle = new TabTitle.Builder(context).build();
        this.initView();
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            QTabView.mergeDrawableStates((int[])drawableState, (int[])new int[]{0x10100A0});
        }
        return drawableState;
    }

    private void initView() {
        this.initContainer();
        this.initIconView();
        this.initTitleView();
        this.initBadge();
        this.addView((View)this.mContainer);
        this.addView((View)this.mBadge);
    }

    private void initContainer() {
        this.mContainer = new LinearLayout(this.mContext);
        this.mContainer.setOrientation(0);
        this.mContainer.setMinimumHeight(this.mMinHeight);
        this.mContainer.setPadding(this.dp2px(5.0f), this.dp2px(5.0f), this.dp2px(5.0f), this.dp2px(5.0f));
        this.mContainer.setGravity(17);
    }

    private void initBadge() {
        this.mBadge = new TextView(this.mContext);
        FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
        params2.gravity = 53;
        params2.setMargins(0, this.dp2px(5.0f), this.dp2px(5.0f), 0);
        this.mBadge.setLayoutParams((ViewGroup.LayoutParams)params2);
        this.mBadge.setGravity(17);
        this.mBadge.setTextColor(-1);
        this.mBadge.setTextSize(9.0f);
        this.setBadge(0);
    }

    private void initTitleView() {
        if (this.mTitle != null) {
            this.mContainer.removeView((View)this.mTitle);
        }
        this.mTitle = new TextView(this.mContext);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.weight = 1.0f;
        this.mTitle.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTitle.setTextColor(this.mTabTitle.mColorNormal);
        this.mTitle.setTextSize((float)this.mTabTitle.mTitleTextSize);
        this.mTitle.setText((CharSequence)this.mTabTitle.mContent);
        this.mTitle.setGravity(3);
        this.mTitle.setSingleLine();
        this.mTitle.setEllipsize(TextUtils.TruncateAt.END);
        this.mTitle.setPadding(this.dp2px(5.0f), this.dp2px(5.0f), this.dp2px(5.0f), this.dp2px(5.0f));
        this.requestContainerLayout(this.mTabIcon.mIconGravity);
    }

    private void initIconView() {
        if (this.mIcon != null) {
            this.mContainer.removeView((View)this.mIcon);
        }
        this.mIcon = new ImageView(this.mContext);
        int dp = AndUtil.isTabletDevice((Context)ContextUtil.getContext()) ? 10 : 7;
        this.mIcon.setPadding(this.dp2px(dp), this.dp2px(dp), this.dp2px(dp), this.dp2px(dp));
        this.mIcon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.getResources().getDimensionPixelSize(R.dimen.uxsdk_38_dp), this.getResources().getDimensionPixelSize(R.dimen.uxsdk_38_dp));
        this.mIcon.setLayoutParams((ViewGroup.LayoutParams)params);
        if (this.mTabIcon.mNormalIcon != 0) {
            this.mIcon.setImageResource(this.mTabIcon.mNormalIcon);
        } else {
            this.mIcon.setVisibility(8);
        }
        if (this.mTabIcon.mBackground != 0) {
            this.mIcon.setBackgroundResource(this.mTabIcon.mBackground);
        }
        this.requestContainerLayout(this.mTabIcon.mIconGravity);
    }

    private void setBadgeImp(int num) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mBadge.getLayoutParams();
        if (num <= 9) {
            lp.width = this.dp2px(12.0f);
            lp.height = this.dp2px(12.0f);
            this.gd.setShape(1);
            this.mBadge.setPadding(0, 0, 0, 0);
        } else {
            lp.width = -2;
            lp.height = -2;
            this.mBadge.setPadding(this.dp2px(3.0f), 0, this.dp2px(3.0f), 0);
            this.gd.setShape(0);
            this.gd.setCornerRadius((float)this.dp2px(6.0f));
        }
        this.mBadge.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mBadge.setBackgroundDrawable((Drawable)this.gd);
        this.mBadge.setText((CharSequence)String.valueOf(num));
        this.mBadge.setVisibility(0);
    }

    @Override
    public QTabView setBadge(int num) {
        if (num > 0) {
            this.setBadgeImp(num);
        } else {
            this.mBadge.setText((CharSequence)"");
            this.mBadge.setVisibility(8);
        }
        return this;
    }

    public QTabView setIcon(TabIcon icon) {
        if (icon != null) {
            this.mTabIcon = icon;
        }
        this.initIconView();
        this.setChecked(this.mChecked);
        return this;
    }

    public QTabView setTitle(TabTitle title) {
        if (title != null) {
            this.mTabTitle = title;
        }
        this.initTitleView();
        this.setChecked(this.mChecked);
        return this;
    }

    public QTabView setBackground(int resId) {
        super.setBackgroundResource(resId);
        return this;
    }

    private void requestContainerLayout(int gravity) {
        this.mContainer.removeAllViews();
        switch (gravity) {
            case 3: {
                this.mContainer.setOrientation(0);
                this.setIconAndTitle();
                break;
            }
            case 48: {
                this.mContainer.setOrientation(1);
                this.setIconAndTitle();
                break;
            }
            case 5: {
                this.mContainer.setOrientation(0);
                this.setTitleAndICon();
                break;
            }
            case 80: {
                this.mContainer.setOrientation(1);
                this.setTitleAndICon();
                break;
            }
            case 17: {
                this.mContainer.setOrientation(1);
                if (this.mIcon != null) {
                    this.mContainer.addView((View)this.mIcon);
                }
                if (this.mTitle == null || TextUtils.isEmpty((CharSequence)this.mTitle.getText().toString())) break;
                this.mContainer.addView((View)this.mTitle);
                break;
            }
        }
    }

    private void setIconAndTitle() {
        if (this.mIcon != null) {
            this.mContainer.addView((View)this.mIcon);
        }
        if (this.mTitle != null && !TextUtils.isEmpty((CharSequence)this.mTitle.getText().toString())) {
            this.mContainer.addView((View)this.mTitle);
        }
    }

    private void setTitleAndICon() {
        if (this.mTitle != null) {
            this.mContainer.addView((View)this.mTitle);
        }
        if (this.mIcon != null) {
            this.mContainer.addView((View)this.mIcon);
        }
    }

    protected int dp2px(float dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.refreshDrawableState();
        this.setSelected(this.mChecked);
        if (this.mChecked) {
            this.mTitle.setTextColor(this.mTabTitle.mColorSelected);
            if (this.mTabIcon.mSelectedIcon != 0) {
                this.mIcon.setVisibility(0);
                this.mIcon.setImageResource(this.mTabIcon.mSelectedIcon);
            } else {
                this.mIcon.setVisibility(8);
            }
        } else {
            this.mTitle.setTextColor(this.mTabTitle.mColorNormal);
            if (this.mTabIcon.mNormalIcon != 0) {
                this.mIcon.setVisibility(0);
                this.mIcon.setImageResource(this.mTabIcon.mNormalIcon);
            } else {
                this.mIcon.setVisibility(8);
            }
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public static class TabIcon {
        public int mSelectedIcon;
        public int mNormalIcon;
        public int mIconGravity;
        public int mIconWidth;
        public int mIconHeight;
        public int mBackground;

        private TabIcon(int mSelectedIcon, int mNormalIcon, int mIconGravity, int mIconWidth, int mIconHeight, int mBackground) {
            this.mSelectedIcon = mSelectedIcon;
            this.mNormalIcon = mNormalIcon;
            this.mIconGravity = mIconGravity;
            this.mIconWidth = mIconWidth;
            this.mIconHeight = mIconHeight;
            this.mBackground = mBackground;
        }

        public static class Builder {
            private int mSelectedIcon = 0;
            private int mNormalIcon = 0;
            private int mIconGravity = 3;
            private int mIconWidth = -2;
            private int mIconHeight = -2;
            private int mBackground = 0;

            public Builder setIcon(int selectIconResId, int normalIconResId) {
                this.mSelectedIcon = selectIconResId;
                this.mNormalIcon = normalIconResId;
                return this;
            }

            public Builder setBackground(int background) {
                this.mBackground = background;
                return this;
            }

            public Builder setIconSize(int width, int height) {
                this.mIconWidth = width;
                this.mIconHeight = height;
                return this;
            }

            public Builder setIconGravity(int gravity) {
                if (gravity != 3 && gravity != 5 && gravity != 48 && gravity != 80 && gravity != 17) {
                    throw new IllegalStateException("iconGravity only support Gravity.LEFT or Gravity.RIGHT or Gravity.TOP or Gravity.BOTTOM");
                }
                this.mIconGravity = gravity;
                return this;
            }

            public TabIcon build() {
                return new TabIcon(this.mSelectedIcon, this.mNormalIcon, this.mIconGravity, this.mIconWidth, this.mIconHeight, this.mBackground);
            }
        }
    }

    public static class TabTitle {
        public int mColorSelected;
        public int mColorNormal;
        public int mTitleTextSize;
        public String mContent;

        private TabTitle(int mColorSelected, int mColorNormal, int mTitleTextSize, String mContent) {
            this.mColorSelected = mColorSelected;
            this.mColorNormal = mColorNormal;
            this.mTitleTextSize = mTitleTextSize;
            this.mContent = mContent;
        }

        public static class Builder {
            private int mColorSelected;
            private int mColorNormal;
            private int mTitleTextSize;
            private String mContent;

            public Builder(Context context) {
                this.mColorSelected = context.getResources().getColor(R.color.uxsdk_blue_highlight);
                this.mColorNormal = -9079435;
                this.mTitleTextSize = 16;
                this.mContent = null;
            }

            public Builder setTextColor(int colorSelected, int colorNormal) {
                this.mColorSelected = colorSelected;
                this.mColorNormal = colorNormal;
                return this;
            }

            public Builder setTextSize(int sizeSp) {
                this.mTitleTextSize = sizeSp;
                return this;
            }

            public Builder setContent(String content) {
                this.mContent = content;
                return this;
            }

            public TabTitle build() {
                return new TabTitle(this.mColorSelected, this.mColorNormal, this.mTitleTextSize, this.mContent);
            }
        }
    }
}

