/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi.dashboard;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.DJIExecutor;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.hsi.dashboard.FpvStrokeConfig;
import dji.v5.ux.core.util.FontUtils;

public abstract class ScrollableAttributeDashBoard
extends View {
    public static final String TAG = "ScrollableAttributeDashBoard";
    protected static final Rect RECT = new Rect();
    private static final Path PATH = new Path();
    private static final Float DEFAULT_OFFSET_PER_UNIT = Float.valueOf(1.0f);
    private static final int DEFAULT_VISIBLE_CALIBRATION_UNIT_COUNT = 20;
    private static final int SMALL_CALIBRATION_UNIT_COUNT_BETWEEN_TWO_BIG_CALIBRATION_UNIT = 5;
    private static final int DASH_BOARD_ALIGN_LEFT = 0;
    private static final int DASH_BOARD_ALIGN_RIGHT = 1;
    private static final int DEFAULT_DASH_BOARD_ALIGN = 0;
    public static final String VIEW_PROPERTY_CATEGORY_DJI = "dji";
    private final String mAttributeName;
    private float mAttributePadding;
    @ViewDebug.ExportedProperty(category="dji")
    protected final float mAttributeOffsetPerUnit;
    @ViewDebug.ExportedProperty(category="dji")
    private boolean mShowBorder;
    @ViewDebug.ExportedProperty(category="dji")
    private float mBorderRadius;
    private int mBorderColor;
    private float mBorderWidth;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mAttributeCalibrationTextSize;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mAttributeCurrentCalibrationTextSize;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mAttributeUnitTextSize;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mAttributeNameTextSize;
    @ViewDebug.ExportedProperty(category="dji")
    private final float mAttributeMaxValue;
    @ViewDebug.ExportedProperty(category="dji")
    private final float mAttributeMinValue;
    @ViewDebug.ExportedProperty(category="dji", prefix="hsi_", mapping={@ViewDebug.IntToString(from=0, to="left"), @ViewDebug.IntToString(from=1, to="right")})
    private final int mAttributeDashBoardAlign;
    @ViewDebug.ExportedProperty(category="dji", prefix="hsi_")
    private float mCurrentValue;
    private int mCurrentValueColor;
    @ViewDebug.ExportedProperty(category="dji", prefix="hsi_")
    private float mCurrentValuePadding;
    private int mAttributePropertyColor;
    @ViewDebug.ExportedProperty(category="dji")
    protected int mVisibleCalibrationUnitCount;
    @ViewDebug.ExportedProperty(category="dji")
    protected int mFrameworkStrokeWidth;
    @ViewDebug.ExportedProperty(category="dji", formatToHexString=true)
    protected int mFrameworkPrimaryColor;
    @ViewDebug.ExportedProperty(category="dji", formatToHexString=true)
    protected int mFrameworkSecondaryColor;
    @ViewDebug.ExportedProperty(category="dji", formatToHexString=true)
    protected int mFrameworkFrameValueColor;
    @ViewDebug.ExportedProperty(category="dji", formatToHexString=true)
    protected int mFrameworkStrokeColor;
    @ViewDebug.ExportedProperty(category="dji")
    private final boolean mShowFramework;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mFrameworkWidth;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mFrameworkHeight;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mPointerHeight;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mPointerWidth;
    @ViewDebug.ExportedProperty(category="dji")
    protected final int mFrameworkPaddingStart;
    @ViewDebug.ExportedProperty(category="dji")
    protected int mFrameworkPaddingVercital;
    @ViewDebug.ExportedProperty(category="dji")
    protected final int mPointerLineInnerWidth;
    @ViewDebug.ExportedProperty(category="dji")
    protected final int mPointerLineOuterWidth;
    @ViewDebug.ExportedProperty(category="dji")
    protected final int mTextPadding;
    @ViewDebug.ExportedProperty(category="dji")
    protected final int mDegreeLineLongWidth;
    @ViewDebug.ExportedProperty(category="dji")
    protected final int mDegreeLineShortWidth;
    protected Paint mPaint;
    protected Paint mStrokePaint;
    protected Drawable mWaypointIcon;
    private float mCalibrationTextPadding;
    protected float mWaypointIconPadding;
    private final Object mDisplayValueLock = new Object();
    protected DisplayValue mDisplayValue;
    private static final int INVALIDATE_INTERVAL_TIME = 100;
    private static final int MSG_INVALIDATE = 1;
    @NonNull
    private final Handler.Callback mCallback = msg -> {
        if (msg.what == 1) {
            this.invalidate();
            return true;
        }
        return false;
    };
    @Nullable
    private Handler mHandler;
    protected FpvStrokeConfig mStrokeConfig;
    private Typeface mDefaultTypeface;
    private Typeface mCalibrationTextTypeface;
    private final int mStrokeColor = AndUtil.getResColor((int)R.color.uxsdk_black_30_percent);
    private final float mCalibrationLineStrokeWidth = (float)this.getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp) / 2.0f;
    private final int mTextColor = AndUtil.getResColor((int)R.color.uxsdk_green_in_dark);
    protected Handler mDataHandler;
    private Path tmpPath = new Path();

    protected ScrollableAttributeDashBoard(Context context) {
        this(context, null);
    }

    protected ScrollableAttributeDashBoard(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    protected ScrollableAttributeDashBoard(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.mDataHandler = new Handler(DJIExecutor.getLooper());
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScrollableAttributeDashBoard);
        this.mAttributeName = typedArray.getString(R.styleable.ScrollableAttributeDashBoard_uxsdk_name);
        this.mAttributeCalibrationTextSize = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_calibration_text_size, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_text_size_normal_medium));
        this.mPointerWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_pointer_width, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_65_dp));
        this.mPointerHeight = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_pointer_height, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_21_dp));
        this.mFrameworkWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_framework_width, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_25_dp));
        this.mFrameworkHeight = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_framework_height, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_117_dp));
        this.mFrameworkStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_framework_stroke_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp));
        this.mFrameworkPrimaryColor = typedArray.getColor(R.styleable.ScrollableAttributeDashBoard_uxsdk_framework_primary_color, this.getResources().getColor(R.color.uxsdk_green_in_dark));
        this.mFrameworkSecondaryColor = typedArray.getColor(R.styleable.ScrollableAttributeDashBoard_uxsdk_framework_secondary_color, this.getResources().getColor(R.color.uxsdk_green_in_dark_045));
        this.mFrameworkStrokeColor = typedArray.getColor(R.styleable.ScrollableAttributeDashBoard_uxsdk_framework_stroke_color, this.getResources().getColor(R.color.uxsdk_black_30_percent));
        this.mPointerLineInnerWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_pointer_line_inner_width, 0);
        this.mPointerLineOuterWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_pointer_line_outer_width, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_6_dp));
        this.mTextPadding = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_pointer_text_padding, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_2_dp));
        this.mFrameworkPaddingStart = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_calibration_framework_padding_start, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_21_dp));
        this.mFrameworkPaddingVercital = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_calibration_framework_padding_vertical, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_3_dp));
        this.mDegreeLineLongWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_degree_line_long, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_8_dp));
        this.mDegreeLineShortWidth = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_degree_line_short, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_6_dp));
        this.mAttributeUnitTextSize = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_unit_text_size, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_text_size_small));
        this.mAttributeNameTextSize = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_name_text_size, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_text_size_normal));
        this.mAttributeCurrentCalibrationTextSize = typedArray.getDimensionPixelSize(R.styleable.ScrollableAttributeDashBoard_uxsdk_current_calibration_text_size, this.getResources().getDimensionPixelOffset(R.dimen.uxsdk_text_size_medium_large));
        this.mAttributePadding = typedArray.getDimension(R.styleable.ScrollableAttributeDashBoard_uxsdk_padding, this.getResources().getDimension(R.dimen.uxsdk_2_dp));
        this.mAttributeMaxValue = typedArray.getFloat(R.styleable.ScrollableAttributeDashBoard_uxsdk_max_value, Float.MAX_VALUE);
        this.mAttributeMinValue = typedArray.getFloat(R.styleable.ScrollableAttributeDashBoard_uxsdk_min_value, -3.4028235E38f);
        this.mAttributeOffsetPerUnit = typedArray.getFloat(R.styleable.ScrollableAttributeDashBoard_uxsdk_offset_per_unit, DEFAULT_OFFSET_PER_UNIT.floatValue());
        this.mCalibrationTextPadding = typedArray.getDimension(R.styleable.ScrollableAttributeDashBoard_uxsdk_calibration_text_padding, this.getResources().getDimension(R.dimen.uxsdk_2_dp));
        this.mShowBorder = typedArray.getBoolean(R.styleable.ScrollableAttributeDashBoard_uxsdk_show_border, false);
        this.mBorderColor = typedArray.getColor(R.styleable.ScrollableAttributeDashBoard_uxsdk_border_color, this.getResources().getColor(R.color.uxsdk_green_in_dark));
        this.mBorderWidth = typedArray.getDimension(R.styleable.ScrollableAttributeDashBoard_uxsdk_border_width, this.getResources().getDimension(R.dimen.uxsdk_0_6_dp));
        this.mBorderRadius = typedArray.getDimension(R.styleable.ScrollableAttributeDashBoard_uxsdk_border_radius, this.getResources().getDimension(R.dimen.uxsdk_2_dp));
        float currentValue = typedArray.getFloat(R.styleable.ScrollableAttributeDashBoard_uxsdk_current_value, 0.0f);
        this.mCurrentValueColor = typedArray.getColor(R.styleable.ScrollableAttributeDashBoard_uxsdk_current_value_color, -1);
        this.mCurrentValuePadding = typedArray.getDimension(R.styleable.ScrollableAttributeDashBoard_uxsdk_current_value_padding, this.getResources().getDimension(R.dimen.uxsdk_2_dp));
        this.mAttributePropertyColor = typedArray.getColor(R.styleable.ScrollableAttributeDashBoard_uxsdk_property_color, -1);
        this.mAttributeDashBoardAlign = typedArray.getInt(R.styleable.ScrollableAttributeDashBoard_uxsdk_dash_board_align, 0);
        this.mVisibleCalibrationUnitCount = typedArray.getInt(R.styleable.ScrollableAttributeDashBoard_uxsdk_visible_calibration_unit_count, 20);
        this.mShowFramework = typedArray.getBoolean(R.styleable.ScrollableAttributeDashBoard_uxsdk_show_calibration_framework, true);
        typedArray.recycle();
        this.mDefaultTypeface = Typeface.create((String)"sans-serif-condensed", (int)1);
        this.mCalibrationTextTypeface = Typeface.create((String)"sans-serif-condensed", (int)0);
        this.mPaint = new Paint(5);
        this.mStrokePaint = new Paint(5);
        this.restoreTypeface();
        this.mWaypointIconPadding = this.getResources().getDimension(R.dimen.uxsdk_1_dp);
        this.mFrameworkFrameValueColor = this.mFrameworkPrimaryColor;
        this.setCurrentValue(currentValue);
        this.mDisplayValue = new DisplayValue();
        this.mStrokeConfig = new FpvStrokeConfig(context);
    }

    private void restoreTypeface() {
        this.mPaint.setTypeface(this.mDefaultTypeface);
        this.mStrokePaint.setTypeface(this.mDefaultTypeface);
    }

    private void setCalibrationTypeface() {
        this.mPaint.setTypeface(this.mCalibrationTextTypeface);
        this.mStrokePaint.setTypeface(this.mCalibrationTextTypeface);
    }

    protected float getShadowLineStrokeWidth() {
        return this.mStrokeConfig.getStrokeThinWidth();
    }

    protected float getShadowTextStrokeWidth() {
        return this.mStrokeConfig.getStrokeBoldWidth();
    }

    protected int getShadowLineStrokeColor() {
        return this.mStrokeConfig.getStrokeShallowColor();
    }

    protected int getShadowTextStrokeColor() {
        return this.mStrokeConfig.getStrokeDeepColor();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHandler = new Handler(Looper.getMainLooper(), this.mCallback);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.mDataHandler != null) {
            this.mDataHandler.removeCallbacksAndMessages(null);
        }
    }

    @MainThread
    public void setCurrentValue(float currentValue) {
        if (this.isInEditMode()) {
            return;
        }
        if (currentValue > this.mAttributeMaxValue) {
            currentValue = this.mAttributeMaxValue;
        } else if (currentValue < this.mAttributeMinValue) {
            currentValue = this.mAttributeMinValue;
        }
        this.mCurrentValue = currentValue;
        float value = currentValue;
        this.mDataHandler.post(() -> {
            this.calcDisplayValue(value);
            this.updateWidget();
        });
    }

    protected void updateWidget() {
        if (this.mHandler != null && !this.mHandler.hasMessages(1)) {
            this.mHandler.sendEmptyMessageDelayed(1, 100L);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measuredWidth = ScrollableAttributeDashBoard.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int measuredHeight = ScrollableAttributeDashBoard.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        if (widthSpecMode != 0x40000000) {
            int minWidth = this.getMinWidth();
            measuredWidth = widthSpecMode == 0 ? minWidth : Math.min(minWidth, widthSpecSize);
        }
        if (heightSpecMode != 0x40000000) {
            int minHeight = this.getMinHeight();
            measuredHeight = widthSpecMode == 0 ? minHeight : Math.min(minHeight, heightSpecSize);
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected int getMinHeight() {
        if (this.mShowFramework) {
            return this.mFrameworkHeight + this.mFrameworkPaddingVercital * 2;
        }
        return this.mPointerHeight + this.mFrameworkStrokeWidth * 2;
    }

    protected int getMinWidth() {
        return this.mPointerWidth + this.mFrameworkPaddingStart + this.mPointerLineInnerWidth + this.mTextPadding + this.mFrameworkStrokeWidth;
    }

    protected int getFrameworkHeight() {
        return this.mFrameworkHeight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCurrentValue(canvas);
        this.clipPointerArea(canvas);
        if (this.mShowFramework) {
            this.drawCalibration(canvas);
            this.drawCalibrationFramework(canvas);
        }
    }

    protected float getCurrentValue() {
        return this.mCurrentValue;
    }

    protected boolean isShowFramework() {
        return this.mShowFramework;
    }

    private void clipPointerArea(Canvas canvas) {
        int currentAreaOffsetX = this.mFrameworkPaddingStart + this.mPointerLineInnerWidth + this.mTextPadding;
        boolean alginLeft = this.isAlginLeft();
        if (!alginLeft) {
            currentAreaOffsetX = this.getWidth() - currentAreaOffsetX;
        }
        float currentAreaOffsetY = (float)(this.getHeight() - this.mPointerHeight) / 2.0f;
        PATH.reset();
        PATH.addRoundRect(0.0f, 0.0f, alginLeft ? (float)this.mPointerWidth : (float)(-this.mPointerWidth), (float)this.mPointerHeight, this.mBorderRadius, this.mBorderRadius, Path.Direction.CW);
        PATH.offset((float)currentAreaOffsetX, currentAreaOffsetY);
        canvas.clipPath(PATH, Region.Op.DIFFERENCE);
    }

    private void drawCalibrationFramework(Canvas canvas) {
        RectF rect = new RectF();
        this.mPaint.setColor(this.mFrameworkPrimaryColor);
        this.mPaint.setStrokeWidth((float)this.mFrameworkStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        int width = this.getWidth();
        boolean alginLeft = this.isAlginLeft();
        this.tmpPath.reset();
        float strokeWidth = this.mFrameworkStrokeWidth;
        float halfStrokeWidth = (float)this.mFrameworkStrokeWidth / 2.0f;
        float shadowStrokeWidth = this.getShadowLineStrokeWidth();
        float halfShadowWidth = shadowStrokeWidth / 2.0f;
        int offsetX = alginLeft ? this.mFrameworkPaddingStart : width - this.mFrameworkPaddingStart;
        float fw = alginLeft ? (float)this.mFrameworkWidth : (float)(-this.mFrameworkWidth);
        float top = (float)(this.getHeight() - this.mFrameworkHeight) / 2.0f;
        rect.set((float)offsetX, top, (float)offsetX + fw, top + (float)this.mFrameworkHeight);
        this.tmpPath.moveTo(rect.right, rect.top);
        this.tmpPath.lineTo(rect.left, rect.top);
        this.tmpPath.lineTo(rect.left, rect.bottom);
        this.tmpPath.lineTo(rect.right, rect.bottom);
        this.mPaint.setColor(this.mFrameworkPrimaryColor);
        this.mPaint.setStrokeWidth((float)this.mFrameworkStrokeWidth);
        canvas.drawPath(this.tmpPath, this.mPaint);
        rect.inset(-halfShadowWidth - halfStrokeWidth, -halfShadowWidth - halfStrokeWidth);
        this.tmpPath.reset();
        this.tmpPath.moveTo(rect.right, rect.top);
        this.tmpPath.lineTo(rect.left, rect.top);
        this.tmpPath.lineTo(rect.left, rect.bottom);
        this.tmpPath.lineTo(rect.right, rect.bottom);
        rect.inset(shadowStrokeWidth + strokeWidth, shadowStrokeWidth + strokeWidth);
        this.tmpPath.lineTo(rect.right, rect.bottom);
        this.tmpPath.lineTo(rect.left, rect.bottom);
        this.tmpPath.lineTo(rect.left, rect.top);
        this.tmpPath.lineTo(rect.right, rect.top);
        this.tmpPath.close();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mFrameworkStrokeColor);
        this.mPaint.setStrokeWidth(this.getShadowLineStrokeWidth());
        canvas.drawPath(this.tmpPath, this.mPaint);
    }

    private void drawCalibration(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        float centerY = (float)height / 2.0f;
        float calibrationHorizontalMargin = (float)(this.mPointerLineInnerWidth - this.mDegreeLineShortWidth) / 2.0f;
        float offsetMargin = (float)this.mFrameworkHeight / (float)this.mVisibleCalibrationUnitCount;
        float currentPerUnitValue = this.mCurrentValue / this.mAttributeOffsetPerUnit;
        int currentPerUnitCount = (int)currentPerUnitValue;
        float currentValueOffset = (currentPerUnitValue - (float)currentPerUnitCount) * offsetMargin;
        canvas.save();
        this.setCalibrationTypeface();
        float offsetY = currentValueOffset + centerY;
        this.mStrokePaint.setColor(this.mStrokeColor);
        this.mStrokePaint.setStrokeWidth(this.getShadowLineStrokeWidth());
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        boolean alignLeft = this.isAlginLeft();
        int offsetX = alignLeft ? this.mFrameworkPaddingStart : width - this.mFrameworkPaddingStart;
        canvas.translate((float)offsetX, 0.0f);
        for (int i = -this.mVisibleCalibrationUnitCount / 2; i <= this.mVisibleCalibrationUnitCount / 2; ++i) {
            int currentCalibrationUnit = currentPerUnitCount - i;
            float y = (float)i * offsetMargin;
            float calibrationValue = (float)currentCalibrationUnit * this.mAttributeOffsetPerUnit;
            if (this.needDrawValue(calibrationValue)) continue;
            this.mPaint.setColor(this.mFrameworkSecondaryColor);
            this.mPaint.setStrokeWidth(this.mCalibrationLineStrokeWidth);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mStrokePaint.setColor(this.mStrokeColor);
            this.mStrokePaint.setStrokeWidth(this.getShadowLineStrokeWidth());
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            int drawDirect = alignLeft ? 1 : -1;
            float calibrationStartX = calibrationHorizontalMargin * (float)drawDirect;
            boolean drawText = currentCalibrationUnit % 5 == 0;
            int lineLength = drawDirect * (drawText ? this.mDegreeLineLongWidth : this.mDegreeLineShortWidth);
            float lineOffsetY = y + offsetY;
            if (this.lineInFramework(centerY, lineOffsetY)) continue;
            this.drawCalibrationHorizontal(canvas, calibrationStartX, lineOffsetY, lineLength, drawText);
            if (!drawText) continue;
            float textStartX = 2.0f * calibrationStartX + (float)lineLength + (alignLeft ? this.mCalibrationTextPadding : -this.mCalibrationTextPadding);
            this.drawCalibrationText(canvas, offsetMargin, lineOffsetY, calibrationValue, textStartX, alignLeft);
        }
        this.restoreTypeface();
        canvas.restore();
    }

    private boolean needDrawValue(float calibrationValue) {
        return calibrationValue > this.mAttributeMaxValue || calibrationValue < this.mAttributeMinValue;
    }

    private boolean lineInFramework(float centerY, float lineOffsetY) {
        return lineOffsetY > centerY + (float)this.mFrameworkHeight / 2.0f || lineOffsetY < centerY - (float)this.mFrameworkHeight / 2.0f;
    }

    private void drawCalibrationText(Canvas canvas, float offsetMargin, float y, float calibrationValue, float textStartX, boolean alignLeft) {
        this.mPaint.setTextAlign(Paint.Align.LEFT);
        this.mPaint.setTextSize((float)this.mAttributeCalibrationTextSize);
        int value = Math.round(calibrationValue);
        String currentValueString = value < 0 ? (value > -10 ? "-0" + value : "" + value) : (value < 10 ? "0" + value : "" + value);
        this.mPaint.getTextBounds(currentValueString, 0, currentValueString.length(), RECT);
        Paint.FontMetricsInt fontMetrics = this.mPaint.getFontMetricsInt();
        float baseline = (offsetMargin - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
        this.drawTextWithStroke(canvas, currentValueString, alignLeft ? textStartX : textStartX - (float)RECT.width(), baseline + y - offsetMargin / 2.0f, this.getShadowLineStrokeWidth(), this.mStrokeColor, this.mTextColor);
    }

    private void drawCalibrationHorizontal(Canvas canvas, float x, float y, int length, boolean needText) {
        float width = this.mPaint.getStrokeWidth();
        if (y - width / 2.0f < (float)(this.getHeight() - this.mFrameworkHeight) / 2.0f - (float)this.mFrameworkStrokeWidth / 2.0f || y + width / 2.0f > (float)(this.getHeight() + this.mFrameworkHeight) / 2.0f - (float)this.mFrameworkStrokeWidth / 2.0f) {
            return;
        }
        this.mPaint.setColor(needText ? this.mFrameworkFrameValueColor : this.mFrameworkSecondaryColor);
        canvas.drawLine(x, y, x + (float)length, y, this.mPaint);
        canvas.drawRect(x, y - width, x + (float)length, y + width, this.mStrokePaint);
    }

    protected int getIndicatorLineLength() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawCurrentValue(Canvas canvas) {
        DisplayValue displayValue;
        int width = this.getWidth();
        int height = this.getHeight();
        Object object = this.mDisplayValueLock;
        synchronized (object) {
            displayValue = this.mDisplayValue;
        }
        if (displayValue == null || displayValue.mDisplayValue == null || displayValue.mDisplayUnit == null) {
            return;
        }
        String currentValueString = displayValue.mDisplayValue;
        int canvasMark = canvas.save();
        boolean alginLeft = this.isAlginLeft();
        int alginDirect = alginLeft ? 1 : -1;
        int currentAreaOffsetX = this.mFrameworkPaddingStart + this.mPointerLineInnerWidth + this.mTextPadding;
        if (!alginLeft) {
            currentAreaOffsetX = width - currentAreaOffsetX;
        }
        float currentAreaOffsetY = (float)(height - this.mPointerHeight) / 2.0f;
        canvas.translate((float)currentAreaOffsetX, currentAreaOffsetY);
        int currentWidth = this.mPointerWidth * alginDirect;
        if (this.mShowBorder) {
            this.drawCurrentValueLine(canvas, this.mPointerHeight, alginLeft);
            this.drawCurrentBackground(canvas, currentWidth, this.mPointerHeight);
        }
        this.drawCurrentText(canvas, currentValueString, alginLeft);
        this.drawCurrentName(canvas, this.mAttributeName, alginLeft);
        this.drawCurrentUnit(canvas, displayValue.mDisplayUnit, alginLeft);
        canvas.restoreToCount(canvasMark);
    }

    private void drawCurrentValueLine(Canvas canvas, int pointerHeight, boolean alginLeft) {
        float right;
        float left;
        int lineLength = this.mPointerLineInnerWidth + this.mTextPadding;
        if (alginLeft) {
            left = -lineLength;
            right = 0.0f;
        } else {
            left = 0.0f;
            right = lineLength;
        }
        Paint backgroundPaint = this.getBackgroundPaint();
        float lineWidth = backgroundPaint.getStrokeWidth();
        float centerY = (float)pointerHeight / 2.0f;
        float top = centerY - lineWidth / 2.0f;
        float bottom = centerY + lineWidth / 2.0f;
        float lineY = centerY;
        canvas.drawLine(left, lineY, right, lineY, backgroundPaint);
        float strokeWidth = this.getShadowLineStrokeWidth();
        this.mStrokePaint.setColor(this.getShadowLineStrokeColor());
        this.mStrokePaint.setStrokeWidth(strokeWidth);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        lineY = top - strokeWidth / 2.0f;
        canvas.drawLine(left, lineY, right, lineY, backgroundPaint);
        lineY = bottom + strokeWidth / 2.0f;
        canvas.drawLine(left, lineY, right, lineY, backgroundPaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DisplayValue calcDisplayValue(float currentValue) {
        float displayValue = this.getDisplayValue(currentValue);
        boolean shorthand = displayValue + 0.05f > 1000.0f;
        String unit = this.getAttributeUnit();
        String value = String.format(this.getCurrentValueDisplayFormat(shorthand), Float.valueOf(displayValue));
        Object object = this.mDisplayValueLock;
        synchronized (object) {
            if (this.mDisplayValue == null) {
                this.mDisplayValue = new DisplayValue();
            }
            this.mDisplayValue.set(value, unit);
        }
        return this.mDisplayValue;
    }

    private boolean isAlginLeft() {
        return this.mAttributeDashBoardAlign == 0;
    }

    private void drawCurrentUnit(Canvas canvas, String text, boolean alignLeft) {
        Paint paint = this.getUnitPaint();
        float len = paint.measureText(text);
        float unitTextOffset = alignLeft ? (float)this.mPointerWidth - len - this.mAttributePadding : (float)(-this.mPointerWidth) + this.mAttributePadding;
        float unitTextBaseline = FontUtils.getDigitalBaselineFromTop(paint, (float)this.mPointerHeight / 2.0f) + 1.0f;
        this.drawTextWithStroke(canvas, text, unitTextOffset, unitTextBaseline, this.getShadowTextStrokeWidth(), this.getShadowTextStrokeColor(), this.mAttributePropertyColor);
    }

    private Paint getUnitPaint() {
        this.mPaint.setTextSize((float)this.mAttributeUnitTextSize);
        return this.mPaint;
    }

    private void drawCurrentName(Canvas canvas, String text, boolean alginLeft) {
        Paint paint = this.getCurrentNamePaint();
        float len = paint.measureText(text);
        float attrTextOffset = alginLeft ? (float)this.mPointerWidth - len - this.mAttributePadding : (float)(-this.mPointerWidth) + this.mAttributePadding;
        float baseline = FontUtils.getDigitalBaselineFromBottom(this.mPaint, (float)this.mPointerHeight / 2.0f) - 1.0f;
        this.drawTextWithStroke(canvas, text, attrTextOffset, baseline, this.getShadowTextStrokeWidth(), this.getShadowTextStrokeColor(), this.mAttributePropertyColor);
    }

    private Paint getCurrentNamePaint() {
        this.mPaint.setTextSize((float)this.mAttributeNameTextSize);
        this.mPaint.setColor(-1);
        return this.mPaint;
    }

    private void drawCurrentText(Canvas canvas, String text, boolean alginLeft) {
        Paint paint = this.getCurrentPaint();
        float len = paint.measureText(text);
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        float top = fontMetrics.ascent;
        float bottom = fontMetrics.descent;
        float baseline = ((float)this.mPointerHeight - bottom + top) / 2.0f - top;
        float textStart = alginLeft ? this.mCurrentValuePadding : -this.mCurrentValuePadding - len;
        this.drawTextWithStroke(canvas, text, textStart, baseline, this.mStrokeConfig.getStrokeBoldWidth(), this.getShadowTextStrokeColor(), this.mCurrentValueColor);
    }

    private Paint getCurrentPaint() {
        Paint paint = this.mPaint;
        paint.setTextAlign(Paint.Align.LEFT);
        paint.setTextSize((float)this.mAttributeCurrentCalibrationTextSize);
        return paint;
    }

    private void drawCurrentBackground(Canvas canvas, int width, int height) {
        Paint backgroundPaint = this.getBackgroundPaint();
        canvas.drawRoundRect(0.0f, 0.0f, (float)width, (float)height, this.mBorderRadius, this.mBorderRadius, backgroundPaint);
    }

    private Paint getBackgroundPaint() {
        this.mPaint.setColor(this.mBorderColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mBorderWidth);
        return this.mPaint;
    }

    protected void drawTextWithStroke(Canvas canvas, String currentValueString, float textOffset, float baseline, float strokeWidth, int strokeColor, int textColor) {
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(strokeColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawText(currentValueString, textOffset, baseline, this.mPaint);
        this.mPaint.setColor(textColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(currentValueString, textOffset, baseline, this.mPaint);
    }

    protected abstract String getCurrentValueDisplayFormat(boolean var1);

    protected abstract String getAttributeUnit();

    protected abstract float getDisplayValue(float var1);

    protected static class DisplayValue {
        String mDisplayValue;
        String mDisplayUnit;

        protected DisplayValue() {
        }

        public void set(String displayValue, String displayUnit) {
            this.mDisplayValue = displayValue;
            this.mDisplayUnit = displayUnit;
        }
    }
}

