/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.animation;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import dji.v5.ux.core.base.charts.animation.ChartAnimationListener;
import dji.v5.ux.core.base.charts.animation.ChartViewportAnimator;
import dji.v5.ux.core.base.charts.animation.DummyChartAnimationListener;
import dji.v5.ux.core.base.charts.model.Viewport;
import dji.v5.ux.core.base.charts.view.Chart;

@SuppressLint(value={"NewApi"})
public class ChartViewportAnimatorV14
implements ChartViewportAnimator,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private final Chart chart;
    private ValueAnimator animator;
    private Viewport startViewport = new Viewport();
    private Viewport targetViewport = new Viewport();
    private Viewport newViewport = new Viewport();
    private ChartAnimationListener animationListener = new DummyChartAnimationListener();

    public ChartViewportAnimatorV14(Chart chart) {
        this.chart = chart;
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.addListener((Animator.AnimatorListener)this);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animator.setDuration(300L);
    }

    @Override
    public void startAnimation(Viewport startViewport, Viewport targetViewport) {
        this.startViewport.set(startViewport);
        this.targetViewport.set(targetViewport);
        this.animator.setDuration(300L);
        this.animator.start();
    }

    @Override
    public void startAnimation(Viewport startViewport, Viewport targetViewport, long duration) {
        this.startViewport.set(startViewport);
        this.targetViewport.set(targetViewport);
        this.animator.setDuration(duration);
        this.animator.start();
    }

    @Override
    public void cancelAnimation() {
        this.animator.cancel();
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float scale = animation.getAnimatedFraction();
        float diffLeft = (this.targetViewport.left - this.startViewport.left) * scale;
        float diffTop = (this.targetViewport.top - this.startViewport.top) * scale;
        float diffRight = (this.targetViewport.right - this.startViewport.right) * scale;
        float diffBottom = (this.targetViewport.bottom - this.startViewport.bottom) * scale;
        this.newViewport.set(this.startViewport.left + diffLeft, this.startViewport.top + diffTop, this.startViewport.right + diffRight, this.startViewport.bottom + diffBottom);
        this.chart.setCurrentViewport(this.newViewport);
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        this.chart.setCurrentViewport(this.targetViewport);
        this.animationListener.onAnimationFinished();
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void onAnimationStart(Animator animation) {
        this.animationListener.onAnimationStarted();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.animator.isStarted();
    }

    @Override
    public void setChartAnimationListener(ChartAnimationListener animationListener) {
        this.animationListener = null == animationListener ? new DummyChartAnimationListener() : animationListener;
    }
}

