/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationConnetState;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationInfo;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.common.error.RxError;
import dji.v5.manager.aircraft.rtk.station.ConnectedRTKStationInfo;
import dji.v5.manager.aircraft.rtk.station.ConnectedRTKStationInfoListener;
import dji.v5.manager.aircraft.rtk.station.RTKStationConnectStatusListener;
import dji.v5.manager.aircraft.rtk.station.SearchRTKStationListener;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.manager.interfaces.IRTKStationManager;
import dji.v5.ux.accessory.data.DJIRTKBaseStationConnectInfo;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.processors.BehaviorProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020+H\u0014J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001a0.2\u0006\u0010/\u001a\u000200J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a0.J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0.J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u000e\u00104\u001a\n\u0012\u0004\u0012\u000206\u0018\u000105H\u0002J\f\u00107\u001a\u00020\u0015*\u000206H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\"8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180\"8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u001d\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\"8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010#\u00a8\u00068"}, d2={"Ldji/v5/ux/accessory/RTKStationConnectWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "rtkCenter", "Ldji/v5/manager/interfaces/IRTKCenter;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/manager/interfaces/IRTKCenter;)V", "getRtkCenter", "()Ldji/v5/manager/interfaces/IRTKCenter;", "rtkStationManager", "Ldji/v5/manager/interfaces/IRTKStationManager;", "kotlin.jvm.PlatformType", "Ldji/v5/manager/interfaces/IRTKStationManager;", "rtkStationConnectStateProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKStationConnetState;", "stationListProcessor", "Ljava/util/ArrayList;", "Ldji/v5/ux/accessory/data/DJIRTKBaseStationConnectInfo;", "connectedRTKStationInfoProcessor", "Lio/reactivex/rxjava3/processors/BehaviorProcessor;", "Ldji/v5/manager/aircraft/rtk/station/ConnectedRTKStationInfo;", "isMotorOnProcessor", "", "stationConnectStatusListener", "Ldji/v5/manager/aircraft/rtk/station/RTKStationConnectStatusListener;", "connectedRTKStationInfoListener", "Ldji/v5/manager/aircraft/rtk/station/ConnectedRTKStationInfoListener;", "searchStationListener", "Ldji/v5/manager/aircraft/rtk/station/SearchRTKStationListener;", "isMotorOn", "Lio/reactivex/rxjava3/core/Flowable;", "()Lio/reactivex/rxjava3/core/Flowable;", "stationConnectStatus", "getStationConnectStatus", "connectedRTKStationInfo", "getConnectedRTKStationInfo", "stationList", "getStationList", "inSetup", "", "inCleanup", "startConnectToRTKStation", "Lio/reactivex/rxjava3/core/Single;", "stationId", "", "startSearchStationRTK", "stopSearchStationRTK", "convertToDJIRTKBaseStationConnectInfo", "list", "", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKStationInfo;", "toDJIRTKBaseStationConnectInfo", "android-sdk-v5-uxsdk_debug"})
public final class RTKStationConnectWidgetModel
extends WidgetModel {
    @NotNull
    private final IRTKCenter rtkCenter;
    private final IRTKStationManager rtkStationManager;
    @NotNull
    private final DataProcessor<RTKStationConnetState> rtkStationConnectStateProcessor;
    @NotNull
    private final DataProcessor<ArrayList<DJIRTKBaseStationConnectInfo>> stationListProcessor;
    @NotNull
    private final BehaviorProcessor<ConnectedRTKStationInfo> connectedRTKStationInfoProcessor;
    @NotNull
    private final DataProcessor<Boolean> isMotorOnProcessor;
    @NotNull
    private final RTKStationConnectStatusListener stationConnectStatusListener;
    @NotNull
    private final ConnectedRTKStationInfoListener connectedRTKStationInfoListener;
    @NotNull
    private final SearchRTKStationListener searchStationListener;

    public RTKStationConnectWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @NotNull IRTKCenter rtkCenter) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        Intrinsics.checkNotNullParameter((Object)rtkCenter, (String)"rtkCenter");
        super(djiSdkModel, keyedStore);
        this.rtkCenter = rtkCenter;
        this.rtkStationManager = this.rtkCenter.getRTKStationManager();
        DataProcessor<RTKStationConnetState> dataProcessor = DataProcessor.create(RTKStationConnetState.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.rtkStationConnectStateProcessor = dataProcessor;
        DataProcessor dataProcessor2 = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.stationListProcessor = dataProcessor2;
        BehaviorProcessor behaviorProcessor = BehaviorProcessor.create();
        Intrinsics.checkNotNullExpressionValue((Object)behaviorProcessor, (String)"create(...)");
        this.connectedRTKStationInfoProcessor = behaviorProcessor;
        DataProcessor<Boolean> dataProcessor3 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.isMotorOnProcessor = dataProcessor3;
        this.stationConnectStatusListener = arg_0 -> RTKStationConnectWidgetModel.stationConnectStatusListener$lambda$0(this, arg_0);
        this.connectedRTKStationInfoListener = arg_0 -> RTKStationConnectWidgetModel.connectedRTKStationInfoListener$lambda$1(this, arg_0);
        this.searchStationListener = arg_0 -> RTKStationConnectWidgetModel.searchStationListener$lambda$2(this, arg_0);
    }

    @NotNull
    public final IRTKCenter getRtkCenter() {
        return this.rtkCenter;
    }

    @NotNull
    public final Flowable<Boolean> isMotorOn() {
        Flowable<Boolean> flowable = this.isMotorOnProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<RTKStationConnetState> getStationConnectStatus() {
        Flowable<RTKStationConnetState> flowable = this.rtkStationConnectStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<ConnectedRTKStationInfo> getConnectedRTKStationInfo() {
        Flowable flowable = this.connectedRTKStationInfoProcessor.observeOn(SchedulerProvider.computation()).onBackpressureLatest();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"onBackpressureLatest(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<ArrayList<DJIRTKBaseStationConnectInfo>> getStationList() {
        Flowable<ArrayList<DJIRTKBaseStationConnectInfo>> flowable = this.stationListProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), this.isMotorOnProcessor);
        this.rtkStationManager.addRTKStationConnectStatusListener(this.stationConnectStatusListener);
        this.rtkStationManager.addConnectedRTKStationInfoListener(this.connectedRTKStationInfoListener);
        this.rtkStationManager.addSearchRTKStationListener(this.searchStationListener);
    }

    @Override
    protected void inCleanup() {
        this.rtkStationManager.removeRTKStationConnectStatusListener(this.stationConnectStatusListener);
        this.rtkStationManager.removeConnectedRTKStationInfoListener(this.connectedRTKStationInfoListener);
        this.rtkStationManager.removeSearchRTKStationListener(this.searchStationListener);
    }

    @NotNull
    public final Single<Boolean> startConnectToRTKStation(int stationId) {
        Single single = Single.create(arg_0 -> RTKStationConnectWidgetModel.startConnectToRTKStation$lambda$3(this, stationId, arg_0)).subscribeOn(Schedulers.computation());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    @NotNull
    public final Single<Boolean> startSearchStationRTK() {
        Single single = Single.create(arg_0 -> RTKStationConnectWidgetModel.startSearchStationRTK$lambda$4(this, arg_0)).subscribeOn(Schedulers.computation());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    @NotNull
    public final Single<Boolean> stopSearchStationRTK() {
        Single single = Single.create(arg_0 -> RTKStationConnectWidgetModel.stopSearchStationRTK$lambda$5(this, arg_0)).subscribeOn(Schedulers.computation());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    private final ArrayList<DJIRTKBaseStationConnectInfo> convertToDJIRTKBaseStationConnectInfo(List<? extends RTKStationInfo> list) {
        ArrayList<DJIRTKBaseStationConnectInfo> djiRTKBaseStationConnectInfoList;
        block1: {
            djiRTKBaseStationConnectInfoList = new ArrayList<DJIRTKBaseStationConnectInfo>();
            List<? extends RTKStationInfo> list2 = list;
            if (list2 == null) break block1;
            List<? extends RTKStationInfo> it = list2;
            boolean bl = false;
            for (RTKStationInfo rTKStationInfo : list) {
                DJIRTKBaseStationConnectInfo djirtkBaseStationConnectInfo = this.toDJIRTKBaseStationConnectInfo(rTKStationInfo);
                djiRTKBaseStationConnectInfoList.add(djirtkBaseStationConnectInfo);
            }
        }
        return djiRTKBaseStationConnectInfoList;
    }

    private final DJIRTKBaseStationConnectInfo toDJIRTKBaseStationConnectInfo(RTKStationInfo $this$toDJIRTKBaseStationConnectInfo) {
        Integer baseStationId = $this$toDJIRTKBaseStationConnectInfo.getStationId();
        String name = $this$toDJIRTKBaseStationConnectInfo.getStationName();
        Integer signalLevel = $this$toDJIRTKBaseStationConnectInfo.getSignalLevel();
        Intrinsics.checkNotNull((Object)baseStationId);
        int n = baseStationId;
        Intrinsics.checkNotNull((Object)signalLevel);
        int n2 = signalLevel;
        Intrinsics.checkNotNull((Object)name);
        return new DJIRTKBaseStationConnectInfo(n, n2, name, null, 8, null);
    }

    private static final void stationConnectStatusListener$lambda$0(RTKStationConnectWidgetModel this$0, RTKStationConnetState rtkBaseStationConnectState) {
        this$0.rtkStationConnectStateProcessor.onNext(rtkBaseStationConnectState);
    }

    private static final void connectedRTKStationInfoListener$lambda$1(RTKStationConnectWidgetModel this$0, ConnectedRTKStationInfo it) {
        this$0.connectedRTKStationInfoProcessor.onNext((Object)it);
    }

    private static final void searchStationListener$lambda$2(RTKStationConnectWidgetModel this$0, List newConnectInfoList) {
        ArrayList<DJIRTKBaseStationConnectInfo> convertToDJIRTKBaseStationConnectInfo = this$0.convertToDJIRTKBaseStationConnectInfo(newConnectInfoList);
        this$0.stationListProcessor.onNext(convertToDJIRTKBaseStationConnectInfo);
    }

    private static final void startConnectToRTKStation$lambda$3(RTKStationConnectWidgetModel this$0, int $stationId, SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.rtkStationManager.startConnectToRTKStation($stationId, new CommonCallbacks.CompletionCallback((SingleEmitter<Boolean>)it){
            final /* synthetic */ SingleEmitter<Boolean> $it;
            {
                this.$it = $it;
            }

            public void onSuccess() {
                this.$it.onSuccess((Object)true);
            }

            public void onFailure(IDJIError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$it.onError((Throwable)new RxError(error));
            }
        });
    }

    private static final void startSearchStationRTK$lambda$4(RTKStationConnectWidgetModel this$0, SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.rtkStationManager.startSearchRTKStation(new CommonCallbacks.CompletionCallback((SingleEmitter<Boolean>)it){
            final /* synthetic */ SingleEmitter<Boolean> $it;
            {
                this.$it = $it;
            }

            public void onSuccess() {
                this.$it.onSuccess((Object)true);
            }

            public void onFailure(IDJIError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$it.onError((Throwable)new RxError(error));
            }
        });
    }

    private static final void stopSearchStationRTK$lambda$5(RTKStationConnectWidgetModel this$0, SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.rtkStationManager.startSearchRTKStation(new CommonCallbacks.CompletionCallback((SingleEmitter<Boolean>)it){
            final /* synthetic */ SingleEmitter<Boolean> $it;
            {
                this.$it = $it;
            }

            public void onSuccess() {
                this.$it.onSuccess((Object)true);
            }

            public void onFailure(IDJIError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$it.onError((Throwable)new RxError(error));
            }
        });
    }
}

