/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import dji.v5.utils.common.LogUtils;

public class KeyValueDB
extends SQLiteOpenHelper {
    private static final String TAG = LogUtils.getTag((String)KeyValueDB.class.getSimpleName());
    private static Context sContext;
    private static KeyValueDB sInstance;
    private static String DATABASE_NAME;
    private static String DATABASE_TABLE;
    private static int DATABASE_VERSION;
    private static final String KEY = "KEY";
    private static final String VALUE = "VALUE";
    private static final String PERSIST = "PERSIST";
    private static final String KEY_CREATED_AT = "KEY_CREATED_AT";

    private static String createDBQueryBuilder(String database) {
        return "CREATE TABLE " + database + "(" + KEY + " TEXT PRIMARY KEY," + VALUE + " TEXT," + PERSIST + " INTEGER," + KEY_CREATED_AT + " DATETIME)";
    }

    private static String alterTableQueryBuilder(String table, long count, long limit) {
        return "DELETE FROM " + table + " WHERE " + KEY + " IN (SELECT " + KEY + " FROM " + DATABASE_TABLE + " ORDER BY " + KEY_CREATED_AT + " ASC LIMIT " + String.valueOf(count - limit) + ");";
    }

    private static String getState() {
        return "State: " + DATABASE_TABLE + " on " + DATABASE_NAME + " @ " + DATABASE_VERSION;
    }

    public static void init(Context context) {
        KeyValueDB.init(context, DATABASE_NAME, DATABASE_TABLE);
    }

    private static void init(Context context, String databaseName, String tableName) {
        sContext = context;
        KeyValueDB.setDBName(databaseName);
        KeyValueDB.setTableName(tableName);
    }

    private static void setDBName(String name) {
        DATABASE_NAME = name;
    }

    private static void setTableName(String name) {
        DATABASE_TABLE = name;
    }

    private static synchronized KeyValueDB getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new KeyValueDB(context.getApplicationContext());
        }
        return sInstance;
    }

    private KeyValueDB(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    public void onCreate(SQLiteDatabase db) {
        Log.v((String)TAG, (String)"onCreate");
        KeyValueDB.flush(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.v((String)TAG, (String)"onUpgrade");
        KeyValueDB.flush(db);
    }

    public static synchronized long set(String key, String value, Boolean persist) {
        return KeyValueDB.set(sContext, key, value, persist);
    }

    public static synchronized long set(Context context, String key, String value, Boolean persist) {
        Log.i((String)TAG, (String)KeyValueDB.getState());
        key = DatabaseUtils.sqlEscapeString((String)key);
        KeyValueDB dbHelper = KeyValueDB.getInstance(context);
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        long row = 0L;
        if (db != null) {
            ContentValues values = new ContentValues();
            values.put(KEY, key);
            values.put(VALUE, value);
            if (persist.booleanValue()) {
                values.put(PERSIST, Integer.valueOf(1));
            } else {
                values.put(PERSIST, Integer.valueOf(0));
            }
            values.put(KEY_CREATED_AT, "time('now')");
            Object c = null;
            try {
                row = db.replace(DATABASE_TABLE, null, values);
            }
            catch (SQLiteException e) {
                KeyValueDB.flush((Exception)((Object)e), db);
                KeyValueDB.set(context, key, value, persist);
            }
            db.close();
        }
        return row;
    }

    public static synchronized String get(String key, String defaultValue) {
        return KeyValueDB.get(sContext, key, defaultValue);
    }

    public static synchronized String get(Context context, String key, String defaultValue) {
        Log.i((String)TAG, (String)KeyValueDB.getState());
        key = DatabaseUtils.sqlEscapeString((String)key);
        Log.v((String)TAG, (String)("getting cache: " + key));
        KeyValueDB dbHelper = KeyValueDB.getInstance(context);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String value = defaultValue;
        if (db != null) {
            Cursor c = null;
            try {
                c = db.query(DATABASE_TABLE, new String[]{VALUE}, "KEY=?", new String[]{key}, null, null, null);
            }
            catch (SQLiteException e) {
                KeyValueDB.flush((Exception)((Object)e), db);
                KeyValueDB.get(context, key, defaultValue);
            }
            if (c != null) {
                if (c.moveToNext()) {
                    value = c.getString(c.getColumnIndex(VALUE));
                }
                Log.v((String)TAG, (String)("get cache size:" + String.valueOf(value.length())));
                c.close();
            }
            db.close();
        }
        return value;
    }

    public static synchronized long clearCacheByLimit(long limit) {
        return KeyValueDB.clearCacheByLimit(sContext, limit);
    }

    public static synchronized long clearCacheByLimit(Context context, long limit) {
        KeyValueDB dbHelper = KeyValueDB.getInstance(context);
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        long numRows = 0L;
        if (db != null) {
            Cursor c = null;
            try {
                c = db.query(DATABASE_TABLE, null, null, null, null, null, null);
            }
            catch (SQLiteException e) {
                KeyValueDB.flush((Exception)((Object)e), db);
                KeyValueDB.clearCacheByLimit(context, limit);
            }
            if (c != null) {
                long count = c.getCount();
                Log.v((String)TAG, (String)("cached rows" + String.valueOf(count)));
                if (count > limit) {
                    try {
                        db.execSQL(KeyValueDB.alterTableQueryBuilder(DATABASE_TABLE, count, limit));
                    }
                    catch (SQLiteException e) {
                        KeyValueDB.flush((Exception)((Object)e), db);
                        KeyValueDB.clearCacheByLimit(context, limit);
                    }
                }
                numRows = count - (long)c.getCount();
                c.close();
            }
            db.close();
        }
        return numRows;
    }

    private static void flush(Exception e, SQLiteDatabase db) {
        LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
        KeyValueDB.flush(db);
    }

    private static void flush(SQLiteDatabase db) {
        try {
            db.execSQL("DROP TABLE IF EXISTS " + DATABASE_TABLE);
            db.execSQL(KeyValueDB.createDBQueryBuilder(DATABASE_TABLE));
        }
        catch (SQLException e) {
            LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
            throw new IllegalStateException("SQLException while flush. Have to drop caching");
        }
    }

    static {
        DATABASE_NAME = "_app";
        DATABASE_TABLE = "_cache";
        DATABASE_VERSION = 1;
    }
}

