/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.compass;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.hardware.SensorManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.sdk.keyvalue.value.common.Attitude;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.widget.compass.CompassWidgetModel;
import dji.v5.ux.core.widget.compass.GimbalYawView;
import dji.v5.ux.core.widget.compass.VisualCompassView;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\bT\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u00ac\u0001\u00ad\u0001B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010y\u001a\u00020z2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010{\u001a\u00020zH\u0014J\b\u0010|\u001a\u00020zH\u0014J4\u0010}\u001a\u00020z2\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\b2\u0007\u0010\u0081\u0001\u001a\u00020\b2\u0007\u0010\u0082\u0001\u001a\u00020\b2\u0007\u0010\u0083\u0001\u001a\u00020\bH\u0014J\t\u0010\u0084\u0001\u001a\u00020zH\u0014J\u0013\u0010\u0085\u0001\u001a\u00020z2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0002J+\u0010\u0088\u0001\u001a\u00070\u0089\u0001R\u00020\u00002\u0007\u0010\u008a\u0001\u001a\u00020\f2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0002J\u001d\u0010\u008f\u0001\u001a\u00020\f2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0002J+\u0010\u0090\u0001\u001a\u00070\u0089\u0001R\u00020\u00002\u0007\u0010\u008a\u0001\u001a\u00020\f2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020\f2\u0007\u0010\u0092\u0001\u001a\u00020\fH\u0002J\u0012\u0010\u0093\u0001\u001a\u00020z2\u0007\u0010\u008a\u0001\u001a\u00020\fH\u0002J\u0013\u0010\u0094\u0001\u001a\u00020z2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0002J\u001c\u0010\u0097\u0001\u001a\u00020z2\u0007\u0010\u008a\u0001\u001a\u00020\f2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0002J)\u0010\u0098\u0001\u001a\u00020z2\u0007\u0010\u0099\u0001\u001a\u00020\f2\u0007\u0010\u009a\u0001\u001a\u00020\f2\f\u0010\u009b\u0001\u001a\u00070\u0089\u0001R\u00020\u0000H\u0002J\u001b\u0010\u009c\u0001\u001a\u00020z2\u0007\u0010\u009d\u0001\u001a\u00020\f2\u0007\u0010\u009e\u0001\u001a\u00020\fH\u0002J!\u0010\u009f\u0001\u001a\u00020z2\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u00012\f\u0010\u009b\u0001\u001a\u00070\u0089\u0001R\u00020\u0000H\u0002J\n\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001H\u0016J\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001J\u0013\u0010\u00a6\u0001\u001a\u00020z2\n\u0010\u00a7\u0001\u001a\u0005\u0018\u00010\u00a5\u0001J\u0011\u0010)\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010.\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u00101\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u00104\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u00107\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010:\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010=\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010@\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010C\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010F\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010I\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010L\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010O\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010R\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0011\u0010X\u001a\u00020z2\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\bJ\u0019\u0010\u00a9\u0001\u001a\u00020z2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0010\u0010\u00aa\u0001\u001a\t\u0012\u0004\u0012\u00020\u00020\u00ab\u0001H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010,\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010(\"\u0004\b.\u0010*R$\u0010/\u001a\u00020%2\u0006\u0010$\u001a\u00020%8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010(\"\u0004\b1\u0010*R$\u00102\u001a\u00020%2\u0006\u0010+\u001a\u00020%8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010(\"\u0004\b4\u0010*R$\u00105\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010(\"\u0004\b7\u0010*R$\u00108\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010(\"\u0004\b:\u0010*R$\u0010;\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010(\"\u0004\b=\u0010*R$\u0010>\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010(\"\u0004\b@\u0010*R$\u0010A\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010(\"\u0004\bC\u0010*R$\u0010D\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010(\"\u0004\bF\u0010*R$\u0010G\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010(\"\u0004\bI\u0010*R$\u0010J\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010(\"\u0004\bL\u0010*R$\u0010M\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010(\"\u0004\bO\u0010*R$\u0010P\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bQ\u0010(\"\u0004\bR\u0010*R(\u0010S\u001a\u0004\u0018\u00010%2\b\u0010$\u001a\u0004\u0018\u00010%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010(\"\u0004\bU\u0010*R$\u0010V\u001a\u00020%2\u0006\u0010+\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bW\u0010(\"\u0004\bX\u0010*R&\u0010Z\u001a\u00020\f2\b\b\u0001\u0010Y\u001a\u00020\f8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R&\u0010`\u001a\u00020\b2\b\b\u0001\u0010_\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR&\u0010f\u001a\u00020\b2\b\b\u0001\u0010e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bg\u0010b\"\u0004\bh\u0010dR&\u0010j\u001a\u00020\b2\b\b\u0001\u0010i\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bk\u0010b\"\u0004\bl\u0010dR&\u0010m\u001a\u00020\f2\b\b\u0001\u0010Y\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bn\u0010\\\"\u0004\bo\u0010^R&\u0010p\u001a\u00020\b2\b\b\u0001\u0010_\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010b\"\u0004\br\u0010dR&\u0010s\u001a\u00020\b2\b\b\u0001\u0010_\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bt\u0010b\"\u0004\bu\u0010dR&\u0010v\u001a\u00020\b2\b\b\u0001\u0010_\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bw\u0010b\"\u0004\bx\u0010d\u00a8\u0006\u00ae\u0001"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "halfNorthIconWidth", "", "halfAttitudeBallWidth", "paddingWidth", "paddingHeight", "homeImageView", "Landroid/widget/ImageView;", "rcImageView", "aircraftImageView", "gimbalYawImageView", "innerCirclesImageView", "northImageView", "compassBackgroundImageView", "aircraftAttitudeProgressBar", "Landroid/widget/ProgressBar;", "visualCompassView", "Ldji/v5/ux/core/widget/compass/VisualCompassView;", "gimbalYawView", "Ldji/v5/ux/core/widget/compass/GimbalYawView;", "widgetModel", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/widget/compass/CompassWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "icon", "Landroid/graphics/drawable/Drawable;", "homeIcon", "getHomeIcon", "()Landroid/graphics/drawable/Drawable;", "setHomeIcon", "(Landroid/graphics/drawable/Drawable;)V", "background", "homeIconBackground", "getHomeIconBackground", "setHomeIconBackground", "rcLocationIcon", "getRCLocationIcon", "setRCLocationIcon", "rcLocationIconBackground", "getRCLocationIconBackground", "setRCLocationIconBackground", "aircraftIcon", "getAircraftIcon", "setAircraftIcon", "aircraftIconBackground", "getAircraftIconBackground", "setAircraftIconBackground", "gimbalYawIcon", "getGimbalYawIcon", "setGimbalYawIcon", "gimbalYawIconBackground", "getGimbalYawIconBackground", "setGimbalYawIconBackground", "northIcon", "getNorthIcon", "setNorthIcon", "northIconBackground", "getNorthIconBackground", "setNorthIconBackground", "innerCirclesIcon", "getInnerCirclesIcon", "setInnerCirclesIcon", "innerCirclesIconBackground", "getInnerCirclesIconBackground", "setInnerCirclesIconBackground", "compassBackgroundIcon", "getCompassBackgroundIcon", "setCompassBackgroundIcon", "compassBackgroundIconBackground", "getCompassBackgroundIconBackground", "setCompassBackgroundIconBackground", "aircraftAttitudeIcon", "getAircraftAttitudeIcon", "setAircraftAttitudeIcon", "aircraftAttitudeIconBackground", "getAircraftAttitudeIconBackground", "setAircraftAttitudeIconBackground", "strokeWidth", "visualCompassViewStrokeWidth", "getVisualCompassViewStrokeWidth", "()F", "setVisualCompassViewStrokeWidth", "(F)V", "color", "visualCompassViewLineColor", "getVisualCompassViewLineColor", "()I", "setVisualCompassViewLineColor", "(I)V", "interval", "visualCompassViewLineInterval", "getVisualCompassViewLineInterval", "setVisualCompassViewLineInterval", "numberOfLines", "visualCompassViewNumberOfLines", "getVisualCompassViewNumberOfLines", "setVisualCompassViewNumberOfLines", "gimbalYawViewStrokeWidth", "getGimbalYawViewStrokeWidth", "setGimbalYawViewStrokeWidth", "gimbalYawViewYawColor", "getGimbalYawViewYawColor", "setGimbalYawViewYawColor", "gimbalYawViewInvalidColor", "getGimbalYawViewInvalidColor", "setGimbalYawViewInvalidColor", "gimbalYawViewBlinkColor", "getGimbalYawViewBlinkColor", "setGimbalYawViewBlinkColor", "initView", "", "onAttachedToWindow", "onDetachedFromWindow", "onLayout", "changed", "", "left", "top", "right", "bottom", "reactToModelChanges", "onCompassStateUpdated", "compassWidgetState", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CompassWidgetState;", "getSecondGPSLocationCoordinates", "Ldji/v5/ux/core/widget/compass/CompassWidget$ViewCoordinates;", "phoneAzimuth", "state", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CurrentLocationState;", "aircraftState", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$AircraftState;", "getMaxDistance", "getAircraftLocationCoordinates", "calculateScale", "distance", "updateNorthHeadingUI", "updateAircraftAttitudeUI", "aircraftAttitude", "Ldji/sdk/keyvalue/value/common/Attitude;", "updateAircraftHeadingUI", "updateAircraftLocationUI", "maxDistance", "scale", "viewCoordinates", "updateGimbalHeadingUI", "gimbalHeading", "rotationOffset", "updateSecondGPSLocationUI", "type", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CenterType;", "getIdealDimensionRatioString", "", "getGimbalIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "setGimbalIndex", "gimbalIndex", "resourceId", "initAttributes", "getWidgetStateUpdate", "Lio/reactivex/rxjava3/core/Flowable;", "ViewCoordinates", "ModelState", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nCompassWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompassWidget.kt\ndji/v5/ux/core/widget/compass/CompassWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 4 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n*L\n1#1,815:1\n1#2:816\n1#2:825\n1#2:829\n1#2:833\n1#2:837\n1#2:841\n1#2:845\n1#2:849\n1#2:853\n233#3:817\n234#3,2:895\n112#4,5:818\n101#4,2:823\n103#4:826\n101#4,2:827\n103#4:830\n101#4,2:831\n103#4:834\n101#4,2:835\n103#4:838\n101#4,2:839\n103#4:842\n101#4,2:843\n103#4:846\n101#4,2:847\n103#4:850\n101#4,2:851\n103#4:854\n88#4,5:855\n64#4,5:860\n151#4,5:865\n151#4,5:870\n88#4,5:875\n64#4,5:880\n64#4,5:885\n64#4,5:890\n*S KotlinDebug\n*F\n+ 1 CompassWidget.kt\ndji/v5/ux/core/widget/compass/CompassWidget\n*L\n732#1:825\n735#1:829\n738#1:833\n741#1:837\n744#1:841\n747#1:845\n750#1:849\n753#1:853\n728#1:817\n728#1:895,2\n729#1:818,5\n732#1:823,2\n732#1:826\n735#1:827,2\n735#1:830\n738#1:831,2\n738#1:834\n741#1:835,2\n741#1:838\n744#1:839,2\n744#1:842\n747#1:843,2\n747#1:846\n750#1:847,2\n750#1:850\n753#1:851,2\n753#1:854\n756#1:855,5\n759#1:860,5\n762#1:865,5\n765#1:870,5\n768#1:875,5\n771#1:880,5\n774#1:885,5\n777#1:890,5\n*E\n"})
public class CompassWidget
extends ConstraintLayoutWidget<ModelState> {
    private float halfNorthIconWidth;
    private float halfAttitudeBallWidth;
    private float paddingWidth;
    private float paddingHeight;
    @NotNull
    private final ImageView homeImageView;
    @NotNull
    private final ImageView rcImageView;
    @NotNull
    private final ImageView aircraftImageView;
    @NotNull
    private final ImageView gimbalYawImageView;
    @NotNull
    private final ImageView innerCirclesImageView;
    @NotNull
    private final ImageView northImageView;
    @NotNull
    private final ImageView compassBackgroundImageView;
    @NotNull
    private final ProgressBar aircraftAttitudeProgressBar;
    @NotNull
    private final VisualCompassView visualCompassView;
    @NotNull
    private final GimbalYawView gimbalYawView;
    @NotNull
    private final Lazy widgetModel$delegate;

    @JvmOverloads
    public CompassWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            View view = this.findViewById(R.id.imageview_compass_home);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
            this.homeImageView = (ImageView)view;
            View view2 = this.findViewById(R.id.imageview_compass_rc);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
            this.rcImageView = (ImageView)view2;
            View view3 = this.findViewById(R.id.imageview_compass_aircraft);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
            this.aircraftImageView = (ImageView)view3;
            View view4 = this.findViewById(R.id.imageview_gimbal_heading);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
            this.gimbalYawImageView = (ImageView)view4;
            View view5 = this.findViewById(R.id.imageview_inner_circles);
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
            this.innerCirclesImageView = (ImageView)view5;
            View view6 = this.findViewById(R.id.imageview_north);
            Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
            this.northImageView = (ImageView)view6;
            View view7 = this.findViewById(R.id.imageview_compass_background);
            Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(...)");
            this.compassBackgroundImageView = (ImageView)view7;
            View view8 = this.findViewById(R.id.progressbar_compass_attitude);
            Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(...)");
            this.aircraftAttitudeProgressBar = (ProgressBar)view8;
            View view9 = this.findViewById(R.id.visual_compass_view);
            Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"findViewById(...)");
            this.visualCompassView = (VisualCompassView)view9;
            View view10 = this.findViewById(R.id.gimbal_yaw_view);
            Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"findViewById(...)");
            this.gimbalYawView = (GimbalYawView)view10;
            this.widgetModel$delegate = LazyKt.lazy(() -> CompassWidget.widgetModel_delegate$lambda$0(context));
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block0;
            AttributeSet it = attributeSet;
            boolean bl = false;
            this.initAttributes(context, it);
        }
    }

    public /* synthetic */ CompassWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final CompassWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (CompassWidgetModel)lazy.getValue();
    }

    @NotNull
    public final Drawable getHomeIcon() {
        Drawable drawable2 = this.homeImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final void setHomeIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.homeImageView.setImageDrawable(icon);
    }

    @NotNull
    public final Drawable getHomeIconBackground() {
        Drawable drawable2 = this.homeImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setHomeIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.homeImageView.setBackground(background);
    }

    @JvmName(name="getRCLocationIcon")
    @NotNull
    public final Drawable getRCLocationIcon() {
        Drawable drawable2 = this.rcImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    @JvmName(name="setRCLocationIcon")
    public final void setRCLocationIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.rcImageView.setImageDrawable(icon);
    }

    @JvmName(name="getRCLocationIconBackground")
    @NotNull
    public final Drawable getRCLocationIconBackground() {
        Drawable drawable2 = this.rcImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    @JvmName(name="setRCLocationIconBackground")
    public final void setRCLocationIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.rcImageView.setBackground(background);
    }

    @NotNull
    public final Drawable getAircraftIcon() {
        Drawable drawable2 = this.aircraftImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final void setAircraftIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.aircraftImageView.setImageDrawable(icon);
    }

    @NotNull
    public final Drawable getAircraftIconBackground() {
        Drawable drawable2 = this.aircraftImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setAircraftIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.aircraftImageView.setBackground(background);
    }

    @NotNull
    public final Drawable getGimbalYawIcon() {
        Drawable drawable2 = this.gimbalYawImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final void setGimbalYawIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.gimbalYawImageView.setImageDrawable(icon);
    }

    @NotNull
    public final Drawable getGimbalYawIconBackground() {
        Drawable drawable2 = this.gimbalYawImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setGimbalYawIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.gimbalYawImageView.setBackground(background);
    }

    @NotNull
    public final Drawable getNorthIcon() {
        Drawable drawable2 = this.northImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final void setNorthIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.northImageView.setImageDrawable(icon);
    }

    @NotNull
    public final Drawable getNorthIconBackground() {
        Drawable drawable2 = this.northImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setNorthIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.northImageView.setBackground(background);
    }

    @NotNull
    public final Drawable getInnerCirclesIcon() {
        Drawable drawable2 = this.innerCirclesImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final void setInnerCirclesIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.innerCirclesImageView.setImageDrawable(icon);
    }

    @NotNull
    public final Drawable getInnerCirclesIconBackground() {
        Drawable drawable2 = this.innerCirclesImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setInnerCirclesIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.innerCirclesImageView.setBackground(background);
    }

    @NotNull
    public final Drawable getCompassBackgroundIcon() {
        Drawable drawable2 = this.compassBackgroundImageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final void setCompassBackgroundIcon(@NotNull Drawable icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.compassBackgroundImageView.setImageDrawable(icon);
    }

    @NotNull
    public final Drawable getCompassBackgroundIconBackground() {
        Drawable drawable2 = this.compassBackgroundImageView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setCompassBackgroundIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.compassBackgroundImageView.setBackground(background);
    }

    @Nullable
    public final Drawable getAircraftAttitudeIcon() {
        return this.aircraftAttitudeProgressBar.getProgressDrawable();
    }

    public final void setAircraftAttitudeIcon(@Nullable Drawable icon) {
        this.aircraftAttitudeProgressBar.setProgressDrawable(icon);
    }

    @NotNull
    public final Drawable getAircraftAttitudeIconBackground() {
        Drawable drawable2 = this.aircraftAttitudeProgressBar.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setAircraftAttitudeIconBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.aircraftAttitudeProgressBar.setBackground(background);
    }

    @FloatRange(from=1.0, to=4.0)
    public final float getVisualCompassViewStrokeWidth() {
        return this.visualCompassView.getStrokeWidth();
    }

    public final void setVisualCompassViewStrokeWidth(@FloatRange(from=1.0, to=4.0) float strokeWidth) {
        this.visualCompassView.setStrokeWidth(strokeWidth);
    }

    @ColorInt
    public final int getVisualCompassViewLineColor() {
        return this.visualCompassView.getLineColor();
    }

    public final void setVisualCompassViewLineColor(@ColorInt int color2) {
        this.visualCompassView.setLineColor(color2);
    }

    public final int getVisualCompassViewLineInterval() {
        return this.visualCompassView.getLineInterval();
    }

    public final void setVisualCompassViewLineInterval(@IntRange(from=1L) int interval) {
        this.visualCompassView.setLineInterval(interval);
    }

    public final int getVisualCompassViewNumberOfLines() {
        return this.visualCompassView.getNumberOfLines();
    }

    public final void setVisualCompassViewNumberOfLines(@IntRange(from=3L) int numberOfLines) {
        this.visualCompassView.setNumberOfLines(numberOfLines);
    }

    public final float getGimbalYawViewStrokeWidth() {
        return this.gimbalYawView.getStrokeWidth();
    }

    public final void setGimbalYawViewStrokeWidth(@FloatRange(from=1.0, to=4.0) float strokeWidth) {
        this.gimbalYawView.setStrokeWidth(strokeWidth);
    }

    @ColorInt
    public final int getGimbalYawViewYawColor() {
        return this.gimbalYawView.getYawColor();
    }

    public final void setGimbalYawViewYawColor(@ColorInt int color2) {
        this.gimbalYawView.setYawColor(color2);
    }

    @ColorInt
    public final int getGimbalYawViewInvalidColor() {
        return this.gimbalYawView.getInvalidColor();
    }

    public final void setGimbalYawViewInvalidColor(@ColorInt int color2) {
        this.gimbalYawView.setInvalidColor(color2);
    }

    @ColorInt
    public final int getGimbalYawViewBlinkColor() {
        return this.gimbalYawView.getBlinkColor();
    }

    public final void setGimbalYawViewBlinkColor(@ColorInt int color2) {
        this.gimbalYawView.setBlinkColor(color2);
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)R.layout.uxsdk_widget_compass, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.isInEditMode()) {
            CompassWidget compassWidget = this;
            synchronized (compassWidget) {
                boolean bl = false;
                this.gimbalYawImageView.setPivotX((float)this.gimbalYawImageView.getMeasuredWidth() / 2.0f);
                this.gimbalYawImageView.setPivotY((float)this.gimbalYawImageView.getMeasuredHeight());
                Unit unit = Unit.INSTANCE;
            }
            this.halfNorthIconWidth = (float)this.northImageView.getWidth() / (float)2;
            this.halfAttitudeBallWidth = (float)this.compassBackgroundImageView.getWidth() / (float)2;
            this.paddingWidth = (float)this.getWidth() - (float)this.compassBackgroundImageView.getWidth();
            this.paddingHeight = (float)this.getHeight() - (float)this.compassBackgroundImageView.getHeight();
        }
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getCompassWidgetState().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ CompassWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(CompassWidgetModel.CompassWidgetState compassWidgetState) {
                Intrinsics.checkNotNullParameter((Object)compassWidgetState, (String)"compassWidgetState");
                CompassWidget.access$onCompassStateUpdated(this.this$0, compassWidgetState);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ CompassWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompassWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.ProductConnected(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
    }

    private final void onCompassStateUpdated(CompassWidgetModel.CompassWidgetState compassWidgetState) {
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.CompassStateUpdated(compassWidgetState));
        this.updateAircraftAttitudeUI(compassWidgetState.getAircraftAttitude());
        this.updateNorthHeadingUI(compassWidgetState.getPhoneAzimuth());
        this.updateAircraftHeadingUI(compassWidgetState.getPhoneAzimuth(), compassWidgetState.getAircraftAttitude());
        ViewCoordinates viewCoordinates = this.getAircraftLocationCoordinates(compassWidgetState.getPhoneAzimuth(), compassWidgetState.getAircraftState(), compassWidgetState.getCurrentLocationState());
        this.updateAircraftLocationUI(this.getMaxDistance(compassWidgetState.getAircraftState(), compassWidgetState.getCurrentLocationState()), this.calculateScale(compassWidgetState.getAircraftState().getDistance()), viewCoordinates);
        this.updateGimbalHeadingUI(compassWidgetState.getGimbalHeading(), (float)compassWidgetState.getAircraftAttitude().getYaw().doubleValue() - compassWidgetState.getPhoneAzimuth());
        ViewCoordinates secondViewCoordinates = this.getSecondGPSLocationCoordinates(compassWidgetState.getPhoneAzimuth(), compassWidgetState.getCurrentLocationState(), compassWidgetState.getAircraftState());
        this.updateSecondGPSLocationUI(compassWidgetState.getCenterType(), secondViewCoordinates);
    }

    private final ViewCoordinates getSecondGPSLocationCoordinates(float phoneAzimuth, CompassWidgetModel.CurrentLocationState state, CompassWidgetModel.AircraftState aircraftState) {
        double radians = Math.toRadians((double)state.getAngle() + (double)phoneAzimuth);
        float maxDistance = this.getMaxDistance(aircraftState, state);
        float rcHomeDistance = state.getDistance();
        float x = 0.0f;
        float y = 0.0f;
        if (rcHomeDistance == maxDistance) {
            x = (float)Math.cos(radians);
            y = (float)Math.sin(radians);
        } else {
            x = (float)((double)rcHomeDistance * Math.cos(radians) / (double)maxDistance);
            y = (float)((double)rcHomeDistance * Math.sin(radians) / (double)maxDistance);
        }
        return new ViewCoordinates(x, y);
    }

    private final float getMaxDistance(CompassWidgetModel.AircraftState aircraftState, CompassWidgetModel.CurrentLocationState state) {
        float maxDistance = aircraftState.getDistance();
        if (maxDistance < state.getDistance()) {
            maxDistance = state.getDistance();
        }
        if (maxDistance < 400.0f) {
            maxDistance = 400.0f;
        }
        return maxDistance;
    }

    private final ViewCoordinates getAircraftLocationCoordinates(float phoneAzimuth, CompassWidgetModel.AircraftState aircraftState, CompassWidgetModel.CurrentLocationState state) {
        float maxDistance = this.getMaxDistance(aircraftState, state);
        double radians = Math.toRadians((double)aircraftState.getAngle() + (double)phoneAzimuth);
        float aircraftDistance = aircraftState.getDistance();
        float x = 0.0f;
        float y = 0.0f;
        if (aircraftDistance >= maxDistance) {
            x = (float)Math.cos(radians);
            y = (float)Math.sin(radians);
        } else {
            x = (float)((double)aircraftDistance * Math.cos(radians) / (double)maxDistance);
            y = (float)((double)aircraftDistance * Math.sin(radians) / (double)maxDistance);
        }
        return new ViewCoordinates(x, y);
    }

    private final float calculateScale(float distance) {
        float scale = 1.0f;
        if (distance >= 2000.0f) {
            scale = 0.6f;
        } else if (distance > 400.0f) {
            scale = 0.39999998f + ((float)2000 - distance) / (float)1600 * 0.6f;
        }
        return scale;
    }

    private final void updateNorthHeadingUI(float phoneAzimuth) {
        double northRadian = Math.toRadians((double)((float)360 - phoneAzimuth) % 360.0);
        float moveX = (float)((double)(this.halfAttitudeBallWidth + this.paddingWidth / (float)2) + (double)this.halfAttitudeBallWidth * Math.sin(northRadian));
        float moveY = (float)((double)(this.halfAttitudeBallWidth + this.paddingHeight / (float)2) - (double)this.halfAttitudeBallWidth * Math.cos(northRadian));
        this.northImageView.setX(moveX - this.halfNorthIconWidth);
        this.northImageView.setY(moveY - this.halfNorthIconWidth);
    }

    private final void updateAircraftAttitudeUI(Attitude aircraftAttitude) {
        this.aircraftAttitudeProgressBar.setRotation((float)aircraftAttitude.getRoll().doubleValue());
        float tempPitch = (float)(-aircraftAttitude.getPitch().doubleValue()) + (float)90;
        int progress = (int)(tempPitch * (float)100 / (float)180);
        if (progress < 0) {
            progress = 0;
        } else if (progress > 100) {
            progress = 100;
        }
        if (this.aircraftAttitudeProgressBar.getProgress() != progress) {
            this.aircraftAttitudeProgressBar.setProgress(progress);
        }
    }

    private final void updateAircraftHeadingUI(float phoneAzimuth, Attitude aircraftAttitude) {
        this.aircraftImageView.setRotation((float)aircraftAttitude.getYaw().doubleValue() - phoneAzimuth);
    }

    private final void updateAircraftLocationUI(float maxDistance, float scale, ViewCoordinates viewCoordinates) {
        float wRadius = ((float)this.getMeasuredWidth() - this.paddingWidth - (float)this.aircraftImageView.getWidth()) / 2.0f;
        float hRadius = ((float)this.getMeasuredHeight() - this.paddingHeight - (float)this.aircraftImageView.getHeight()) / 2.0f;
        this.aircraftImageView.setX(this.paddingWidth / 2.0f + wRadius + viewCoordinates.getX() * wRadius);
        this.aircraftImageView.setY(this.paddingHeight / 2.0f + hRadius - viewCoordinates.getY() * hRadius);
        this.aircraftImageView.setScaleX(scale);
        this.aircraftImageView.setScaleY(scale);
        this.gimbalYawImageView.setX(this.aircraftImageView.getX() + (float)this.aircraftImageView.getWidth() / 2.0f - (float)this.gimbalYawImageView.getWidth() / 2.0f);
        this.gimbalYawImageView.setY(this.aircraftImageView.getY() + (float)this.aircraftImageView.getHeight() / 2.0f - (float)this.gimbalYawImageView.getHeight());
        this.gimbalYawImageView.setScaleX(scale);
        this.gimbalYawImageView.setScaleY(scale);
        this.visualCompassView.setVisibility(0);
        this.innerCirclesImageView.setVisibility(8);
        this.visualCompassView.setDistance(maxDistance);
    }

    private final void updateGimbalHeadingUI(float gimbalHeading, float rotationOffset) {
        this.gimbalYawView.setYaw(gimbalHeading);
        this.gimbalYawImageView.setRotation(gimbalHeading + rotationOffset);
    }

    private final void updateSecondGPSLocationUI(CompassWidgetModel.CenterType type, ViewCoordinates viewCoordinates) {
        ImageView centerGPSImage = null;
        ImageView secondGPSImage = null;
        if (type == CompassWidgetModel.CenterType.HOME_GPS) {
            centerGPSImage = this.homeImageView;
            secondGPSImage = this.rcImageView;
        } else {
            centerGPSImage = this.rcImageView;
            secondGPSImage = this.homeImageView;
        }
        centerGPSImage.setVisibility(0);
        ViewGroup.LayoutParams layoutParams = centerGPSImage.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        ConstraintLayout.LayoutParams centerParam = (ConstraintLayout.LayoutParams)layoutParams;
        centerParam.leftMargin = 0;
        centerParam.topMargin = 0;
        centerGPSImage.setLayoutParams((ViewGroup.LayoutParams)centerParam);
        if (type != CompassWidgetModel.CenterType.HOME_GPS) {
            secondGPSImage.setVisibility(0);
            float wRadius = ((float)this.getMeasuredWidth() - this.paddingWidth - (float)secondGPSImage.getWidth()) / 2.0f;
            float hRadius = ((float)this.getMeasuredHeight() - this.paddingHeight - (float)secondGPSImage.getHeight()) / 2.0f;
            secondGPSImage.setX(this.paddingWidth / 2.0f + wRadius + viewCoordinates.getX() * wRadius);
            secondGPSImage.setY(this.paddingHeight / 2.0f + hRadius - viewCoordinates.getY() * hRadius);
        } else {
            secondGPSImage.setVisibility(8);
        }
    }

    @Override
    @NotNull
    public String getIdealDimensionRatioString() {
        return ViewExtensions.getString((View)this, R.string.uxsdk_widget_compass_ratio, new Object[0]);
    }

    @NotNull
    public final ComponentIndexType getGimbalIndex() {
        return this.getWidgetModel().getGimbalIndex();
    }

    public final void setGimbalIndex(@Nullable ComponentIndexType gimbalIndex) {
        if (!this.isInEditMode()) {
            this.getWidgetModel().setGimbalIndex(gimbalIndex);
        }
    }

    public final void setHomeIcon(@DrawableRes int resourceId) {
        this.homeImageView.setImageResource(resourceId);
    }

    public final void setHomeIconBackground(@DrawableRes int resourceId) {
        this.homeImageView.setBackgroundResource(resourceId);
    }

    public final void setRCLocationIcon(@DrawableRes int resourceId) {
        this.rcImageView.setImageResource(resourceId);
    }

    public final void setRCLocationIconBackground(@DrawableRes int resourceId) {
        this.rcImageView.setBackgroundResource(resourceId);
    }

    public final void setAircraftIcon(@DrawableRes int resourceId) {
        this.aircraftImageView.setImageResource(resourceId);
    }

    public final void setAircraftIconBackground(@DrawableRes int resourceId) {
        this.aircraftImageView.setBackgroundResource(resourceId);
    }

    public final void setGimbalYawIcon(@DrawableRes int resourceId) {
        this.gimbalYawImageView.setImageResource(resourceId);
    }

    public final void setGimbalYawIconBackground(@DrawableRes int resourceId) {
        this.gimbalYawImageView.setBackgroundResource(resourceId);
    }

    public final void setNorthIcon(@DrawableRes int resourceId) {
        this.northImageView.setImageResource(resourceId);
    }

    public final void setNorthIconBackground(@DrawableRes int resourceId) {
        this.northImageView.setBackgroundResource(resourceId);
    }

    public final void setInnerCirclesIcon(@DrawableRes int resourceId) {
        this.innerCirclesImageView.setImageResource(resourceId);
    }

    public final void setInnerCirclesIconBackground(@DrawableRes int resourceId) {
        this.innerCirclesImageView.setBackgroundResource(resourceId);
    }

    public final void setCompassBackgroundIcon(@DrawableRes int resourceId) {
        this.compassBackgroundImageView.setImageResource(resourceId);
    }

    public final void setCompassBackgroundIconBackground(@DrawableRes int resourceId) {
        this.compassBackgroundImageView.setBackgroundResource(resourceId);
    }

    public final void setAircraftAttitudeIconBackground(@DrawableRes int resourceId) {
        this.aircraftAttitudeProgressBar.setBackgroundResource(resourceId);
    }

    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        TypedArray $this$getIntegerAndUse$iv;
        TypedArray $this$getColorAndUse$iv;
        TypedArray $this$getDimensionAndUse$iv;
        Drawable it;
        boolean bl;
        TypedArray $this$getDrawableAndUse$iv;
        Drawable drawable$iv;
        TypedArray $this$getIntAndUse$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CompassWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl2 = false;
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.CompassWidget_uxsdk_cameraIndex;
        boolean $i$f$getIntAndUse = false;
        int int$iv = $this$getIntAndUse$iv.getInt(index$iv, -1);
        if (int$iv != -1) {
            int it2 = int$iv;
            boolean bl3 = false;
            this.setGimbalIndex(ComponentIndexType.find((int)it2));
        }
        $this$getIntAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_homeIcon;
        boolean $i$f$getDrawableAndUse = false;
        Drawable drawable2 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable2 != null) {
            Drawable it$iv = drawable2;
            bl = false;
            it = drawable$iv;
            boolean bl4 = false;
            this.setHomeIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_rcLocationIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable3 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable3 != null) {
            Drawable it$iv = drawable3;
            bl = false;
            it = drawable$iv;
            boolean bl5 = false;
            this.setRCLocationIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_aircraftIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable4 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable4 != null) {
            Drawable it$iv = drawable4;
            bl = false;
            it = drawable$iv;
            boolean bl6 = false;
            this.setAircraftIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_gimbalYawIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable5 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable5 != null) {
            Drawable it$iv = drawable5;
            bl = false;
            it = drawable$iv;
            boolean bl7 = false;
            this.setGimbalYawIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_northIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable6 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable6 != null) {
            Drawable it$iv = drawable6;
            bl = false;
            it = drawable$iv;
            boolean bl8 = false;
            this.setNorthIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_innerCirclesIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable7 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable7 != null) {
            Drawable it$iv = drawable7;
            bl = false;
            it = drawable$iv;
            boolean bl9 = false;
            this.setInnerCirclesIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_compassBackgroundIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable8 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable8 != null) {
            Drawable it$iv = drawable8;
            bl = false;
            it = drawable$iv;
            boolean bl10 = false;
            this.setCompassBackgroundIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_aircraftAttitudeIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable9 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable9 != null) {
            Drawable it$iv = drawable9;
            bl = false;
            it = drawable$iv;
            boolean bl11 = false;
            this.setAircraftAttitudeIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_visualCompassViewStrokeWidth;
        boolean $i$f$getDimensionAndUse = false;
        float dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it3 = dimension$iv;
            boolean bl12 = false;
            this.setVisualCompassViewStrokeWidth(it3);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_visualCompassViewLineColor;
        boolean $i$f$getColorAndUse = false;
        int colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it4 = colorInt$iv;
            boolean bl13 = false;
            this.setVisualCompassViewLineColor(it4);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_visualCompassViewLineInterval;
        boolean $i$f$getIntegerAndUse = false;
        int intValue$iv = $this$getIntegerAndUse$iv.getInteger(index$iv, -1);
        if (intValue$iv != -1) {
            int it5 = intValue$iv;
            boolean bl14 = false;
            this.setVisualCompassViewLineInterval(it5);
        }
        $this$getIntegerAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_visualCompassViewNumberOfLines;
        $i$f$getIntegerAndUse = false;
        intValue$iv = $this$getIntegerAndUse$iv.getInteger(index$iv, -1);
        if (intValue$iv != -1) {
            int it6 = intValue$iv;
            boolean bl15 = false;
            this.setVisualCompassViewNumberOfLines(it6);
        }
        $this$getIntegerAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_gimbalYawViewStrokeWidth;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it7 = dimension$iv;
            boolean bl16 = false;
            this.setGimbalYawViewStrokeWidth(it7);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_gimbalYawViewYawColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it8 = colorInt$iv;
            boolean bl17 = false;
            this.setGimbalYawViewYawColor(it8);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_gimbalYawViewInvalidColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it9 = colorInt$iv;
            boolean bl18 = false;
            this.setGimbalYawViewInvalidColor(it9);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.CompassWidget_uxsdk_gimbalYawViewBlinkColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it10 = colorInt$iv;
            boolean bl19 = false;
            this.setGimbalYawViewBlinkColor(it10);
        }
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl20 = false;
        $this$use$iv.recycle();
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @JvmOverloads
    public CompassWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CompassWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final CompassWidgetModel widgetModel_delegate$lambda$0(Context $context) {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        Object object = $context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        SensorManager sensorManager = (SensorManager)object;
        Object object2 = $context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.view.WindowManager");
        return new CompassWidgetModel(dJISDKModel, observableInMemoryKeyedStore, sensorManager, (WindowManager)object2);
    }

    public static final /* synthetic */ void access$onCompassStateUpdated(CompassWidget $this, CompassWidgetModel.CompassWidgetState compassWidgetState) {
        $this.onCompassStateUpdated(compassWidgetState);
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(CompassWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "CompassStateUpdated", "Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState$CompassStateUpdated;", "Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState$ProductConnected;", "android-sdk-v5-uxsdk_release"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState$CompassStateUpdated;", "Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState;", "compassWidgetState", "Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CompassWidgetState;", "<init>", "(Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CompassWidgetState;)V", "getCompassWidgetState", "()Ldji/v5/ux/core/widget/compass/CompassWidgetModel$CompassWidgetState;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class CompassStateUpdated
        extends ModelState {
            @NotNull
            private final CompassWidgetModel.CompassWidgetState compassWidgetState;

            public CompassStateUpdated(@NotNull CompassWidgetModel.CompassWidgetState compassWidgetState) {
                Intrinsics.checkNotNullParameter((Object)compassWidgetState, (String)"compassWidgetState");
                super(null);
                this.compassWidgetState = compassWidgetState;
            }

            @NotNull
            public final CompassWidgetModel.CompassWidgetState getCompassWidgetState() {
                return this.compassWidgetState;
            }

            @NotNull
            public final CompassWidgetModel.CompassWidgetState component1() {
                return this.compassWidgetState;
            }

            @NotNull
            public final CompassStateUpdated copy(@NotNull CompassWidgetModel.CompassWidgetState compassWidgetState) {
                Intrinsics.checkNotNullParameter((Object)compassWidgetState, (String)"compassWidgetState");
                return new CompassStateUpdated(compassWidgetState);
            }

            public static /* synthetic */ CompassStateUpdated copy$default(CompassStateUpdated compassStateUpdated, CompassWidgetModel.CompassWidgetState compassWidgetState, int n, Object object) {
                if ((n & 1) != 0) {
                    compassWidgetState = compassStateUpdated.compassWidgetState;
                }
                return compassStateUpdated.copy(compassWidgetState);
            }

            @NotNull
            public String toString() {
                return "CompassStateUpdated(compassWidgetState=" + this.compassWidgetState + ")";
            }

            public int hashCode() {
                return this.compassWidgetState.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CompassStateUpdated)) {
                    return false;
                }
                CompassStateUpdated compassStateUpdated = (CompassStateUpdated)other;
                return Intrinsics.areEqual((Object)this.compassWidgetState, (Object)compassStateUpdated.compassWidgetState);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/compass/CompassWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/compass/CompassWidget$ViewCoordinates;", "", "x", "", "y", "<init>", "(Ldji/v5/ux/core/widget/compass/CompassWidget;FF)V", "getX", "()F", "getY", "android-sdk-v5-uxsdk_release"})
    private final class ViewCoordinates {
        private final float x;
        private final float y;

        public ViewCoordinates(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }
    }
}

