/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.BatteryKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.battery.BatteryOverviewValue;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BatteryGroupInfoWidgetModel
extends WidgetModel {
    private final DataProcessor<Integer> batteryChargeRemainingProcessorForConsume = DataProcessor.create(0);
    private final DataProcessor<Integer> batteryChargeRemainingProcessor = DataProcessor.create(0);
    private final DataProcessor<List<BatteryOverviewValue>> batteryOverviewProcessor = DataProcessor.create(new ArrayList());
    private final DataProcessor<Integer> flightTimeInSecondsProcessor = DataProcessor.create(0);
    private final DataProcessor<Boolean> connectionProcessor = DataProcessor.create(false);
    private final DataProcessor<ProductType> productTypeProcessor = DataProcessor.create(ProductType.UNKNOWN);

    public BatteryGroupInfoWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyChargeRemainingInPercent, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.batteryChargeRemainingProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyBatteryOverviews, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.batteryOverviewProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyFlightTimeInSeconds), this.flightTimeInSecondsProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), this.connectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), this.productTypeProcessor, productType -> {
            if (ProductUtil.isConsumeMachine()) {
                this.batteryOverviewProcessor.onNext(Collections.singletonList(new BatteryOverviewValue(Integer.valueOf(ComponentIndexType.LEFT_OR_MAIN.value()), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0))));
            }
        });
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyChargeRemainingInPercent, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.batteryChargeRemainingProcessorForConsume, integer2 -> {
            if (ProductUtil.isConsumeMachine()) {
                this.batteryChargeRemainingProcessor.onNext((Integer)integer2);
            }
        });
    }

    @Override
    protected void inCleanup() {
    }

    public void reset() {
        this.batteryChargeRemainingProcessor.onNext(0);
        this.batteryOverviewProcessor.onNext(new ArrayList());
        this.flightTimeInSecondsProcessor.onNext(0);
        this.connectionProcessor.onNext(false);
    }

    public Flowable<Integer> getBatteryChargeRemaining() {
        return this.batteryChargeRemainingProcessor.toFlowableOnUI();
    }

    public Flowable<List<BatteryOverviewValue>> getBatteryOverview() {
        return this.batteryOverviewProcessor.toFlowableOnUI();
    }

    public Flowable<Integer> getFlightTimeInSeconds() {
        return this.flightTimeInSecondsProcessor.toFlowableOnUI();
    }

    public Flowable<Boolean> getConnection() {
        return this.connectionProcessor.toFlowableOnUI();
    }
}

