/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.content.Context;
import androidx.annotation.NonNull;
import dji.v5.ux.R;

public final class UnitConversionUtil {
    public static final float TEMPERATURE_K2C = 273.15f;
    private static final float METER_TO_FOOT = 3.2808f;
    private static final float METER_PER_SEC_TO_MILE_PER_HR = 2.2369f;
    private static final float METER_PER_SEC_TO_KM_PER_HR = 3.6f;
    private static final int SEC_TO_MIN = 60;
    private static final int MIN_TO_HOUR = 60;
    private static final int SEC_TO_HOUR = 3600;

    private UnitConversionUtil() {
    }

    public static float convertMetersToFeet(float value) {
        return value * 3.2808f;
    }

    public static double convertMetersToFeet(double value) {
        return value * (double)3.2808f;
    }

    public static float convertFeetToMeters(float value) {
        return value / 3.2808f;
    }

    public static float convertMetersPerSecToMilesPerHr(float value) {
        return value * 2.2369f;
    }

    public static double convertMetersPerSecToMilesPerHr(double value) {
        return value * (double)2.2369f;
    }

    public static float convertMilesPerHrToMetersPerSec(float value) {
        return value / 2.2369f;
    }

    public static float convertMetersPerSecToKmPerHr(float value) {
        return value * 3.6f;
    }

    public static float convertKmPerHrToMetersPerSec(float value) {
        return value / 3.6f;
    }

    public static int[] formatSecondToHour(int second) {
        int[] time = new int[]{second % 60, second / 60 % 60, second / 3600};
        return time;
    }

    public static float kelvinToCelsius(float value) {
        return value - 273.15f;
    }

    public static float celsiusToKelvin(float value) {
        return value + 273.15f;
    }

    public static double celsiusToKelvin(double value) {
        return value + (double)273.15f;
    }

    public static float celsiusToFahrenheit(float value) {
        return value * 1.8f + 32.0f;
    }

    public static double celsiusToFahrenheit(double value) {
        return value * (double)1.8f + 32.0;
    }

    public static float fahrenheitToCelsius(float value) {
        return (value - 32.0f) / 1.8f;
    }

    public static String getSpaceWithUnit(@NonNull Context context, int space) {
        String result = context.getString(R.string.uxsdk_storage_status_remaining_space_mb, new Object[]{space});
        if (space > 1024) {
            result = context.getString(R.string.uxsdk_storage_status_remaining_space_gb, new Object[]{Float.valueOf((float)space / 1024.0f)});
        }
        return result;
    }

    public static enum TemperatureUnitType {
        CELSIUS("CELSIUS", 0),
        FAHRENHEIT("FAHRENHEIT", 1),
        KELVIN("KELVIN", 2);

        private String stringValue;
        private int intValue;
        private static TemperatureUnitType[] values;

        private TemperatureUnitType(String toString, int value) {
            this.stringValue = toString;
            this.intValue = value;
        }

        public static TemperatureUnitType[] getValues() {
            if (values == null) {
                values = TemperatureUnitType.values();
            }
            return values;
        }

        public static TemperatureUnitType find(int value) {
            TemperatureUnitType result = CELSIUS;
            for (int i = 0; i < TemperatureUnitType.getValues().length; ++i) {
                if (TemperatureUnitType.getValues()[i].intValue != value) continue;
                result = TemperatureUnitType.getValues()[i];
                break;
            }
            return result;
        }

        @NonNull
        public String toString() {
            return this.stringValue;
        }

        public int value() {
            return this.intValue;
        }
    }

    public static enum SpeedMetricUnitType {
        METERS_PER_SECOND("MeterPerSec", 0),
        KM_PER_HOUR("KmPerHour", 1);

        private String stringValue;
        private int intValue;
        private static SpeedMetricUnitType[] values;

        private SpeedMetricUnitType(String toString, int value) {
            this.stringValue = toString;
            this.intValue = value;
        }

        public static SpeedMetricUnitType[] getValues() {
            if (values == null) {
                values = SpeedMetricUnitType.values();
            }
            return values;
        }

        public static SpeedMetricUnitType find(int value) {
            SpeedMetricUnitType result = METERS_PER_SECOND;
            for (int i = 0; i < SpeedMetricUnitType.getValues().length; ++i) {
                if (SpeedMetricUnitType.getValues()[i].intValue != value) continue;
                result = SpeedMetricUnitType.getValues()[i];
                break;
            }
            return result;
        }

        @NonNull
        public String toString() {
            return this.stringValue;
        }

        public int value() {
            return this.intValue;
        }
    }

    public static enum UnitType {
        METRIC("Metric", 0),
        IMPERIAL("Imperial", 1);

        private String stringValue;
        private int intValue;
        private static UnitType[] values;

        private UnitType(String toString, int value) {
            this.stringValue = toString;
            this.intValue = value;
        }

        public static UnitType[] getValues() {
            if (values == null) {
                values = UnitType.values();
            }
            return values;
        }

        public static UnitType find(int value) {
            UnitType result = METRIC;
            for (int i = 0; i < UnitType.getValues().length; ++i) {
                if (UnitType.getValues()[i].intValue != value) continue;
                result = UnitType.getValues()[i];
                break;
            }
            return result;
        }

        @NonNull
        public String toString() {
            return this.stringValue;
        }

        public int value() {
            return this.intValue;
        }
    }
}

