/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracontrols.exposuresettingsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.camera.CameraExposureMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.cameracontrols.exposuresettingsindicator.ExposureSettingsIndicatorWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import java.util.HashMap;
import java.util.Map;

public class ExposureSettingsIndicatorWidget
extends FrameLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "ExposureSetIndicWidget";
    private ImageView foregroundImageView;
    private ExposureSettingsIndicatorWidgetModel widgetModel;
    private Map<CameraExposureMode, Drawable> exposureModeDrawableHashMap;
    private int stateChangeResourceId;

    public ExposureSettingsIndicatorWidget(@NonNull Context context) {
        super(context);
    }

    public ExposureSettingsIndicatorWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ExposureSettingsIndicatorWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ExposureSettingsIndicatorWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_exposure_settings_indicator, (ViewGroup)this);
        this.foregroundImageView = (ImageView)this.findViewById(R.id.image_view_exposure_settings_indicator);
        if (!this.isInEditMode()) {
            this.initDefaults();
            this.widgetModel = new ExposureSettingsIndicatorWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.setOnClickListener(this);
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getExposureMode().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    public void onClick(View v) {
        this.updateViewState();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    private void checkAndUpdateUI() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.getExposureMode().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI, UxErrorHandle.logErrorConsumer(TAG, "get exposure mode")));
        }
    }

    private void updateViewState() {
        if (this.stateChangeResourceId != -1 && this.getRootView() != null) {
            View view = this.getRootView().findViewById(this.stateChangeResourceId);
            if (view == null) {
                return;
            }
            view.setVisibility(view.isShown() ? 8 : 0);
        }
    }

    private void initDefaults() {
        this.exposureModeDrawableHashMap = new HashMap<CameraExposureMode, Drawable>();
        this.exposureModeDrawableHashMap.put(CameraExposureMode.APERTURE_PRIORITY, this.getResources().getDrawable(R.drawable.uxsdk_ic_exposure_settings_aperture));
        this.exposureModeDrawableHashMap.put(CameraExposureMode.SHUTTER_PRIORITY, this.getResources().getDrawable(R.drawable.uxsdk_ic_exposure_settings_shutter));
        this.exposureModeDrawableHashMap.put(CameraExposureMode.MANUAL, this.getResources().getDrawable(R.drawable.uxsdk_ic_exposure_settings_manual));
        this.exposureModeDrawableHashMap.put(CameraExposureMode.PROGRAM, this.getResources().getDrawable(R.drawable.uxsdk_ic_exposure_settings_program));
        this.exposureModeDrawableHashMap.put(CameraExposureMode.UNKNOWN, this.getResources().getDrawable(R.drawable.uxsdk_ic_exposure_settings_normal));
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ExposureSettingsIndicatorWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_lensType, 0)));
        }
        this.stateChangeResourceId = typedArray.getResourceId(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_onStateChange, -1);
        Drawable drawable2 = typedArray.getDrawable(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_aperturePriorityModeDrawable);
        if (drawable2 != null) {
            this.setIconByMode(CameraExposureMode.APERTURE_PRIORITY, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_shutterPriorityModeDrawable)) != null) {
            this.setIconByMode(CameraExposureMode.SHUTTER_PRIORITY, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_programModeDrawable)) != null) {
            this.setIconByMode(CameraExposureMode.PROGRAM, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_manualModeDrawable)) != null) {
            this.setIconByMode(CameraExposureMode.MANUAL, drawable2);
        }
        if ((drawable2 = typedArray.getDrawable(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_unknownModeDrawable)) != null) {
            this.setIconByMode(CameraExposureMode.UNKNOWN, drawable2);
        }
        this.setIconBackground(typedArray.getDrawable(R.styleable.ExposureSettingsIndicatorWidget_uxsdk_iconBackground));
        typedArray.recycle();
    }

    private void updateUI(CameraExposureMode exposureMode) {
        switch (exposureMode) {
            case APERTURE_PRIORITY: {
                this.foregroundImageView.setImageDrawable(this.exposureModeDrawableHashMap.get(CameraExposureMode.APERTURE_PRIORITY));
                break;
            }
            case SHUTTER_PRIORITY: {
                this.foregroundImageView.setImageDrawable(this.exposureModeDrawableHashMap.get(CameraExposureMode.SHUTTER_PRIORITY));
                break;
            }
            case MANUAL: {
                this.foregroundImageView.setImageDrawable(this.exposureModeDrawableHashMap.get(CameraExposureMode.MANUAL));
                break;
            }
            case PROGRAM: {
                this.foregroundImageView.setImageDrawable(this.exposureModeDrawableHashMap.get(CameraExposureMode.PROGRAM));
                break;
            }
            default: {
                this.foregroundImageView.setImageDrawable(this.exposureModeDrawableHashMap.get(CameraExposureMode.UNKNOWN));
            }
        }
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setIconByMode(@NonNull CameraExposureMode exposureMode, @DrawableRes int resourceId) {
        this.setIconByMode(exposureMode, this.getResources().getDrawable(resourceId));
    }

    public void setIconByMode(@NonNull CameraExposureMode exposureMode, @Nullable Drawable drawable2) {
        this.exposureModeDrawableHashMap.put(exposureMode, drawable2);
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getIconByMode(@NonNull CameraExposureMode exposureMode) {
        return this.exposureModeDrawableHashMap.get(exposureMode);
    }

    public Drawable getIconBackground() {
        return this.foregroundImageView.getBackground();
    }

    public void setIconBackground(@DrawableRes int resourceId) {
        this.setIconBackground(this.getResources().getDrawable(resourceId));
    }

    public void setIconBackground(@Nullable Drawable drawable2) {
        this.foregroundImageView.setBackground(drawable2);
    }

    public void setStateChangeResourceId(int stateChangeResourceId) {
        this.stateChangeResourceId = stateChangeResourceId;
    }
}

