/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hsi;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.sdk.keyvalue.value.common.Attitude;
import dji.sdk.keyvalue.value.flightcontroller.WindDirection;
import dji.sdk.keyvalue.value.flightcontroller.WindWarning;
import dji.v5.common.utils.UnitUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.hsi.FlashTimer;
import dji.v5.ux.core.ui.hsi.dashboard.SpeedDashBoard;
import dji.v5.ux.core.widget.hsi.SpeedDisplayModel;
import dji.v5.ux.core.widget.hsi.SpeedDisplayWidget;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.functions.Function4;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u001e\u001a\u00020\u001cH\u0014J\b\u0010\u001f\u001a\u00020\u001cH\u0014J\b\u0010 \u001a\u00020\u001cH\u0014J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\bH\u0002J(\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020'H\u0002J\u0018\u0010-\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020)H\u0002J\u0012\u0010/\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u0010\u0010\u000b\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ldji/v5/ux/core/widget/hsi/SpeedDisplayWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mWindTextColor", "mTvWsValue", "Landroid/widget/TextView;", "mIsAnimating", "mSpeedDashBoard", "Ldji/v5/ux/core/ui/hsi/dashboard/SpeedDashBoard;", "getMSpeedDashBoard", "()Ldji/v5/ux/core/ui/hsi/dashboard/SpeedDashBoard;", "setMSpeedDashBoard", "(Ldji/v5/ux/core/ui/hsi/dashboard/SpeedDashBoard;)V", "mCompositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "mListener", "Ldji/v5/ux/core/ui/hsi/FlashTimer$Listener;", "widgetModel", "Ldji/v5/ux/core/widget/hsi/SpeedDisplayModel;", "initView", "", "loadLayout", "onAttachedToWindow", "onDetachedFromWindow", "reactToModelChanges", "getIdealDimensionRatioString", "", "postTvWsVisibility", "visible", "updateWindStatus", "windSpeed", "", "fcWindDirectionStatus", "Ldji/sdk/keyvalue/value/flightcontroller/WindDirection;", "fcWindWarning", "Ldji/sdk/keyvalue/value/flightcontroller/WindWarning;", "aircraftDegree", "getWindDirectionText", "windDirection", "getWindDegree", "Companion", "android-sdk-v5-uxsdk_debug"})
public class SpeedDisplayWidget
extends ConstraintLayoutWidget<Boolean> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ViewDebug.ExportedProperty(category="dji", formatToHexString=true)
    private final int mWindTextColor;
    @Nullable
    private TextView mTvWsValue;
    private boolean mIsAnimating;
    @Nullable
    private SpeedDashBoard mSpeedDashBoard;
    @NotNull
    private final CompositeDisposable mCompositeDisposable;
    @Nullable
    private FlashTimer.Listener mListener;
    @NotNull
    private final SpeedDisplayModel widgetModel;
    private static final String TAG = SpeedDisplayWidget.class.getSimpleName();

    @JvmOverloads
    public SpeedDisplayWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mCompositeDisposable = new CompositeDisposable();
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        this.widgetModel = new SpeedDisplayModel(dJISDKModel, observableInMemoryKeyedStore);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SpeedDisplayWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        this.mWindTextColor = typedArray2.getColor(R.styleable.SpeedDisplayWidget_android_textColor, -1);
        typedArray2.recycle();
    }

    public /* synthetic */ SpeedDisplayWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final SpeedDashBoard getMSpeedDashBoard() {
        return this.mSpeedDashBoard;
    }

    public final void setMSpeedDashBoard(@Nullable SpeedDashBoard speedDashBoard) {
        this.mSpeedDashBoard = speedDashBoard;
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.loadLayout(context);
        this.mSpeedDashBoard = (SpeedDashBoard)this.findViewById(R.id.pfd_speed_dash_board);
        this.mTvWsValue = (TextView)this.findViewById(R.id.pfd_ws_value);
    }

    protected void loadLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_liveview_pfd_speed_display_widget, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            SpeedDashBoard speedDashBoard = this.mSpeedDashBoard;
            if (speedDashBoard != null) {
                speedDashBoard.setModel(this.widgetModel);
            }
            this.widgetModel.setup();
        }
        this.mListener = arg_0 -> SpeedDisplayWidget.onAttachedToWindow$lambda$0(this, arg_0);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCompositeDisposable.dispose();
        FlashTimer.INSTANCE.removeListener(this.mListener);
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    protected void reactToModelChanges() {
        this.mCompositeDisposable.add(Flowable.combineLatest((Publisher)((Publisher)this.widgetModel.getWindSpeedProcessor().toFlowable()), (Publisher)((Publisher)this.widgetModel.getWindDirectionProcessor().toFlowable()), (Publisher)((Publisher)this.widgetModel.getWindWarningProcessor().toFlowable()), (Publisher)((Publisher)this.widgetModel.getAircraftAttitudeProcessor().toFlowable()), (Function4)new Function4(this){
            final /* synthetic */ SpeedDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final Boolean apply(int windSpeed, WindDirection fcWindDirectionStatus, WindWarning fcWindWarning, Attitude attitude) {
                Intrinsics.checkNotNullParameter((Object)fcWindDirectionStatus, (String)"fcWindDirectionStatus");
                Intrinsics.checkNotNullParameter((Object)fcWindWarning, (String)"fcWindWarning");
                Intrinsics.checkNotNullParameter((Object)attitude, (String)"attitude");
                float yaw = (float)attitude.getYaw().doubleValue();
                float aircraftDegree = yaw + (yaw < 0.0f ? 359.0f : 0.0f);
                AndroidSchedulers.mainThread().scheduleDirect(() -> reactToModelChanges.1.apply$lambda$0(this.this$0, windSpeed, fcWindDirectionStatus, fcWindWarning, aircraftDegree));
                return true;
            }

            private static final void apply$lambda$0(SpeedDisplayWidget this$0, int $windSpeed, WindDirection $fcWindDirectionStatus, WindWarning $fcWindWarning, float $aircraftDegree) {
                SpeedDisplayWidget.access$updateWindStatus(this$0, (float)$windSpeed / (float)10, $fcWindDirectionStatus, $fcWindWarning, $aircraftDegree);
            }
        }).subscribe());
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    private final void postTvWsVisibility(int visible) {
        block0: {
            TextView textView = this.mTvWsValue;
            if (textView == null) break block0;
            textView.post(() -> SpeedDisplayWidget.postTvWsVisibility$lambda$1(this, visible));
        }
    }

    private final void updateWindStatus(float windSpeed, WindDirection fcWindDirectionStatus, WindWarning fcWindWarning, float aircraftDegree) {
        boolean shouldBlink;
        float value = UnitUtils.transFormSpeedIntoDifferentUnit((float)windSpeed);
        Locale locale = Locale.ENGLISH;
        String string2 = "WS %04.1f %s";
        Object[] objectArray = new Object[]{Float.valueOf(value), this.getWindDirectionText(fcWindDirectionStatus, aircraftDegree)};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        String textStr = string3;
        TextView textView = this.mTvWsValue;
        if (!Intrinsics.areEqual((Object)textStr, (Object)String.valueOf(textView != null ? textView.getText() : null))) {
            TextView textView2 = this.mTvWsValue;
            Intrinsics.checkNotNull((Object)textView2);
            textView2.setText((CharSequence)textStr);
        }
        if (fcWindWarning == WindWarning.LEVEL_2) {
            TextView textView3 = this.mTvWsValue;
            Intrinsics.checkNotNull((Object)textView3);
            textView3.setTextColor(this.getResources().getColor(R.color.uxsdk_pfd_barrier_color));
        } else if (fcWindWarning == WindWarning.LEVEL_1) {
            TextView textView4 = this.mTvWsValue;
            if (textView4 != null) {
                textView4.setTextColor(this.getResources().getColor(R.color.uxsdk_pfd_avoidance_color));
            }
        } else {
            TextView textView5 = this.mTvWsValue;
            if (textView5 != null) {
                textView5.setTextColor(this.mWindTextColor);
            }
        }
        boolean bl = shouldBlink = fcWindWarning == WindWarning.LEVEL_2;
        if (shouldBlink && !this.mIsAnimating) {
            this.mIsAnimating = true;
            FlashTimer.INSTANCE.addListener(this.mListener);
        } else if (!shouldBlink && this.mIsAnimating) {
            this.mIsAnimating = false;
            FlashTimer.INSTANCE.removeListener(this.mListener);
            this.postTvWsVisibility(0);
        }
    }

    private final String getWindDirectionText(WindDirection fcWindDirectionStatus, float aircraftDegree) {
        float delta;
        if (fcWindDirectionStatus == WindDirection.WINDLESS) {
            return " ";
        }
        WindDirection toAircraft = null;
        delta += (delta = (float)this.getWindDegree(fcWindDirectionStatus) - aircraftDegree) >= 0.0f ? 0.0f : 360.0f;
        float start = 22.5f;
        float offset = 45.0f;
        for (int i = 2; i < 9; ++i) {
            if (delta >= start && delta < start + offset) {
                toAircraft = WindDirection.find((int)i);
                break;
            }
            start += offset;
        }
        if (toAircraft == null) {
            toAircraft = WindDirection.NORTH;
        }
        return this.getWindDirectionText(toAircraft);
    }

    private final String getWindDirectionText(WindDirection windDirection) {
        return switch (WhenMappings.$EnumSwitchMapping$0[windDirection.ordinal()]) {
            case 1 -> "\u2190";
            case 2 -> "\u2192";
            case 3 -> "\u2193";
            case 4 -> "\u2191";
            case 5 -> "\u2199";
            case 6 -> "\u2198";
            case 7 -> "\u2196";
            case 8 -> "\u2197";
            case 9 -> " ";
            default -> " ";
        };
    }

    private final int getWindDegree(WindDirection fcWindDirectionStatus) {
        int n;
        if (fcWindDirectionStatus == null) {
            n = 0;
        } else {
            WindDirection windDirection = fcWindDirectionStatus;
            switch (WhenMappings.$EnumSwitchMapping$0[windDirection.ordinal()]) {
                case 1: {
                    n = 90;
                    break;
                }
                case 2: {
                    n = 270;
                    break;
                }
                case 4: {
                    n = 180;
                    break;
                }
                case 5: {
                    n = 45;
                    break;
                }
                case 6: {
                    n = 315;
                    break;
                }
                case 7: {
                    n = 135;
                    break;
                }
                case 8: {
                    n = 225;
                    break;
                }
                case 3: {
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    @JvmOverloads
    public SpeedDisplayWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SpeedDisplayWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void onAttachedToWindow$lambda$0(SpeedDisplayWidget this$0, boolean show) {
        int visible = this$0.mIsAnimating && !show ? 4 : 0;
        TextView textView = this$0.mTvWsValue;
        if (!(textView != null ? textView.getVisibility() == visible : false)) {
            this$0.postTvWsVisibility(visible);
        }
    }

    private static final void postTvWsVisibility$lambda$1(SpeedDisplayWidget this$0, int $visible) {
        block0: {
            TextView textView = this$0.mTvWsValue;
            if (textView == null) break block0;
            textView.setVisibility($visible);
        }
    }

    public static final /* synthetic */ void access$updateWindStatus(SpeedDisplayWidget $this, float windSpeed, WindDirection fcWindDirectionStatus, WindWarning fcWindWarning, float aircraftDegree) {
        $this.updateWindStatus(windSpeed, fcWindDirectionStatus, fcWindWarning, aircraftDegree);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/widget/hsi/SpeedDisplayWidget$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WindDirection.values().length];
            try {
                nArray[WindDirection.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.NORTH_EAST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.NORTH_WEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.SOUTH_EAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.SOUTH_WEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindDirection.WINDLESS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

