/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.distancerc;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.remotecontroller.RcGPSInfo;
import dji.v5.utils.common.LocationUtil;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferenceKeys;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.MathExtensions;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "rcGPSDataProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/remotecontroller/RcGPSInfo;", "unitTypeDataProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "aircraftLocationProcessor", "Ldji/sdk/keyvalue/value/common/LocationCoordinate2D;", "kotlin.jvm.PlatformType", "distanceRCStateProcessor", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState;", "distanceRCState", "Lio/reactivex/rxjava3/core/Flowable;", "getDistanceRCState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "updateStates", "inCleanup", "DistanceRCState", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nDistanceRCWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistanceRCWidgetModel.kt\ndji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class DistanceRCWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<RcGPSInfo> rcGPSDataProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeDataProcessor;
    @NotNull
    private final DataProcessor<LocationCoordinate2D> aircraftLocationProcessor;
    @NotNull
    private final DataProcessor<DistanceRCState> distanceRCStateProcessor;

    public DistanceRCWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.preferencesManager = preferencesManager;
        DataProcessor<RcGPSInfo> dataProcessor = DataProcessor.create(new RcGPSInfo());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.rcGPSDataProcessor = dataProcessor;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor2 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.unitTypeDataProcessor = dataProcessor2;
        DataProcessor<LocationCoordinate2D> dataProcessor3 = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.aircraftLocationProcessor = dataProcessor3;
        DataProcessor<DistanceRCState.ProductDisconnected> dataProcessor4 = DataProcessor.create(DistanceRCState.ProductDisconnected.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.distanceRCStateProcessor = dataProcessor4;
    }

    @NotNull
    public final Flowable<DistanceRCState> getDistanceRCState() {
        Flowable<DistanceRCState> flowable = this.distanceRCStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        block1: {
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation), this.aircraftLocationProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcGPSInfo), this.rcGPSDataProcessor);
            this.bindDataProcessor(GlobalPreferenceKeys.create("UnitType"), this.unitTypeDataProcessor);
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface != null) {
                globalPreferencesInterface.setUpListener();
            }
            GlobalPreferencesInterface globalPreferencesInterface2 = this.preferencesManager;
            if (globalPreferencesInterface2 == null) break block1;
            GlobalPreferencesInterface it = globalPreferencesInterface2;
            boolean bl = false;
            this.unitTypeDataProcessor.onNext(it.getUnitType());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateStates() {
        if (!((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            this.distanceRCStateProcessor.onNext(DistanceRCState.ProductDisconnected.INSTANCE);
            return;
        }
        Double d = this.aircraftLocationProcessor.getValue().getLatitude();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getLatitude(...)");
        if (LocationUtil.checkLatitude((double)((Number)d).doubleValue())) {
            Double d2 = this.aircraftLocationProcessor.getValue().getLongitude();
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"getLongitude(...)");
            if (LocationUtil.checkLongitude((double)((Number)d2).doubleValue()) && this.rcGPSDataProcessor.getValue().getIsValid().booleanValue()) {
                Double d3 = this.aircraftLocationProcessor.getValue().getLatitude();
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"getLatitude(...)");
                double d4 = ((Number)d3).doubleValue();
                Double d5 = this.aircraftLocationProcessor.getValue().getLongitude();
                Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"getLongitude(...)");
                double d6 = ((Number)d5).doubleValue();
                Double d7 = this.rcGPSDataProcessor.getValue().getLocation().getLatitude();
                Intrinsics.checkNotNullExpressionValue((Object)d7, (String)"getLatitude(...)");
                double d8 = ((Number)d7).doubleValue();
                Double d9 = this.rcGPSDataProcessor.getValue().getLocation().getLongitude();
                Intrinsics.checkNotNullExpressionValue((Object)d9, (String)"getLongitude(...)");
                float f = LocationUtil.distanceBetween((double)d4, (double)d6, (double)d8, (double)((Number)d9).doubleValue());
                UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
                float f2 = MathExtensions.toDistance(f, unitType);
                UnitConversionUtil.UnitType unitType2 = this.unitTypeDataProcessor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType2), (String)"getValue(...)");
                this.distanceRCStateProcessor.onNext(new DistanceRCState.CurrentDistanceToRC(f2, unitType2));
                return;
            }
        }
        this.distanceRCStateProcessor.onNext(DistanceRCState.LocationUnavailable.INSTANCE);
    }

    @Override
    protected void inCleanup() {
        block0: {
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.cleanup();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState;", "", "<init>", "()V", "ProductDisconnected", "LocationUnavailable", "CurrentDistanceToRC", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState$CurrentDistanceToRC;", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState$LocationUnavailable;", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState$ProductDisconnected;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class DistanceRCState {
        private DistanceRCState() {
        }

        public /* synthetic */ DistanceRCState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState$CurrentDistanceToRC;", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState;", "distance", "", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(FLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getDistance", "()F", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class CurrentDistanceToRC
        extends DistanceRCState {
            private final float distance;
            @NotNull
            private final UnitConversionUtil.UnitType unitType;

            public CurrentDistanceToRC(float distance, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                super(null);
                this.distance = distance;
                this.unitType = unitType;
            }

            public final float getDistance() {
                return this.distance;
            }

            @NotNull
            public final UnitConversionUtil.UnitType getUnitType() {
                return this.unitType;
            }

            public final float component1() {
                return this.distance;
            }

            @NotNull
            public final UnitConversionUtil.UnitType component2() {
                return this.unitType;
            }

            @NotNull
            public final CurrentDistanceToRC copy(float distance, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                return new CurrentDistanceToRC(distance, unitType);
            }

            public static /* synthetic */ CurrentDistanceToRC copy$default(CurrentDistanceToRC currentDistanceToRC, float f, UnitConversionUtil.UnitType unitType, int n, Object object) {
                if ((n & 1) != 0) {
                    f = currentDistanceToRC.distance;
                }
                if ((n & 2) != 0) {
                    unitType = currentDistanceToRC.unitType;
                }
                return currentDistanceToRC.copy(f, unitType);
            }

            @NotNull
            public String toString() {
                return "CurrentDistanceToRC(distance=" + this.distance + ", unitType=" + this.unitType + ")";
            }

            public int hashCode() {
                int result = Float.hashCode(this.distance);
                result = result * 31 + this.unitType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CurrentDistanceToRC)) {
                    return false;
                }
                CurrentDistanceToRC currentDistanceToRC = (CurrentDistanceToRC)other;
                if (Float.compare(this.distance, currentDistanceToRC.distance) != 0) {
                    return false;
                }
                return this.unitType == currentDistanceToRC.unitType;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState$LocationUnavailable;", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class LocationUnavailable
        extends DistanceRCState {
            @NotNull
            public static final LocationUnavailable INSTANCE = new LocationUnavailable();

            private LocationUnavailable() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState$ProductDisconnected;", "Ldji/v5/ux/core/widget/distancerc/DistanceRCWidgetModel$DistanceRCState;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class ProductDisconnected
        extends DistanceRCState {
            @NotNull
            public static final ProductDisconnected INSTANCE = new ProductDisconnected();

            private ProductDisconnected() {
                super(null);
            }
        }
    }
}

