/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.graphics.Paint;
import android.graphics.Rect;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Ldji/v5/ux/core/util/FontUtils;", "", "<init>", "()V", "Companion", "android-sdk-v5-uxsdk_debug"})
public final class FontUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static ThreadLocal<Rect> calcCache = new ThreadLocal();
    @NotNull
    private static final String DIGITAL_TEXT = "1.234567890";

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalTextDrawHeight(@NotNull Paint paint, @NotNull String text) {
        return Companion.getDigitalTextDrawHeight(paint, text);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalBaselineFromTop(@NotNull Paint paint, float top, @NotNull String text) {
        return Companion.getDigitalBaselineFromTop(paint, top, text);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalBaselineFromCenter(@NotNull Paint paint, float center, @NotNull String text) {
        return Companion.getDigitalBaselineFromCenter(paint, center, text);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalBaselineFromBottom(@NotNull Paint paint, float bottom, @NotNull String text) {
        return Companion.getDigitalBaselineFromBottom(paint, bottom, text);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalTextDrawHeight(@NotNull Paint paint) {
        return Companion.getDigitalTextDrawHeight(paint);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalBaselineFromTop(@NotNull Paint paint, float top) {
        return Companion.getDigitalBaselineFromTop(paint, top);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalBaselineFromCenter(@NotNull Paint paint, float center) {
        return Companion.getDigitalBaselineFromCenter(paint, center);
    }

    @JvmStatic
    @JvmOverloads
    public static final float getDigitalBaselineFromBottom(@NotNull Paint paint, float bottom) {
        return Companion.getDigitalBaselineFromBottom(paint, bottom);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\fH\u0007J\"\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\fH\u0007J\"\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\fH\u0007J\"\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\fH\u0007J\b\u0010\u0018\u001a\u00020\u0006H\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldji/v5/ux/core/util/FontUtils$Companion;", "", "<init>", "()V", "calcCache", "Ljava/lang/ThreadLocal;", "Landroid/graphics/Rect;", "getCalcCache", "()Ljava/lang/ThreadLocal;", "setCalcCache", "(Ljava/lang/ThreadLocal;)V", "DIGITAL_TEXT", "", "getDigitalTextDrawHeight", "", "paint", "Landroid/graphics/Paint;", "text", "getDigitalBaselineFromTop", "top", "getDigitalBaselineFromCenter", "center", "getDigitalBaselineFromBottom", "bottom", "getCachedRect", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadLocal<Rect> getCalcCache() {
            return calcCache;
        }

        public final void setCalcCache(@NotNull ThreadLocal<Rect> threadLocal) {
            Intrinsics.checkNotNullParameter(threadLocal, (String)"<set-?>");
            calcCache = threadLocal;
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalTextDrawHeight(@NotNull Paint paint, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Rect rect = this.getCachedRect();
            paint.getTextBounds(text, 0, text.length(), rect);
            return rect.height();
        }

        public static /* synthetic */ float getDigitalTextDrawHeight$default(Companion companion, Paint paint, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = FontUtils.DIGITAL_TEXT;
            }
            return companion.getDigitalTextDrawHeight(paint, string2);
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalBaselineFromTop(@NotNull Paint paint, float top, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Rect rect = this.getCachedRect();
            paint.getTextBounds(text, 0, text.length(), rect);
            return top - (float)rect.top;
        }

        public static /* synthetic */ float getDigitalBaselineFromTop$default(Companion companion, Paint paint, float f, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = FontUtils.DIGITAL_TEXT;
            }
            return companion.getDigitalBaselineFromTop(paint, f, string2);
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalBaselineFromCenter(@NotNull Paint paint, float center, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Rect rect = this.getCachedRect();
            paint.getTextBounds(text, 0, text.length(), rect);
            return center + (float)rect.height() / 2.0f - (float)rect.bottom;
        }

        public static /* synthetic */ float getDigitalBaselineFromCenter$default(Companion companion, Paint paint, float f, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = FontUtils.DIGITAL_TEXT;
            }
            return companion.getDigitalBaselineFromCenter(paint, f, string2);
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalBaselineFromBottom(@NotNull Paint paint, float bottom, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Rect rect = this.getCachedRect();
            paint.getTextBounds(text, 0, text.length(), rect);
            return bottom - (float)rect.bottom;
        }

        public static /* synthetic */ float getDigitalBaselineFromBottom$default(Companion companion, Paint paint, float f, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = FontUtils.DIGITAL_TEXT;
            }
            return companion.getDigitalBaselineFromBottom(paint, f, string2);
        }

        private final Rect getCachedRect() {
            Rect cache = this.getCalcCache().get();
            if (cache == null) {
                cache = new Rect();
                this.getCalcCache().set(cache);
            }
            return cache;
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalTextDrawHeight(@NotNull Paint paint) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            return dji.v5.ux.core.util.FontUtils$Companion.getDigitalTextDrawHeight$default(this, paint, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalBaselineFromTop(@NotNull Paint paint, float top) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            return dji.v5.ux.core.util.FontUtils$Companion.getDigitalBaselineFromTop$default(this, paint, top, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalBaselineFromCenter(@NotNull Paint paint, float center) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            return dji.v5.ux.core.util.FontUtils$Companion.getDigitalBaselineFromCenter$default(this, paint, center, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final float getDigitalBaselineFromBottom(@NotNull Paint paint, float bottom) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            return dji.v5.ux.core.util.FontUtils$Companion.getDigitalBaselineFromBottom$default(this, paint, bottom, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

