/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.text.InputFilter;
import android.text.Spanned;

public class EditTextNumberInputFilter
implements InputFilter {
    private int min;
    private int max;

    public EditTextNumberInputFilter(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public EditTextNumberInputFilter(String min, String max) {
        this.min = Integer.parseInt(min);
        this.max = Integer.parseInt(max);
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        try {
            String stringInput = dest.toString() + source.toString();
            double value = stringInput.length() == 1 && stringInput.charAt(0) == '-' ? -1.0 : Double.parseDouble(dest.toString() + source.toString());
            if (this.isInRange(this.min, this.max, value)) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "";
    }

    private boolean isInRange(int a, int b, double c) {
        return b > a ? c >= (double)a && c <= (double)b : c >= (double)b && c <= (double)a;
    }
}

