/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.popover;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.cardview.widget.CardView;
import com.dji.industry.pandora.pilot2.uikit.popover.TintedBitmapDrawable;
import dji.v5.ux.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001RBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000209H\u0002J(\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005H\u0014J\u0016\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020\bJ\b\u0010C\u001a\u000209H\u0002J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ\u0016\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ&\u0010J\u001a\u0002092\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\u0005J\u0010\u0010O\u001a\u0002092\u0006\u0010P\u001a\u00020QH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006S"}, d2={"Ldji/v5/ux/core/popover/PopoverView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "popoverBackgroundColor", "", "arrowColor", "borderRadius", "", "showArrow", "", "arrowOffset", "arrowPosition", "Ldji/v5/ux/core/popover/PopoverView$ArrowPosition;", "<init>", "(Landroid/content/Context;IIFZFLdji/v5/ux/core/popover/PopoverView$ArrowPosition;)V", "arrowAngle", "arrowImageView", "Landroid/widget/ImageView;", "getArrowImageView", "()Landroid/widget/ImageView;", "setArrowImageView", "(Landroid/widget/ImageView;)V", "contentLayout", "Landroidx/cardview/widget/CardView;", "getContentLayout", "()Landroidx/cardview/widget/CardView;", "setContentLayout", "(Landroidx/cardview/widget/CardView;)V", "shadowPaint", "Landroid/graphics/Paint;", "getShadowPaint", "()Landroid/graphics/Paint;", "setShadowPaint", "(Landroid/graphics/Paint;)V", "shadowDx", "getShadowDx", "()F", "setShadowDx", "(F)V", "shadowDy", "getShadowDy", "setShadowDy", "shadowRectF", "Landroid/graphics/RectF;", "getShadowRectF", "()Landroid/graphics/RectF;", "setShadowRectF", "(Landroid/graphics/RectF;)V", "enableDropShadow", "getEnableDropShadow", "()Z", "setEnableDropShadow", "(Z)V", "getArrowDrawable", "Landroid/graphics/drawable/Drawable;", "initViews", "", "onSizeChanged", "w", "h", "oldw", "oldh", "rotateBitmap", "Landroid/graphics/Bitmap;", "source", "angle", "updateArrow", "setArrowOffset", "setContentView", "view", "Landroid/view/View;", "layoutParams", "Landroid/view/ViewGroup$LayoutParams;", "setDropShadow", "blurRadius", "dx", "dy", "color", "onDraw", "canvas", "Landroid/graphics/Canvas;", "ArrowPosition", "android-sdk-v5-uxsdk_debug"})
public final class PopoverView
extends FrameLayout {
    private int popoverBackgroundColor;
    private int arrowColor;
    private float borderRadius;
    private boolean showArrow;
    private float arrowOffset;
    @NotNull
    private ArrowPosition arrowPosition;
    private float arrowAngle;
    public ImageView arrowImageView;
    public CardView contentLayout;
    @NotNull
    private Paint shadowPaint;
    private float shadowDx;
    private float shadowDy;
    @NotNull
    private RectF shadowRectF;
    private boolean enableDropShadow;

    public PopoverView(@NotNull Context context, int popoverBackgroundColor, int arrowColor, float borderRadius, boolean showArrow, float arrowOffset, @NotNull ArrowPosition arrowPosition) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)arrowPosition), (String)"arrowPosition");
        super(context);
        this.popoverBackgroundColor = popoverBackgroundColor;
        this.arrowColor = arrowColor;
        this.borderRadius = borderRadius;
        this.showArrow = showArrow;
        this.arrowOffset = arrowOffset;
        this.arrowPosition = arrowPosition;
        this.arrowAngle = 270.0f;
        this.shadowPaint = new Paint();
        this.shadowRectF = new RectF();
        this.arrowAngle = switch (WhenMappings.$EnumSwitchMapping$0[this.arrowPosition.ordinal()]) {
            case 1 -> 270.0f;
            case 2 -> 0.0f;
            case 3 -> 90.0f;
            case 4 -> 180.0f;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.initViews();
    }

    public /* synthetic */ PopoverView(Context context, int n, int n2, float f, boolean bl, float f2, ArrowPosition arrowPosition, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = Color.parseColor((String)"#FFCC00");
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        if ((n3 & 8) != 0) {
            f = 0.0f;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        if ((n3 & 0x20) != 0) {
            f2 = 0.5f;
        }
        if ((n3 & 0x40) != 0) {
            arrowPosition = ArrowPosition.TOP;
        }
        this(context, n, n2, f, bl, f2, arrowPosition);
    }

    @NotNull
    public final ImageView getArrowImageView() {
        ImageView imageView = this.arrowImageView;
        if (imageView != null) {
            return imageView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"arrowImageView");
        return null;
    }

    public final void setArrowImageView(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
        this.arrowImageView = imageView;
    }

    @NotNull
    public final CardView getContentLayout() {
        CardView cardView = this.contentLayout;
        if (cardView != null) {
            return cardView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
        return null;
    }

    public final void setContentLayout(@NotNull CardView cardView) {
        Intrinsics.checkNotNullParameter((Object)cardView, (String)"<set-?>");
        this.contentLayout = cardView;
    }

    @NotNull
    public final Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public final void setShadowPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.shadowPaint = paint;
    }

    public final float getShadowDx() {
        return this.shadowDx;
    }

    public final void setShadowDx(float f) {
        this.shadowDx = f;
    }

    public final float getShadowDy() {
        return this.shadowDy;
    }

    public final void setShadowDy(float f) {
        this.shadowDy = f;
    }

    @NotNull
    public final RectF getShadowRectF() {
        return this.shadowRectF;
    }

    public final void setShadowRectF(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.shadowRectF = rectF;
    }

    public final boolean getEnableDropShadow() {
        return this.enableDropShadow;
    }

    public final void setEnableDropShadow(boolean bl) {
        this.enableDropShadow = bl;
    }

    private final Drawable getArrowDrawable() {
        int arrowRes = R.drawable.uxsdk_ic_themedark_popover_arrow_left;
        Bitmap source = BitmapFactory.decodeResource((Resources)this.getResources(), (int)arrowRes);
        Intrinsics.checkNotNull((Object)source);
        Bitmap rotateBitmap = this.rotateBitmap(source, this.arrowAngle);
        return (Drawable)new TintedBitmapDrawable(this.getResources(), rotateBitmap, this.arrowColor);
    }

    private final void initViews() {
        this.setContentLayout(new CardView(this.getContext()));
        this.getContentLayout().setRadius(this.borderRadius);
        this.getContentLayout().setCardElevation(0.0f);
        this.getContentLayout().setClickable(true);
        this.getContentLayout().setId(View.generateViewId());
        this.getContentLayout().setCardBackgroundColor(this.popoverBackgroundColor);
        FrameLayout.LayoutParams contentLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.setArrowImageView(new ImageView(this.getContext()));
        this.getArrowImageView().setId(View.generateViewId());
        this.getArrowImageView().setImageDrawable(this.getArrowDrawable());
        FrameLayout.LayoutParams arrowLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.getArrowImageView().measure(0, 0);
        if (this.showArrow) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.arrowPosition.ordinal()]) {
                case 1: {
                    arrowLayoutParams.gravity = 48;
                    contentLayoutParams.topMargin = this.getArrowImageView().getMeasuredHeight();
                    break;
                }
                case 2: {
                    arrowLayoutParams.gravity = 5;
                    contentLayoutParams.rightMargin = this.getArrowImageView().getMeasuredWidth();
                    break;
                }
                case 3: {
                    arrowLayoutParams.gravity = 80;
                    contentLayoutParams.bottomMargin = this.getArrowImageView().getMeasuredHeight();
                    break;
                }
                case 4: {
                    arrowLayoutParams.gravity = 3;
                    contentLayoutParams.leftMargin = this.getArrowImageView().getMeasuredWidth();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.addView((View)this.getArrowImageView(), (ViewGroup.LayoutParams)arrowLayoutParams);
        this.addView((View)this.getContentLayout(), (ViewGroup.LayoutParams)contentLayoutParams);
        this.post(this::updateArrow);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(this::updateArrow);
    }

    @NotNull
    public final Bitmap rotateBitmap(@NotNull Bitmap source, float angle) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        return bitmap;
    }

    private final void updateArrow() {
        if (!this.showArrow) {
            this.getArrowImageView().setVisibility(8);
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getArrowImageView().getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
        switch (WhenMappings.$EnumSwitchMapping$0[this.arrowPosition.ordinal()]) {
            case 1: 
            case 3: {
                float x = (float)this.getContentLayout().getWidth() * this.arrowOffset - (float)(this.getArrowImageView().getWidth() / 2);
                layoutParams2.leftMargin = (int)x;
                break;
            }
            case 2: 
            case 4: {
                float y = (float)this.getContentLayout().getHeight() * this.arrowOffset - (float)(this.getArrowImageView().getHeight() / 2);
                layoutParams2.topMargin = (int)y;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getArrowImageView().setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    @NotNull
    public final PopoverView setArrowOffset(float arrowOffset) {
        this.arrowOffset = arrowOffset;
        this.updateArrow();
        return this;
    }

    @NotNull
    public final PopoverView setContentView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getParent() != null && view.getParent() instanceof ViewGroup) {
            ViewParent viewParent = view.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ((ViewGroup)viewParent).removeView(view);
        }
        this.getContentLayout().addView(view);
        return this;
    }

    @NotNull
    public final PopoverView setContentView(@NotNull View view, @NotNull ViewGroup.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"layoutParams");
        if (view.getParent() != null && view.getParent() instanceof ViewGroup) {
            ViewParent viewParent = view.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ((ViewGroup)viewParent).removeView(view);
        }
        this.getContentLayout().addView(view, layoutParams);
        return this;
    }

    public final void setDropShadow(float blurRadius, float dx, float dy, int color2) {
        if (Build.VERSION.SDK_INT < 29) {
            this.setLayerType(1, null);
        }
        this.enableDropShadow = true;
        this.shadowDx = dx;
        this.shadowDy = dy;
        BlurMaskFilter blurMaskFilter = new BlurMaskFilter(blurRadius, BlurMaskFilter.Blur.NORMAL);
        Paint $this$setDropShadow_u24lambda_u240 = this.shadowPaint;
        boolean bl = false;
        $this$setDropShadow_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$setDropShadow_u24lambda_u240.setAntiAlias(true);
        this.shadowPaint.setColor(color2);
        $this$setDropShadow_u24lambda_u240.setMaskFilter((MaskFilter)blurMaskFilter);
        int padding = (int)(blurRadius * (float)2);
        this.setPadding(padding, padding, padding, padding);
        this.setWillNotDraw(false);
        this.postInvalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (!this.enableDropShadow) {
            return;
        }
        this.shadowRectF.set((float)this.getContentLayout().getLeft() + this.shadowDx, (float)this.getContentLayout().getTop() + this.shadowDy, (float)this.getContentLayout().getRight() + this.shadowDx, (float)this.getContentLayout().getBottom() + this.shadowDy);
        canvas.save();
        canvas.drawRoundRect(this.shadowRectF, this.getContentLayout().getRadius(), this.getContentLayout().getRadius(), this.shadowPaint);
        canvas.restore();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/popover/PopoverView$ArrowPosition;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "RIGHT", "BOTTOM", "LEFT", "android-sdk-v5-uxsdk_debug"})
    public static final class ArrowPosition
    extends Enum<ArrowPosition> {
        public static final /* enum */ ArrowPosition TOP = new ArrowPosition();
        public static final /* enum */ ArrowPosition RIGHT = new ArrowPosition();
        public static final /* enum */ ArrowPosition BOTTOM = new ArrowPosition();
        public static final /* enum */ ArrowPosition LEFT = new ArrowPosition();
        private static final /* synthetic */ ArrowPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ArrowPosition[] values() {
            return (ArrowPosition[])$VALUES.clone();
        }

        public static ArrowPosition valueOf(String value) {
            return Enum.valueOf(ArrowPosition.class, value);
        }

        @NotNull
        public static EnumEntries<ArrowPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = arrowPositionArray = new ArrowPosition[]{ArrowPosition.TOP, ArrowPosition.RIGHT, ArrowPosition.BOTTOM, ArrowPosition.LEFT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArrowPosition.values().length];
            try {
                nArray[ArrowPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowPosition.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowPosition.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowPosition.LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

